 &*                        INSTALL_ARPA.CMD 98170-17006 REV.5015 <890316.1742> & *   *  PURPOSE:   *   #*     This CI command file installs ARPA/1000 by doing the following:  # #*        (1) Loads all the programs which make up ARPA/1000, to run on # *            the system where the command file is invoked   #*        (2) Places these programs into /ARPA1000/RUN/ and /PROGRAMS/, # *            as appropriate   *        (3) Copies the help files to /SYSTEM/  *   *   *  BASIC USAGE:   *   *     From working directory /ARPA1000, enter the CI command:   *   *                    cmd/install_ARPA   *   '****************************************************************************** ' '*                                                                            * ' '* Refer to the ARPA/1000 Node Manager's manual for complete loading          * ' '* information.  There is also information in: A98170_INSTALL.TXT.            * ' '*                                                                            * ' '*      Don't forget to load LAN/1000 subsystem                               * ' '*                                                                            * ' '****************************************************************************** ' *   	*  ADVANCED USAGE: 	 #*     The following CI variables are used to modify the default usage: # *     ns_mdir, ns_cdir, ns_sdir, ns_hdir, ns_idir, ns_snap.   *   %*     Changing the default values may be necessary under these conditions: % "*        (1) If you do not want all of the programs loaded (because  " *            you don't need all of the services)  #*        (2) If the ARPA/1000 files should be put somewhere other than # *            the normal places, for example, so you can purge   *            /ARPA1000/ after installation.   "*        (3) You may want to load these programs for another system  " "*            than this one.  This would probably involve using some  " "*            snap file other than LINK's default snap file, and also " $*            putting the ARPA/1000 files somewhere other than the normal $ 
*            places. 
 *   *     Here's how to do each of these things.  *    *        (1) To delete some programs from the loading, edit this   "*            file, commenting out or deleting the appropriate lines. " *            The lines are grouped according to functionality.  *   %*        (2) The destination of the various ARPA/1000 files is controlled  % $*            by CI variables.  You may change these variables in either  $ 
*            of two ways:  
 "*            (a) You may edit this file, changing the default values " *                assigned below.  !*            (b) You may use the CI "SET" command, to set these CI ! !*                variables in advance.  If any of these variables  ! !*                is set at the time this command file is invoked,  ! #*                then that is the value that will be used.  See below  # *                for more information on these variables.   *   "*        (3) The snap file name is also controlled by a CI variable. " "*            You may control this variable in exactly the same ways  " $*            you control the directory-name variables mentioned in (2).  $ *   *     Variables used, and defaults:   *   !*        ns_mdir        This variable is the name of the directory ! %*                       where ARPA/1000 "monitors" are placed.  There are  % "*                       two types of programs files here: Ones that  " #*                       must be RP'ed before running NSINIT, and ones  # !*                       that are used only by the Network Manager. ! #*                       Once ARPA/1000 is running, there is no need to # "*                       refer to the program files again (although,  " #*                       of course, the program files must still exist  # *                       as long as the program is RP'ed ).  *                       Default: /ARPA1000/RUN/   *   !*        ns_cdir        This variable is the name of the directory ! #*                       where ARPA/1000 "commands" are placed.  These  # *                       programs are often run some time after  "*                       initialization, and most of them are utility " %*                       programs. They are normally placed in /PROGRAMS/,  % *                       so they are readily accessible.   *                       Default: /PROGRAMS/   *   !*        ns_sdir        This variable is the name of the directory ! $*                       where ARPA/1000 "subsystem" programs are placed. $ &*                       These programs are scheduled by ARPA/1000 as needed, & #*                       in order to provide services.  They must be in # *                       /PROGRAMS/ in order to be used.   *                       Default: /PROGRAMS/   *   !*        ns_hdir        This variable is the name of the directory !  *                       where ARPA/1000 "help" files are placed.   !*                       These files are used by parts of ARPA/1000 !  *                       to provide on-line help.  The files must   !*                       be in /SYSTEM/ to be used; if they are not ! %*                       in /SYSTEM/, on-line help will be greatly reduced, % &*                       but the systems other functions will not be damaged. & *                       Default: /SYSTEM/   *   !*        ns_idir        This variable is the name of the directory ! %*                       where ARPA/1000 "initialization" files are placed. % $*                       These files must be on /SYSTEM/ to be used when  $ #*                       NETINIT is run.  If they are not, then NETINIT # "*                       error messages will be restricted to numeric "  *                       codes, instead of informative messages.    *                       Default: /SYSTEM/   *   !*        ns_snap        This variable is the name of the snap file ! *                       to use when loading programs.   !*                       By default, the variable has the value ``  ! "*                       (the null string).  This permits LINK to use " *                       the normal, default snap file.  #*                       Note: the value of this variable must conform  # "*                       to LINK's rules for recognizing a snap file  " *                       from the run string.  *                       Default: `` (the null string)   *   '* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  ' *   *  If not already set, set the "monitors" directory   *   
if is $ns_mdir = \$ns_mdir 
 then     set ns_mdir = run/   fi      *  If not already set, set the "commands" directory   *   
if is $ns_cdir = \$ns_cdir 
 then     set ns_cdir = /programs/       fi      *  If not already set, set the "subsystem" directory  *   
if is $ns_sdir = \$ns_sdir 
 then     set ns_sdir = /programs/   fi      *  If not already set, set the "help" directory   *   
if is $ns_hdir = \$ns_hdir 
 then  
   set ns_hdir = /system/  
 fi      *  If not already set, set the "initialization" directory   *   
if is $ns_idir = \$ns_idir 
 then  
   set ns_idir = /SYSTEM/  
 fi      *  If not already set, set the snap file  *   
if is $ns_snap = \$ns_snap 
 then     set ns_snap =  fi      #*********************************************************************  # #*           Be sure that the run/ directory exists                  *  # #*********************************************************************  # crdir run   #*********************************************************************  # #*********************************************************************  # #*                      Required Software                            *  # #*********************************************************************  # $link $ns_snap $ns_mdir`inpro.run` +ec $ns_mdir`inpro.map` lod/inpro.lod  $ %link $ns_snap $ns_mdir`mminit.run` +ec $ns_mdir`mminit.map` lod/mminit.lod % &link $ns_snap $ns_mdir`netinit.run` +ec $ns_mdir`netinit.map` lod/nsinit.lod & %link $ns_snap $ns_mdir`nspars.run` +ec $ns_mdir`nspars.map` lod/nspars.lod % $link $ns_snap $ns_mdir`nspr1.run` +ec $ns_mdir`nspr1.map` lod/nspr1.lod  $ $link $ns_snap $ns_mdir`nspr2.run` +ec $ns_mdir`nspr2.map` lod/nspr2.lod  $ $link $ns_snap $ns_mdir`nspr3.run` +ec $ns_mdir`nspr3.map` lod/nspr3.lod  $ %link $ns_snap $ns_mdir`outpro.run` +ec $ns_mdir`outpro.map` lod/outpro.lod % $link $ns_snap $ns_mdir`timer.run` +ec $ns_mdir`timer.map` lod/timer.lod  $ $link $ns_snap $ns_mdir`uplin.run` +ec $ns_mdir`uplin.map` lod/uplin.lod  $     #********************************************************************** # #*                  Recommended Software                              * # #********************************************************************** # *   
* Event logging utilities  
 *   $link $ns_snap $ns_cdir`brevl.run` +ec $ns_cdir`brevl.map` lod/brevl.lod  $ $link $ns_snap $ns_mdir`evmon.run` +ec $ns_mdir`evmon.map` lod/evmon.lod  $ %link $ns_snap $ns_cdir`logchg.run` +ec $ns_cdir`logchg.map` lod/logchg.lod % *   
* Tracing utilities  
 *   $link $ns_snap $ns_cdir`brtrc.run` +ec $ns_cdir`brtrc.map` lod/brtrc.lod  $ %* link $ns_snap $ns_cdir`fmtrc.run` +ec $ns_cdir`fmtrc.map` lod/fmtrc.lod  % $link $ns_snap $ns_cdir`nstrc.run` +ec $ns_cdir`nstrc.map` lod/nstrc.lod  $ *   
* Nodal Registry Software  
 *   %link $ns_snap $ns_mdir`nrinit.run` +ec $ns_mdir`nrinit.map` lod/nrinit.lod % %link $ns_snap $ns_cdir`nrlist.run` +ec $ns_cdir`nrlist.map` lod/nrlist.lod % *   * Initialization message files  *   co misc/@.msg $ns_idir`@` d   *   * Information Utility   *   %link $ns_snap $ns_cdir`netinf.run` +ec $ns_cdir`netinf.map` lod/nsinf.lod  % *   * level 3 loop back utility   *   "link $ns_snap $ns_cdir`ping.run` +ec $ns_cdir`ping.map` lod/ping.lod " *   ******************************  *   * TELNET  *   ******************************  $link $ns_snap $ns_sdir`tnsrv.run` +ec $ns_sdir`tnsrv.map` lod/tnsrv.lod  $ %link $ns_snap $ns_cdir`telnet.run` +ec $ns_cdir`telnet.map` lod/telnet.lod % $link $ns_snap $ns_mdir`tnmon.run` +ec $ns_mdir`tnmon.map` lod/tnmon.lod  $             ******************************  *   * FTP   *   ******************************  *   #* FTPSV references $BIGLB library.  If this name is different in your  # #* system generation, change the references to it in 'lod/ftpsv.lod' to # * match your names before loading FTPSV.  *   $link $ns_snap $ns_sdir`ftpsv.run` +ec $ns_sdir`ftpsv.map` lod/ftpsv.lod  $ !link $ns_snap $ns_cdir`ftp.run` +ec $ns_cdir`ftp.map` lod/ftp.lod  ! $link $ns_snap $ns_mdir`ftpmn.run` +ec $ns_mdir`ftpmn.map` lod/ftpmn.lod  $     ********************************  *   * Copying Files   *   ********************************      co doc/telnet.hlp $ns_hdir`@` d   co doc/ftp.hlp $ns_hdir`@` d      *  