#!/bin/sh
#
# Installation script for GNU utilities for HP-UX 9.00
#
# Usage:
#
#   sh install.sh              (for installing all packages)
#   sh install.sh gnu          (for installing only GNU utilities)
#   sh install.sh emacs        (for installing only GNU emacs editor)
#   sh install.sh perl         (for installing only Perl 5)
#   sh install.sh x11          (for installing only X11R5 add-ons)
#   sh install.sh motif        (for installing only Motif 1.2 add-ons)
#
# Note: You need to have sysadmin privileges in order to install the X11R5
#       and Motif 1.2 add-ons
#
# GNU (and some third-party like flex) utilities and Perl will be installed
# under /usr/local, the X11R5 and Motif 1.2 add-ons will be installed in
# different directories since HP-UX (as most other OS) does not use a project
# root such as /usr/X11R5.

# configure
gnu_root=/usr/local
emacs_root=/usr/local/emacs
perl_root=/usr/local/perl5
x11_root=/usr
motif_root=/usr

# intitialize
dist=hpux9.00-v1.0.tar.Z
gnu_archive=gnu-${dist}
emacs_archive=emacs-${dist}
perl_archive=perl-${dist}
x11_archive=x11r5-${dist}
motif_archive=motif1.2-${dist}

do_gnu=
do_emacs=
do_perl=
do_x11=
do_motif=

# disc usage in kBytes
du_gnu=198416
du_emacs=119546
du_perl=24394
du_x11=19436
du_motif=9652

# process command line parameters
if [ $# = "0" ]; then
  do_gnu=1;
  do_emacs=1;
  do_perl=1;
  do_x11=1;
  do_motif=1;
else
  for parm
  do
    if [ $parm = "gnu" ]; then
      do_gnu=1
    else
      if [ $parm = "emacs" ]; then
        do_emacs=1
      else
        if [ $parm = "perl" ]; then
          do_perl=1
        else
          if [ $parm = "x11" ]; then
             do_x11=1
          else
            if [ $parm = "motif" ]; then
              do_motif=1
            else
              echo usage: $0 \[gnu\|emacs\|perl\|x11\|motif\]
              exit 1
            fi
          fi
        fi
      fi
    fi
  done
fi

# check for root privileges
if [ "${do_x11}" -o "${do_motif}" ]; then
  if [ ! `whoami`="root" ]; then
    echo you need to be root to install X11R5 or Motif 1.2 add-ons
    exit 1
  fi
fi

# check for available disc space
disc=`df | awk '{print $2}' | sed 's/(//g'`
disc_free=`df | awk '{print $4}'`
disc_need=0
if [ "${do_gnu}" ]; then
  disc_need=`expr ${disc_need} + ${du_gnu}`
fi
if [ "${do_emacs}" ]; then
  disc_need=`expr ${disc_need} + ${du_emacs}`
fi
if [ "${do_perl}" ]; then
  disc_need=`expr ${disc_need} + ${du_perl}`
fi
if [ "${do_x11}" ]; then
  disc_need=`expr ${disc_need} + ${du_x11}`
fi
if [ "${do_motif}" ]; then
  disc_need=`expr ${disc_need} + ${du_motif}`
fi
if [ ${disc_need} -gt ${disc_free} ]; then
	echo not enough space on ${disc} \(at least ${disc_need} kBytes needed.\)
	exit 1
fi

# install GNU utilities
if [ "${do_gnu}" ]; then
  if [ ! -f ${gnu_archive} ]; then
    echo GNU utilities distribution package ${gnu_archive} not found
    exit 1
  fi 
  if [ ! -d ${gnu_root} ]; then
    mkdir -p ${gnu_root}
  fi 
  echo installing GNU utilities in ${gnu_root}... 
  uncompress -c ${gnu_archive} | ( cd ${gnu_root}; tar xvf - ) 
  echo done. 
fi

# install GNU emacs
if [ "${do_emacs}" ]; then
  if [ ! -f ${emacs_archive} ]; then
    echo GNU emacs distribution package ${emacs_archive} not found
    exit 1
  fi 
  if [ ! -d ${emacs_root} ]; then
    mkdir -p ${emacs_root}
  fi 
  echo installing GNU emacs in ${gnu_root}... 
  uncompress -c ${emacs_archive} | ( cd ${emacs_root}; tar xvf - ) 
  echo done. 
fi

# install Perl
if [ "${do_perl}" ]; then
  if [ ! -f ${perl_archive} ]; then
    echo Perl distribution package ${perl_archive} not found
    exit 1
  fi 
  if [ ! -d ${perl_root} ]; then
    mkdir -p ${perl_root}
  fi 
  echo installing Perl 5 in ${perl_root}... 
  uncompress -c ${perl_archive} | ( cd ${perl_root}; tar xvf - ) 
  echo done. 
fi

# install X11R5 add-ons
if [ "${do_x11}" ]; then
  if [ ! -f ${x11_archive} ]; then
    echo X11R5 add-ons distribution package ${x11_archive} not found
    exit 1
  fi  
  if [ ! -d ${x11_root} ]; then
    mkdir -p ${x11_root}
  fi 
  echo installing X11R5 add-ons in ${x11_root}... 
  uncompress -c ${x11_archive} | ( cd ${x11_root}; tar xvf - ) 
  echo done. 
fi

# install Motif 1.2 add-ons
if [ "${do_motif}" ]; then
  if [ ! -f ${motif_archive} ]; then
    echo Motif 1.2 add-ons distribution package ${motif_archive} not found
    exit 1
  fi 
  if [ ! -d ${motif_root} ]; then
    mkdir -p ${motif_root}
  fi 
  echo installing Motif 1.2 add-ons in ${motif_root}... 
  uncompress -c ${motif_archive} | ( cd ${motif_root}; tar xvf - ) 
  echo done. 
fi

exit 0
