; HPC Demo Program, Timer Interrupt Service Routine

; Import register name definitions

	.extrn	enir:B
	.extrn	r2:W
	.extrn	t2:W
	.extrn	tmmode:W
	.extrn	pwmode:W
	.extrn	divby:W

; Import global variables

	.extrn	STOP_TIMER:ROM8
	.extrn	START_TIMER:ROM8
	.extrn  CMD_PEND:RAM8:B
        .extrn	PENDING_FLAG:RAM8:B
	.extrn	MSG_A:ROM8:B
	.extrn	MSG_B:ROM8:B
	.extrn	MSG_I:ROM8:B
	.extrn	END_MSGS:ROM8:B
	.extrn	MSG_DEST:RAM8:B


; Define new section for interrupt handler

	.SECT	INTHNDLRSECT, ROM8

; Here's where the work is done. This is the interrupt service routine
; for the Timer 2 interrupt. First, check to see if there is a command
; pending. If not, return from interrupt. Otherwise, we skip the RETI
; and process the command.

	.public	HANDLE_CMD

HANDLE_CMD:	JSR	STOP_TIMER
		IFEQ	PENDING_FLAG, #0
		JP	NO_CMD
		JP	INTERPRET_CMD

; There was no command.

NO_CMD:		JSR	START_TIMER
		RETI

; The pending flag was non-zero, so we need to interpret the command.


INTERPRET_CMD:	IFEQ	CMD_PEND, #'A'
		JP	CMD_A
		IFEQ	CMD_PEND, #'B'
		JP	CMD_B
		JP	CMD_I

; We got command A, so set up the pointer to the beginning of that
; message.

CMD_A:		LD	X, #MSG_A
		LD	A, #MSG_B-MSG_A-1
		JP	WRITE_MSG

CMD_B:		LD	X, #MSG_B
		LD	A, #MSG_I-MSG_B-1
		JP	WRITE_MSG

CMD_I:		LD	X, #MSG_I
		LD	A, #END_MSGS-MSG_I-1
		JP	WRITE_MSG
				
; Write the message to the buffer.

WRITE_MSG:	LD	B, #MSG_DEST
		LD	K, B
		ADD	K, A

MSG_LOOP:	LD	A, [X+].B
		XS	A, [B+].B
		JP	MSG_LOOP

; Fill the remainder of the destination area with spaces (hex 20).

FILL_DEST:	LD	K, #MSG_DEST+32

FILL_LOOP:	LD	A, #0x20
		XS	A, [B+].B
		JP	FILL_LOOP

; Clean up by clearing the pending command, and reset the pending flag.

RESET_PEND:	LD	CMD_PEND, #0
		LD	PENDING_FLAG, #0


; Return from interrupt

		JSR	START_TIMER
		RETI

; End of interrupt handler
