
Creation date: Tue Aug 28 10:38:18 1990	crt0_32c.s	page 1


Address	Instruction	Line #	Source line
			1	/********************************************************
			2	 *                          							*
			3	 *	FILE:	crt0_32c.s		                    		*
			4	 *							                            *
			5	 *	DESCRIPTION:	startup file for dcc generated	    *
			6	 *			DSP32 programs.			                    *
			7	 *							                            *
			8	 ********************************************************/
			9	
			10	#define	sp	r14e		/* stack pointer */
			11	#define	rp	r18			/* return pointer */
			12	#define	rpe	r18e		/* return pointer */
			13	#define	ir	r19			/* increment register */
			14	
			15	#define	STACK_INC	4	/* stack increment */
			16	
			17		.rsect	".text"
			18		.global	__start
			19		.global	__end
			20		.global	errno
			21	    .extern main
			22	    .extern sioin_int
			23	    .extern sioout_int
			24	
			25		.align	4
			26	
			27	__start:
0000	00000000	28	    nop
0004	00000000	29	    nop
0008	1740000c	30		dauc = 0x0c	        /* Set round to int */
000c	17600cc5	31		ioc = 0x0cc5		/* Disable any Serial DMAs	*/
0010	c00e0000	32		sp = _stack		    /* Stack is empty at bottom	*/
0014	16a00004	33		ir = STACK_INC		/* stack increment */
0018	c01d0048	34		r22e = ivt		    /* Interrupt vector table pointer */
001c	142080c0	35	    r1 = 0x80c0         /* PCW register */
0020	00000000	36	    nop
0024	1f81001e	37	    pcw = r1
0028	00000000	38	    nop
002c	00000000	39	    nop
0030	e0140000	40		call main (rp)		/* Nothing else to do now	*/
0034	c0140038	41		rpe = . + 4		    /* to get around call bug in 32c rev 2.0 */
			42	
0038	14200000	43		r1 = 0
003c	1f810006	44		pdr = r1		    /* exit (0) */
			45	__end:
0040	bfeffff8	46		goto	__end
0044	00000000	47		nop
			48	
			49	/* Interrupt pointer table */
			50	ivt:
0048	a0001180	51	    fltbits 0x0a0001180 /* External interrupt 1 (Monitor @ 1000h) */
004c	00000000	52	    nop
0050	003e0000	53	    ireturn             /* PIO buffer full */
0054	00000000	54	    nop
0058	003e0000	55	    ireturn             /* PIO buffer empty */
005c	00000000	56	    nop
0060	a00f0020	57	    goto __int_sio_in   /* SIO input buffer full */
0064	00000000	58	    nop
0068	a00f0024	59	    goto __int_sio_out  /* SIO output buffer empty */
006c	00000000	60	    nop

Creation date: Tue Aug 28 10:38:18 1990	crt0_32c.s	page 2


Address	Instruction	Line #	Source line
0070	a00f0008	61	    goto __ext_int2     /* External interrupt 2 */
0074	00000000	62	    nop
			63	
			64	/* Interrupt Service Routines */
			65	
			66	__ext_int1:  /* External interrupt 1 */
0078	003e0000	67	    ireturn
007c	00000000	68	    nop
			69	
			70	__ext_int2:  /* External interrupt 2 */
0080	003e0000	71	    ireturn
0084	00000000	72	    nop
			73	
			74	__int_sio_in:  /* input from sio */
0088	e0140000	75	    call sioin_int(rp)
008c	003e0000	76	    ireturn
0090	00000000	77	    nop
			78	
			79	__int_sio_out: /* output from sio */
0094	e0140000	80	    call sioout_int(rp)
0098	003e0000	81	    ireturn
009c	00000000	82	    nop
			83	
			84		.rsect	".data"
0000	    0000	85	errno:	int
			86	
			87		.rsect	".bss"
0000	      00	88	_stack:	256 * byte


d3as:warning:crt0_32c.s line 37: could be changing external memory wait states 
		during DA instruction write to memory.



Symbol Table
.file	crt0_32c.s
.text	(section 1)	size 0xa0
.data	(section 3)	size 0x2
.bss	(section 4)	size 0x100
sioin_int	section 256	external	value 0x0
main	section 256	external	value 0x0
__start	section 1	global	defined	value 0x0
ivt	section 1	defined	value 0x48
__ext_int1	section 1	defined	value 0x78
__ext_int2	section 1	defined	value 0x80
__end	section 1	global	defined	value 0x40
__int_sio_in	section 1	defined	value 0x88
__int_sio_out	section 1	defined	value 0x94
sioout_int	section 256	external	value 0x0
errno	section 3	global	defined	value 0x0
_stack	section 4	defined	value 0x0
