* This module contains the message intepreter and message printing routines
* for the 64748 demo program. The main program module is demo.s.
*
* Module: handler.s
* Written by: Dave Kumpf; Document Technology, Inc.
* Written: February 27, 1991
* Last Revised: February 28, 1991


* Int_Cmd must be made global so demo.s can see it.
	
		xdef	Int_Cmd

* Data local to this module are the message definitions and the message
* output buffer.

		sect	Data,,d

* Define the messages printed for commands A, B and invalid respectively.

Msg_A		dc.b	'Command A entered'
Msg_B		dc.b	'Entered B command'
Msg_I		dc.b	'Invalid command'
End_Msgs

* Message output buffer.

Msg_Dest	ds.b	32

* Start program code for this module.

		sect	Prog,,c

* Int_Cmd is the command interpreter routine. It is called by the main
* program loop in demo.s whenever a command is found.

Int_Cmd		cmp.b	#'A',d0
		beq	Cmd_A
		cmp.b	#'B',d0
		beq	Cmd_B
		bra	Cmd_I

* If "A", then load a pointer to the beginning of the "A" message into a0,
* and load the message's length into d1. Then call the routine to print
* the message. When done, return to the caller (the main program loop in
* demo.s).

Cmd_A		lea	Msg_A,a0
		move.l	#Msg_B-Msg_A-1,d1
		bsr	Print_Msg
		rts

* If "B", then load a pointer to the beginning of the "B" message into a0,
* and load the message's length into d1. Then call the routine to print
* the message. When done, return to the caller (the main program loop in
* demo.s).

Cmd_B		lea	Msg_B,a0
		move.l	#Msg_I-Msg_B-1,d1
		bsr	Print_Msg
		rts

* The command isn't recognized, so load a pointer to the beginning of the 
* invalid message into a0,
* and load the message's length into d1. Then call the routine to print
* the message. When done, return to the caller (the main program loop in
* demo.s).

Cmd_I		lea	Msg_I,a0
		move.l	#End_Msgs-Msg_I-1,d1
		bsr	Print_Msg
		rts

* End of Int_Cmd



* Print_Msg handles the writing of the appropriate message to the Msg_Dest
* buffer. After the message is written, it writes nulls to the remaining
* locations to clear them from previous commands.

* To print the message, we load a pointer to the output buffer into
* a1, then do a block xfer with autoincrement addressing. When the number
* of characters specified in d1 has been moved, fall out of the Again loop.

Print_Msg	lea	Msg_Dest,a1
Again		move.b	(a0)+,(a1)+
		dbeq	d1,Again

* Now move a null to the next location pointed to by a1 (which is now after
* the last character of the message. Compare the address in a1 to the end
* address of the message buffer, and keep repeating until all remaining
* destination buffer locations are zeroed. Then return to the caller
* (Int_Cmd in this case).

Fill_Dest	move.b	#0,(a1)+
		cmpa	#Msg_Dest+32,a1
		bne	Fill_Dest
		rts

* End of Print_Msg


* End of handler.s
