'68000' 

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;    EMULATION FOREGROUND MONITOR FOR 64746 EMULATOR.
;    THIS MONITOR VERSION IS USED WITH THE HP LANGUAGE
;    SYSTEM.
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; @(mktid) ((null) 08Aug90)                       .............. A.00.00 DDMMMYY HH:MM:SS status....
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;    THE EMULATION FOREGROUND MONITOR IS THE VEHICLE BY WHICH THE
;    FOLLOWING EMULATOR FUNCTIONS ARE EFFECTED IF THE 64746 
;    EMULATOR IS CONFIGURED TO OPERATE WITH A FOREGROUND MONITOR:
;        READ/WRITE TARGET SYSTEM MEMORY
;        DISPLAY/MODIFY 68302 REGISTERS
;        EXECUTE USER PROGRAM
;        BREAK AWAY FROM USER PROGRAM
;
;    THE 64746 FOREGROUND MONITOR MUST START ON A 2K BYTE BOUNDARY
;    OTHER THAN 0H.  THE DESIRED 2K BYTE BOUNDARY SHOULD BE SPECIFIED
;    IN THE "ORG" STATEMENT AT THE START OF THE MONITOR.  THE SAME
;    24 BIT ADDRESS MUST BE SPECIFIED IN THE EMULATOR CONFIGURATION
;    QUESTION "cf mon=fg..XXXXXX".  IN THIS MANNER, COMMUNICATION
;    BETWEEN THE FOREGROUND MONITOR AND THE EMULATOR OPERATING SOFTWARE
;    CAN BE ESTABLISHED.
;
;    THE FIRST FEW SECTIONS OF THE FOREGROUND MONITOR CANNOT BE
;    MODIFIED AND THEIR LOCATION WITH RESPECT TO THE START OF THE
;    FOREGROUND MONITOR CANNOT BE ALTERED. THESE INCLUDE THE FOLLOWING:
;        MONITOR VECTOR TABLE
;        MONITOR VARIABLES
;        KEY MONITOR ENTRY ROUTINES
;
;    THE MONITOR VECTOR TABLE IS USED EXCLUSIVELY BY THE EMULATOR
;    TO TRANSITION INTO THE FOREGROUND MONITOR FROM RESET, FROM
;    SOFTWARE BREAKPOINTS, OR FROM EMULATION GENERATED BREAKS LIKE
;    THE BREAK COMMAND OR A WRITE TO ROM.  THE MONITOR VECTOR IS NOT
;    A REPLACEMENT FOR THE TARGET SYSTEM'S EXCEPTION VECTOR TABLE.
;
;    THE MONITOR VARIABLES SECTION CONTAINS FOUR PARTS.
;    THE FIRST PART IS A GROUP OF VARIABLES THAT ACT AS THE
;    COMMUNICATIONS PATH BETWEEN THE FOREGROUND MONITOR AND THE
;    EMULATOR CONTROLLER.  THE SECOND SECTION HOLDS A COPY OF THE
;    68302 REGISTERS WHICH ARE STORED WHEN ENTERING THE FOREGROUND MONITOR.
;    THE THIRD SECTION IS THE XFER_BUF WHICH IS A BUFFER TO HOLD DATA
;    WHICH IS TRANSFERED BETWEEN THE EMULATOR CONTROLLER AND TARGET
;    SYSTEM MEMORY.  THE BK_STACK IS A STACK USED BY THE MONITOR
;    WHEN IT IS IN A BACKGROUND STATE FOR A FEW BUS CYCLES UPON
;    TRANSITION TO THE FOREGROUND MONITOR.  THE STAT(1:4) VARIABLES
;    ARE A HOLDING AREA FOR THE EXTRA STACK INFORMATION THAT OCCURS
;    WHEN A BUS ERROR OR ADDRESS ERROR HANDLER IS DIRECTED INTO THE MONITOR.
;
;    THE KEY MONITOR ENTRY ROUTINES ARE BK_RESET_ENTRY, INT_ENTRY,
;    SW_ENTRY, INMON_INT_ENTRY, AND INMON_TRACE_ENTRY.  THESE ROUTINES INVOLVE
;    A BRIEF STOP IN THE BACKGROUND MONITOR AND THEREFORE CANNOT BE
;    MODIFIED OR MOVED WITH RESPECT TO THE START OF THE MONITOR.
;
;
;    TO PERFORM SINGLE STEPPING WITH THE FOREGROUND MONITOR, THE
;    "TRACE" VECTOR IN THE EXCEPTION VECTOR TABLE MUST POINT TO
;    "TRACE_ENTRY" IN THE FOREGROUND MONITOR.
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


; ORG XXXXXX      ; START MONITOR ON 2K BOUNDARY OTHER THAN ZERO

MONITOR_START

;;;;;;;;;;;;;;;;;;;;;;;;
; MONITOR VECTOR TABLE ;
;;;;;;;;;;;;;;;;;;;;;;;;

;    ---RESET---
   DC.L    BK_STACK
   DC.L    0258H

;    --- MARK SPACE ---
     DC.L  0
     DC.L  0
     DC.L  0
     DC.L  0
     DC.L  0
     DC.L  0
     DC.L  0
     DC.L  02D8H      ;TRACE ENTRY AFTER STEP
     DC.L  0
     DC.L  0

MONITOR_REGISTERS

CURRENT_PC
PCH           DC.W            0
PCL           DC.W            0
PSTAT         DC.W            0
              DC.W            0          ;ALIGNMENT SPACER
PREGS
PD0            DC.L            0
PD1            DC.L            0
PD2            DC.L            0
PD3            DC.L            0
PD4            DC.L            0
PD5            DC.L            0
PD6            DC.L            0
PD7            DC.L            0
PA0            DC.L            0
PA1            DC.L            0
PA2            DC.L            0
PA3            DC.L            0
PA4            DC.L            0
PA5            DC.L            0
PA6            DC.L            0
PA7            DC.L            0
PUSP           DC.L            0

; END OF MONITOR_REGISTERS ;

;    --- INTERRUPT MONITOR ENTRY ---
     DC.L  266H


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; TRAP VECTORS ( SOFTWARE BREAKPOINT VECTOR ) ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
   DC.L    029EH
   DC.L    029EH
   DC.L    029EH
   DC.L    029EH
   DC.L    029EH
   DC.L    029EH
   DC.L    029EH
   DC.L    029EH
   DC.L    029EH
   DC.L    029EH
   DC.L    029EH
   DC.L    029EH
   DC.L    029EH
   DC.L    029EH
   DC.L    029EH
   DC.L    029EH

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; END OF MONITOR VECTOR TABLE ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;;;;;;;;;;;;;;;;;;;;;
; MONITOR VARIABLES ;
;;;;;;;;;;;;;;;;;;;;;

STADJVAR        DC.W    0       ;ALIGNMENT SPACER
                DC.W    0       ;ALIGNMENT SPACER

CMD_CONTROL     DC.W    3       ;VARIABLE TO TELL WHO IS IN CONTROL MONITOR OR EMULATOR
                                ;'1' INDICATES COMMAND PENDING
                                ;'2' INDICATES COMMAND IN PROGRESS
                                ;'3' INDICATES COMMAND COMPLETE
CMD_RESULT      DC.W    0       ;'0' INDICATES NO PROBLEM
                                ;'1' INDICATES ILLEGAL SR ON ENTRY
CMD_TYPE        DC.W    0       ;'1' INDICATES 'ARE-YOU-THERE'
                                ;'2' INDICATES MONITOR EXIT
                                ;'4' INDICATES TARGET MEMORY WRITES
                                ;'8' INDICATES TARGET MEMORY READS
TARG_START      DC.L    0       ;START ADDRESS TO LOAD EMULATION MEMORY
TARG_BYTES      DC.W    0       ;NUMBER OF BYTES TO TRANSFER
                                ;IF BIT 15 HIGH, DO WORD TRANSFERS
STEP_ENTRY      DC.W    0
LAST_ENTRY      DC.W    0
STEP_MODE       DC.W    0


;    --- MARK SPACE ---
     DC.W  0
     DC.L  0
     DC.L  0
     DC.L  0
     DC.L  0
     DC.L  0
     DC.L  0
     DC.L  0
     DC.L  0
     DC.L  0
     DC.L  0
     DC.L  0
     DC.L  0
     DC.L  0
     DC.L  0
     DC.L  0
     DC.L  0
     DC.L  0
     DC.L  0

XFR_BUF         DS.W          136
                DS.W           16
BK_STACK

STAT1           DC.W            0
STAT2           DC.W            0
STAT3           DC.W            0
STAT4           DC.W            0


;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; END OF MONITOR VARIABLES ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; KEY MONITOR ENTRY ROUTINES ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

BK_RESET_ENTRY
   MOVE.W       #01H,0D2H
   DC.W         04EF9H
   DC.L         BK_RESET_PROCESS
   NOP

INT_ENTRY
   MOVE.B       #008H,0F4H        *CLEAR SCR IPA BIT
   MOVE.L       D0,038H           *PD0
   MOVE.B       0D1H,D0   *POLL IOB REGISTER, BG CONTROL BIT
   AND.B        #0FH,D0           *CHECK IF SWBK ENTRY
   BTST         #03H,D0 
   BEQ          NO_SWBK_ENTRY
   MOVE.L       038H,D0
   ADDQ.L        #6,A7             *FIX THE SYSTEM STACK POINTER 
   DC.W         04EF9H
   DC.L         SW_ENTRY-MONITOR_START
NO_SWBK_ENTRY
   MOVE.L       038H,D0
   MOVE.W       #02H,0D2H
   DC.W         04EF9H
   DC.L         MON_ENT
   NOP

SW_ENTRY
   NOP
   NOP
   NOP
   NOP
   MOVE.L       D0,038H
   MOVE.W       0D4H,D0
   BEQ          NO_STEP_FIX
   MOVE.L       038H,D0
   ADDQ.L        #6,A7             *FIX THE SYSTEM STACK POINTER 
NO_STEP_FIX
   MOVE.L       038H,D0
   MOVE.W       #03H,0D2H
   DC.W         04EF9H
   DC.L         MON_ENT
   NOP

INMON_TRACE_ENTRY
   ADDQ.L  #6,A7        ;ADJUST STACK POINTER TO IGNORE STACKING FOR TRACE
   MOVE.W #0BH,0D0H    ;INDICATES A STEP HAS OCURRED.
   JMP    SW_ENTRY-MONITOR_START

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; END OF KEY MONITOR ENTRY ROUTINES ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;; MONITOR OPERATING ROUTINES ;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

; SOFTWARE IN MONITOR AND OPERATING VERIFICATION
;   THIS ROUTINE IS USED TO TELL THE EMULATOR CONTROLLER
;   IF THE EMULATOR IS OPERATING IN THE MONITOR AND IS
;   READY TO ACCEPT COMMANDS.

SW_IN_MON
   MOVE.W       #3,CMD_CONTROL
   BRA          MON_LOOP


; MONITOR EXIT ROUTINE
;   THE MONITOR EXIT ROUTINE PERFORMS THE TRANSITION FROM FOREGROUND
;   MONITOR OPERATION TO EXECUTION OF THE USERS PROGRAM

START_EXIT
   MOVE         SR,D0                 ;CHECK THAT 68302 IS IN
   BTST         #13,D0                ;SUPERVISOR MODE
   BNE          EXIT_OK
   MOVE.W       #0FH,LAST_ENTRY       ;FLAG THE PROBLEM
   BRA          MON_LOOP              ;GO BACK TO MONITOR LOOP
EXIT_OK
   MOVE.L       PUSP,A0
   MOVE.L       A0,USP                ;RESTORE USER STACK POINTER
   MOVEM.L      PREGS,D0-D7/A0-A7     ;RESTORE REGISTERS
   MOVE         PCL,-[SP]             ;PUSH PCL
   MOVE         PCH,-[SP]             ;PUSH PCH
   MOVE         PSTAT,-[SP]           ;PUSH STATUS
   MOVE         #3,CMD_CONTROL
   RTE                                ;RETURN TO USERS PROGRAM

; END OF THE MONITOR EXIT ROUTINE


; WRITE TARGET MEMORY ACCESS ROUTINE
;   THIS ROUTINE WRITES DATA TO TARGET SYSTEM MEMORY.
;   THE DATA WAS LOADED INTO THE 'XFER_BUF' BY THE EMULATION CONTROLLER.
;   THE STARTING ADDRESS OF THE WRITE PROCESS WAS LOADED INTO
;   'TARG_START' BY THE EMULATION CONTROLLER.  THE LOWER BYTE OF THE
;   'TARG_BYTES' VARIABLE CONTAINS THE NUMBER OF BYTES OF DATA WHICH
;   WILL BE WRITTEN TO TARGET MEMORY.  IF BIT 11 OF THE 'TARG_BTYE'
;   FIELD IS SET THEN THE ACCESS MODE TO TARGET MEMORY IS WORDS.  IF
;   BIT 11 IS NOT SET THEN THE ACCESS MODE IS BYTES. THE 'TARG_BYTE'
;   VARIABLE WAS SET BY THE EMULATION CONTROLLER.
;

TARG_MEM_WR
   MOVE.L       TARG_START,A0
   MOVE.L       #XFR_BUF,A1
   MOVE.W       TARG_BYTES,A2
   CMP.W        #00800H,A2
   BPL          TARG_WORD_WR

TARG_BYTE_WR
   AND.W        #007FFH,TARG_BYTES
T_BYTE_LP_WR
   MOVE.B       [A1]+,D0
   MOVE.B       D0,[A0]+
   NOP
   SUB.W        #1,TARG_BYTES
   BEQ          TARG_WR_ACC_DONE
   BRA          T_BYTE_LP_WR


TARG_WORD_WR
   AND.W        #007FFH,TARG_BYTES
T_WORD_LP_WR
   MOVE.W       [A1]+,A2
   MOVE.W       A2,[A0]+
   SUB.W        #2,TARG_BYTES
   BEQ          TARG_WR_ACC_DONE
   BRA          T_WORD_LP_WR
TARG_WR_ACC_DONE
   MOVE.W       #3,CMD_CONTROL
   BRA          MON_LOOP

; END OF WRITE TARGET MEMORY ACCESS ROUTINE


; READ TARGET MEMORY ACCESS ROUTINE
;   THIS ROUTINE READS DATA FROM TARGET SYSTEM MEMORY.
;   THE DATA IS STORED IN THE 'XFER_BUF'.
;   THE STARTING ADDRESS OF THE READ PROCESS WAS LOADED INTO
;   'TARG_START' BY THE EMULATION CONTROLLER.  THE LOWER BYTE OF THE
;   'TARG_BYTES' VARIABLE CONTAINS THE NUMBER OF BYTES OF DATA WHICH
;   WILL BE READ FROM TARGET MEMORY.  IF BIT 11 OF THE 'TARG_BTYE'
;   FIELD IS SET THEN THE ACCESS MODE TO TARGET MEMORY IS WORDS.  IF
;   BIT 11 IS NOT SET THEN THE ACCESS MODE IS BYTES. THE 'TARG_BYTE'
;   VARIABLE WAS SET BY THE EMULATION CONTROLLER.
;

TARG_MEM_RD
   MOVE.L       TARG_START,A0
   MOVE.L       #XFR_BUF,A1
   MOVE.W       TARG_BYTES,A2
   CMP.W        #00800H,A2
   BPL          TARG_WORD_RD

; PROCESS IN BYTES

TARG_BYTE_RD
   AND.W        #007FFH,TARG_BYTES
T_BYTE_LP_RD
   MOVE.B       [A0]+,D0
   MOVE.B       D0,[A1]+
   SUB.W        #1,TARG_BYTES
   BEQ          TARG_RD_ACC_DONE
   BRA          T_BYTE_LP_RD

;; PROCESS IN WORDS

TARG_WORD_RD
   AND.W        #007FFH,TARG_BYTES
T_WORD_LP_RD
   MOVE.W       [A0]+,D0
   MOVE.W       D0,[A1]+
   SUB.W        #2,TARG_BYTES
   BEQ          TARG_RD_ACC_DONE
   BRA          T_WORD_LP_RD

TARG_RD_ACC_DONE
   MOVE.W       #3,CMD_CONTROL
   BRA          MON_LOOP

; END OF READ TARGET MEMORY ACCESS ROUTINE


;;;;;;;;;;;;;;;;;;;
;; MONITOR ENTRY ;;
;;;;;;;;;;;;;;;;;;;

MON_ENT
                                      ;LOOK FOR BREAK WHILE
                                      ;ALREADY IN THE MONITOR
   CMP.L        #MONITOR_START,2[A7]  ;STACK ADDRESS LESS THAN
   BMI          BREAK_OK              ;MONITOR_START
   CMP.L        #MONITOR_END,2[A7]    ;STACK ADDRESS GREATER THAN
   BPL          BREAK_OK              ;MONITOR_END
   RTE                                ;ALREADY IN THE MONITOR

BREAK_OK
   MOVE         [SP]+,PSTAT          ;SAVE STATUS REGISTER PRIOR TO ENTRY
   MOVE         [SP]+,PCH            ;SAVE PC PRIOR TO ENTRY
   MOVE         [SP]+,PCL            ;STACK IS AS IT WAS BEFORE
INT_JUMP_ENTRY
   MOVEM.L      D0-D7/A0-A7,PREGS    ;SAVE REGISTERS
   MOVE         SR,D0                ;VERIFY SUPERVISOR MODE OPERATION
   BTST         #13,D0
   BNE          MODE_OK
   MOVE.W       #10H,LAST_ENTRY      ;FLAG THE PROBLEM
   BRA          MON_LOOP             ;GO TO MONITOR LOOP
MODE_OK
   MOVE.L       USP,A0               ;SAVE USER STACK POINTER
   MOVE.L       A0,PUSP
   MOVE.W       #3,CMD_CONTROL
;                                    SET STATUS REGISTER AS IT WAS
;                                    PRIOR TO MONITOR ENTRY
;  MOVE.W       PSTAT,D0
;  OR           #0F8FFH,D0
;  MOVE.W       SR,D1
;  AND          D1,D0
;  MOVE.W       D0,SR
   JMP          MON_LOOP

; MONITOR CONTROL LOOP
;   THE FOREGROUND MONITOR WAITS IN THIS LOOP UNTIL THE EMULATOR
;   CONTROLLER REQUESTS AN ACTION BY SETTING CMD_CONTROL TO 1
;

MON_LOOP
   MOVE.W       CMD_CONTROL,D0
   CMP.W        #1,D0             ;COMMAND HAS BEEN REQUESTED
   BEQ          COMMAND_REQUEST
   BRA          MON_LOOP

; COMMAND_REQUEST
;   WHEN A COMMAND HAS BEEN REQUESTED, THIS ROUTINE DETERMINES THE
;   TYPE OF COMMAND REQUESTED AND INITITES THE APPROPRIATE ACTION

COMMAND_REQUEST
   MOVE.W       #0,CMD_RESULT     ;CLEAR OUT RESULT VARIABLE
   MOVE.W       #2,CMD_CONTROL    ;SET TO INDICATE COMMAND PROCESSING STARTED
   MOVE.W       CMD_TYPE,D0
   CMP.W        #1,D0             ;IN MONITOR OPERATION VERIFICATION
   BEQ          SW_IN_MON
   CMP.W        #2,D0             ;START MONITOR EXIT PROCESS
   BEQ          START_EXIT
   CMP.W        #4,D0             ;PERFORM TARGET MEMORY ACCESS WRITES
   BEQ          TARG_MEM_WR
   CMP.W        #8,D0             ;PERFORM TARGET MEMORY ACCESS READS
   BEQ          TARG_MEM_RD
   BRA          ILL_CTRL_REQ

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; COMMAND ERROR LOOP
ILL_CTRL_REQ
                BRA ILL_CTRL_REQ
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

; FG_RESET_ENTRY IS THE ENTRY ROUTINE THAT A RESET: INITITAL PC
;   IN THE USERS EXCEPTION VECTOR TABLE SHOULD POINT TO IF THE
;   USER WANTS THE EMULATOR TO VECTOR TO THE FOREGROUND MONITOR
;   FROM TARGET SYSTEM RESETS.
;   THIS ROUTINE CLEARS OUT THE REGISTERS D7-D0 AND A6-A0.
;   THE STATUS REGISTER IS SET TO 2700H.
;   THE PC IS SET TO JUMP_ENTRY
;   THE A7 REGISTER, THE SUPERVISOR STACK POINTER AND THE USER
;   STACK POINTER ARE SET TO THE VALUE OF THE SSP AS THE EMULATOR
;   IS RELEASED FROM TARGET RESET.

FG_RESET_ENTRY
   MOVE.W       #01H,LAST_ENTRY            ;SET ENTRY CAUSE
   MOVE.L       #JUMP_ENTRY,CURRENT_PC     ;SET COPY OF PC
   MOVE.W       #2700H,PSTAT               ;SET STATUS
   CLR.L        PD0                        ;CLEAR REGISTERS
   CLR.L        PD1
   CLR.L        PD2
   CLR.L        PD3
   CLR.L        PD4
   CLR.L        PD5
   CLR.L        PD6
   CLR.L        PD7
   CLR.L        PA0
   CLR.L        PA1
   CLR.L        PA2
   CLR.L        PA3
   CLR.L        PA4
   CLR.L        PA5
   CLR.L        PA6
   MOVE.L       A7,PA7                     ;SET EMULATOR COPY OF SSP
   MOVE.L       A7,USP                     ;SET USP TO SAME AS SSP
   MOVE.L       A7,PUSP                    ;SET EMULATOR COPY OF USP
   BRA          MON_LOOP

BERR_ENTRY
   MOVE.W       #04H,LAST_ENTRY
   BRA          SPECIAL_ENTRY
ADDR_ERR_ENTRY
   MOVE.W       #05H,LAST_ENTRY
   BRA          SPECIAL_ENTRY
ILL_INST_ENTRY
   MOVE.W       #06H,LAST_ENTRY
   BRA          MON_ENT
ZERO_D_ENTRY
   MOVE.W       #07H,LAST_ENTRY
   BRA          MON_ENT
CHK_I_ENTRY
   MOVE.W       #08H,LAST_ENTRY
   BRA          MON_ENT
TRAPV_ENTRY
   MOVE.W       #09H,LAST_ENTRY
   BRA          MON_ENT
PRIV_V_ENTRY
   MOVE.W       #0AH,LAST_ENTRY
   BRA          MON_ENT
TRACE_ENTRY
   MOVE.W       #0BH,STEP_ENTRY
   MOVE.W       #0BH,LAST_ENTRY
   BRA          MON_ENT
EMUL_1010_ENTRY
   MOVE.W       #0CH,LAST_ENTRY
   BRA          MON_ENT
EMUL_1111_ENTRY
   MOVE.W       #0DH,LAST_ENTRY
   BRA          MON_ENT
JUMP_ENTRY
   MOVE.W       #0EH,LAST_ENTRY
   BRA          INT_JUMP_ENTRY

BK_RESET_PROCESS
   MOVE.W       #0,CMD_RESULT
   MOVE.W       #2700H,PSTAT
   BRA          MON_LOOP

; SPECIAL ENTRY IS EXECUTRED WHEN THE MONITOR IS ENTERED FROM A BERR
;   OR AN ADDRESS ERROR.  INFORMATION STACKED AS A RESULT OF THE
;   BERR OR ADDRESS ERROR IS SAVED IN STAT1, STAT2, STAT3 AND STAT4.

SPECIAL_ENTRY
     MOVE      [SP]+,STAT1         ;PULL & SAVE EXCEPTION STATUS.
     MOVE      [SP]+,STAT2         ;PULL & SAVE ACCESS ADDRESS HIGH.
     MOVE      [SP]+,STAT3         ;PULL & SAVE ACCESS ADDRESS LOW.
     MOVE      [SP]+,STAT4         ;PULL & SAVE INSTRUCTION REGISTER.
     BRA       MON_ENT

MONITOR_END
