**=====================================================**
*							*
*	XEBEC S1410 DRIVE DIAGNOSTIC			*
*	FOR USE WITH SEAGATE ST-412 5.25 DRIVE		*
*	PERFORMS THE FOLLOWING OPERATIONS:		*
*	   1. CONTROLLER INTERNAL DIAGNOSTIC (E4)	*
*	   2. RAM DIAGNOSTIC (E0)			*
*	   3. TEST DRIVE READY				*
*	   4. INIT DRIVE CHARACTERISTICS		*
*	   5. DRIVE DIAGNOSTIC				*
*	   6. RECALIBRATE DRIVE				*
*							*
**=====================================================**
*
DATA	EQU	0D8H		;SASI DATA
CONTROL	EQU	0D9H		;     CONTROL
XSTEP	EQU	4		;ST-412 buffered step
CMDMSK	EQU	00100000B	;MASK COMMANDD
BSYMSK	EQU	00000010B	;     BUSY
REQMSK	EQU	10000000B	;     REQUEST
SELECT	EQU	3
RESET	EQU	2
ON	EQU	00001000B
OFF	EQU	0
*
CR	EQU	0DH
LF	EQU	0AH
BELL	EQU	07H
*
	ORG	0100H
*
*=============================*
*   INITIALIZATION ROUTINTES  *
*=============================*
*
START:	LXI	SP,STACK	;INIT STACK
	LXI	H,HELMSG	;SAY HELLO
	CALL	PTXT
	JMP	TEST1
*
HELMSG	DB	CR,LF,' BB-II XEBEC Controller and ST-412 Drive Diagnostic'
	DB	' [092684]',CR,LF
	DB	'  Reading sector zero of all 153 tracks.' 
	DB	' Please wait.',CR,LF,0
*
*=============================*
*   DIAGNOSTIC TEST ROUTINES  *
*=============================*
*
* CONTROLLER INTERNAL DIAGNOSTIC
*
TEST1:	LXI	H,T1DCB
	CALL	CMDOUT
	CALL	GETSTAT
*
* CONTROLLER RAM DIAGNOSTIC
*
TEST2:	LXI	H,T2DCB
	CALL	CMDOUT
	CALL	GETSTAT
*
* INIT DRIVE CHARACTERISTICS FOR ST-412
*
	CALL	TEST3
	JMP	TEST4
*
TEST3:	LXI	H,T3DCB
	CALL	CMDOUT		
	CALL	REQWAIT
	LXI	H,T35DCB
TEST35:	IN	CONTROL		
	ANI	CMDMSK
	JNZ	TEST36
	MOV	A,M
	OUT	DATA
	INX	H
	JMP	TEST35
TEST36:	CALL	GETSTAT
	RET
*	
* DRIVE READY
*
TEST4:	LXI	H,T4DCB
	CALL	CMDOUT
	CALL	GETSTAT
*
* DRIVE DIAGNOSTIC
*
TEST5:	LXI	H,T5DCB
	CALL	CMDOUT
	CALL	GETSTAT
*
* RECALIBRATE DRIVE
*
TEST6:	LXI	H,T6DCB
	CALL	CMDOUT
	CALL	GETSTAT
*
DONE:	LXI	H,GBYMSG
	CALL	PTXT
	JMP	0
*
GBYMSG	DB	'    Done, returning to CPM',07,CR,LF,0
*
* COMMAND CONTROL BLOCKS
*
T1DCB	DB	0E4H,0,0,0,0,XSTEP
*
T2DCB	DB	0E0H,0,0,0,0,XSTEP
*
T3DCB	DB	00CH,0,0,0,0,XSTEP
T35DCB	DB	001H,032H	;NUMBER OF CYLINDERS
	DB	004H		;NUMBER OF HEADS
	DB	000H,080H	;CYL TO REDUCE WRITE CURRENT
	DB	000H,080H	;CYL TO WRITE PRECOMP
	DB	00BH		;ERROR BURST LENGTH
*
T4DCB	DB	00BH,0,0,0,0,XSTEP
*
T5DCB	DB	0E3H,0,0,0,0,XSTEP
*
T6DCB	DB	00BH,0,0,0,0,XSTEP
*
*=============================*
*   SASI INTERFACE ROUTINES   *
*=============================*
*
* OUTPUT COMMAND
*
CMDOUT: CALL	SELCTLR
	CALL	REQWAIT
	MVI	B,6
CMDOU1:	MOV	A,M
	OUT	DATA
	INX	H
	DCR	B
	JNZ	CMDOU1
	RET
*
* SELECT CONTROLLER
*
SELCTLR:IN	CONTROL		;WAIT CONTROLLER NOT BUSY
	ANI	BSYMSK
	JNZ	SELCTLR
	MVI	A,1		;SELECT XEBEC CTLR # 1
	OUT	DATA
	MVI	A,SELECT+ON
	OUT	CONTROL		
SELC1:	IN	CONTROL		;WAIT CONTROLLER BUSY
	ANI	BSYMSK	
	JZ	SELC1
	MVI	A,SELECT+OFF
	OUT	CONTROL
	RET
*
* GET CONTROLLER STATUS BYTES
*
GETSTAT:CALL	REQWAIT
	IN	DATA		;READ FIRST COMPLETION BYTE
	MOV	B,A
	CALL	REQWAIT
	IN	DATA		;READ SECOND COMPLETION BYTE
	MOV	A,B
	ANI	002H
	CNZ	ERROR
	CALL	BREAK
	RET
*
* WAIT FOR REQUEST ACTIVE FROM CONTROLLER
*
REQWAIT:in	CONTROL
	ani	REQMSK
	rnz
	push	h
	push	d
	push	b
	call	BREAK
	pop	b
	pop	d
	pop	h
	jmp	REQWAIT
*
* CONSOLE BREAK
*
BREAK:	MVI	C,11
	CALL	0005H
	ORA	A
	RZ
	MVI	C,1
	CALL	0005H
	LXI	H,BRKMSG
	CALL	PTXT
	MVI	C,1
	CALL	0005H
	PUSH	PSW
	CALL	CRLF
	POP	PSW
	CPI	'Y'
	JZ	BREAK1
	CPI	'y'
	RNZ
BREAK1	MVI	A,RESET+ON
	OUT	CONTROL
	XRI	ON
	OUT	CONTROL
	CALL	TEST3
	JMP	DONE
*
BRKMSG	DB	'  User break? (Y/N) ',0
*
* READ SENSE BYTES 
*
READS:	LXI	H,RSSDCB
	CALL	CMDOUT		;READ-SENSE-STATUS COMMAND
	CALL	REQWAIT
	LXI	H,ERRBUF
	MVI	B,4
READS1:	IN	DATA
	MOV	M,A
	INX	H
	DCR	B
	JNZ	READS1
	CALL	GETSTAT
	RET
*
RSSDCB	DB	003H,0,0,0,0,000H
*
*=============================*
*   ERROR HANDLING ROUTINES   *
*=============================*
*
ERROR:	LXI	H,ERRMSG
	CALL	PTXT		
	CALL	READS		;READ SENSE BYTES
	LDA	ERRBUF
	CALL	PUTHEX
	LDA	ERRBUF+1
	CALL	PUTHEX
	LDA	ERRBUF+2
	CALL	PUTHEX
	LDA	ERRBUF+3
	CALL	PUTHEX
	JMP	DONE
*
ERRMSG	DB	CR,LF,BELL,'  ** SASI Error: ',0
*
* PRINT HEX NUMBER IN A-REG FOLLOWED BY '.'
*
PUTHEX:	PUSH	PSW
	RRC ! RRC ! RRC ! RRC
	CALL	PNYBBL		;PRINT HIGH NYBBLE OF HEX BYTE
	POP	PSW
	CALL	PNYBBL		;PRINT LOW NYBBLE OF HEX BYTE
	MVI	E,'.'
	CALL	OUTC		;PRINT DELIMITER CHARACTER @HL
	RET
*
* PRINT NIBBLE
*
PNYBBL:	ANI	00FH
	ADI	090H
	DAA
	ACI	040H
	DAA
	MOV	E,A
	CALL	OUTC
	RET
*
* OUTPUT CHARACTER
*
OUTC:	PUSH	H
	PUSH	D
	PUSH	B
	MVI	C,2
	CALL	0005H		;BDOS
	POP	B
	POP	D
	POP	H
	RET
*
* NEWLINE
*
CRLF	MVI	E,CR
	CALL	OUTC
	MVI	E,LF
	CALL	OUTC
	RET
*
* OUTPUT TEXT
*
PTXT:	MOV	A,M
	ORA	A
	RZ
	MOV	E,A
	CALL	OUTC
	INX	H
	JMP	PTXT
*
*=============================*
*   DATA AND STACK AREA       *
*=============================*
*
ERRBUF	DB	0,0,0,0		;ADDRESS ERROR BYTES
*
	DS	64
STACK	DS	0
*
	END

