ECHO OFF
CLS
REM  ---------------------------------------------------------------------
REM  --              Sample File Backup/Compare Batch File
REM  --                               for
REM  --           Everex Streaming Tape Software Version 4.08
REM  --
REM  -- Usage: BatchFileName [DriveName:]
REM  --
REM  -- This batch file will backup file-by-file all files of the specified
REM  -- drive to the tape and log backup list to the file LOG under current
REM  -- directory.
REM  --
REM  -- If backup completed with no errors, this batch file will compare
REM  -- the tape directory against the LOG file and then compare the tape
REM  -- data with the disk files.
REM  --
REM  -- If no drive specified, the current drive is used.
REM  --
REM  -- NOTE:
REM  -- (1) Must put a tape on the tape drive before starting this file.
REM  -- (2) Tape data will be overwritten.
REM  ---------------------------------------------------------------------
ECHO --
ECHO -- File backup in progress...please wait
ECHO --
ECHO -- FBACKUP /QE /CT /TN1 /DN1 /LB /LF:LOG %1\*.*/S/Y/H/R/A/I
ECHO --
ECHO --         /QE - Quit on error
ECHO --         /CT - Do not check tape number
ECHO --         /TN - Tape number
ECHO --         /DN - Dataset number (1=overwrite existing tape data)
ECHO --         /LB - Log during backup
ECHO --         /LF - Log file name  (/LF:filename)
ECHO --
ECHO --         /S  - Subdirectory files
ECHO --         /Y  - System files
ECHO --         /H  - Hidden files
ECHO --         /R  - Read only files
ECHO --         /A  - Preserve archive bit
ECHO --         /M  - Modified files only
ECHO --         /D  - Starting date  (/D:mm-dd-year)
ECHO --         /B  - Ending   date  (/B:mm-dd-year)
ECHO --         /I  - Include
ECHO --         /E  - Exclude
ECHO --
FBACKUP /QE /CT /TN1 /DN1 /LB /LF:LOG %1\*.*/S/Y/H/R/A/I/D:1-1-80/B:12-31-2107
IF ERRORLEVEL 1 GOTO L_BAK
CLS
ECHO --
ECHO -- File compare in progress...please wait
ECHO --
ECHO -- FRESTORE COMP /QE /DN1 /DC /LF:LOG %1\*.*/S/Y/H/R/I/E
ECHO --
ECHO --          COMP - Perform compare operation
ECHO --          /QE  - Quit on error
ECHO --          /DN  - Dataset number
ECHO --          /DC  - Compare log file content with tape directory
ECHO --          /LF  - Log file name
ECHO --
ECHO --          /S   - Subdirectory files
ECHO --          /Y   - System files
ECHO --          /H   - Hidden files
ECHO --          /R   - Read only files
ECHO --          /I   - Include
ECHO --          /E   - Exclude
ECHO --
FRESTORE COMP /QE /DN1 /DC /LF:LOG %1\*.*/S/Y/H/R/I
IF ERRORLEVEL 1 GOTO L_CMP
CLS
ECHO --------------------------------------------------------
ECHO -- File backup  of drive %1 completed with no errors. --
ECHO -- File compare of drive %1 completed with no errors. --
ECHO --------------------------------------------------------
GOTO L_END
:L_BAK
ECHO ********************************************************
ECHO ** File backup  of drive %1 terminated due to ERROR!! **
ECHO ********************************************************
PAUSE
GOTO L_END
:L_CMP
ECHO ********************************************************
ECHO ** File compare of drive %1 terminated due to ERROR!! **
ECHO ********************************************************
PAUSE
GOTO L_END
:L_END
ECHO ON

