   Syntax10.Scn.Fnt    Syntax10i.Scn.Fnt                             T    
           T                     MODULE Terminal;

	IMPORT
		V24, Input, Display, Fonts, Texts, TextFrames, WriteFrames,
		Viewers, MenuViewers, Oberon, Terminals, TerminalFrames;

	CONST
		Version = "Terminal - gri 5.6.92";
		Menu1 = "System.Close  System.Grow  Terminal.Reset";
		Menu2 = "System.Close  System.Copy  System.Grow  Terminal.Clear  Write.Search  Write.Store ";
		StdFont = "Courier10.Scn.Fnt";
		left = 2; middle = 1; right = 0;

	VAR
		W: Texts.Writer;
		CSR, MR1, MR2: CHAR; (* V24 settings *)
		Server: Oberon.Task; (* polling task *)
		Term: Terminals.Terminal;
		

	PROCEDURE* Send0 (T: Terminals.Terminal; ch: CHAR);
	BEGIN V24.Send(ch)
	END Send0;
	
	PROCEDURE* Break0 (T: Terminals.Terminal);
	BEGIN V24.Break
	END Break0;

	PROCEDURE* Serve;
		VAR ch: CHAR; keys, oldKeys: SET; x, y, oldX, oldY: INTEGER;
	BEGIN
		Input.Mouse(keys, x, y);
		oldKeys := keys; oldX := x; oldY := y;
		WHILE (V24.Available() > 0) & (keys = oldKeys) & (x = oldX) & (y = oldY) DO
			V24.Receive(ch); Terminals.Receive(Term, ch);
			Input.Mouse(keys, x, y)
		END;
		Terminals.Flush(Term)
	END Serve;

	PROCEDURE OpenScanner (VAR S: Texts.Scanner);
		VAR text: Texts.Text; beg, end, time: LONGINT;
	BEGIN
		Texts.OpenScanner(S, Oberon.Par.text, Oberon.Par.pos); Texts.Scan(S);
		IF (S.class = Texts.Char) & (S.c = "^") & (S.line = 0) THEN Oberon.GetSelection(text, beg, end, time);
			IF time >= 0 THEN Texts.OpenScanner(S, text, beg); Texts.Scan(S) END
		END
	END OpenScanner;

	PROCEDURE Start*;
		VAR S: Texts.Scanner;
	BEGIN OpenScanner(S);
		LOOP
			IF (S.line = 0) & (S.class = Texts.Name) THEN
				IF S.s = "even" THEN MR1 := CHR(ORD(MR1) DIV 32 * 32 + 0 + ORD(MR1) MOD 4)
				ELSIF S.s = "odd" THEN MR1 := CHR(ORD(MR1) DIV 32 * 32 + 4 + ORD(MR1) MOD 4)
				ELSIF S.s = "none" THEN MR1 := CHR(ORD(MR1) DIV 32 * 32 + 16 + ORD(MR1) MOD 4)
				END
			ELSIF (S.line = 0) & (S.class = Texts.Int) THEN
				IF S.i = 1 THEN MR2 := 7X
				ELSIF S.i = 2 THEN MR2 := 0FX
				ELSIF S.i = 7 THEN MR1 := CHR(ORD(MR1) DIV 4 * 4 + 2)
				ELSIF S.i = 8 THEN MR1 := CHR(ORD(MR1) DIV 4 * 4 + 3)
				ELSIF S.i = 1200 THEN CSR := 66X
				ELSIF S.i = 2400 THEN CSR := 88X
				ELSIF S.i = 4800 THEN CSR := 99X
				ELSIF S.i = 9600 THEN CSR := 0BBX
				ELSIF S.i = 19200 THEN CSR := 0CCX
				END
			ELSE EXIT
			END;
			Texts.Scan(S)
		END;
		V24.Stop; V24.Send(1X); (* enable flow control *)
		V24.Start(CSR, MR1, MR2);
		IF Server = NIL THEN NEW(Server); Server.safe := FALSE; Server.handle := Serve; Oberon.Install(Server) END
	END Start;

	PROCEDURE Stop*;
	BEGIN V24.Stop; V24.Send(0X); (* disable flow control *)
		IF Server # NIL THEN Oberon.Remove(Server); Server := NIL END
	END Stop;


(* VT100 view *)

	PROCEDURE Open*;
		VAR S: Texts.Scanner; F: TerminalFrames.Frame; V: MenuViewers.Viewer; x, y: INTEGER;
	BEGIN OpenScanner(S);
		IF (S.line # 0) OR (S.class # Texts.Name) THEN S.s := StdFont END;
		NEW(F); TerminalFrames.Open(F, TerminalFrames.Handle, Term, Fonts.This(S.s));
		Oberon.AllocateUserViewer(Oberon.Mouse.X, x, y);
		V := MenuViewers.New(TextFrames.NewMenu("VT100", Menu1), F, TextFrames.menuH, x, y)
	END Open;

	PROCEDURE Send*;
		VAR S: Texts.Scanner;
	BEGIN OpenScanner(S);
		LOOP
			IF S.class IN {Texts.Name, Texts.String} THEN Terminals.SendString(Term, S.s)
			ELSIF S.class = Texts.Int THEN Terminals.Send(Term, CHR(S.i MOD 256))
			ELSE EXIT
			END;
			Texts.Scan(S)
		END
	END Send;
	
	PROCEDURE Reset*;
	BEGIN Terminals.Reset(Term)
	END Reset;


(* log view *)

	PROCEDURE Scroll (F: WriteFrames.Frame; ins: LONGINT);
		VAR R: Texts.Reader; beg, end, n: LONGINT; ch: CHAR;
	BEGIN end := WriteFrames.Pos(F, F.X + F.W, F.Y);
		IF (ins < end) & (end < F.text.len) THEN
			Texts.OpenReader(R, F.text, end); Texts.Read(R, ch); n := 0;
			WHILE ~R.eot DO
				IF ch = 0DX THEN INC(n) END;
				Texts.Read(R, ch)
			END;
			beg := F.org;
			Texts.OpenReader(R, F.text, beg); Texts.Read(R, ch);
			WHILE ~R.eot & (n > 0) & (Texts.Pos(R) # Term.pin) DO
				IF ch = 0DX THEN DEC(n); beg := Texts.Pos(R) END;
				Texts.Read(R, ch)
			END;
			IF beg # F.org THEN WriteFrames.Show(F, beg) END
		END
	END Scroll;
	
	PROCEDURE SetCaret (F: WriteFrames.Frame);
		VAR pos: LONGINT;
	BEGIN pos := WriteFrames.Pos(F, F.X + F.W, F.Y);
		IF ~F.hasCar OR (F.carLoc.pos # pos) THEN WriteFrames.SetCaret(F, pos) END
	END SetCaret;

	PROCEDURE SendKey (ch: CHAR);
	BEGIN
		IF ch = "" THEN Terminals.Send(Term, 1BX)
		ELSIF ch = "" THEN Terminals.Send(Term, 81X)
		ELSIF ch = "" THEN Terminals.Send(Term, 8FX)
		ELSIF ch = "" THEN Terminals.Send(Term, 95X)
		ELSIF ch = "" THEN Terminals.Send(Term, 01X)
		ELSIF ch = "" THEN Terminals.Send(Term, 0FX)
		ELSIF ch = "" THEN Terminals.Send(Term, 15X)
		ELSE Terminals.Send(Term, ch)
		END
	END SendKey;

	PROCEDURE* Handle (F: Display.Frame; VAR msg: Display.FrameMsg);
		VAR text: Texts.Text; beg, end, time: LONGINT; hasCar: BOOLEAN;
	BEGIN
		WITH F: WriteFrames.Frame DO
			IF msg IS Oberon.InputMsg THEN
				WITH msg: Oberon.InputMsg DO
					IF (msg.id = Oberon.consume) & F.hasCar THEN SendKey(msg.ch)
					ELSIF (msg.id = Oberon.track) & (F.X + F.barW <= msg.X) & (left IN msg.keys) THEN
						Oberon.PassFocus(MenuViewers.Ancestor);
						WriteFrames.TrackCaret(F, msg.X, msg.Y, msg.keys);
						IF msg.keys * {middle, right} = {middle} THEN
							Oberon.GetSelection(text, beg, end, time);
							IF time >= 0 THEN Terminals.SendText(Term, text, beg, end) END
						END
					ELSE WriteFrames.Handle(F, msg)
					END
				END
			ELSIF (msg IS Oberon.CopyOverMsg) & F.hasCar THEN
				WITH msg: Oberon.CopyOverMsg DO Terminals.SendText(Term, msg.text, msg.beg, msg.end) END
			ELSIF msg IS TextFrames.UpdateMsg THEN
				WITH msg: TextFrames.UpdateMsg DO
					IF msg.text = F.text THEN hasCar := F.hasCar; WriteFrames.Handle(F, msg);
						IF (msg.id = TextFrames.insert) & (F.H DIV F.lsp > 0) THEN Scroll(F, msg.beg) END;
						IF hasCar THEN SetCaret(F) END
					END
				END
			ELSE WriteFrames.Handle(F, msg)
			END
		END
	END Handle;

	PROCEDURE OpenLog*;
		VAR S: Texts.Scanner; x, y: INTEGER; V: MenuViewers.Viewer;
	BEGIN OpenScanner(S);
		IF (S.line = 0) & (S.class = Texts.Name) THEN Texts.SetFont(Term.cache, Fonts.This(S.s)) END;
		Oberon.AllocateUserViewer(Oberon.Mouse.X, x, y);
		V := MenuViewers.New(
			TextFrames.NewMenu("Log", Menu2),
			WriteFrames.NewText(Term.text, 0),
			TextFrames.menuH, x, y);
		V.dsc.next.handle := Handle
	END OpenLog;

	PROCEDURE Clear*;
	BEGIN Texts.Delete(Term.text, 0, Term.text.len)
	END Clear;

BEGIN Texts.OpenWriter(W);
	Texts.WriteString(W, Version); Texts.WriteLn(W); Texts.Append(Oberon.Log, W.buf);
	CSR := 0BBX; MR1 := 13X; (* no parity, 8 bits *) MR2 := 7X; (* 9600 baud, 1 stop bit *)
	NEW(Term); Terminals.Open(Term, TextFrames.Text(""), Send0, Break0, TerminalFrames.NotifyDisplay);
	Server := NIL;
    V24.SetOP({0,1});
END Terminal.