#   Syntax10.Scn.Fnt  )   )  					MODULE  Printmaps              NW 9.7.89 / 17.11.90

BMadr     EQU     $300000     Ceres-2
Org       EQU     $300000+3425*292

Pat       SBLKD   10

					SDOUBLE   9      array bounds
plim      SDOUBLE   0
a0        SDOUBLE   0
h         SDOUBLE   0
pwb       SDOUBLE   0

pat0      SDOUBLE   $1200000, 0
pat1      SDOUBLE   $8200000, $10001, 0, 0, 0, $1000100, 0, 0, 0
pat2      SDOUBLE   $6200000, $1010101, 0, 0, $10101010, 0, 0
pat3      SDOUBLE   $4200000, $11111111, 0, $44444444, 0
pat4      SDOUBLE   $2200000, $11111111, $44444444
pat5      SDOUBLE   $1200000, -1
pat6      SDOUBLE   $10200000, $10001, $20002, $40004, $80008, $100010, $200020, $400040, $800080
					SDOUBLE   $1000100, $2000200, $4000400, $8000800, $10001000, $20002000, $40004000, $80008000
pat7      SDOUBLE   $10200000, $80008000, $40004000, $20002000, $10001000, $8000800, $4000400, $2000200
					SDOUBLE   $1000100, $800080, $400040, $200020, $100010, $80008, $40004, $20002, $10001
pat8      SDOUBLE   $1200000, $80008000
pat9      SDOUBLE   $10200000, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0

					ADDR    pat0+2, Pat      initialization
					ADDR    pat1+2, Pat+4
					ADDR    pat2+2, Pat+8
					ADDR    pat3+2, Pat+12
					ADDR    pat4+2, Pat+16
					ADDR    pat5+2, Pat+20
					ADDR    pat6+2, Pat+24
					ADDR    pat7+2, Pat+28
					ADDR    pat8+2, Pat+32
					ADDR    pat9+2, Pat+36
					RXP     0

* PROCEDURE Map(): LONGINT;
Map       MOVD    BMadr, R0
					RXP     0

* PROCEDURE ClearPage;

ClearPage MOVD    BMadr, R0
					MOVD    3425*292, R1
CLoop     MOVQD   0, -4(R0)[R1:B]
					ACBD   -4, R1, CLoop
					RXP     0

* PROCEDURE CopyPattern 
*              (pat: LONGINT;         16
*               X, Y: INTEGER);       12, 8
*
* R0: work reg
* R1: source    p
* R2: dest      M + 3425*292 - Y*292 + X DIV 8
* R3: width     (p.w + 7) DIV 8
* R4: height    p.h
* R5: inc
* R6: offset    X MOD 8
* R7: extent    p.w

CopyPattern MOVD  16(SP), R1           p
					MOVZBD  0(R1), R3            p.w
					MOVD    R3, R7               p.w
					ADDQD   7, R3                p.w + 7
					LSHD    -3, R3             | (p.w + 7) DIV 8
					MOVZBD  1(R1), R4            p.h
					MOVD    8(SP), R0            Y
					MOVXWD  12(SP), R2           X
					MOVD    R2, R6               X
					LSHD    -3, R2               X DIV 8
					MULD    292, 8(SP)            Y*292
					SUBD    8(SP), R2          | -Y*292 + X DIV 8
					ADDD    3425*292+BMadr, R2
					ANDD    7, R6                X MOD 8
					MOVD    -292, R5             inc

					CMPQW   0, R7
					BLT     CPTryB               0 < p.w
					RXP     12

CPTryB    CMPW    8, R7                paint mode
					BLT     CPTryW               8 < p.w
					ADDD    R6, R7               p.w + X MOD 8
					CMPW    8, R7
					BLT     CPBWLine             8 < p.w + X MOD 8

CPBLine   MOVB    2(R1), R0            pattern byte
					LSHB    R6, R0               adjust
					ORB     R0, 0(R2)            store
					ADDD    R3, R1
					ADDD    R5, R2               next upper line
					ACBD    -1, R4, CPBLine      dec h
					RXP     12

CPBWLine  MOVZBW  2(R1), R0            pattern byte
					LSHW    R6, R0               adjust
					ORW     R0, 0(R2)            store
					ADDD    R3, R1
					ADDD    R5, R2               next upper line
					ACBD    -1, R4, CPBWLine     dec h
					RXP     12

CPTryW    CMPW    16, R7
					BLT     CPTryD               16 < p.w
					ADDD    R6, R7               p.w + X MOD 8
					CMPW    16, R7
					BLT     CPWDLine             16 < p.w + X MOD 8

CPWLine   MOVW    2(R1), R0            pattern word
					LSHW    R6, R0               adjust
					ORW     R0, 0(R2)            store
					ADDD    R3, R1
					ADDD    R5, R2               next upper line
					ACBD    -1, R4, CPWLine      dec h
					RXP     12

CPWDLine  MOVZWD  2(R1), R0            pattern word
					LSHD    R6, R0               adjust
					ORD     R0, 0(R2)            store
					ADDD    R3, R1
					ADDD    R5, R2               next upper line
					ACBD    -1, R4, CPWDLine     dec h
					RXP     12

CPTryD    CMPW    24, R7
					BLT     CPELine              24 < p.w

CPDLine   MOVD    2(R1), R0            three pattern bytes
					ANDD    $FFFFFF, R0           mask
					LSHD    R6, R0               adjust
					ORD     R0, 0(R2)            store
					ADDD    R3, R1
					ADDD    R5, R2               next upper line
					ACBD    -1, R4, CPDLine      dec h
					RXP     12

CPELine   MOVD    R4, h                four or more pattern bytes
					MOVQD  -1, R5
					LSHD    R6, R5               mask
					MOVD    R3, pwb              pat width in bytes
CPE0      MOVD    R2, a0               start line
					MOVQD   0, R4                carry
CPE1      MOVD    2(R1), R0            next pat dbl word
					ADDQD   4, R1
					ROTD    R6, R0               rotated pattern
					MOVD    R0, R7
					ANDD    R5, R7
					ORD     R4, R7
					ORD     R7, 0(R2)
					ADDQD   4, R2
					BICD    R5, R0
					MOVD    R0, R4
					ADDQD  -4, R3
					CMPQD   2, R3
					BGE     CPE2
					CMPQD   4, R3
					BLE     CPE1

					MOVD    2(R1), R0            three pat bytes
					ADDQD   3, R1
					ANDD    $FFFFFF, R0
					LSHD    R6, R0
					ORD     R4, R0
					ORD     R0, 0(R2)
					BR      CPE5:W

CPE2      CMPQD   1, R3
					BGE     CPE3
					MOVZWD  2(R1), R0            two pat bytes
					ADDQD   2, R1
					LSHD    R6, R0
					ORD     R4, R0
					ORD     R0, 0(R2)
					BR      CPE5

CPE3      BGT     CPE4
					MOVZBW  2(R1), R0            one pat byte
					ADDQD   1, R1
					LSHW    R6, R0
					ORW     R4, R0
					ORW     R0, 0(R2)
					BR      CPE5

CPE4      ORB     R4, 0(R2)            zero pat bytes

CPE5      MOVD    a0, R2
					SUBD    292, R2
					MOVD    pwb, R3
					ACBW   -1, h , CPE0          next line
					RXP     12

* ----------------------------------------------------------

* PROCEDURE ReplPattern
*             (p:  LONGINT;               24
*              X, Y, W, H: INTEGER)       20, 16, 12, 8
*
* R0: work reg
* R1: source
* R2: dest       M + 3425*292 - Y*292 + X DIV 8
* R3: width      W
* R4: height     H
* R5: pattern
* R6: left mask
* R7: right mask

ReplPattern MOVD  8(SP),R4             H
					CMPQD   0,R4
					BGE     RPexit:W
					MOVD    20(SP), R2           X
					MOVD    R2, R0
					ANDB    $1F, R0
					MOVQD  -1, R6
					LSHD    R0, R6               left mask
					MOVD    R2, R3
					ADDD    12(SP), R3           X + W
					MOVD    R3, R0
					ANDB    $1F, R0
					MOVQD  -1, R7
					LSHD    R0, R7
					COMD    R7, R7               right mask
					LSHD   -5, R2
					LSHD   -5, R3
					SUBD    R2, R3               word count
					LSHD    2, R2
					MOVD    16(SP), R5           Y
					ADDQD   2, 24(SP)            adjust
					MOVD    24(SP), R4           adr pat
					MOVXBD  -1(R4), R0           h
					MODD    R0, R5
					LSHD    2, R0                h*4
					ADDD    R4, R0
					MOVD    R0, plim             pattern limit
					LSHD    2, R5
					ADDD    R5, R4               pat start adr
					MOVD    16(SP), R5           Y
					MULD    292, R5
					SUBD    R5, R2
					ADDD    3425*292+BMadr, R2
					CMPQD   1, R3                paint mode
					BLE     RPPTryM
					MOVD    8(SP), R3            H
					ANDD    R6, R7               combined mask

RPPSLine  MOVD    0(R4), R1            pattern
					ANDD    R7, R1
					ORD     R1, 0(R2)
					ADDQD   4, R4
					CMPD    R4, plim
					BLT     RPPSL1
					MOVD    24(SP), R4
RPPSL1    SUBD    292, R2
					ACBW   -1, R3, RPPSLine
					RXP     20

RPPTryM   BLT     RPPLLine
					MOVD    8(SP), R3            H

RPPMLine  MOVD    0(R4), R5            pattern
					MOVD    R5, R1
					ANDD    R6, R1
					ORD     R1, 0(R2)
					ANDD    R7, R5
					ORD     R5, 4(R2)
					ADDQD   4, R4
					CMPD    R4, plim
					BLT     RPPML1
					MOVD    24(SP), R4
RPPML1    SUBD    292, R2
					ACBW   -1, R3, RPPMLine
					RXP     20

RPPLLine  MOVD    R3, 12(SP)
RPPLL0    MOVD    0(R4), R5            pattern
					MOVD    R5, R1
					ANDD    R7, R1
					ORD     R1, 0(R2)[R3:D]
					ADDQD  -1, R3
RPPLL1    ORD     R5, 0(R2)[R3:D]
					ACBD   -1, R3, RPPLL1
					ANDD    R6, R5
					ORD     R5, 0(R2)[R3:D]
					ADDQD   4, R4
					CMPD    R4, plim
					BLT     RPPLL2
					MOVD    24(SP), R4
RPPLL2    SUBD    292, R2
					MOVD    12(SP), R3
					ACBW   -1, 8(SP), RPPLL0
RPexit    RXP     20

* ----------------------------------------------------------

* PROCEDURE ReplConst
*             (X, Y, W, H: INTEGER)       20, 16, 12, 8
*
* R0: work reg
* R1: bits
* R2: dest       M + 3425*292 - Y*292 + (X DIV 32)*4
* R3: width      W
* R4: height     H
* R5: inc
* R6: left mask
* R7: right mask

ReplConst MOVD    8(SP),R4           H
					CMPQD   0,R4
					BGE     RCexit:W
					MOVD    12(SP),R3          W
					CMPQD   0,R3
					BGE     RCexit:W
					MOVD    20(SP), R2           X
					MOVD    R2, R0               X
					ANDB    $1F, R0              X MOD 32
					MOVQD   -1, R6
					LSHD    R0, R6               left mask
					ADDD    R2, R3               X + W
					MOVD    R3, R0
					ANDB    $1F, R0            | (X + W) MOD 32
					MOVQD   -1, R7
					LSHD    R0, R7
					COMD    R7, R7               right mask
					LSHD    -5, R3             | (X + W) DIV 32
					LSHD    -5, R2               X DIV 32
					SUBD    R2, R3             | (X + W) DIV 32 - X DIV 32
					LSHD    2, R2              | (X DIV 32)*4
					MULD    292, 16(SP)            Y*292
					SUBD    16(SP), R2         | - Y*292 + (X DIV 32)*4
					ADDD    3425*292+BMadr, R2
					MOVQD   -1, R1
					MOVD    -292, R5

					CMPQD   1, R3                replace mode
					BLE     RCRTryM              0 < width
					ANDD    R6, R7               combined mask
RCRSLine  ORD     R7, 0(R2)
					ADDD    R5, R2               next upper line
					ACBW    -1, R4, RCRSLine     dec H
					RXP     16

RCRTryM   BLT     RCRLLine
RCRMLine  ORD     R7, 4(R2)
					ORD     R6, 0(R2)
					ADDD    R5, R2               next upper line
					ACBW    -1, R4, RCRMLine     dec H
					RXP     16

RCRLLine  MOVD    R3, R0               width
					ORD     R7, 0(R2) [R0:D]
					ADDQD   -1, R0               dec width
RCRLWord  MOVD    R1, 0(R2) [R0:D]
					ACBD    -1, R0, RCRLWord
					ORD     R6, 0(R2)   
					ADDD    R5, R2               next upper line
					ACBW    -1, R4, RCRLLine     dec H
RCexit    RXP     16

* -------------------------------------------------

* PROCEDURE Dot(x, y: LONGINT);

Dot       MOVD    12(SP), R0    x
					MOVD    8(SP), R1    y
					CMPQD   0, R0
					BGT     dex
					CMPD    R0, 2336
					BGE     dex
					CMPQD   0, R1
					BGT     dex
					CMPD    R1, 3425
					BGE     dex
					MULD    2336, R1
					SUBD    R1, R0
					SBITD    R0, @Org
dex       RXP     8
