#   Syntax10.Scn.Fnt       LSC.Compile *	LSC.Compile @
LSD.OpenLog	LSD.Show	LSD.ClearLog	LSD.Init

Simulator.Open
Simulator.Init	Simulator.Reset	Simulator.Step 32
Simulator.Set ~

MODULE  Counter;
	CONST N = 5;
	VAR Q, c: [N] BIT;
		bus: BUS; oc: OC;
BEGIN
	Q.0 := REG(~Q.0); c.0 := Q.0;
	FOR i := 1 .. N-1 DO Q.i := REG(Q.i - c[i-1]); c.i := Q.i * c[i-1] END ;
	bus := Q.1 | Q.2; bus := c.3 | Q.4;
	oc := ~c.1; oc := ~Q.2
END Counter.

MODULE Mem;
	VAR a0, a1, a2, b0, b1, b2, b3, q0, q1, q2, q3: BIT;
BEGIN a0 := REG(~a0); a1 := REG(a1-a0); a2 := REG(a2 - a1*a0);
	b0 := a0+a1; b1 := ~a0+a1; b2 := a0+~a1; b3:= ~a0+~a1;
	q0 := SR(b0+a2, b0+~a2); q1 := SR(b1+a2, b1+~a2);
	q2 := SR(b2+a2, b2+~a2); q3 := SR(b3+a2, b3+~a2)
END Mem.

