#   Syntax10.Scn.Fnt  7
   7
  MODULE LP;

IMPORT LSD, Oberon, Texts;

CONST DSC = 0; NXT = 1;

TYPE
	OLMC = RECORD (* Output Logic Macro Cell *)
		pin: ARRAY 4 OF CHAR; (* name of associated pin *)
		prod: INTEGER; (* number of available products *)
		off: INTEGER; (* fusemap offset *)
		p: INTEGER; (* next product to fill in *)
	END;

	IP = RECORD (* Input Pin *)
		pin:  ARRAY 4 OF CHAR; (* name of associated pin *)
	END;
						
VAR 
	W: Texts.Writer;
	opin: ARRAY 10 OF OLMC;
	ipin: ARRAY 10 OF IP;
	ip, op: INTEGER;
	fm: ARRAY 6136 OF BOOLEAN; (* 44 * 138 + 64 bits *)
	i: INTEGER;

PROCEDURE Err(s: ARRAY OF CHAR);
BEGIN
	Texts.WriteString(W, "*** Error: "); Texts.WriteString(W, s); Texts.WriteLn(W); Texts.Append(Oberon.Log, W.buf)
END Err;

PROCEDURE Add(in: LSD.Signal);
BEGIN
	ip := 0; WHILE (ip <= 9) & (in(LSD.Variable).name # ipin[ip].pin) DO INC(ip) END;
	IF op > 9 THEN Err("unknown input pin")
	ELSE fm[opin[op].off + opin[op].p*44 + ip*4] := TRUE;  Texts.WriteInt(W, opin[op].off + opin[op].p*44 + ip*4, 5);
	END;
END Add;

PROCEDURE Expr(e: LSD.Signal);
BEGIN
	IF ~(e.fct IN {LSD.and, LSD.or}) THEN
		Err("unknown operator")
	ELSE
		IF e.fct = LSD.and THEN Texts.WriteString(W, " AND ");
		ELSIF e.fct = LSD.or THEN Texts.WriteString(W, " OR ");
		END;
		IF e.x.fct = LSD.Bit THEN Add(e.x); LSD.WriteName(W, e.x(LSD.Variable)) ELSE Expr(e.x) END;
		INC(opin[op].p);
		IF e.y.fct = LSD.Bit THEN Add(e.y); LSD.WriteName(W, e.y(LSD.Variable)) ELSE Expr(e.y) END;
		INC(opin[op].p);
	END;
END Expr;

PROCEDURE GenFMap*;
	VAR v: LSD.Variable; e: LSD.Signal;
BEGIN
	IF LSD.org = NIL THEN Err("empty circuit")
	ELSE 
		v := LSD.org.dsc;
		WHILE v # NIL DO
			LSD.WriteName(W, v);
			IF (v.x # NIL) THEN (* new OLMC *)
				op := 0; WHILE (op <= 9) & (v.name # opin[op].pin) DO INC(op) END;
				IF op > 9 THEN Err("unknown output pin")
				ELSE Expr(v.x) END;
			END;
			Texts.WriteLn(W); Texts.Append(Oberon.Log, W.buf);
			v := v.next;
		END;
	END;
END GenFMap;

PROCEDURE WriteFMap*;
	VAR r, c: INTEGER;
BEGIN i := 44;
	FOR r := 0 TO 119 DO
		FOR c := 0 TO 43 DO
			IF fm[i] THEN Texts.Write(W, "X") ELSE Texts.Write(W, "-") END;
			IF c MOD 4 = 3 THEN Texts.Write(W, " ") END;
			INC(i)
		END;
		INC(i, 6);
		Texts.WriteLn(W); Texts.Append(Oberon.Log, W.buf);
	END;
END WriteFMap;
		

BEGIN
	Texts.OpenWriter(W);
	opin[0].pin := "P27"; opin[0].prod := 8; opin[0].off := 44; opin[0].p := 0;
	opin[1].pin := "P26"; opin[1].prod := 10; opin[1].off := 440; opin[1].p := 0;
	opin[2].pin := "P25"; opin[2].prod := 12; opin[2].off := 924; opin[2].p := 0;
	opin[3].pin := "P24"; opin[3].prod := 14; opin[3].off := 1496; opin[3].p := 0;
	opin[4].pin := "P23"; opin[4].prod := 16; opin[4].off := 2156; opin[4].p := 0;
	opin[5].pin := "P21"; opin[5].prod := 16; opin[5].off := 2904; opin[5].p := 0;
	opin[6].pin := "P20"; opin[6].prod := 14; opin[6].off := 3652; opin[6].p := 0;
	opin[7].pin := "P19"; opin[7].prod := 12; opin[7].off := 4312; opin[7].p := 0;
	opin[8].pin := "P18"; opin[8].prod := 10; opin[8].off := 4884; opin[8].p := 0;
	opin[9].pin := "P17"; opin[9].prod := 8; opin[9].off := 5368; opin[9].p := 0;
	ipin[0].pin := "P2"; ipin[1].pin := "P3"; ipin[2].pin := "P4"; ipin[3].pin := "P5"; ipin[4].pin := "P6";
	ipin[5].pin := "P7"; ipin[6].pin := "P9"; ipin[7].pin := "P10"; ipin[8].pin := "P11"; ipin[9].pin := "P12";
	FOR i := 0 TO 6135 DO fm[i] := FALSE END;
END LP.

LP.GenFMap
LP.WriteFMap