#   Syntax10.Scn.Fnt  &   &  MODULE Printer;  (*NW 8.8.88 / 5.7.91   LBP*)
	IMPORT SYSTEM, Display, Printmaps, Fonts;

	CONST maxfonts = 16;
		N = 20;  (*max nof polys for splines*)
		PR0 = 0FFFFF600H; PR1 = 0FFFFF604H;
		proff = 0; prdy = 1; sbusy = 2; end = 3;  (*Istat elements*)

	TYPE RealVector = ARRAY N OF REAL;
		Poly = RECORD a, b, c, d, t: REAL END ;
		PolyVector = ARRAY N OF Poly;

	VAR res*: INTEGER;
		PageWidth*, PageHeight*: INTEGER;
		nofonts: INTEGER;
		X, Y: INTEGER;  (*coordinates for Strings*)
		BMadr: LONGINT;
		fontname: ARRAY maxfonts, 32 OF CHAR;
		pfont: ARRAY maxfonts OF Fonts.Font;
		map: ARRAY 256 OF INTEGER;

	PROCEDURE Append(VAR d: ARRAY OF CHAR; s: ARRAY OF CHAR; k: INTEGER);
		VAR i: INTEGER;
	BEGIN i := 0;
		REPEAT d[k] := s[i]; INC(k); INC(i) UNTIL s[i-1] = 0X
	END Append;

	PROCEDURE Open*(VAR name, user: ARRAY OF CHAR; password: LONGINT);
		(*res = 0: opened, 1: no connection, 2: no link, 3: bad response, 4: no permission*)
	BEGIN nofonts := 0;
		IF SYSTEM.BIT(PR0, proff) THEN res := 1 ELSE Printmaps.ClearPage; res := 0 END
	END Open;

	PROCEDURE ReplConst*(x, y, w, h: INTEGER);
	BEGIN
		IF x < 0 THEN INC(w, x); x := 0 END ;
		IF x+w > PageWidth THEN w := PageWidth - x END ;
		IF y < 0 THEN INC(h, y); y := 0 END ;
		IF y+h > PageHeight THEN h := PageHeight - y END ;
		Printmaps.ReplConst(x, y, w, h)
	END ReplConst;

	PROCEDURE PrintFont(VAR fname: ARRAY OF CHAR): Fonts.Font;
		VAR i, j: INTEGER;
			pfnt: Fonts.Font;
			extname: ARRAY 32 OF CHAR;
	BEGIN i := 0;
		WHILE (i < nofonts) & (fontname[i] # fname) DO INC(i) END ;
		IF i = nofonts THEN
			IF nofonts < maxfonts THEN 
				j := 0;
				REPEAT extname[j] := fname[j]; INC(j) UNTIL extname[j-1] < "0";
				Append(extname, ".Pr3.Fnt", j-1);
				pfnt := Fonts.This(extname);
				IF pfnt = Fonts.Default THEN pfnt := Fonts.This("Syntax10.Pr3.Fnt") END ;
				COPY(fname, fontname[nofonts]); pfont[nofonts] := pfnt; INC(nofonts)
			ELSE i := 0
			END
		END ;
		RETURN pfont[i]
	END PrintFont;

	PROCEDURE UseListFont*(VAR name: ARRAY OF CHAR);
		VAR pfnt: Fonts.Font;
	BEGIN
		IF nofonts < maxfonts THEN
			pfnt := Fonts.This("Gacha10l.Pr3.Fnt");
			IF pfnt = NIL THEN pfnt := Fonts.This("Syntax10.Pr3.Fnt") END ;
			COPY(name, fontname[nofonts]); pfont[nofonts] := pfnt; INC(nofonts)
		END
	END UseListFont;

	PROCEDURE String*(x, y: INTEGER; VAR s, fname: ARRAY OF CHAR);
		VAR i, dx, x0, y0, w, h: INTEGER;
			pat: LONGINT; pfnt: Fonts.Font;
	BEGIN X := x; Y := y; pfnt := PrintFont(fname);
		IF (x >= 0) & (y >= 0) & (y + pfnt.height < PageHeight) THEN
			i := 0;
			WHILE s[i] > 0X DO
				Display.GetChar(pfnt.raster, s[i], dx, x0, y0, w, h, pat);
				IF (X + x0 + w <= PageWidth) & (h > 0) THEN
					Printmaps.CopyPattern(pat, X+x0, Y+y0)
				END ;
				INC(X, dx); INC(i)
			END
		END
	END String;

	PROCEDURE ContString*(VAR s, fname: ARRAY OF CHAR);
		VAR i, dx, x0, y0, w, h: INTEGER;
			pat: LONGINT; pfnt: Fonts.Font;
	BEGIN pfnt := PrintFont(fname);
		IF (X >= 0) & (Y >= 0) & (Y + pfnt.height < PageHeight) THEN
			i := 0;
			WHILE s[i] > 0X DO
				Display.GetChar(pfnt.raster, s[i], dx, x0, y0, w, h, pat);
				IF (X + x0 + w <= PageWidth) & (h > 0) THEN
					Printmaps.CopyPattern(pat, X+x0, Y+y0)
				END ;
				INC(X, dx); INC(i)
			END
		END
	END ContString;

	PROCEDURE ReplPattern*(x, y, w, h, col: INTEGER);
	BEGIN
		IF (x >= 0) & (y >= 0) & (x+w < PageWidth) & (y+h < PageHeight) THEN
			IF (col < 0) OR (col > 9) THEN col := 1 END ;
			Printmaps.ReplPattern(Printmaps.Pat[col], x, y, w, h)
		END
	END ReplPattern;

	PROCEDURE Line*(x0, y0, x1, y1: INTEGER);
		VAR w, h, d, u: INTEGER;
	BEGIN w := ABS(x1-x0); h := ABS(y1-y0);
		IF h <= w THEN
			IF x1 < x0 THEN u := x0; x0 := x1; x1 := u; u := y0; y0 := y1; y1 := u END ;
			IF y0 <= y1 THEN d := 1 ELSE d := -1 END ;
			u := (h-w) DIV 2;
			WHILE x0 < x1 DO
				Printmaps.Dot(x0, y0); INC(x0);
				IF u < 0 THEN INC(u, h) ELSE INC(u, h-w); INC(y0, d) END
			END
		ELSE
			IF y1 < y0 THEN u := x0; x0 := x1; x1 := u; u := y0; y0 := y1; y1 := u END ;
			IF x0 <= x1 THEN d := 1 ELSE d := -1 END ;
			u := (w-h) DIV 2;
			WHILE y0 < y1 DO
				Printmaps.Dot(x0, y0); INC(y0);
				IF u < 0 THEN INC(u, w) ELSE INC(u, w-h); INC(x0, d) END
			END
		END
	END Line;

	PROCEDURE Circle*(x0, y0, r: INTEGER);
		VAR X, Y, x, y, u: LONGINT;
	BEGIN X := x0; Y := y0; u := 1 - r; x := r; y := 0;
		WHILE y <= x DO
			Printmaps.Dot(X+x, Y+y); Printmaps.Dot(X+y, Y+x);
			Printmaps.Dot(X-y, Y+x); Printmaps.Dot(X-x, Y+y);
			Printmaps.Dot(X-x, Y-y); Printmaps.Dot(X-y, Y-x);
			Printmaps.Dot(X+y, Y-x); Printmaps.Dot(X+x, Y-y);
			IF u < 0 THEN INC(u, 2*y+3) ELSE INC(u, 2*(y-x)+5); DEC(x) END ;
			INC(y)
		END
	END Circle;

	PROCEDURE Ellipse*(x0, y0, a, b: INTEGER);
		VAR X, Y, x, y, y1, aa, bb, d, g, h: LONGINT;
	BEGIN aa := a*a; bb := b*b;
		h := (aa DIV 4) - b*aa + bb; g := (9*aa DIV 4) - 3*b*aa + bb; x := 0; y := b;
		WHILE g < 0 DO
			Printmaps.Dot(X+x, Y+y); Printmaps.Dot(X-x, Y+y);
			Printmaps.Dot(X-x, Y-y); Printmaps.Dot(X+x, Y-y);
			IF h < 0 THEN d := (2*x+3)*bb; INC(g, d)
			ELSE d := (2*x+3)*bb - 2*(y-1)*aa; INC(g, d + 2*aa); DEC(y)
			END ;
			INC(h, d); INC(x)
		END ;
		y1 := y; h := (bb DIV 4) - a*bb + aa; x := a; y := 0;
		WHILE y <= y1 DO
			Printmaps.Dot(X+x, Y+y); Printmaps.Dot(X-x, Y+y);
			Printmaps.Dot(X-x, Y-y); Printmaps.Dot(X+x, Y-y);
			IF h < 0 THEN INC(h, (2*y+3)*aa) ELSE INC(h, (2*y+3)*aa - 2*(x-1)*bb); DEC(x) END ;
			INC(y)
		END
	END Ellipse;

	PROCEDURE ShowPoly(VAR p, q: Poly; lim: REAL);
		VAR t: REAL; x, y: LONGINT;
	BEGIN t := 0;
		REPEAT
			Printmaps.Dot(ENTIER(((p.a * t + p.b) * t + p.c) * t + p.d),
				ENTIER(((q.a * t + q.b) * t + q.c) * t + q.d));
			t := t + 1.0
		UNTIL t >= lim
	END ShowPoly;

	PROCEDURE SolveTriDiag(VAR a, b, c, y: RealVector; n: INTEGER);
		VAR i: INTEGER;
	BEGIN (*a, b, c of tri-diag matrix T; solve Ty' = y for y', assign y' to y*)
		i := 1;
		WHILE i < n DO y[i] := y[i] - c[i-1]*y[i-1]; INC(i) END ;
		i := n-1; y[i] := y[i]/a[i];
		WHILE i > 0 DO DEC(i); y[i] := (y[i] - b[i]*y[i+1])/a[i] END
	END SolveTriDiag;	

	PROCEDURE OpenSpline(VAR x, y, d: RealVector; n: INTEGER);
		VAR i: INTEGER; d1, d2: REAL;
			a, b, c: RealVector;
	BEGIN (*from x, y compute d = y'*)
		b[0] := 1.0/(x[1] - x[0]); a[0] := 2.0*b[0]; c[0] := b[0];
		d1 := (y[1] - y[0])*3.0*b[0]*b[0]; d[0] := d1; i := 1;
		WHILE i < n-1 DO
			b[i] := 1.0/(x[i+1] - x[i]);
			a[i] := 2.0*(c[i-1] + b[i]);
			c[i] := b[i];
			d2 := (y[i+1] - y[i])*3.0*b[i]*b[i];
			d[i] := d1 + d2; d1 := d2; INC(i)
		END ;
		a[i] := 2.0*b[i-1]; d[i] := d1; i := 0;
		WHILE i < n-1 DO c[i] := c[i]/a[i]; a[i+1] := a[i+1] - c[i]*b[i]; INC(i) END ;
		SolveTriDiag(a, b, c, d, n)
	END OpenSpline;

	PROCEDURE ClosedSpline(VAR x, y, d: RealVector; n: INTEGER);
		VAR i: INTEGER; d1, d2, hn, dn: REAL;
			a, b, c, w: RealVector;
	BEGIN (*from x, y compute d = y'*)
		hn := 1.0/(x[n-1] - x[n-2]);
		dn := (y[n-1] - y[n-2])*3.0*hn*hn;
		b[0] := 1.0/(x[1] - x[0]);
		a[0] := 2.0*b[0] + hn;
		c[0] := b[0];
		d1 := (y[1] - y[0])*3.0*b[0]*b[0]; d[0] := dn + d1;
		w[0] := 1.0; i := 1;
		WHILE i < n-2 DO
			b[i] := 1.0/(x[i+1] - x[i]);
			a[i] := 2.0*(c[i-1] + b[i]);
			c[i] := b[i];
			d2 := (y[i+1] - y[i])*3.0*b[i]*b[i]; d[i] := d1 + d2; d1 := d2;
			w[i] := 0; INC(i)
		END ;
		a[i] := 2.0*b[i-1] + hn; d[i] := d1 + dn;
		w[i] := 1.0; i := 0;
		WHILE i < n-2 DO c[i] := c[i]/a[i]; a[i+1] := a[i+1] - c[i]*b[i]; INC(i) END ;
		SolveTriDiag(a, b, c, d, n-1); SolveTriDiag(a, b, c, w, n-1); 
		d1 := (d[0] + d[i])/(w[0] + w[i] + x[i+1] - x[i]); i := 0;
		WHILE i < n-1 DO d[i] := d[i] - d1*w[i]; INC(i) END ;
		d[i] := d[0]
	END ClosedSpline;

	PROCEDURE Spline*(x0, y0, n, open: INTEGER; VAR X, Y: ARRAY OF INTEGER);
		VAR i: INTEGER; dx, dy, ds: REAL;
			x, xd, y, yd, s: RealVector;
			p, q: PolyVector;
	BEGIN (*from u, v compute x, y, s*)
		x[0] := X[0] + x0; y[0] := Y[0] + y0; s[0] := 0; i := 1;
		WHILE i < n DO
			x[i] := X[i] + x0; dx := x[i] - x[i-1];
			y[i] := Y[i] + y0; dy := y[i] - y[i-1];
			s[i] := ABS(dx) + ABS(dy) + s[i-1]; INC(i)
		END ;
		IF open = 1 THEN OpenSpline(s, x, xd, n); OpenSpline(s, y, yd, n)
		ELSE ClosedSpline(s, x, xd, n); ClosedSpline(s, y, yd, n)
		END ;
		(*compute coefficients from x, y, xd, yd, s*)  i := 0;
		WHILE i < n-1 DO
			ds := 1.0/(s[i+1] - s[i]);
			dx := (x[i+1] - x[i])*ds;
			p[i].a := ds*ds*(xd[i] + xd[i+1] - 2.0*dx);
			p[i].b := ds*(3.0*dx - 2.0*xd[i] -xd[i+1]);
			p[i].c := xd[i];
			p[i].d := x[i];
			p[i].t := s[i];
			dy := ds*(y[i+1] - y[i]);
			q[i].a := ds*ds*(yd[i] + yd[i+1] - 2.0*dy);
			q[i].b := ds*(3.0*dy - 2.0*yd[i] - yd[i+1]);
			q[i].c := yd[i];
			q[i].d := y[i];
			q[i].t := s[i]; INC(i)
		END ;
		p[i].t := s[i]; q[i].t := s[i];
		(*display polynomials*)
		i := 0;
		WHILE i < n-1 DO ShowPoly(p[i], q[i], p[i+1].t - p[i].t); INC(i) END
	END Spline;

	PROCEDURE Picture*(x, y, w, h, mode: INTEGER; adr: LONGINT);
		VAR src, dst: LONGINT; b: CHAR;
	BEGIN src := Display.Map(0); adr := BMadr + 5856; y := 800;
		REPEAT x := 128; dst := adr;
			REPEAT SYSTEM.GET(src, b); INC(src);
				SYSTEM.PUT(dst, map[ORD(b)]); SYSTEM.PUT(dst+292, map[ORD(b)]);
				INC(dst, 2); DEC(x)
			UNTIL x = 0;
			INC(adr, 584); DEC(y)
		UNTIL y = 0
	END Picture;

	PROCEDURE Page*(nofcopies: INTEGER);
	BEGIN
		WHILE nofcopies > 0 DO
			REPEAT UNTIL SYSTEM.BIT(PR0, prdy);
			SYSTEM.PUT(PR0, BMadr); (*start printer*)
			REPEAT UNTIL SYSTEM.BIT(PR0, end);
			REPEAT UNTIL ~SYSTEM.BIT(PR0, end);
			DEC(nofcopies)
		END ;
		Printmaps.ClearPage
	END Page;

	PROCEDURE Close*;
	BEGIN
		WHILE nofonts > 0 DO DEC(nofonts); fontname[nofonts, 0] := 0X; pfont[nofonts] := NIL END
	END Close;

	PROCEDURE InitMap;
		VAR i, k, s, t: INTEGER;
	BEGIN i := 0; SYSTEM.OVFL(FALSE);
		REPEAT k := i; s := 0; t := 3;
			WHILE k > 0 DO
				IF ODD(k) THEN INC(s, t) END ;
				t := 4*t; k := k DIV 2
			END ;
			map[i] := s; INC(i)
		UNTIL i = 256;
		SYSTEM.OVFL(TRUE)
	END InitMap;

BEGIN PageWidth := 2336; PageHeight := 3425; BMadr := Printmaps.Map(); InitMap
END Printer.
