B  Syntax10.Scn.Fnt       Z  ParcElems Alloc    9  M    Z          8  FoldElems New  #   Syntax10.Scn.Fnt  *    *   
	BEGIN
		pos := Oberon.Log.len
	END Here; 8       z8   #   Syntax10.Scn.Fnt  d    d   
	BEGIN
		IF pos < Oberon.Log.len THEN Texts.Delete(Oberon.Log, pos, Oberon.Log.len) END
	END Clear; 8       8   #   Syntax10.Scn.Fnt  F    F   
	BEGIN
		Texts.Write(W, ch); Texts.Append(Oberon.Log, W.buf)
	END Ch; 8   $    8   #   Syntax10.Scn.Fnt  N    N   
	BEGIN
		Texts.WriteString(W, str); Texts.Append(Oberon.Log, W.buf)
	END Str; 8       8   #   Syntax10.Scn.Fnt  L    L   
	BEGIN
		Texts.WriteInt(W, n, 0); Texts.Append(Oberon.Log, W.buf)
	END Int; 8       8   #   Syntax10.Scn.Fnt  D    D   
	BEGIN
		Texts.WriteLn(W); Texts.Append(Oberon.Log, W.buf)
	END Ln; 8   &    8   #   Syntax10.Scn.Fnt  .    .   
	BEGIN
		Str("Error: "); Str(str)
	END Error; 8   G    8   #   Syntax10.Scn.Fnt  
    
   
	END Old; 8   /    8   #   Syntax10.Scn.Fnt  
    
   
	END New; 8       8   #   Syntax10.Scn.Fnt         
	END Register; 8   %    8   #   Syntax10.Scn.Fnt  
    
   
	END Pos; 8   )    8   #   Syntax10.Scn.Fnt         
	END Read; 8   %    8   #   Syntax10.Scn.Fnt  
    
   
	END eof; 8   &    8   #   Syntax10.Scn.Fnt         
	END Write; 8       \8   #   Syntax10.Scn.Fnt         
	BEGIN
		IF F.len > 0 THEN Int(F.len - F.Pos()); Str(" Bytes left ")
		ELSE Int(F.Pos()); Str(" Bytes arrived ")
		END
	END Left; 8   <    8   #   Syntax10.Scn.Fnt         
		VAR
			F1: Files.File;
	BEGIN
		F1 := Files.Old(name);
		IF F1 # NIL THEN
			Files.Set(F.R, F1, 0);
			F.receive := FALSE; COPY(name, F.name); F.len := Files.Length(F1)
		END;
		RETURN F1 # NIL
	END Old; 8   0    P8   #   Syntax10.Scn.Fnt         
		VAR
			F1: Files.File;
	BEGIN
		F1 := Files.New(name); Files.Set(F.R, F1, 0);
		F.receive := TRUE; COPY(name, F.name); F.len := 0
	END New; 8        8   #   Syntax10.Scn.Fnt  &   &  
		VAR
			i: INTEGER;
			bak: ARRAY 64 OF CHAR;
	BEGIN
		i := 0;
		WHILE F.name[i] # 0X DO bak[i] := F.name[i]; INC(i) END;
		bak[i] := "."; bak[i + 1] := "B"; bak[i + 2] := "a"; bak[i + 3] := "k"; bak[i + 4] := 0X;
		Files.Rename(F.name, bak, i); Files.Register(Files.Base(F.R))
	END Register; 8   &    8   #   Syntax10.Scn.Fnt  )    )   
	BEGIN
		RETURN Files.Pos(F.R)
	END Pos; 8   *    8   #   Syntax10.Scn.Fnt  (    (   
	BEGIN
		Files.Read(F.R, ch)
	END Read; 8   &    8   #   Syntax10.Scn.Fnt  "    "   
	BEGIN
		RETURN F.R.eof
	END eof; 8   '    8   #   Syntax10.Scn.Fnt  *    *   
	BEGIN
		Files.Write(F.R, ch)
	END Write; 8   ;    8   #   Syntax10.Scn.Fnt         
		VAR
			F1: Files.File;
			T1: Texts.Text;
	BEGIN
		F1 := Files.Old(name);
		IF F1 # NIL THEN
			NEW(T1); Texts.Open(T1, name); Texts.OpenReader(T.R, T1, 0);
			T.receive := FALSE; COPY(name, T.name); T.len := T1.len
		END;
		RETURN F1 # NIL
	END Old; 8   0    K8   #   Syntax10.Scn.Fnt         
	BEGIN
		Texts.OpenWriter(T.W); Texts.SetFont(T.W, Fonts.This("Courier10.Scn.Fnt"));
		T.receive := TRUE; COPY(name, T.name); T.len := 0
	END New; 8        _8   #   Syntax10.Scn.Fnt         
		VAR
			T1: Texts.Text;
	BEGIN
		T1 := TextFrames.Text(""); Texts.Append(T1, T.W.buf); Texts.Close(T1, T.name)
	END Register; 8   &    8   #   Syntax10.Scn.Fnt  [    [   
	BEGIN
		IF T.receive THEN RETURN T.W.buf.len
		ELSE RETURN Texts.Pos(T.R)
		END
	END Pos; 8   *    8   #   Syntax10.Scn.Fnt  ]    ]   
	BEGIN
		REPEAT Texts.Read(T.R, ch) UNTIL ch # FS;
		IF ch = CR THEN ch := LF END
	END Read; 8   &    8   #   Syntax10.Scn.Fnt  "    "   
	BEGIN
		RETURN T.R.eot
	END eof; 8   '    8   #   Syntax10.Scn.Fnt  Z    Z   
	BEGIN
		IF ch = LF THEN Texts.WriteLn(T.W)
		ELSE Texts.Write(T.W, ch)
		END
	END Write; 8   7    8   #   Syntax10.Scn.Fnt  /    /   
	BEGIN
		RETURN CHR(ORD(ch) + 32)
	END ToChar; 8   $    8   #   Syntax10.Scn.Fnt  /    /   
	BEGIN
		RETURN CHR(ORD(ch) - 32)
	END UnChar; 8        h8   #   Syntax10.Scn.Fnt  v    v   
	BEGIN
		IF (ORD(ch) DIV 64) MOD 2 = 0 THEN RETURN CHR(ORD(ch) + 64)
		ELSE RETURN CHR(ORD(ch) - 64)
		END;
	END Ctl; 8   8    U8   #   Syntax10.Scn.Fnt       
	BEGIN
		L.me.maxl := MAXL; L.me.time := TIME; L.me.npad := NPAD; L.me.padc := PADC; L.me.eol := EOL; L.me.qctl := QCTL;
		L.me.qbin := QBIN; L.me.chkt := CHKT; L.me.rept := REPT; L.me.capas := CAPAS; L.me.windo := WINDO;
		L.me.maxlx1 := MAXLX1; L.me.maxlx2 := MAXLX2;
		L.me.mark := MARK;
		L.me.n := 0; L.me.len := ORD(MAXLX1) * 95 + ORD(MAXLX2);
		L.you := L.me; L.you.len := 0
	END Init; 8   +    8   #   Syntax10.Scn.Fnt       
	BEGIN
		L.me.buf[0] := ToChar(L.me.maxl); L.me.buf[1] := ToChar(L.me.time); L.me.buf[2] := ToChar(L.me.npad);
		L.me.buf[3] := Ctl(L.me.padc); L.me.buf[4] := ToChar(L.me.eol); L.me.buf[5] := L.me.qctl; L.me.buf[6] := L.me.qbin;
		L.me.buf[7] := L.me.chkt; L.me.buf[8] := L.me.rept; L.me.buf[9] := ToChar(L.me.capas);
		L.me.buf[10] := ToChar(L.me.windo); L.me.buf[11] := ToChar(L.me.maxlx1); L.me.buf[12] := ToChar(L.me.maxlx2);
		L.me.n := 13
	END GetSettings; 8   +    8   #   Syntax10.Scn.Fnt  !   !  
		VAR
			i: INTEGER;
	BEGIN
		L.you.maxl := UnChar(L.you.buf[0]); L.you.time := UnChar(L.you.buf[1]); L.you.npad := UnChar(L.you.buf[2]);
		L.you.padc := Ctl(L.you.buf[3]); L.you.eol := UnChar(L.you.buf[4]); L.you.qctl := L.you.buf[5];
		IF (L.you.n >= 6) & ((L.you.buf[6] = "&") OR (L.you.buf[6] = "Y")) THEN L.you.qbin := L.me.qbin
		ELSE L.you.qbin := "N"
		END;
		IF (L.you.n >= 7) & (L.you.buf[7] = L.me.chkt) THEN L.you.chkt := L.me.chkt
		ELSE L.you.chkt := CHKT1
		END;
		IF (L.you.n >= 8) & (L.you.buf[8] = L.me.rept) THEN L.you.rept := L.me.rept
		ELSE L.you.rept := "N"
		END;
		IF L.you.n >= 9 THEN 
			L.you.capas := UnChar(L.you.buf[9]); i := 9;
			WHILE ODD(ORD(L.you.buf[i])) DO INC(i) END; INC(i);
			L.you.windo := UnChar(L.you.buf[i]);
			L.you.maxlx1 := UnChar(L.you.buf[i + 1]);
			L.you.maxlx2 := UnChar(L.you.buf[i + 2])
		ELSE L.you.capas := 0X
		END;
		IF ODD(ASH(ORD(L.you.capas), -long)) THEN L.you.len := ORD(L.you.maxlx1) * 95 + ORD(L.you.maxlx2)
		ELSE L.you.len := ORD(L.you.maxl)
		END;
		DEC(L.you.len, 5)
	END SetSettings; 8   K    8   #   Syntax10.Scn.Fnt  U    U   
	BEGIN
		CASE chkt OF
			CHKT1: check := (check + ORD(ch)) MOD 256
		END
	END Check; 8   H    8   #   Syntax10.Scn.Fnt  \    \   
	BEGIN
		CASE chkt OF
			CHKT1: check := (check + check DIV 64) MOD 64
		END
	END CheckSum; 8   B    8   #   Syntax10.Scn.Fnt  @    @   
	BEGIN
		V24.Send(ch); L.Check(ch, L.me.chkt, check)
	END Send; 8   R    8   #   Syntax10.Scn.Fnt         
		VAR
			t: LONGINT;
	BEGIN
		t := Oberon.Time();
		LOOP
			IF V24.Available() > 0 THEN V24.Receive(ch); L.Check(ch, L.you.chkt, check); RETURN TRUE
			ELSIF Oberon.Time() - t > ORD(L.you.time) * 100 THEN RETURN FALSE
			END
		END
	END Receive; 8   +    8   #   Syntax10.Scn.Fnt  _    _   
		VAR
			ch: CHAR;
	BEGIN
		WHILE V24.Available() > 0 DO V24.Receive(ch) END
	END FlushBuffer; 8   F    Q8   #   Syntax10.Scn.Fnt       
		VAR
			check, check1, i: INTEGER;
	BEGIN
		L.FlushBuffer;
		i := ORD(L.you.npad);
		WHILE i > 0 DO L.Send(L.you.padc, check1); INC(i) END;
		IF L.me.n + 2 + ORD(L.you.chkt) - ORD("0") <= ORD(L.you.maxl) THEN (* basic kermit packet *)
			L.Send(L.me.mark, check1);
			check := 0;
			L.Send(ToChar(CHR(L.me.n + 2 + ORD(L.you.chkt) - ORD("0"))), check);
			L.Send(ToChar(CHR(seq)), check);
			L.Send(type, check);
			i := 0;
			WHILE i < L.me.n DO L.Send(L.me.buf[i], check); INC(i) END;
			L.CheckSum(L.me.chkt, check); L.Send(ToChar(CHR(check)), check1);
			L.Send(L.you.eol, check1)
		ELSE (* extended kermit packet *)
			L.Send(L.me.mark, check1);
			check := 0;
			L.Send(ToChar(0X), check);
			L.Send(ToChar(CHR(seq)), check);
			L.Send(type, check);
			i := L.me.n + ORD(L.you.chkt) - ORD("0");
			L.Send(ToChar(CHR(i DIV 95)), check);
			L.Send(ToChar(CHR(i MOD 95)), check);
			check1 := check; L.CheckSum(L.me.chkt, check1); L.Send(ToChar(CHR(check1)), check);
			i := 0;
			WHILE i < L.me.n DO L.Send(L.me.buf[i], check); INC(i) END;
			L.CheckSum(L.me.chkt, check); L.Send(ToChar(CHR(check)), check1);
			L.Send(L.you.eol, check1)
		END
	END SendPacket; 8   O    8   #   Syntax10.Scn.Fnt       
	(* abort option not implemented *)
		VAR
			ch: CHAR;
			check, check1, i: INTEGER;
	BEGIN
		REPEAT
			IF ~L.Receive(ch, check1) THEN type := "T"; RETURN END;
		UNTIL ch = L.you.mark;
		check := 0;
		IF ~L.Receive(ch, check) THEN type := "T"; RETURN END;
		L.you.n := ORD(UnChar(ch));
		IF ~L.Receive(ch, check) THEN type := "T"; RETURN END;
		seq := ORD(UnChar(ch));
		IF ~L.Receive(type, check) THEN type := "T"; RETURN END;
		IF L.you.n > 0 THEN
			DEC(L.you.n, 2 + ORD(L.you.chkt) - ORD("0"))
		ELSE
			IF ~L.Receive(ch, check) THEN type := "T"; RETURN END;
			L.you.n := ORD(UnChar(ch)) * 95;
			IF ~L.Receive(ch, check) THEN type := "T"; RETURN END;
			INC(L.you.n, ORD(UnChar(ch))); check1 := check;
			IF ~L.Receive(ch, check) THEN type := "T"; RETURN END;
			L.CheckSum(L.you.chkt, check1);
			IF ToChar(CHR(check1)) # ch THEN type := "Q"; RETURN END;
			DEC(L.you.n, ORD(L.you.chkt) - ORD("0"))
		END;
		i := 0;
		WHILE i < L.you.n DO
			IF ~L.Receive(L.you.buf[i], check) THEN type := "T"; RETURN END;
			INC(i)
		END;
		IF ~L.Receive(ch, check1) THEN type := "T"; RETURN END;
		L.CheckSum(L.you.chkt, check);
		IF ToChar(CHR(check)) # ch THEN type := "Q"; RETURN END;
		IF ~L.Receive(ch, check1) THEN type := "T"; RETURN END;
		IF L.me.eol # ch THEN type := "Q"; RETURN END
	END ReceivePacket; 8   C    8   #   Syntax10.Scn.Fnt  (    (   
	BEGIN
		L.Init^; L.seq := 0
	END Init; 8   F    $8   #   Syntax10.Scn.Fnt       
		VAR
			done: BOOLEAN;
			otype: CHAR;
			t, seq: INTEGER;
	BEGIN
		done := FALSE; t := MAXTRY;
		REPEAT
			DEC(t); L.you.n := 0;
			L.SendPacket(L.seq, type); L.ReceivePacket(seq, otype);
			IF (seq = L.seq) & (otype = "Y") THEN done := TRUE
			ELSIF otype = "E" THEN  L.you.buf[L.you.n] := 0X; Error(L.you.buf); RETURN FALSE
			END;
		UNTIL done OR (t = 0);
		IF done THEN L.seq := (L.seq + 1) MOD 64 END;
		RETURN done
	END SendSequence; 8   M    8      8   (    8   #   Syntax10.Scn.Fnt  I    I   
	BEGIN
		L.SendPacket(L.seq, "Y"); L.seq := (L.seq + 1) MOD 64
	END ACK; 8   J    98   #   Syntax10.Scn.Fnt         
	BEGIN
		Here; Str("initiation ");
		L.Init; L.GetSettings;
		L.done := L.SendSequence("S");
		IF L.done THEN L.SetSettings; Clear ELSE Ln END;
	END SendInitiation; 8   4    }8   #   Syntax10.Scn.Fnt  a   a  
		VAR
			qbin: BOOLEAN;
			ch, ch0, type: CHAR;
	BEGIN
	(* header *)
		Str("sending "); Str(F.name); Str(": "); Here; Left(F);
		L.me.n := 0;
		WHILE F.name[L.me.n] # 0X DO L.me.buf[L.me.n] := F.name[L.me.n]; INC(L.me.n) END;
		L.done := L.SendSequence("F");
	(* data *)
		qbin := L.you.qbin # "N";
		L.me.n := 0; F.Read(ch);
		WHILE L.done & ~F.eof() DO
			IF L.me.n < L.you.len THEN
				ch0 := CHR(ORD(ch) MOD 80H);
				IF qbin & (ch >= 80X) THEN
					L.me.buf[L.me.n] := L.me.qbin; INC(L.me.n)
				END;
				IF (ch0 < 20X) OR (ch0 = 7FX) OR (ch0 = L.me.qbin) OR qbin & (ch0 = L.me.qctl) THEN
					L.me.buf[L.me.n] := L.me.qctl; INC(L.me.n)
				END;
				IF (ch0 < 20X) OR (ch0 = 7FX) THEN
					L.me.buf[L.me.n] := Ctl(ch0); INC(L.me.n)
				ELSE
					L.me.buf[L.me.n] := ch0; INC(L.me.n)
				END;
				F.Read(ch)
			ELSE
				L.done := L.SendSequence("D"); L.me.n := 0;
				Clear; Left(F)
			END
		END;
		IF L.done & (L.me.n > 0) THEN L.done := L.SendSequence("D"); L.me.n := 0; Clear; Left(F) END;
	(* eof *)
		IF L.done THEN L.done := L.SendSequence("Z") END;
		IF L.done THEN Clear; Str("done") END;
		Ln
	END SendFile; 8   *    ?8   #   Syntax10.Scn.Fnt         
		VAR
			type: CHAR;
	BEGIN
		Here; Str("end of transmission");
		L.me.n := 0; L.done := L.SendSequence("B");
		IF L.done THEN Clear ELSE Ln END
	END SendEOT; 8   9    i8   #   Syntax10.Scn.Fnt  u    u   
	BEGIN
		Here; Str("receiving ");
		L.done := L.ReceiveSequence(type);
		IF L.done THEN Clear ELSE Ln END
	END Next; 8   D    _8   #   Syntax10.Scn.Fnt         
	BEGIN
		L.done := type = "S";
		IF L.done THEN L.GetSettings; L.ACK; L.SetSettings; L.Next(type) END;
	END ReceiveInitiation; 8   G    8   #   Syntax10.Scn.Fnt  
   
  
		VAR
			qbin, bin, ctl: BOOLEAN;
			ch: CHAR;
			i: INTEGER;
			name: ARRAY 32 OF CHAR;
	BEGIN
	(* header *)
		L.done := type = "F";
		i := 0;
		WHILE (i < L.you.n) & (i < 31) DO
			ch := L.you.buf[i];
			IF (i = 0) & ((CAP(ch) < "A") OR ("Z" < CAP(ch))) THEN ch := "A"
			ELSIF ((CAP(ch) < "A") OR ("Z" < CAP(ch))) & ((ch < "0") OR ("9" < ch )) & (ch # ".") THEN ch := "."
			END;
			name[i] := ch; L.me.buf[i] := ch;
			INC(i)
		END;
		name[i] := 0X; L.me.n := i; L.ACK; L.me.n := 0;
		F.New(name);
	(* data *)
		Str("receiving "); Str(F.name); Str(": "); Here; Left(F);
		qbin := L.you.qbin # "N";
		L.done := L.ReceiveSequence(type);
		WHILE L.done & (type = "D") DO
			L.ACK; i := 0;
			WHILE i < L.you.n DO
				ch := L.you.buf[i]; INC(i);
				bin := qbin & (ch = L.you.qbin);
				IF bin THEN ch := L.you.buf[i]; INC(i) END;
				ctl := ch = L.you.qctl;
				IF ctl THEN ch := L.you.buf[i]; INC(i) END;
				IF ctl & (ch # L.you.qbin) & (ch # L.you.qctl) THEN ch := Ctl(ch) END;
				IF bin THEN ch := CHR(ORD(ch) + 80H) END;
				F.Write(ch)
			END;
			Clear; Left(F);
			L.done := L.ReceiveSequence(type)
		END;
	(* eof *)
		IF L.done & (type = "Z") THEN
			L.ACK; Clear;
			IF L.you.n = 0 THEN F.Register; Str("done") ELSE Str("discarded") END;
			Ln; L.Next(type)
		END
	END ReceiveFile; 8   =    8   #   Syntax10.Scn.Fnt  X    X   
	BEGIN
		L.done := type = "B";
		IF L.done THEN L.me.n := 0; L.ACK END
	END ReceiveEOT; 8   <    8   #   Syntax10.Scn.Fnt  4   4  
		VAR
			beg, end, time: LONGINT;
			S: Texts.Scanner;
			T: Texts.Text;
	BEGIN
		Oberon.GetSelection(T, beg, end, time); Texts.OpenScanner(S, Oberon.Par.text, Oberon.Par.pos); Texts.Scan(S);
		IF (S.class = Texts.Char) & (S.c = "^") THEN Texts.OpenScanner(S, T, beg); Texts.Scan(S) END;
		L.SendInitiation;
		IF L.done THEN
			WHILE L.done & ((S.class = Texts.Name) OR (S.class = Texts.String)) DO 
				IF F.Old(S.s) THEN L.SendFile(F) ELSE Str("file not found: "); Str(S.s); Ln END;
				Texts.Scan(S)
			END;
			IF L.done THEN L.SendEOT END
		END
	END SendFile; 8   !    8   #   Syntax10.Scn.Fnt         
		VAR
			type: CHAR;
	BEGIN
		L.Init; L.Next(type);
		L.ReceiveInitiation(type);
		IF L.done THEN
			WHILE L.done & (type = "F") DO L.ReceiveFile(F, type) END;
			IF L.done & (type = "B") THEN L.ReceiveEOT(type) END
		END
	END ReceiveFile; 8       8   #   Syntax10.Scn.Fnt  @    @   
		VAR
			B: BFile;
	BEGIN
		NEW(B); SendFile(B)
	END SendFiles; 8       8   #   Syntax10.Scn.Fnt  D    D   
		VAR
			T: TFile;
	BEGIN
		NEW(T); SendFile(T)
	END SendTextFiles; 8       8   #   Syntax10.Scn.Fnt  F    F   
		VAR
			B: BFile;
	BEGIN
		NEW(B); ReceiveFile(B)
	END ReceiveFiles; 8       8   #   Syntax10.Scn.Fnt  J    J   
		VAR
			T: TFile;
	BEGIN
		NEW(T); ReceiveFile(T)
	END ReceiveTextFiles; 8       [8   #   Syntax10.Scn.Fnt         
	Texts.OpenWriter(W);
	Texts.WriteString(W, "Kermit 1.6 / EO 25. Januar 1994"); Texts.WriteLn(W);
	Texts.Append(Oberon.Log, W.buf) 8   
    4  (*
	1.0	3. August 1993	EO
	1.1	17. August 1993	new command: Kermit.ReceiveTextFiles
	1.2	1. September 1993	long packets introduced
	1.3	24. September 1993	new command: Kermit.SendTextFiles
	1.4	7. Oktober 1993	log improved
	1.5	11. November 1993	translating of filenames corrected
	1.6	25. Januar 1994	timeout for long packets adjusted
*)

MODULE Kermit;

	IMPORT
		Files, Fonts, Oberon, TextFrames, Texts, V24;
		
	CONST
		CR = 0DX; LF = 0AX; FS = 1CX;
		
	(* checksum types *)
		CHKT1 = "1"; CHKT2 = "2"; CHLT3 = "3";
		
	(* capability types *)
		res1 = 5; res2 = 4; attr = 3; win = 2; long = 1; cnt = 0;
		
	(* initialization string *)
		MAXL = 5EX; (* 0..94 *)
		TIME = 20X; (* 0..94 *)
		NPAD = 0X; (* 0..94 *)
		PADC = 0X; (* 0..63 *)
		EOL = 0DX; (* 0..63 *)
		QCTL = "#"; (* literal *)
		QBIN = "&"; (* literal *)
		CHKT = CHKT1; (* literal *)
		REPT = "N"; (* literal *)
		CAPAS = CHR(ASH(1, long)); (* 0..63 *)
		WINDO = 0X;
		MAXLX1 = 5EX; (* 0..94 *)
		MAXLX2 = 5EX; (* 0..94 *)
		
	(* kermit packet *)
		MARK = 1X; (* control *)
		
	(* transport layer *)
		MAXTRY = 10;
		
	TYPE
	(* files *)
		File = POINTER TO FileDesc;
		FileDesc = RECORD
			receive: BOOLEAN;
			name: ARRAY 32 OF CHAR;
			len: LONGINT
		END;
		BFile = POINTER TO BFileDesc;
		BFileDesc = RECORD (FileDesc)
			R: Files.Rider
		END;
		TFile = POINTER TO TFileDesc;
		TFileDesc = RECORD (FileDesc)
			R: Texts.Reader;
			W: Texts.Writer;
		END;

	(* layers *)
		DataLayer = RECORD
			me, you: RECORD
				maxl, time, npad, padc, eol, qctl, qbin, chkt, rept, capas, windo, maxlx1, maxlx2: CHAR;
				mark: CHAR;
				buf: ARRAY 5FH * ORD(MAXLX1) + ORD(MAXLX2) OF CHAR; n, len: INTEGER
			END
		END;
		TransportLayer = RECORD (DataLayer)
			seq: INTEGER
		END;
		SessionLayer = RECORD (TransportLayer)
			done: BOOLEAN
		END;

	VAR
		W: Texts.Writer;
		L: SessionLayer;
		pos: LONGINT;
		
	(* log *)
	
	PROCEDURE Here;
	PROCEDURE Clear;
	PROCEDURE Ch(ch: CHAR);
	PROCEDURE Str(str: ARRAY OF CHAR);
	PROCEDURE Int(n: LONGINT);
	PROCEDURE Ln;
	PROCEDURE Error(str: ARRAY OF CHAR);

	(* file *)
	
	PROCEDURE (F: File) Old(name: ARRAY OF CHAR): BOOLEAN;
	PROCEDURE (F: File) New(name: ARRAY OF CHAR);
	PROCEDURE (F: File) Register;
	PROCEDURE (F: File) Pos(): LONGINT;
	PROCEDURE (F: File) Read(VAR ch: CHAR);
	PROCEDURE (F: File) eof(): BOOLEAN;
	PROCEDURE (F: File) Write(ch: CHAR);
	PROCEDURE Left(F: File);
		
	PROCEDURE (F: BFile) Old(name: ARRAY OF CHAR): BOOLEAN;
	PROCEDURE (F: BFile) New(name: ARRAY OF CHAR);
	PROCEDURE (F: BFile) Register;
	PROCEDURE (F: BFile) Pos(): LONGINT;
	PROCEDURE (F: BFile) Read(VAR ch: CHAR);
	PROCEDURE (F: BFile) eof(): BOOLEAN;
	PROCEDURE (F: BFile) Write(ch: CHAR);
	
	PROCEDURE (T: TFile) Old(name: ARRAY OF CHAR): BOOLEAN;
	PROCEDURE (T: TFile) New(name: ARRAY OF CHAR);
	PROCEDURE (T: TFile) Register;
	PROCEDURE (T: TFile) Pos(): LONGINT;
	PROCEDURE (T: TFile) Read(VAR ch: CHAR);
	PROCEDURE (T: TFile) eof(): BOOLEAN;
	PROCEDURE (T: TFile) Write(ch: CHAR);
		
	(* coding *)
		
	PROCEDURE ToChar(ch: CHAR): CHAR;
	PROCEDURE UnChar(ch: CHAR) : CHAR;
	PROCEDURE Ctl(ch: CHAR): CHAR;

	(* data layer *)

	PROCEDURE (VAR L: DataLayer) Init;
	PROCEDURE (VAR L: DataLayer) GetSettings;
	PROCEDURE (VAR L: DataLayer) SetSettings;
	
	PROCEDURE (VAR L: DataLayer) Check(ch, chkt: CHAR; VAR check: INTEGER);
	PROCEDURE (VAR L: DataLayer) CheckSum(chkt: CHAR; VAR check: INTEGER);
	PROCEDURE (VAR L: DataLayer) Send(ch: CHAR; VAR check: INTEGER);
	PROCEDURE (VAR L: DataLayer) Receive(VAR ch: CHAR; VAR check: INTEGER): BOOLEAN;
	PROCEDURE (VAR L: DataLayer) FlushBuffer;
	
	PROCEDURE (VAR L: DataLayer) SendPacket(seq: INTEGER; type: CHAR);
	PROCEDURE (VAR L: DataLayer) ReceivePacket(VAR seq: INTEGER; VAR type: CHAR);

	(* transport layer *)
	
	PROCEDURE (VAR L: TransportLayer) Init;
	PROCEDURE (VAR L: TransportLayer) SendSequence(type: CHAR): BOOLEAN;
	PROCEDURE (VAR L: TransportLayer) ReceiveSequence(VAR type: CHAR): BOOLEAN;
		VAR
			done: BOOLEAN;
			t, seq: INTEGER;
	BEGIN
		done := FALSE; t := MAXTRY;
		REPEAT
			DEC(t); L.you.n := 0;
			L.ReceivePacket(seq, type);
			IF (type = "T") OR (type = "Q") THEN L.me.n := 0; L.SendPacket(L.seq, "N"); Ch(type)
			ELSIF type = "E" THEN L.you.buf[L.me.n] := 0X; Error(L.you.buf); RETURN FALSE
			ELSIF seq = L.seq THEN done := TRUE
			END
		UNTIL done OR (t = 0);
		RETURN done
	END ReceiveSequence;
	PROCEDURE (VAR L: TransportLayer) ACK;
	
	(* session layer *)
	
	PROCEDURE (VAR L: SessionLayer) SendInitiation;
	PROCEDURE (VAR L: SessionLayer) SendFile(F: File);
	PROCEDURE (VAR L: SessionLayer) SendEOT;
	
	PROCEDURE (VAR L: SessionLayer) Next(VAR type: CHAR);
	PROCEDURE (VAR L: SessionLayer) ReceiveInitiation(VAR type: CHAR);
	PROCEDURE (VAR L: SessionLayer) ReceiveFile(F: File; VAR type: CHAR);
	PROCEDURE (VAR L: SessionLayer) ReceiveEOT(VAR type: CHAR);
	
	(* presentation layer *)
	
	PROCEDURE SendFile(F: File);
	PROCEDURE ReceiveFile(F: File);
	
	PROCEDURE SendFiles*;
	PROCEDURE SendTextFiles*;
	PROCEDURE ReceiveFiles*;
	PROCEDURE ReceiveTextFiles*;
	
BEGIN
END Kermit.
