  Syntax10.Scn.Fnt  u Z  ParcElems Alloc     
 +6      ևԒҝШϳ;    Syntax10i.Scn.Fnt        StampElems Alloc 6 May 94      \       8  FoldElems New  %    8   $    8   )    8   !    8   )    8   ,    8   1    8       8   C    8   6    8      8   V    8      8   (    8       8   *    8       8   .    8      8   Y    8   .   8   g    8       8   G    8       8      Syntax10b.Scn.Fnt          8   5   8   ;        8       8               8      8   :        8       8               8      8   <        8   Y   8       	        8      8               8      8       8   x    8   C    #  MODULE CLTime;	(* sg 26. Jul 93,  *)

IMPORT Viewers, Texts, Oberon, CLGAs, CLFramesD, CLAnalyze;

CONST
	AOut = CLGAs.AOut; BOut = CLGAs.BOut; LOut = CLGAs.LOut;
	LBusN = CLGAs.LBusN; LBusS = CLGAs.LBusS; LBusW = CLGAs.LBusW; LBusE = CLGAs.LBusE;
	EBusN = CLGAs.EBusN; EBusS = CLGAs.EBusS; EBusW = CLGAs.EBusW; EBusE = CLGAs.EBusE;
	Cell = CLAnalyze.Cell; IO = CLAnalyze.IO; Repeater = CLAnalyze.Repeater; (* kind *)


VAR
	W : Texts.Writer;
	dummy : CLGAs.Label;
	err, first : BOOLEAN;
	maxDelay : INTEGER;
	srcU, srcV, srcSig : INTEGER;

PROCEDURE Char (ch : CHAR);
BEGIN
	Texts.Write (W, ch)
END Char;

PROCEDURE Str (s : ARRAY OF CHAR);
BEGIN
	Texts.WriteString (W, s)
END Str;

PROCEDURE Int (i, w : LONGINT);
BEGIN
	Texts.WriteInt (W, i, w)
END Int;

PROCEDURE Real (r : REAL; n, k : INTEGER);
BEGIN
	Texts.WriteRealFix (W, r, n, k)
END Real;

PROCEDURE Ln;
BEGIN
	Texts.WriteLn (W); Texts.Append (Oberon.Log, W.buf)
END Ln;

PROCEDURE Show (ga : CLGAs.GA; u, v, sig : INTEGER);
VAR L : CLGAs.Label; routing : INTEGER;
BEGIN
	IF sig IN {LBusN..LBusE} THEN
		routing := ga.c[u, v].routing;
		IF routing IN {CLGAs.Turn0, CLGAs.TurnB} THEN L := NIL ELSE L := CLGAs.LabelAt (ga, u, v, LOut) END
	ELSE L := CLGAs.LabelAt (ga, u, v, sig)
	END;
	IF L # NIL THEN Str (L.name)
	ELSE
		Char ("("); Int (u, 0); Char (" "); Int (v, 0);
		CASE sig OF
			AOut	:	Str (" AOut")
		|	BOut	:	Str (" BOut")
		|	LBusN	:	Str (" LBusN")
		|	LBusS	:	Str (" LBusS")
		|	LBusW	:	Str (" LBusW")
		|	LBusE	:	Str (" LBusE")
		|	EBusN	:	Str (" EBusN")
		|	EBusS	:	Str (" EBusS")
		|	EBusW	:	Str (" EBusW")
		|	EBusE	:	Str (" EBusE")
		ELSE (* do nothing *)
		END;
		Char (")")
	END
END Show;

PROCEDURE ShowTime (ga : CLGAs.GA; u, v, sig, d, kind : INTEGER; s : ARRAY OF CHAR);
VAR d1 : INTEGER;
BEGIN
	d1 := d;
	IF d < 0 THEN d1 := 0 END;
	Real (d1 / 10, 6, 1); Str (" ns "); Str (s);
	IF kind = Cell THEN
		Show (ga, u, v, sig);
		IF (d < 0) & (sig IN {CLGAs.AOut, CLGAs.LBusN..CLGAs.LBusE}) & (ga.c[u, v].state = CLGAs.State3) THEN
			IF ga.clk[u] = CLGAs.ClkOne THEN Str (", clock not enabled!") END
		END
	ELSIF kind = IO THEN
		Show (ga, u, v, sig)
	ELSE Str ("repeater ("); Int (u, 0); Char (" "); Int (v, 0); Char (")")
	END;
	Ln
END ShowTime;

PROCEDURE Err (in, out : CLGAs.Label);
BEGIN
	IF in = dummy THEN Str ("all inputs constant!")
	ELSE Str ("no path "); Str (in.name); Str (" -> "); Str (out.name); Str (" (or constant inputs)")
	END;
	Ln
END Err;

PROCEDURE Arrow (VAR S : Texts.Scanner);
VAR T : Texts.Text; beg, end, time : LONGINT;
BEGIN Texts.Scan (S);
	IF (S.class = Texts.Char) & (S.c = "^") THEN
		Oberon.GetSelection (T, beg, end, time);
		IF time >= 0 THEN Texts.OpenScanner (S, T, beg); Texts.Scan (S) END
	END
END Arrow;

PROCEDURE GetFrame(VAR F : CLFramesD.Frame);
VAR V : Viewers.Viewer;
BEGIN
	IF (Oberon.Par.frame = Oberon.Par.vwr.dsc) & (Oberon.Par.frame.next # NIL) &
			(Oberon.Par.frame.next IS CLFramesD.Frame) THEN
		F := Oberon.Par.frame.next(CLFramesD.Frame)
	ELSE
		V := Oberon.MarkedViewer();
		IF (V.dsc # NIL) & (V.dsc.next # NIL) & (V.dsc.next IS CLFramesD.Frame) THEN F := V.dsc.next(CLFramesD.Frame)
		ELSE F := CLFramesD.Selected()
		END
	END
END GetFrame;

PROCEDURE Var (ga : CLGAs.GA; VAR S : Texts.Scanner; required : BOOLEAN) : CLGAs.Label;
VAR len : INTEGER; var : CLGAs.Label; name : ARRAY CLGAs.LabelLen OF CHAR;
BEGIN
	var := dummy; err := required;
	IF S.class = Texts.Name THEN
		COPY (S.s, name);
		var := CLGAs.This (ga, name);
		IF (var = NIL) & (S.len < CLGAs.LabelLen - 1) THEN
			len := S.len; name[len] := "'"; name[len + 1] := 0X; var := CLGAs.This (ga, name)
		END;
		IF var = NIL THEN
			var := dummy;
			IF required THEN Str ("output ") ELSE Str ("input ") END;
			Str (S.s); Str (" not found in design"); Ln END;
		err := (var = dummy);
		Texts.Scan (S)
	END;
	RETURN var
END Var;

PROCEDURE GetDelay (u, v, sig, kind : INTEGER; VAR delay : INTEGER; VAR onPath, onMaxPath : BOOLEAN);
BEGIN
	IF kind = Cell THEN CLAnalyze.GetCell (u, v, sig, delay, onPath, onMaxPath)
	ELSIF kind = IO THEN CLAnalyze.GetIO (u, v, sig, delay, onPath, onMaxPath);
	ELSE CLAnalyze.GetRepeater (u, v, sig, delay, onPath, onMaxPath)
	END
END GetDelay;

PROCEDURE ShowMaxDelay (ga : CLGAs.GA; u, v, sig, kind, d : INTEGER);
VAR delay : INTEGER; onPath, onMaxPath : BOOLEAN;
BEGIN
	IF first THEN
		GetDelay (u, v, sig, kind, delay, onPath, onMaxPath);
		IF onMaxPath THEN first := FALSE; ShowTime (ga, u, v, sig, d, kind, "from ") END
	END
END ShowMaxDelay;

PROCEDURE MaxDelay*; (* output [input] *)
VAR F : CLFramesD.Frame; S : Texts.Scanner; in, out : CLGAs.Label; d : INTEGER;
BEGIN
	GetFrame (F);
	IF F # NIL THEN
		Texts.OpenScanner (S, Oberon.Par.text, Oberon.Par.pos); Arrow (S);
		out := Var (F.a, S, TRUE);
		IF ~err THEN
			in := Var (F.a, S, FALSE);
			first := TRUE;
			Str ("longest delay to "); Show (F.a, out.u, out.v, out.sig); Str (" is ");
			d := CLAnalyze.MaxPath (F.a, in.u, in.v, in.sig, out.u, out.v, out.sig, ShowMaxDelay);
			IF d < 0 THEN Str ("0 ns. "); Err (in, out) END
		END
	ELSE Str ("no CLi viewer selected"); Ln
	END
END MaxDelay;

PROCEDURE ShowAllPaths (ga : CLGAs.GA; u, v, sig, kind, d : INTEGER);
VAR delay : INTEGER; onPath, onMaxPath : BOOLEAN;
BEGIN
	GetDelay (u, v, sig, kind, delay, onPath, onMaxPath);
	ShowTime (ga, u, v, sig, delay, kind, "at ");
END ShowAllPaths;

PROCEDURE AllPaths*; (* output [input] *)
VAR F : CLFramesD.Frame; S : Texts.Scanner; in, out : CLGAs.Label; d : INTEGER;
BEGIN
	GetFrame (F);
	IF F # NIL THEN
		Texts.OpenScanner (S, Oberon.Par.text, Oberon.Par.pos); Arrow (S);
		out := Var (F.a, S, TRUE);
		IF ~err THEN
			in := Var (F.a, S, FALSE);
			d := CLAnalyze.AllPaths (F.a, in.u, in.v, in.sig, out.u, out.v, out.sig, ShowAllPaths);
			IF d < 0 THEN Err (in, out) END
		END
	ELSE Str ("no CLi viewer selected"); Ln
	END
END AllPaths;

PROCEDURE ShowMaxPath (ga : CLGAs.GA; u, v, sig, kind, d : INTEGER);
VAR delay : INTEGER; onPath, onMaxPath : BOOLEAN;
BEGIN
	GetDelay (u, v, sig, kind, delay, onPath, onMaxPath);
	IF onMaxPath & (delay > maxDelay) THEN maxDelay := delay; ShowTime (ga, u, v, sig, delay, kind, "at ") END;
END ShowMaxPath;

PROCEDURE MaxPath*; (* output [input] *)
VAR F : CLFramesD.Frame; S : Texts.Scanner; in, out : CLGAs.Label; d : INTEGER;
BEGIN
	GetFrame (F);
	IF F # NIL THEN
		Texts.OpenScanner (S, Oberon.Par.text, Oberon.Par.pos); Arrow (S);
		out := Var (F.a, S, TRUE);
		IF ~err THEN
			in := Var (F.a, S, FALSE);
			maxDelay := -1; (* to show input too *)
			d := CLAnalyze.MaxPath (F.a, in.u, in.v, in.sig, out.u, out.v, out.sig, ShowMaxPath);
			IF d < 0 THEN Err (in, out) END
		END
	ELSE Str ("no CLi viewer selected"); Ln
	END
END MaxPath;

PROCEDURE ShowAllInputs (ga : CLGAs.GA; u, v, sig, kind, d : INTEGER);
VAR delay : INTEGER; onPath, onMaxPath : BOOLEAN;
BEGIN
	IF kind = Cell THEN
		IF (sig IN {CLGAs.AOut, CLGAs.LBusN..CLGAs.LBusE}) & (ga.c[u, v].state = CLGAs.State3) THEN
			IF (u = srcU) & (v = srcV) & (sig = srcSig) THEN
				IF ~first THEN
					Str ("register: "); Show (ga, u, v, sig);
					GetDelay (u, v, sig, kind, delay, onPath, onMaxPath);
					IF delay < 0 THEN Str (", clock not enabled!") END;
					Ln
				END;
				first := FALSE
			ELSE
				Str ("register: "); Show (ga, u, v, sig);
				GetDelay (u, v, sig, kind, delay, onPath, onMaxPath);
				IF delay < 0 THEN Str (", clock not enabled!") END;
				Ln
			END
		END
	ELSIF kind = IO THEN
		IF first OR (u # srcU) OR (v # srcV) OR (sig # srcSig) THEN
			Str ("IO: "); Show (ga, u, v, sig); Ln;
			IF (u = srcU) & (v = srcV) & (sig = srcSig) THEN first := FALSE END
		END
	END
END ShowAllInputs;

PROCEDURE AllInputs*; (* output *)
VAR F : CLFramesD.Frame; S : Texts.Scanner; out : CLGAs.Label; d : INTEGER;
BEGIN
	GetFrame (F);
	IF F # NIL THEN
		Texts.OpenScanner (S, Oberon.Par.text, Oberon.Par.pos); Arrow (S);
		out := Var (F.a, S, TRUE);
		IF ~err THEN
			srcU := out.u; srcV := out.v; srcSig := out.sig; first := TRUE;
			d := CLAnalyze.AllPaths (F.a, dummy.u, dummy.v, dummy.sig, out.u, out.v, out.sig, ShowAllInputs);
			IF d < 0 THEN Err (dummy, out) END
		END
	ELSE Str ("no CLi viewer selected"); Ln
	END
END AllInputs;

PROCEDURE CriticalPath*;
VAR F : CLFramesD.Frame; label, out : CLGAs.Label; d, max : INTEGER; oldErr: BOOLEAN;
BEGIN
	GetFrame (F);
	IF F # NIL THEN
		oldErr := CLAnalyze.showErr; CLAnalyze.showErr := FALSE;
		label := F.a.first; out := NIL; max := MIN(INTEGER);
		WHILE label # NIL DO
			d := CLAnalyze.MaxPath (F.a, dummy.u, dummy.v, dummy.sig, label.u, label.v, label.sig, NIL);
			IF d > max THEN max := d; out := label END;
			label := label.next
		END;
		IF out # NIL THEN
			Str("Critical path:"); Ln; maxDelay := 0;
			d := CLAnalyze.MaxPath (F.a, dummy.u, dummy.v, dummy.sig, out.u, out.v, out.sig, ShowMaxPath);
			IF d < 0 THEN Err (dummy, out) END
		END;
		CLAnalyze.showErr := oldErr
	ELSE Str ("no CLi viewer selected"); Ln
	END
END CriticalPath;

BEGIN
	Texts.OpenWriter (W);
	NEW (dummy); dummy.next := NIL; dummy.u := -1; dummy.v := -1; dummy.sig := -1; dummy.name := ""
END CLTime.

CLTime.AllPaths ^
CLTime.MaxDelay ^
CLTime.MaxPath ^
