  Syntax10.Scn.Fnt  u Z  ParcElems Alloc     
 +6      ևԒҝШϳ;        StampElems Alloc 19 May 94  *   Syntax10i.Scn.Fnt  R       Syntax10b.Scn.Fnt                  	                                            .                                                $                                                                                                
                            	        
    )                    
            '                                                                                                                                                $                                N    	                        	                                    Z        4            	                            ,        M        &                /        R        T        ?        .        .        (        %               5    8  FoldElems New            8           5    8   q    8   C    8   +    8       8      8               8       8           )    8   p    8   3    8   ,   8           )    8       8           I    8      8           ;    8   X   8       :  MODULE CLGAs; (* sg 26 Oct 92/ *) (* formatting: Edit.Set tabs * 50~ *)
(* 27 Apr 94: new proc Copy for undo, SHML *)
(* 4 May 94: file compression, sg *)

IMPORT
	Files;

CONST
	Sector* = 8; Dim* = 4 * Sector; LabelLen* = 12;
	None* = -1; North* = 0; South* = 1; West* = 2; East* = 3;   (* cell input directions (/value) *)
	Write* = 0; TS* = 1; Read* = 2; Mux* = 3; TurnB* = 4; Turn0* = 5;  (* internal cell routing *)
	State0* = 0; State1* = 1; State2* = 2; State3* = 3;  (* cell states *)
	EEWE* = 1; LEWE* = 2; LLWE* = 4; ELWE* = 8; EEEW* = 16; LEEW* = 32; LLEW* = 64; ELEW* = 128;
	PassGate* = 256; (* reps WE=NS *)
	ClkOne* = 1; ClkAout* = 2; ClkGlobal* = 4; ClkExpress* = 8; (* clock/reset cell selectors *)
	TSOff* = 0; TSSerial* = 1; TSParallel* = 2; TSOn* = 4; (* I/O pad output selectors *)
	TTL* = 1; Pullup* = 2; TSOpen* = 4; TSFast* = 8; (* I/O pad flags *)

	AOut* = 0; BOut* = 1; LOut* = 2;
	LBusN* = 3; LBusS* = 4; LBusW* = 5; LBusE* = 6; EBusN* = 7; EBusS* = 8; EBusW* = 9; EBusE* = 10;

	ComprTag = 0C3X; (* compressed portable file format *)
	FileTag = 0C2X; (* portable file format *)
	OldFileTag = 0C1X; (* Ceres-3 file format *)

TYPE
	Cell*	=	RECORD
						routing*, state* : SHORTINT;  (* function *)
						a*, b*, weL*, nsL* : SHORTINT;  (* input directions/cornerturn output direction *)
					END;

	VRepeater*	=	RECORD w*, e* : INTEGER END;
	HRepeater*	=	RECORD n*, s* : INTEGER END;

	Pad*	=	RECORD
						selector* : SHORTINT;  (* tri-state output selector (local bus direction, True or False) *)
						flags* : SHORTINT;  (* I/O pad input flags *)
					END;
	Label*	=	POINTER TO LabelDesc;
	LabelDesc*	=	RECORD
							next* : Label;
							u*, v* : INTEGER;  (* cell coordinates *)
							sig* : SHORTINT; (* labelled output signal (AOut, BOut, LBusN..EBusE) *)
							name*: ARRAY LabelLen OF CHAR
						END;
	GADesc*	=	RECORD
						c* : ARRAY Dim, Dim OF Cell;  (* cells *)
						vr* : ARRAY Dim, (Dim DIV Sector) - 1 OF VRepeater;  (* vertical repeaters *)
						hr* : ARRAY (Dim DIV Sector) - 1, Dim OF HRepeater;  (* horizontal repeaters *)
						p* : ARRAY 4, Dim DIV 2 OF Pad;  (* I/O pads (N/S/W/E) *)
						res* : ARRAY Dim OF SHORTINT;  (* reset *)
						clk* : ARRAY Dim OF SHORTINT;  (* clock *)
						first* : Label;  (* label list *)
					END;
	GA* = POINTER TO GADesc;


PROCEDURE ^ Insert* (ga: GA; name : ARRAY OF CHAR; u, v, sig : INTEGER; VAR old : Label);

(* compressed file format:
	tag dimension
	{ nofEmpty cell } { nofEmpty vRep } { nofEmpty hRep }
	{ nofEmpty reset } { nofEmpty clock } { nofEmpty I/Opad }
	nofEmpty
	{ label }

	all empty parts (cells, repeaters, etc.) are counted and the count stored. When the file is read, an
	empty (initialized) part is stored in the data structure as long as nofEmpty > 0
*)
PROCEDURE Open* (ga : GA; name : ARRAY OF CHAR; VAR res : INTEGER);
VAR
	u, v, x : INTEGER;
	L : Label;
	F : Files.File;
	R : Files.Rider;
	s1, s2: ARRAY LabelLen OF CHAR;
	tag : CHAR;
	t, nofEmpty : LONGINT;
	dim : INTEGER;
	eCell : Cell;
	eRepV : VRepeater;
	eRepH : HRepeater;
	ePad : Pad;
	eReset, eClock : SHORTINT;
BEGIN
	eCell.routing := None; eCell.state := None; eCell.a := None; eCell.b := None; eCell.weL := None; eCell.nsL := None;
	eRepV.w := 0; eRepV.e := 0; eRepH.n := 0; eRepH.s := 0;
	ePad.selector := TSOff; ePad.flags := Pullup;
	eReset := ClkGlobal; eClock := ClkOne;
	F := Files.Old(name); res := 0;
	IF F # NIL THEN
		Files.Set(R, F, 0);
		Files.Read (R, tag);
		IF tag = ComprTag THEN (* compressed file format *)
			Files.ReadNum (R, t); dim := SHORT (t);						(* dimension *)
			ASSERT (dim = Dim, 100);
			Files.ReadNum (R, nofEmpty);
			FOR u := 0 TO dim - 1 DO										(* cells *)
				FOR v := 0 TO dim - 1 DO
					IF nofEmpty > 0 THEN ga.c[u, v] := eCell; DEC (nofEmpty)
					ELSE
						Files.ReadNum (R, t); ga.c[u, v].routing := SHORT (SHORT (t));
						Files.ReadNum (R, t); ga.c[u, v].state := SHORT (SHORT (t));
						Files.ReadNum (R, t); ga.c[u, v].a := SHORT (SHORT (t));
						Files.ReadNum (R, t); ga.c[u, v].b := SHORT (SHORT (t));
						Files.ReadNum (R, t); ga.c[u, v].weL := SHORT (SHORT (t));
						Files.ReadNum (R, t); ga.c[u, v].nsL := SHORT (SHORT (t));
						Files.ReadNum (R, nofEmpty)
					END
				END
			END;
			FOR u := 0 TO dim - 1 DO										(* vertical repeaters *)
				FOR v := 0 TO (dim DIV Sector) - 2 DO
					IF nofEmpty > 0 THEN ga.vr[u, v] := eRepV; DEC (nofEmpty)
					ELSE
						Files.ReadNum (R, t); ga.vr[u, v].w := SHORT (t);
						Files.ReadNum (R, t); ga.vr[u, v].e := SHORT (t);
						Files.ReadNum (R, nofEmpty)
					END
				END
			END;
			FOR u := 0 TO (dim DIV Sector) - 2 DO						(* horizontal repeaters *)
				FOR v := 0 TO dim - 1 DO
					IF nofEmpty > 0 THEN ga.hr[u, v] := eRepH; DEC (nofEmpty)
					ELSE
						Files.ReadNum (R, t); ga.hr[u, v].n := SHORT (t);
						Files.ReadNum (R, t); ga.hr[u, v].s := SHORT (t);
						Files.ReadNum (R, nofEmpty)
					END
				END
			END;
			FOR u := 0 TO dim - 1 DO										(* reset *)
				IF nofEmpty > 0 THEN ga.res[u] := eReset; DEC (nofEmpty)
				ELSE Files.ReadNum (R, t); ga.res[u] := SHORT (SHORT (t)); Files.ReadNum (R, nofEmpty)
				END
			END;
			FOR u := 0 TO dim - 1 DO										(* clock *)
				IF nofEmpty > 0 THEN ga.clk[u] := eClock; DEC (nofEmpty)
				ELSE Files.ReadNum (R, t); ga.clk[u] := SHORT (SHORT (t)); Files.ReadNum (R, nofEmpty)
				END
			END;
			FOR u := North TO East DO										(* I/O pads *)
				FOR v := 0 TO (dim DIV 2) - 1 DO
					IF nofEmpty > 0 THEN ga.p[u, v] := ePad; DEC (nofEmpty)
					ELSE
						Files.ReadNum (R, t); ga.p[u, v].selector := SHORT (SHORT (t));
						Files.ReadNum (R, t); ga.p[u, v].flags := SHORT (SHORT (t));
						Files.ReadNum (R, nofEmpty)
					END
				END
			END;
			ASSERT (nofEmpty = 0, 101);
			Files.ReadNum(R, t);											(* labels *)
			IF ~R.eof THEN
				NEW (L); ga.first := L;
				L.u := SHORT (t);
				Files.ReadNum (R, t); L.v := SHORT (t);
				Files.ReadNum (R, t); L.sig := SHORT (SHORT (t));
				Files.ReadString(R, L.name);
				Files.ReadNum(R, t);
				WHILE ~R.eof DO
					NEW (L.next); L := L.next;
					L.u := SHORT (t);
					Files.ReadNum (R, t); L.v := SHORT (t);
					Files.ReadNum (R, t); L.sig := SHORT (SHORT (t));
					Files.ReadString(R, L.name);
					Files.ReadNum(R, t);
				END
			END
		ELSIF tag = FileTag THEN (* portable file format *)
			u := 0;
			WHILE u < Dim DO
				v := 0;
				WHILE v < Dim DO
					Files.ReadNum (R, t); ga.c[u, v].routing := SHORT (SHORT (t));
					Files.ReadNum (R, t); ga.c[u, v].state := SHORT (SHORT (t));
					Files.ReadNum (R, t); ga.c[u, v].a := SHORT (SHORT (t));
					Files.ReadNum (R, t); ga.c[u, v].b := SHORT (SHORT (t));
					Files.ReadNum (R, t); ga.c[u, v].weL := SHORT (SHORT (t));
					Files.ReadNum (R, t); ga.c[u, v].nsL := SHORT (SHORT (t));
					INC (v)
				END;
				INC (u)
			END;
			u := 0;
			WHILE u < Dim DO
				v := 0;
				WHILE v < (Dim DIV Sector) - 1 DO
					Files.ReadNum (R, t); ga.vr[u, v].w := SHORT (t);
					Files.ReadNum (R, t); ga.vr[u, v].e := SHORT (t);
					INC (v)
				END;
				INC (u)
			END;
			u := 0;
			WHILE u < (Dim DIV Sector) - 1 DO
				v := 0;
				WHILE v < Dim DO
					Files.ReadNum (R, t); ga.hr[u, v].n := SHORT (t);
					Files.ReadNum (R, t); ga.hr[u, v].s := SHORT (t);
					INC (v)
				END;
				INC (u)
			END;
			u := 0;
			WHILE u < 4 DO
				v := 0;
				WHILE v < Dim DIV 2 DO
					Files.ReadNum (R, t); ga.p[u, v].selector := SHORT (SHORT (t));
					Files.ReadNum (R, t); ga.p[u, v].flags := SHORT (SHORT (t));
					INC (v)
				END;
				INC (u)
			END;
			u := 0;
			WHILE u < Dim DO Files.ReadNum (R, t); ga.res[u] := SHORT (SHORT (t)); INC (u) END;
			u := 0;
			WHILE u < Dim DO Files.ReadNum (R, t); ga.clk[u] := SHORT (SHORT (t)); INC (u) END;
			Files.ReadNum(R, t);
			IF ~R.eof THEN
				NEW (L); ga.first := L;
				L.u := SHORT (t);
				Files.ReadNum (R, t); L.v := SHORT (t);
				Files.ReadNum (R, t); L.sig := SHORT (SHORT (t));
				Files.ReadString(R, L.name);
				Files.ReadNum(R, t);
				WHILE ~R.eof DO
					NEW (L.next); L := L.next;
					L.u := SHORT (t);
					Files.ReadNum (R, t); L.v := SHORT (t);
					Files.ReadNum (R, t); L.sig := SHORT (SHORT (t));
					Files.ReadString(R, L.name);
					Files.ReadNum(R, t);
				END
			END
		ELSIF tag = OldFileTag THEN (* non-portable file format *)
			Files.ReadBytes (R, ga.c, Dim * Dim * SIZE (Cell));
			Files.ReadBytes (R, ga.vr, Dim * ((Dim DIV Sector) - 1) * 2 * SIZE (INTEGER));
			Files.ReadBytes (R, ga.hr, ((Dim DIV Sector) - 1) * Dim * 2 * SIZE (INTEGER));
			Files.ReadBytes (R, ga.p, 4 * (Dim DIV 2) * SIZE (Pad));
			Files.ReadBytes (R, ga.res, Dim * SIZE (SHORTINT));
			Files.ReadBytes (R, ga.clk, Dim * SIZE (SHORTINT));
			Files.ReadInt(R, u);
			IF ~R.eof THEN
				NEW (L); ga.first := L;
				L.u := u; Files.ReadInt (R, L.v); Files.ReadInt (R, x); L.sig := SHORT (x);
				Files.ReadString(R, L.name);
				Files.ReadInt(R, u);
				WHILE ~R.eof DO
					NEW (L.next); L := L.next;
					L.u := u; Files.ReadInt (R, L.v); Files.ReadInt (R, x); L.sig := SHORT (x);
					Files.ReadString (R, L.name);
					Files.ReadInt (R, u)
				END
			END
		ELSE res := -1; (* wrong tag *)
		END
	ELSE (* open new empty *)
		FOR u := 0 TO Dim - 1 DO
			FOR v := 0 TO Dim - 1 DO
				ga.c[u, v] := eCell
			END;
			FOR v := 0 TO (Dim DIV Sector) - 2 DO
				ga.vr[u, v] := eRepV;
				ga.hr[v, u] := eRepH
			END;
			ga.res[u] := eReset; ga.clk[u] := ClkOne;
		END;
		FOR u := 0 TO (Dim DIV 2) - 1 DO
			ga.p[North, u].selector := TSOn; ga.p[North, u].flags := Pullup; (* RAM address lines enabled *)
			ga.p[South, u] := ePad; ga.p[West, u] := ePad; ga.p[East, u] := ePad;
		END;
		ga.p[East, 12].selector := TSOn; ga.p[East, 13].selector := TSOn; (* OE, WE enabled (+1 because of shifting) *)
		v := 0;
		COPY ("D.*", s1); COPY ("d.*", s2); (* insert default labels *)
		WHILE v < 8 DO
			s1[2] := CHR (ORD ("0") + v); s2[2] := s1[2]; Insert (ga, s1, -1, v, AOut, L); Insert (ga, s2, Dim, v, AOut, L);
			INC (v)
		END;
		Insert (ga, "INT'", -1, 8, AOut, L); Insert (ga, "CW'", -1, 14, AOut, L);
		Insert (ga, "RD'", -1, 11, AOut, L); Insert (ga, "WR'", -1, 12, AOut, L); Insert (ga, "SEL'", -1, 13, AOut, L);
		Insert (ga, "A2", -1, 10, AOut, L); Insert (ga, "A3", -1, 9, AOut, L);
		Insert (ga, "OE'", Dim, 11, AOut, L); Insert (ga, "WE'", Dim, 12, AOut, L); Insert (ga, "CS'", Dim, 13, AOut, L);
		u := 0; COPY ("a.*", s1);
		WHILE u < 10 DO s1[2] := CHR (ORD ("0") + u); Insert (ga, s1, 14-u, Dim, AOut, L); INC(u) END;
		COPY ("a.1*", s1);
		WHILE u < 15 DO s1[3] := CHR (ORD ("0") + u - 10); Insert (ga, s1, 14-u, Dim, AOut, L); INC(u) END
	END
END Open;

PROCEDURE Store* (ga : GA; name : ARRAY OF CHAR; VAR len : LONGINT);
VAR
	F : Files.File;
	R : Files.Rider;
	L : Label;
	u, v, dim : INTEGER;
	nofEmpty : LONGINT;

	PROCEDURE Flush;
	BEGIN
		Files.WriteNum (R, nofEmpty); nofEmpty := 0;
	END Flush;

	PROCEDURE EmptyCell (c : Cell) : BOOLEAN;
	BEGIN
		RETURN (c.routing = None) & (c.state = None) & (c.a = None) & (c.b = None) & (c.weL = None) & (c.nsL = None)
	END EmptyCell;
	
BEGIN
	F := Files.New (name); Files.Set (R, F, 0);
	Files.Write (R, ComprTag);
	dim := Dim; Files.WriteNum (R, dim);							(* dimension *)
	nofEmpty := 0;
	FOR u := 0 TO dim - 1 DO										(* cells *)
		FOR v := 0 TO dim - 1 DO
			IF EmptyCell (ga.c[u, v]) THEN INC (nofEmpty)
			ELSE
				Flush;
				Files.WriteNum (R, ga.c[u, v].routing); Files.WriteNum (R, ga.c[u, v].state); Files.WriteNum (R, ga.c[u, v].a);
				Files.WriteNum (R, ga.c[u, v].b); Files.WriteNum (R, ga.c[u, v].weL); Files.WriteNum (R, ga.c[u, v].nsL)
			END
		END
	END;
	FOR u := 0 TO dim - 1 DO										(* vertical repeaters *)
		FOR v := 0 TO (dim DIV Sector) - 2 DO
			IF (ga.vr[u, v].w = 0) & (ga.vr[u, v].e = 0) THEN INC (nofEmpty)
			ELSE
				Flush;
				Files.WriteNum (R, ga.vr[u, v].w); Files.WriteNum (R, ga.vr[u, v].e)
			END
		END
	END;
	FOR u := 0 TO (dim DIV Sector) - 2 DO						(* horizontal repeaters *)
		FOR v := 0 TO dim - 1 DO
			IF (ga.hr[u, v].n = 0) & (ga.hr[u, v].s = 0) THEN INC (nofEmpty)
			ELSE Flush; Files.WriteNum (R, ga.hr[u, v].n); Files.WriteNum (R, ga.hr[u, v].s)
			END
		END
	END;
	FOR u := 0 TO dim - 1 DO										(* reset *)
		IF ga.res[u] = ClkGlobal THEN INC (nofEmpty)
		ELSE Flush; Files.WriteNum (R, ga.res[u])
		END
	END;
	FOR u := 0 TO dim - 1 DO										(* clock *)
		IF ga.clk[u] = ClkOne THEN INC (nofEmpty)
		ELSE Flush; Files.WriteNum (R, ga.clk[u])
		END
	END;
	FOR u := North TO East DO										(* I/O pads *)
		FOR v := 0 TO (dim DIV 2) - 1 DO
			IF (ga.p[u, v].selector = TSOff) & (ga.p[u, v].flags = Pullup) THEN INC (nofEmpty)
			ELSE Flush; Files.WriteNum (R, ga.p[u, v].selector); Files.WriteNum (R, ga.p[u, v].flags)
			END
		END
	END;
	Flush;
	L := ga.first;														(* labels *)
	WHILE L # NIL DO
		Files.WriteNum (R, L.u); Files.WriteNum (R, L.v); Files.WriteNum (R, L.sig);
		Files.WriteString (R, L.name); L := L.next
	END;
	len := Files.Pos (R);
	Files.Register(F)
END Store;

PROCEDURE Copy*(src, dest: GA); 
VAR l, old : Label;
BEGIN
	dest^ := src^;
	dest.first := NIL; l := src.first;
	WHILE l # NIL DO Insert(dest, l.name, l.u, l.v, l.sig, old); l := l.next END
END Copy;

PROCEDURE This* (ga: GA; name : ARRAY OF CHAR): Label; 
VAR l : Label;
BEGIN
	l := ga.first;
	WHILE (l # NIL) & (l.name # name) DO l := l.next END;
	RETURN l
END This;

PROCEDURE AdjustCoords (VAR u, v, sig : INTEGER);
BEGIN
	IF sig IN {LBusN, LBusS, EBusN, EBusS} THEN u := (u DIV Sector) * Sector (* adjust for beginning location of bus *)
	ELSIF sig IN {LBusW, LBusE, EBusW, EBusE} THEN v := (v DIV Sector) * Sector
	ELSIF sig = LOut THEN sig := AOut (* LOut labels are same as AOut labels *)
	END
END AdjustCoords;

PROCEDURE LabelAt* (ga : GA; u, v, sig : INTEGER): Label; 
VAR l : Label;
BEGIN
	AdjustCoords (u, v, sig);
	l := ga.first;
	WHILE (l # NIL) & ((l.u < u) OR (l.v < v) OR (l.sig < sig)) DO l := l.next END;
	IF (l # NIL) & ((l.u # u) OR (l.v # v) OR (l.sig # sig)) THEN l := NIL END;
	RETURN l
END LabelAt;

PROCEDURE Insert* (ga : GA; name : ARRAY OF CHAR; u, v, sig : INTEGER; VAR old : Label); 
VAR l, prev : Label;
BEGIN
	AdjustCoords (u, v, sig);
	l := ga.first; prev := NIL;
	WHILE (l # NIL) & (l.name # name) DO
		IF (l.u < u) OR ((l.u = u) & ((l.v < v) OR ((l.v = v) & (l.sig < sig)))) THEN prev := l END;
		l := l.next
	END;
	old := l;
	IF l = NIL THEN (* insert new label after prev *)
		NEW (l); COPY (name, l.name); l.u := u; l.v := v; l.sig := SHORT (sig);
		IF prev # NIL THEN l.next := prev.next; prev.next := l
		ELSE l.next := ga.first; ga.first := l
		END
	END
END Insert;

PROCEDURE Delete* (ga: GA; u, v, sig : INTEGER; VAR name : ARRAY OF CHAR); 
VAR l, prev: Label;
BEGIN
	AdjustCoords (u, v, sig);
	l := ga.first; prev := NIL;
	WHILE (l # NIL) & ((l.u < u) OR (l.v < v) OR (l.sig < sig)) DO prev := l; l := l.next END;
	IF (l # NIL) & ((l.u = u) & (l.v = v) & (l.sig = sig)) THEN
		IF prev # NIL THEN prev.next := l.next ELSE ga.first := l.next END;
		COPY (l.name, name)
	END
END Delete;

END CLGAs.