:  Syntax10.Scn.Fnt     Syntax10i.Scn.Fnt        StampElems Alloc 7 Jun 94          T        *    o        	            <    !    +    0        !    d        R                            !    f    !             nN '  LineElems Alloc  2  Syntax10b.Scn.Fnt              M                3    8  FoldElems New     8   0                                K    8   m   5    	   8   .    8   	   8   &    8   ;        %        1    8   <    8           %        3    8   C    8   j        %        1    8   B    8           %        0    8           E '   
            8   ^                        (              t            G        )        
        +        f        _                   R            F            8   K    8   l       "           8   G    8   h        F           8   J    8   '       2    8   F    8   L           8   K    8   7        .    8   J    8   8        .    8   J    8   8        .    8   J    8   7        .    8   G    8       8   G    8   >            8   G    8       8   G    8   >            8   H    8   C    '    <    &        &                                       8   
            8   ^    8           *    8   !    $    L       +       U                  Courier8.Scn.Fnt      `                %                z                               	        i                7               A                L        	        a        }                        O                                        N                                       4                                     *            '    ;        i                        w          8               8   L        &        ,    8           .    8                   +           J        I               o                -                &                        ;        R    8               8       8           ;    8   }       F   8               8             8                   8      8   
   R  MODULE CLFrames;	(** SHML 30 Oct 92 /  **)
	(* 27 Apr 94: new proc Backup and Undo for undo. New parameter in Print (comment) *)
	(* 19 May 94: new font pattern numbers *)

	IMPORT
		Input, Display, Printer, Viewers, Texts, Oberon, MenuViewers, TextFrames, CLGAs, Fr := CLFramesD
		(*, Bitmaps (* Windows only! *) *);

	CONST
		Wirth = FALSE; Windows = FALSE; System3 = FALSE;	(* search for Windows/System3 *) 
		Dim = CLGAs.Dim; Sector = CLGAs.Sector;	(* dimension of chip/sector (e.g. 8x8 cells) *)
		RepW = 16; RepPerCell = 5; CellW = RepPerCell*RepW; PadW = 2*RepW;
		RepPerSector = Sector*RepPerCell;
		CellLen = CellW-25;
		SWPadRep = -2; NEPadRep = Dim DIV Sector * (RepPerSector+1);	(* repeater coords for border *)
		XOffset = PadW; YOffset = -Dim*CellW - 3*RepW - PadW - 1;
		MenuCol = 15; MenuColHighlight = 14;	(* colors *)
		MR = 0; MM = 1; ML = 2; cancel = {MR, MM, ML};
		drawMode = Display.replace;
		(* drawMode = Display.paint;	(* Windows *) *)

	TYPE
		PatternProc = PROCEDURE(F: Fr.Frame; u, v, x, y, i, j: INTEGER): BOOLEAN;
		UpdateProc = PROCEDURE(F: Fr.Frame; u, v, i, j: INTEGER; keySum: SET);
		RestoreMsg = RECORD (Fr.UpdateMsg) END;	(* for copying of cells only! *)
		UndoMsg = RECORD (Fr.UpdateMsg) b: CLGAs.GA END;

	VAR W: Texts.Writer; rep: ARRAY 4, 7 OF INTEGER;	(* legal values for repeaters *)

	(* Support *) 

	PROCEDURE Str(s: ARRAY OF CHAR);	BEGIN Texts.WriteString(W, s) END Str;

	PROCEDURE Int(i: LONGINT);	BEGIN Texts.Write(W, " "); Texts.WriteInt(W, i, 0) END Int;

	PROCEDURE Ln;	BEGIN Texts.WriteLn(W); Texts.Append(Oberon.Log, W.buf) END Ln;

	PROCEDURE Min(x, y: INTEGER): INTEGER; BEGIN IF x <= y THEN RETURN x ELSE RETURN y END END Min;
	PROCEDURE Max(x, y: INTEGER): INTEGER; BEGIN IF x >= y THEN RETURN x ELSE RETURN y END END Max;

	PROCEDURE MarkMenu(F: Fr.Frame);	
		VAR R: Texts.Reader; V: Viewers.Viewer; T: Texts.Text; ch: CHAR;
	BEGIN
		V := Viewers.This(F.X, F.Y);
		IF (V IS MenuViewers.Viewer) & (V.dsc IS TextFrames.Frame) THEN
			T := V.dsc(TextFrames.Frame).text;
			IF T.len > 0 THEN Texts.OpenReader(R, T, T.len - 1); Texts.Read(R, ch) ELSE ch := 0X END;
			IF ch # "!" THEN Texts.Write(W, "!"); Texts.Append(T, W.buf) END
		END
	END MarkMenu;

	PROCEDURE RepSet(rep, val: INTEGER): BOOLEAN;	(* Is bit with val in rep set? *)
	BEGIN RETURN ODD(rep DIV val)
	END RepSet;

	PROCEDURE InitLocalBusCache(F: Fr.Frame);	
		VAR hr: CLGAs.HRepeater; vr: CLGAs.VRepeater; u, v: INTEGER; cache: Fr.BusCache;
	BEGIN
		cache := F.cache; v := 0;
		WHILE v < Dim DIV Sector DO
			u := 0;
			WHILE u < Dim DO
				cache.localNS[v, u, 0] := FALSE; cache.localNS[v, u, 1] := FALSE;
				cache.localWE[u, v, 0] := FALSE; cache.localWE[u, v, 1] := FALSE;
				INC(u)
			END;
			INC(v)
		END;
		v := 0;	(* check cells, if they write or read a local bus *)
		WHILE v < Dim DO
			u := 0;
			WHILE u < Dim DO
				IF F.a.c[u, v].nsL = CLGAs.North THEN cache.localNS[u DIV Sector, v, CLGAs.North MOD 2] := TRUE
				ELSIF F.a.c[u, v].nsL = CLGAs.South THEN cache.localNS[u DIV Sector, v, CLGAs.South MOD 2] := TRUE
				END;
				IF F.a.c[u, v].weL = CLGAs.West THEN cache.localWE[u, v DIV Sector, CLGAs.West MOD 2] := TRUE
				ELSIF F.a.c[u, v].weL = CLGAs.East THEN cache.localWE[u, v DIV Sector, CLGAs.East MOD 2] := TRUE
				END;
				INC(u)
			END;
			INC(v)
		END;
		v := 0;
		WHILE v < Dim DIV Sector-1 DO
			u := 0;
			WHILE u < Dim DO
				hr := F.a.hr[v, u]; vr := F.a.vr[u, v];
				IF hr.n # 0 THEN
					IF RepSet(hr.n, CLGAs.LEWE) OR RepSet(hr.n, CLGAs.LLWE)
							OR RepSet(hr.n, CLGAs.LLEW) OR RepSet(hr.n, CLGAs.ELEW) THEN
						cache.localNS[v, u, CLGAs.North MOD 2] := TRUE
					END;
					IF RepSet(hr.n, CLGAs.LEEW) OR RepSet(hr.n, CLGAs.LLEW)
							OR RepSet(hr.n, CLGAs.LLWE) OR RepSet(hr.n, CLGAs.ELWE) THEN
						cache.localNS[v+1, u, CLGAs.North MOD 2] := TRUE
					END
				END;
				IF hr.s # 0 THEN
					IF RepSet(hr.s, CLGAs.LEWE) OR RepSet(hr.s, CLGAs.LLWE)
							OR RepSet(hr.s, CLGAs.LLEW) OR RepSet(hr.s, CLGAs.ELEW)
							OR ODD(hr.s DIV CLGAs.PassGate) THEN
						cache.localNS[v, u, CLGAs.South MOD 2] := TRUE
					END;
					IF RepSet(hr.s, CLGAs.LEEW) OR RepSet(hr.s, CLGAs.LLEW)
							OR RepSet(hr.s, CLGAs.LLWE) OR RepSet(hr.s, CLGAs.ELWE)
							OR ODD(hr.s DIV CLGAs.PassGate) THEN
						cache.localNS[v+1, u, CLGAs.South MOD 2] := TRUE
					END
				END;
				IF vr.w # 0 THEN
					IF RepSet(vr.w, CLGAs.LEWE) OR RepSet(vr.w, CLGAs.LLWE)
							OR RepSet(vr.w, CLGAs.LLEW) OR RepSet(vr.w, CLGAs.ELEW) THEN
						cache.localWE[u, v+1, CLGAs.West MOD 2] := TRUE
					END;
					IF RepSet(vr.w, CLGAs.LEEW) OR RepSet(vr.w, CLGAs.LLEW)
							OR RepSet(vr.w, CLGAs.LLWE) OR RepSet(vr.w, CLGAs.ELWE) THEN
						cache.localWE[u, v, CLGAs.West MOD 2] := TRUE
					END
				END;
				IF vr.e # 0 THEN
					IF RepSet(vr.e, CLGAs.LEWE) OR RepSet(vr.e, CLGAs.LLWE)
							OR RepSet(vr.e, CLGAs.LLEW) OR RepSet(vr.e, CLGAs.ELEW)
							OR ODD(vr.e DIV CLGAs.PassGate) THEN
						cache.localWE[u, v+1, CLGAs.East MOD 2] := TRUE
					END;
					IF RepSet(vr.e, CLGAs.LEEW) OR RepSet(vr.e, CLGAs.LLEW)
							OR RepSet(vr.e, CLGAs.LLWE) OR RepSet(vr.e, CLGAs.ELWE)
							OR ODD(vr.e DIV CLGAs.PassGate) THEN
						cache.localWE[u, v, CLGAs.East MOD 2] := TRUE
					END
				END;
				INC(u)
			END;
			INC(v)
		END
	END InitLocalBusCache;

	PROCEDURE InitExpressBusCache(F: Fr.Frame);	
		VAR hr: CLGAs.HRepeater; vr: CLGAs.VRepeater; u, v: INTEGER; cache: Fr.BusCache;
	BEGIN
		cache := F.cache; v := 0;
		WHILE v < Dim DIV Sector DO
			u := 0;
			WHILE u < Dim DO
				cache.expNS[v, u, 0] := FALSE; cache.expNS[v, u, 1] := FALSE;
				cache.expWE[u, v, 0] := FALSE; cache.expWE[u, v, 1] := FALSE;
				INC(u)
			END;
			INC(v)
		END;
		v := 0;
		WHILE v < Dim DIV Sector-1 DO
			u := 0;
			WHILE u < Dim DO
				hr := F.a.hr[v, u]; vr := F.a.vr[u, v];
				IF hr.n # 0 THEN
					IF RepSet(hr.n, CLGAs.ELWE) OR RepSet(hr.n, CLGAs.EEWE)
							OR RepSet(hr.n, CLGAs.EEEW) OR RepSet(hr.n, CLGAs.LEEW) THEN
						cache.expNS[v, u, CLGAs.North MOD 2] := TRUE
					END;
					IF RepSet(hr.n, CLGAs.ELEW) OR RepSet(hr.n, CLGAs.EEEW)
							OR RepSet(hr.n, CLGAs.EEWE) OR RepSet(hr.n, CLGAs.LEWE) THEN
						cache.expNS[v+1, u, CLGAs.North MOD 2] := TRUE
					END
				END;
				IF hr.s # 0 THEN
					IF RepSet(hr.s, CLGAs.ELWE) OR RepSet(hr.s, CLGAs.EEWE)
							OR RepSet(hr.s, CLGAs.EEEW) OR RepSet(hr.s, CLGAs.LEEW) THEN
						cache.expNS[v, u, CLGAs.South MOD 2] := TRUE
					END;
					IF RepSet(hr.s, CLGAs.ELEW) OR RepSet(hr.s, CLGAs.EEEW)
							OR RepSet(hr.s, CLGAs.EEWE) OR RepSet(hr.s, CLGAs.LEWE) THEN
						cache.expNS[v+1, u, CLGAs.South MOD 2] := TRUE
					END
				END;
				IF vr.w # 0 THEN
					IF RepSet(vr.w, CLGAs.ELWE) OR RepSet(vr.w, CLGAs.EEWE)
							OR RepSet(vr.w, CLGAs.EEEW) OR RepSet(vr.w, CLGAs.LEEW) THEN
						cache.expWE[u, v+1, CLGAs.West MOD 2] := TRUE
					END;
					IF RepSet(vr.w, CLGAs.ELEW) OR RepSet(vr.w, CLGAs.EEEW)
							OR RepSet(vr.w, CLGAs.EEWE) OR RepSet(vr.w, CLGAs.LEWE) THEN
						cache.expWE[u, v, CLGAs.West MOD 2] := TRUE
					END
				END;
				IF vr.e # 0 THEN
					IF RepSet(vr.e, CLGAs.ELWE) OR RepSet(vr.e, CLGAs.EEWE)
							OR RepSet(vr.e, CLGAs.EEEW) OR RepSet(vr.e, CLGAs.LEEW) THEN
						cache.expWE[u, v+1, CLGAs.East MOD 2] := TRUE
					END;
					IF RepSet(vr.e, CLGAs.ELEW) OR RepSet(vr.e, CLGAs.EEEW)
							OR RepSet(vr.e, CLGAs.EEWE) OR RepSet(vr.e, CLGAs.LEWE) THEN
						cache.expWE[u, v, CLGAs.East MOD 2] := TRUE
					END
				END;
				INC(u)
			END;
			INC(v)
		END;
		u := 0;
		WHILE u < Dim DO
			IF F.a.clk[u] = CLGAs.ClkExpress THEN
				cache.expNS[u DIV Sector, Dim-1, CLGAs.South MOD 2] := TRUE
			END;
			IF F.a.res[u] = CLGAs.ClkExpress THEN
				cache.expNS[u DIV Sector, 0, CLGAs.North MOD 2] := TRUE
			END;
			INC(u)
		END
	END InitExpressBusCache;

	PROCEDURE RestoreAll(a: CLGAs.GA);	
		VAR msg: RestoreMsg;
	BEGIN msg.a := a; IF System3 THEN (* msg.F := NIL; Display.Broadcast(msg) *) ELSE Viewers.Broadcast(msg) END
	END RestoreAll;

	PROCEDURE UpdateCells(F: Fr.Frame; u, v, w, h: INTEGER);	
		VAR msg: Fr.CellMsg;
	BEGIN
		InitLocalBusCache(F);
		msg.a := F.a; msg.u := u; msg.v := v; msg.w := w; msg.h := h;
		IF System3 THEN (* msg.F := NIL; Display.Broadcast(msg) *) ELSE Viewers.Broadcast(msg) END
	END UpdateCells;

	PROCEDURE UpdatePad(F: Fr.Frame; u, v: INTEGER; side: SHORTINT);	
		VAR msg: Fr.PadMsg;
	BEGIN
		msg.a := F.a; msg.u := u; msg.v := v; msg.side := side;
		IF System3 THEN (* msg.F := NIL; Display.Broadcast(msg) *) ELSE Viewers.Broadcast(msg) END
	END UpdatePad;

	PROCEDURE UpdateRep(F: Fr.Frame; u, v: INTEGER; typ: SHORTINT);	
		VAR msg: Fr.RepMsg;
	BEGIN
		InitLocalBusCache(F); InitExpressBusCache(F);
		msg.a := F.a; msg.u := u; msg.v := v; msg.typ := typ;
		IF System3 THEN (* msg.F := NIL; Display.Broadcast(msg) *) ELSE Viewers.Broadcast(msg) END
	END UpdateRep;

	(** Frame procedures **) 

	PROCEDURE Backup*(f: Fr.Frame);	BEGIN CLGAs.Copy(f.a, f.b) END Backup;

	PROCEDURE Menu(F: Fr.Frame; x0, y0, u, v, xn, yn, xw, yw: INTEGER; pattern: PatternProc; update: UpdateProc);	
		VAR
			keySum, keys: SET;
			width, height, x, y, x1, y1, X, Y, oldX, oldY, i, j: INTEGER;
			(*b: Bitmaps.Bitmap;	(* Windows only! *) *)

		PROCEDURE Flip(i, j: INTEGER);
		BEGIN
			IF (0 <= i) & (i < xn) & (0 <= j) & (j < yn) THEN
				Display.ReplConst(MenuCol, x+i*xw+i, y+j*yw+j, xw-2, yw-2, Display.invert)
			END
		END Flip;

	BEGIN
		width := xn*xw+(xn-1)+4; height := yn*yw+(yn-1)+4;
		IF (F.W < width) OR (F.H < height) THEN RETURN END;
		IF x0+width > F.X1 THEN x0 := F.X1-width ELSIF x0 < F.X THEN x0 := F.X END;
		IF y0+height > F.Y1 THEN y0 := F.Y1-height ELSIF y0 < F.Y THEN y0 := F.Y END;
		Oberon.RemoveMarks(x0, y0, width, height); Oberon.FadeCursor(Oberon.Mouse);
		IF Windows THEN
			(*b := Bitmaps.New(width, height);
			Bitmaps.CopyBlock(Bitmaps.Disp, b, x0, y0, width, height, 0, 0, Display.replace)*)
		ELSE Display.CopyBlock(x0, y0, width, height, x0, -height, Display.replace);	(* save *)
		END;
		Display.ReplConst(Display.black(*Display.BG*), x0, y0, width, height, Display.replace);	(* clear *)
		Fr.Rect(F, MenuCol, x0, y0, width, height, 2);
		x := x0+2+xw; y := y0+2; x1 := x+(xn-1)*(xw+1);
		(* vertical lines *)
		WHILE x < x1 DO Display.ReplConst(MenuCol, x, y, 1, height-4, drawMode); INC(x, xw+1) END;
		(* horizontal lines *)
		x := x0+2; y := y0+2+yw; y1 := y+(yn-1)*(yw+1);
		WHILE y < y1 DO Display.ReplConst(MenuCol, x, y, width-4, 1, drawMode); INC(y, yw+1) END;
		j := 0; y := y0+3;
		WHILE j < yn DO
			i := 0; x := x0+3;
			WHILE i < xn DO
				IF pattern(F, u, v, x, y, i, j) THEN Fr.Rect(F, MenuColHighlight, x-1, y-1, xw, yw, 2) END;
				INC(i); INC(x, xw+1)
			END;
			INC(j); INC(y, yw+1)
		END;
		x := x0+3; y := y0+3; oldX := -1; oldY := -1; keySum := {ML};
		REPEAT
			Input.Mouse(keys, x1, y1); keySum := keySum + keys;
			Oberon.DrawCursor(Oberon.Mouse, Oberon.Arrow, x1, y1);
			X := (x1-(x0+2)) DIV (xw+1); Y := (y1-(y0+2)) DIV (yw+1);
			IF (X # oldX) OR (Y # oldY) THEN Flip(oldX, oldY); Flip(X, Y); oldX := X; oldY := Y END
		UNTIL keys = {};
		Oberon.FadeCursor(Oberon.Mouse);
		IF Windows THEN (* Bitmaps.CopyBlock(b, Bitmaps.Disp, 0, 0, width, height, x0, y0, Display.replace) *)
		ELSE Display.CopyBlock(x0, -height, width, height, x0, y0, Display.replace)	(* restore *)
		END;
		IF (keySum # cancel) & (0 <= oldX) & (oldX < xn) & (0 <= oldY) & (oldY < yn)
				OR (keySum = {ML, MM}) THEN
			Backup(F); update(F, u, v, oldX, oldY, keySum)
		END
	END Menu;

	PROCEDURE CellPattern(F: Fr.Frame; u, v, x, y, i, j: INTEGER): BOOLEAN;	
		VAR cell, cell1: CLGAs.Cell;
	BEGIN
		cell.a := CLGAs.North; cell.b := CLGAs.North; cell.routing := CLGAs.None; cell.state := CLGAs.None;
		IF j = 0 THEN
			CASE i OF
			| 0..3: cell.state := SHORT(i+CLGAs.State0); Fr.CellPattern(F, MenuCol, x+5, y, cell)
			| 4: cell.state := CLGAs.State2; cell.routing := CLGAs.Mux; Fr.CellPattern(F, MenuCol, x, y, cell)
			| 5: cell.state := CLGAs.State3; cell.routing := CLGAs.Mux; Fr.CellPattern(F, MenuCol, x, y, cell)
			END
		ELSE
			cell.routing := SHORT(i+CLGAs.Write); Fr.CellPattern(F, MenuCol, x, y, cell);
			IF i >= 4 THEN Fr.CopyPattern(MenuCol, x+10, y+13, 53H) END	(* corner turn *)
		END;
		cell1 := F.a.c[u, v];
		RETURN (j = 0) & (cell1.state # CLGAs.None) & (cell1.state = cell.state) & (
			(i < 4) & ((cell1.state IN {CLGAs.State0, CLGAs.State1}) OR
				(cell1.state IN {CLGAs.State2, CLGAs.State3}) & (cell1.routing # CLGAs.Mux))
			OR (i >= 4) & (cell1.state IN {CLGAs.State2, CLGAs.State3}) & (cell1.routing = CLGAs.Mux)
			) OR
			(j = 1) & (cell1.routing = cell.routing) & ((cell.routing # CLGAs.None) & (cell1.routing # CLGAs.Mux)
				OR (cell1.routing = CLGAs.Mux) & ~(cell1.state IN {CLGAs.State2, CLGAs.State3}))
	END CellPattern;

	PROCEDURE CellUpdate(F: Fr.Frame; u, v, i, j: INTEGER; keySum: SET);	
		VAR oldR, routing, state: SHORTINT; name: ARRAY CLGAs.LabelLen OF CHAR;
	BEGIN
		IF MM IN keySum THEN	(* initialize cell *)
			F.a.c[u, v].routing := CLGAs.None; F.a.c[u, v].state := CLGAs.None;
			F.a.c[u, v].a := CLGAs.None; F.a.c[u, v].b := CLGAs.None;
			F.a.c[u, v].nsL := CLGAs.None; F.a.c[u, v].weL := CLGAs.None;
			CLGAs.Delete(F.a, u, v, CLGAs.AOut, name); CLGAs.Delete(F.a, u, v, CLGAs.BOut, name);
			UpdateCells(F, u-u MOD Sector, v, Sector, 1); UpdateCells(F, u, v-v MOD Sector, 1, Sector)
		ELSE
			routing := F.a.c[u, v].routing; state := F.a.c[u, v].state;
			IF j = 0 THEN
				CASE i OF
				| 0..3: state := SHORT(i)
				| 4: state := CLGAs.State2; routing := CLGAs.Mux
				| 5: state := CLGAs.State3; routing := CLGAs.Mux
				END
			ELSE routing := SHORT(i)
			END;
			oldR := F.a.c[u, v].routing;
			IF (oldR # routing) OR (F.a.c[u, v].state # state) THEN
				IF (routing IN {CLGAs.Turn0, CLGAs.TurnB}) & ~(oldR IN {CLGAs.Turn0, CLGAs.TurnB})THEN
					IF F.a.c[u, v].nsL = CLGAs.None THEN
						F.a.c[u, v].nsL := CLGAs.North; UpdateCells(F, u-u MOD Sector, v, Sector, 1)
					END;
					IF F.a.c[u, v].weL = CLGAs.None THEN
						F.a.c[u, v].weL := CLGAs.West; UpdateCells(F, u, v-v MOD Sector, 1, Sector)
					END
				ELSIF (routing IN {CLGAs.Read, CLGAs.Mux}) & ~(oldR IN {CLGAs.Read, CLGAs.Mux}) OR
						~(routing IN {CLGAs.Read, CLGAs.Mux}) & (oldR IN {CLGAs.Read, CLGAs.Mux}) THEN
					F.a.c[u, v].nsL := CLGAs.None; F.a.c[u, v].weL := CLGAs.None;	(* init l if no cornerturn *)
					UpdateCells(F, u-u MOD Sector, v, Sector, 1); UpdateCells(F, u, v-v MOD Sector, 1, Sector)
				END;
				F.a.c[u, v].routing := routing; F.a.c[u, v].state := state; UpdateCells(F, u, v, 1, 1)
			END
		END
	END CellUpdate;

	PROCEDURE PadPattern(F: Fr.Frame; u, v, x, y, i, j: INTEGER): BOOLEAN;	
		VAR sel: INTEGER;
	BEGIN
		Fr.CopyPattern(MenuCol, x, y+2, 0B0H+i);
		IF v = Dim THEN sel := F.a.p[CLGAs.North, u].selector
		ELSIF v = -1 THEN sel := F.a.p[CLGAs.South, u].selector
		ELSIF u = -1 THEN sel := F.a.p[CLGAs.West, v].selector
		ELSE sel := F.a.p[CLGAs.East, v].selector
		END;
		RETURN sel = CLGAs.TSOff+(i + i DIV 3)
	END PadPattern;

	PROCEDURE PadUpdate(F: Fr.Frame; u, v, i, j: INTEGER; keySum: SET);	
		VAR sel, side: SHORTINT;
	BEGIN
		IF MM IN keySum THEN sel := CLGAs.TSOff	(* initialize pad *)
		ELSE sel := CLGAs.TSOff+SHORT(i + i DIV 3)
		END;
		IF v = Dim THEN F.a.p[CLGAs.North, u].selector := sel; side := CLGAs.North
		ELSIF v = -1 THEN F.a.p[CLGAs.South, u].selector := sel; side := CLGAs.South
		ELSIF u = -1 THEN F.a.p[CLGAs.West, v].selector := sel; side := CLGAs.West
		ELSE F.a.p[CLGAs.East, v].selector := sel; side := CLGAs.East
		END;
		UpdatePad(F, u, v, side)
	END PadUpdate;

	PROCEDURE RepPatternN(F: Fr.Frame; u, v, x, y, i, j: INTEGER): BOOLEAN;	
	BEGIN Fr.WERep(F, MenuCol, x, y+2, rep[j, i], TRUE); RETURN F.a.hr[u, v].n = rep[j, i]
	END RepPatternN;

	PROCEDURE RepPatternS(F: Fr.Frame; u, v, x, y, i, j: INTEGER): BOOLEAN;	
	BEGIN Fr.WERep(F, MenuCol, x, y+2, rep[j, i], FALSE); RETURN F.a.hr[u, v].s = rep[j, i]
	END RepPatternS;

	PROCEDURE RepPatternW(F: Fr.Frame; u, v, x, y, i, j: INTEGER): BOOLEAN;	
	BEGIN Fr.NSRep(F, MenuCol, x+2, y, rep[j, i], FALSE); RETURN F.a.vr[u, v].w = rep[j, i]
	END RepPatternW;

	PROCEDURE RepPatternE(F: Fr.Frame; u, v, x, y, i, j: INTEGER): BOOLEAN;	
	BEGIN Fr.NSRep(F, MenuCol, x+2, y, rep[j, i], TRUE); RETURN F.a.vr[u, v].e = rep[j, i]
	END RepPatternE;

	PROCEDURE RepUpdateN(F: Fr.Frame; u, v, i, j: INTEGER; keySum: SET);	
		VAR r: INTEGER;
	BEGIN
		IF MM IN keySum THEN r := 0 ELSE r := rep[j, i] END;
		F.a.hr[u, v].n := r; UpdateRep(F, u, v, Fr.nRepSel); UpdateCells(F, u*Sector, v, 2*Sector, 1)
	END RepUpdateN;

	PROCEDURE RepUpdateS(F: Fr.Frame; u, v, i, j: INTEGER; keySum: SET);	
		VAR r: INTEGER;
	BEGIN
		IF MM IN keySum THEN r := 0
		ELSE	(* keep pass gate status *)
			r := (F.a.hr[u, v].s DIV CLGAs.PassGate)*CLGAs.PassGate + rep[j, i]
		END;
		F.a.hr[u, v].s := r; UpdateRep(F, u, v, Fr.sRepSel); UpdateCells(F, u*Sector, v, 2*Sector, 1)
	END RepUpdateS;

	PROCEDURE RepUpdateW(F: Fr.Frame; u, v, i, j: INTEGER; keySum: SET);	
		VAR r: INTEGER;
	BEGIN
		IF MM IN keySum THEN r := 0 ELSE r := rep[j, i] END;
		F.a.vr[u, v].w := r; UpdateRep(F, u, v, Fr.wRepSel); UpdateCells(F, u, v*Sector, 1, 2*Sector)
	END RepUpdateW;

	PROCEDURE RepUpdateE(F: Fr.Frame; u, v, i, j: INTEGER; keySum: SET);	
		VAR r: INTEGER;
	BEGIN
		IF MM IN keySum THEN r := 0
		ELSE	(* keep pass gate status *)
			r := (F.a.vr[u, v].e DIV CLGAs.PassGate)*CLGAs.PassGate + rep[j, i]
		END;
		F.a.vr[u, v].e := r; UpdateRep(F, u, v, Fr.eRepSel); UpdateCells(F, u, v*Sector, 1, 2*Sector)
	END RepUpdateE;

	PROCEDURE EditConnections(F: Fr.Frame; cellU, cellV, u, v: INTEGER);	
		CONST left = 1; middle = RepPerCell DIV 2; right = RepPerCell-2;	(* coords of a_, b_, l_output south *)

		PROCEDURE Toggle(VAR selector: SHORTINT; dir: SHORTINT);	(* set direction or toggle if same *)
		BEGIN
			Backup(F);
			IF selector = dir THEN selector := CLGAs.None ELSE selector := dir END;
			UpdateCells(F, cellU, cellV, 1, 1)
		END Toggle;

		PROCEDURE SetL(dir: SHORTINT);
			PROCEDURE ToggleL(VAR selector: SHORTINT; dir: SHORTINT);	(* set direction or toggle if same *)
			BEGIN IF selector = dir THEN selector := CLGAs.None ELSE selector := dir END
			END ToggleL;
		BEGIN
			Backup(F);
			CASE F.a.c[cellU, cellV].routing OF
			| CLGAs.None, CLGAs.Write, CLGAs.TS:
				IF dir IN {CLGAs.North, CLGAs.South} THEN ToggleL(F.a.c[cellU, cellV].nsL, dir)
				ELSE ToggleL(F.a.c[cellU, cellV].weL, dir)
				END
			| CLGAs.Read, CLGAs.Mux:
				IF dir IN {CLGAs.North, CLGAs.South} THEN
					F.a.c[cellU, cellV].weL := CLGAs.None; ToggleL(F.a.c[cellU, cellV].nsL, dir)
				ELSE F.a.c[cellU, cellV].nsL := CLGAs.None; ToggleL(F.a.c[cellU, cellV].weL, dir)
				END
			| CLGAs.TurnB, CLGAs.Turn0:
				IF dir IN {CLGAs.North, CLGAs.South} THEN F.a.c[cellU, cellV].nsL := dir
				ELSE F.a.c[cellU, cellV].weL := dir
				END
			END;
			UpdateCells(F, cellU-cellU MOD Sector, cellV, Sector, 1);
			UpdateCells(F, cellU, cellV-cellV MOD Sector, 1, Sector)
		END SetL;

	BEGIN
		IF v = RepPerCell-1 THEN	(* north *)
			IF u = left THEN Toggle(F.a.c[cellU, cellV].a, CLGAs.North)
			ELSIF u = middle THEN SetL(CLGAs.North)
			ELSIF u = right THEN Toggle(F.a.c[cellU, cellV].b, CLGAs.North)
			END
		ELSIF v = 0 THEN	(* south *)
			IF u = left THEN Toggle(F.a.c[cellU, cellV].b, CLGAs.South)
			ELSIF u = middle THEN SetL(CLGAs.South)
			ELSIF u = right THEN Toggle(F.a.c[cellU, cellV].a, CLGAs.South)
			END
		ELSIF u = 0 THEN	(* west *)
			IF v = left THEN Toggle(F.a.c[cellU, cellV].b, CLGAs.West)
			ELSIF v = middle THEN SetL(CLGAs.West)
			ELSIF v = right THEN Toggle(F.a.c[cellU, cellV].a, CLGAs.West)
			END
		ELSIF u = RepPerCell-1 THEN	(* east *)
			IF v = left THEN Toggle(F.a.c[cellU, cellV].a, CLGAs.East)
			ELSIF v = middle THEN SetL(CLGAs.East)
			ELSIF v = right THEN Toggle(F.a.c[cellU, cellV].b, CLGAs.East)
			END
		END
	END EditConnections;

	PROCEDURE Update*(F: Fr.Frame);	
	BEGIN InitLocalBusCache(F); InitExpressBusCache(F); Fr.Restore(F); MarkMenu(F)
	END Update;

	PROCEDURE Edit*(F: Fr.Frame; x, y: INTEGER; keys: SET);	
		CONST A = 1; B = RepPerCell-2;	(* coords of a_ & b_output south *)
		VAR
			V: Viewers.Viewer; dF: Fr.Frame; cell: CLGAs.Cell;
			keySum: SET;
			x1, y1, repU, repV, cellU, cellV, secU, secV, u, v, w, h, du, dv: INTEGER;
			repU1, repV1, cellU1, cellV1, secU1, secV1, u1, v1, rep, pad, padM: INTEGER;
			repCol, repRow, repCol1, repRow1, ml: BOOLEAN;
			sig: SHORTINT;

		PROCEDURE TrackMouse(VAR sum: SET; VAR x0, y0: INTEGER);
			VAR k: SET;
		BEGIN
			sum := keys;
			REPEAT
				Input.Mouse(k, x0, y0); sum := sum + k;
				Oberon.DrawCursor(Oberon.Mouse, Oberon.Arrow, x0, y0)
			UNTIL k = {}
		END TrackMouse;

		PROCEDURE SetLabel(lu, lv: INTEGER; s: SHORTINT);
			VAR
				old: CLGAs.Label; dummy, name: ARRAY CLGAs.LabelLen OF CHAR; side: SHORTINT;
				Sel: Texts.Text; S: Texts.Scanner; beg, end, time: LONGINT;
		BEGIN
			Oberon.GetSelection(Sel, beg, end, time);
			IF (time >= 0) & (keySum = {ML, MM}) THEN
				Texts.OpenScanner(S, Sel, beg); Texts.Scan(S);
				IF ((S.class = Texts.Name) OR (S.class = Texts.String)) & (S.len < CLGAs.LabelLen) THEN
					COPY(S.s, name);
					IF (S.class = Texts.Name) & (S.nextCh = "'") THEN name[S.len] := "'"; name[S.len+1] := 0X END;
					old := CLGAs.This(F.a, name);
					IF old # NIL THEN Str(name); Str(" already defined at"); Int(old.u); Int(old.v); Ln
					ELSE Backup(F); CLGAs.Delete(F.a, lu, lv, s, dummy); CLGAs.Insert(F.a, name, lu, lv, s, old)
					END
				ELSE RETURN
				END
			ELSIF keySum = {ML, MR} THEN Backup(F); CLGAs.Delete(F.a, lu, lv, s, dummy)
			END;
			IF lv = Dim THEN side := CLGAs.North
			ELSIF lv = -1 THEN side := CLGAs.South
			ELSIF lu = -1 THEN side := CLGAs.West
			ELSIF lu = Dim THEN side := CLGAs.East
			ELSE UpdateCells(F, lu, lv, 1, 1); RETURN
			END;
			UpdatePad(F, lu, lv, side)
		END SetLabel;

		PROCEDURE Pad(repeater: INTEGER);
		BEGIN
			pad := (repeater-2*(RepPerCell-1)) DIV RepPerCell;
			padM := (repeater-2*(RepPerCell-1)) MOD RepPerCell
		END Pad;

		PROCEDURE PadLabel(pu, pv: INTEGER);
		BEGIN
			IF ml THEN
				TrackMouse(keySum, x1, y1);
				IF keySum = cancel THEN RETURN END;
				repU1 := (x1-F.x) DIV RepW; repV1 := (y1-F.y) DIV RepW;
				IF (repU = repU1) & (repV = repV1) & (keySum * {MM, MR} # {}) THEN SetLabel(pu, pv, CLGAs.AOut) END
			END
		END PadLabel;

		PROCEDURE Copy;	(* uses u, v, du, dv, F, dF *)
			VAR u0, v0: INTEGER;
			PROCEDURE MoveLabel(s: SHORTINT);
				VAR l: CLGAs.Label; name: ARRAY CLGAs.LabelLen OF CHAR;
			BEGIN
				l := CLGAs.LabelAt(F.a, u, v, s);
				IF l # NIL THEN
					IF ML IN keySum THEN CLGAs.Delete(F.a, u, v, s, name) END;
					CLGAs.Delete(dF.a, u0, v0, s, name); CLGAs.Insert(dF.a, l.name, u0, v0, s, l)
				END
			END MoveLabel;
		BEGIN
			u0 := u+du; v0 := v+dv; dF.a.c[u0, v0] := F.a.c[u, v];
			IF ML IN keySum THEN MoveLabel(CLGAs.AOut); MoveLabel(CLGAs.BOut); F.a.c[u, v] := cell
			ELSIF F.a # dF.a THEN MoveLabel(CLGAs.AOut); MoveLabel(CLGAs.BOut)
			END
		END Copy;

	BEGIN
		Fr.Translate(F, x, y, repU, repV, cellU, cellV, secU, secV, repCol, repRow);
		IF keys*{ML, MR} # {} THEN	(* edit/select *)
			ml := keys = {ML};
			IF (repU >= SWPadRep) & (repU <= NEPadRep) & (repV >= SWPadRep) & (repV <= NEPadRep) THEN
				IF ~repRow & ~repCol & (0 <= repU) & (repU <= NEPadRep-2)
						& (0 <= repV) & (repV <= NEPadRep-2) THEN	(* cell *)
					u := (repU-secU) MOD RepPerCell; v := (repV-secV) MOD RepPerCell;
					IF (A <= u) & (u <= B) & (A <= v) & (v <= B) THEN	(* edit cell *)
						IF ml THEN Menu(F, x, y, cellU, cellV, 6, 2, CellLen, CellLen, CellPattern, CellUpdate)
						ELSE	(* select cell *)
							Fr.SelectCells(F, cellU, cellV, 1, 1, FALSE);
							REPEAT
								Input.Mouse(keys, x1, y1);
								Oberon.DrawCursor(Oberon.Mouse, Oberon.Arrow, x1, y1);
								Fr.Translate(F, x1, y1, repU1, repV1, cellU1, cellV1, secU1, secV1, repCol1, repRow1);
								IF ~repRow1 & ~repCol1 & (0 <= repU1) & (repU1 <= NEPadRep-2)
										& (0 <= repV1) & (repV1 <= NEPadRep-2) THEN
									u1 := (repU1-secU1) MOD RepPerCell; v1 := (repV1-secV1) MOD RepPerCell;
									IF (A <= u1) & (u1 <= B) & (A <= v1) & (v1 <= B)
											& ((cellU <= cellU1) & (cellU1-cellU+1 # F.selW)
											OR (cellV <= cellV1) & (cellV1-cellV+1 # F.selH)) THEN
										Fr.SelectCells(F, cellU, cellV, Max(1, cellU1-cellU+1), Max(1, cellV1-cellV+1), TRUE)
									END
								END
							UNTIL keys = {}
						END
					ELSIF ml THEN	(* connections/labels *)
						TrackMouse(keySum, x1, y1);
						IF keySum = cancel THEN RETURN END;
						repU1 := (x1-F.x) DIV RepW; repV1 := (y1-F.y) DIV RepW;
						IF (repU = repU1) & (repV = repV1) THEN
							IF keySum = {ML} THEN EditConnections(F, cellU, cellV, u, v)
							ELSIF (keySum * {MM, MR} # {}) & (v = 0) THEN	(* set label *)
								IF u = A THEN sig := CLGAs.AOut
								ELSIF u = B THEN sig := CLGAs.BOut
								ELSE RETURN
								END;
								SetLabel(cellU, cellV, sig)
							END
						END
					ELSE TrackMouse(keySum, x1, y1)
					END
				ELSE	(* not cell *)
					IF keys = {MR} THEN
						TrackMouse(keySum, x1, y1);
						Fr.Translate(F, x1, y1, repU, repV, cellU, cellV, secU, secV, repCol, repRow);
						IF (repU < SWPadRep) OR (repU > NEPadRep)
							OR (repV < SWPadRep) OR (repV > NEPadRep) THEN RETURN
						END
					END;
					IF (SWPadRep-repV >= -1) OR (NEPadRep-repV <= 1) THEN	(* N_ or S_pad *)
						Pad(repU-secU);
						IF (pad >= 0) & (pad < Dim-3) & (padM < RepPerCell-1) & ~ODD(pad) THEN
							IF repV = NEPadRep THEN	(* N_pad *)
								IF ml THEN Menu(F, x, y, pad DIV 2, Dim, 4, 1, 28, 25, PadPattern, PadUpdate)
								ELSE Fr.SelectPad(F, pad DIV 2, Dim, Fr.nPadSel)
								END
							ELSIF repV = NEPadRep-1 THEN PadLabel(pad DIV 2, Dim)
							ELSIF repV = SWPadRep THEN	(* S_pad *)
								IF ml THEN Menu(F, x, y, pad DIV 2, -1, 4, 1, 28, 25, PadPattern, PadUpdate)
								ELSE Fr.SelectPad(F, pad DIV 2, -1, Fr.sPadSel)
								END
							ELSIF repV = SWPadRep+1 THEN PadLabel(pad DIV 2, -1)
							END
						ELSE TrackMouse(keySum, x1, y1)
						END
					ELSIF (SWPadRep-repU >= -1) OR (NEPadRep-repU <= 1) THEN	(* W_ or E_pad *)
						Pad(repV-secV);
						IF (pad >= 0) & (pad < Dim-3) & (padM < RepPerCell-1) & ~ODD(pad) THEN
							IF repU = SWPadRep THEN	(* W_pad *)
								IF ml THEN Menu(F, x, y, -1, pad DIV 2, 4, 1, 28, 25, PadPattern, PadUpdate)
								ELSE Fr.SelectPad(F, -1, pad DIV 2, Fr.wPadSel)
								END
							ELSIF repU = SWPadRep+1 THEN PadLabel(-1, pad DIV 2)
							ELSIF repU = NEPadRep THEN	(* E_pad *)
								IF ml THEN Menu(F, x, y, Dim, pad DIV 2, 4, 1, 28, 25, PadPattern, PadUpdate)
								ELSE Fr.SelectPad(F, Dim, pad DIV 2, Fr.ePadSel)
								END
							ELSIF repU = NEPadRep-1 THEN PadLabel(Dim, pad DIV 2)
							END
						ELSE TrackMouse(keySum, x1, y1)
						END
					ELSIF ~repCol & repRow THEN	(* NS_rep *)
						rep := (repU-secU) MOD 5;
						IF rep = 4 THEN
							IF ml THEN Menu(F, x, y, cellU, cellV DIV 8 - 1, 7, 4, RepW, RepW+2, RepPatternE, RepUpdateE)
							ELSE Fr.SelectRep(F, cellU, cellV DIV 8 - 1, Fr.eRepSel)
							END
						ELSIF rep = 0 THEN
							IF ml THEN Menu(F, x, y, cellU, cellV DIV 8 - 1, 7, 4, RepW, RepW+2, RepPatternW, RepUpdateW)
							ELSE Fr.SelectRep(F, cellU, cellV DIV 8 - 1, Fr.wRepSel)
							END
						ELSE TrackMouse(keySum, x1, y1)
						END
					ELSIF ~repRow & repCol THEN	(* WE_rep *)
						rep := (repV-secV) MOD 5;
						IF rep = 4 THEN
							IF ml THEN Menu(F, x, y, cellU DIV 8 - 1, cellV, 7, 4, RepW+2, RepW, RepPatternN, RepUpdateN)
							ELSE Fr.SelectRep(F, cellU DIV 8 - 1, cellV, Fr.nRepSel)
							END
						ELSIF rep = 0 THEN
							IF ml THEN Menu(F, x, y, cellU DIV 8 - 1, cellV, 7, 4, RepW+2, RepW, RepPatternS, RepUpdateS)
							ELSE Fr.SelectRep(F, cellU DIV 8 - 1, cellV, Fr.sRepSel)
							END
						ELSE TrackMouse(keySum, x1, y1)
						END
					ELSE TrackMouse(keySum, x1, y1)
					END
				END	(* IF cell *)
			ELSE TrackMouse(keySum, x1, y1)
			END	(* IF repU >= ... *)
		ELSIF keys = {MM} THEN	(* shift plane / move/copy selection *)
			TrackMouse(keySum, x1, y1);
			IF keySum = cancel THEN RETURN END;
			IF (keySum = {MM}) & ((x # x1) OR (y # y1)) THEN INC(F.Xa, x1-x); INC(F.Ya, y1-y); Fr.Restore(F)	(* shift *)
			ELSIF keySum # {MM} THEN	(* MM, ML or MM, MR *)
				V := Viewers.This(x1, y1);
				IF V.dsc.next IS Fr.Frame THEN dF := V.dsc.next(Fr.Frame); F := Fr.Selected() ELSE F := NIL END;
				IF (F # NIL) & (F.selected) & (F.selTyp = Fr.cellSel) THEN	(* move/copy selection *)
					Fr.Translate(dF, x1, y1, repU, repV, cellU, cellV, secU, secV, repCol, repRow);
					du := cellU-F.selU; dv := cellV-F.selV;
					IF ((du # 0) OR (dv # 0) OR (F.a # dF.a))
							& (F.selU+du >= 0) & (F.selU+F.selW+du <= Dim)
							& (F.selV+dv >= 0) & (F.selV+F.selH+dv <= Dim) THEN
						Backup(F);
						IF F.a # dF.a THEN Backup(dF) END;
						IF ML IN keySum THEN	(* move selection *)
							cell.routing := CLGAs.None; cell.state := CLGAs.None;
							cell.a := CLGAs.None; cell.b := CLGAs.None; cell.nsL := CLGAs.None; cell.weL := CLGAs.None
						END;
						u1 := F.selU+F.selW; v1 := F.selV+F.selH;
						IF du < 0 THEN
							u := F.selU; REPEAT v := F.selV; REPEAT Copy; INC(v) UNTIL v = v1; INC(u) UNTIL u = u1
						ELSIF du = 0 THEN
							IF dv <= 0 THEN
								u := F.selU; REPEAT v := F.selV; REPEAT Copy; INC(v) UNTIL v = v1; INC(u) UNTIL u = u1
							ELSIF dv > 0 THEN
								u := u1; REPEAT DEC(u); v := v1; REPEAT DEC(v); Copy UNTIL v = F.selV UNTIL u = F.selU
							END
						ELSE
							u := u1; REPEAT DEC(u); v := F.selV; REPEAT Copy; INC(v) UNTIL v = v1 UNTIL u = F.selU
						END;
						RestoreAll(dF.a);
						IF (ML IN keySum) & (F.a # dF.a) THEN RestoreAll(F.a) END;
						IF dF = F THEN u := F.selU+du; v := F.selV+dv ELSE u := cellU; v := cellV END;
						Fr.SelectCells(dF, u, v, F.selW, F.selH, FALSE)
					END
				END
			END
		END
	END Edit;

	PROCEDURE Undo*(F: Fr.Frame);	
		VAR msg: UndoMsg;
	BEGIN
		msg.a := F.a; msg.b := F.b;
		IF System3 THEN (* msg.F := NIL; Display.Broadcast(msg) *) ELSE Viewers.Broadcast(msg) END
	END Undo;

	PROCEDURE Handle*(f: Display.Frame; VAR M: Display.FrameMsg);	
	(* PROCEDURE Handle*(f: Objects.Object; VAR M:Objects.ObjMsg); *)
		VAR F, F1: Fr.Frame; c: CLGAs.GA;
	BEGIN
		F := f(Fr.Frame);
		IF M IS Oberon.InputMsg THEN
			WITH M: Oberon.InputMsg DO
				IF M.id = Oberon.track THEN
					IF M.keys # {} THEN Edit(F, M.X, M.Y, M.keys)
					ELSE Oberon.DrawCursor(Oberon.Mouse, Oberon.Arrow, M.X, M.Y)
					END
				END
			END
		ELSIF M IS Fr.SelMsg THEN
			WITH M: Fr.SelMsg DO
				IF F.selected & (M.time < F.time) THEN M.f := F; M.time := F.time END
			END
		ELSIF M IS Fr.CellMsg THEN
			WITH M: Fr.CellMsg DO
				IF M.a = F.a THEN Fr.UpdateCells(F, M.u, M.v, M.w, M.h); MarkMenu(F) END
			END
		ELSIF M IS Fr.PadMsg THEN
			WITH M: Fr.PadMsg DO
				IF M.a = F.a THEN Fr.UpdatePad(F, M.u, M.v, M.side); MarkMenu(F) END
			END
		ELSIF M IS Fr.RepMsg THEN
			WITH M: Fr.RepMsg DO
				IF M.a = F.a THEN Fr.UpdateRep(F, M.u, M.v, M.typ); MarkMenu(F) END
			END
		ELSIF M IS RestoreMsg THEN
			WITH M: RestoreMsg DO
				IF M.a = F.a THEN Update(F) END
			END
		ELSIF M IS UndoMsg THEN
			WITH M: UndoMsg DO
				IF System3 THEN IF ~(((M.a = F.a) & (M.b = F.b)) = (M.a = F.a)) THEN HALT(99) END
				ELSE ASSERT(((M.a = F.a) & (M.b = F.b)) = (M.a = F.a))
				END;
				IF (M.a = F.a) & (M.b = F.b) THEN c := F.a; F.a := F.b; F.b := c; Update(F) END
			END
		ELSIF M IS Oberon.ControlMsg THEN
			IF M(Oberon.ControlMsg).id = Oberon.neutralize THEN
				Oberon.RemoveMarks(F.X, F.Y, F.W, F.H); Fr.Deselect(F)
			END
		ELSIF M IS Oberon.CopyMsg (* Objects.CopyMsg *) THEN
			Oberon.RemoveMarks(F.X, F.Y, F.W, F.H);
			NEW(F1); F1^ := F^; F1.selected := FALSE; M(Oberon.CopyMsg (* Objects.CopyMsg *)).F := F1
		ELSIF M IS MenuViewers.ModifyMsg (* M IS Display.ModifyMsg *)THEN
			WITH M: MenuViewers.ModifyMsg (* M: Display.ModifyMsg *) DO
				IF System3 THEN (* IF M.F = F THEN F.Y := M.Y; F.H := M.H; Fr.Restore(F) END *)
				ELSE F.Y := M.Y; F.H := M.H; Fr.Restore(F)
				END
			END
		END
	END Handle;

	PROCEDURE Open*(F: Fr.Frame; a: CLGAs.GA);	
	BEGIN
		F.a := a; NEW(F.b); CLGAs.Copy(a, F.b);
		F.Xa := XOffset; F.Ya := YOffset;
		NEW(F.cache); InitLocalBusCache(F); InitExpressBusCache(F);
		F.selected := FALSE; F.handle := Handle; F.mode := {Fr.cellMode};
		F.print := FALSE
	END Open;

	PROCEDURE Print*(F: Fr.Frame; x0: INTEGER; name, comment: ARRAY OF CHAR);	
		VAR PF: Fr.Frame; font, blank: ARRAY 32 OF CHAR;
	BEGIN
		IF Wirth THEN
			NEW(PF); PF^ := F^; PF.selected := FALSE;
			PF.X := 4096; PF.Y := 0; PF.W := Printer.PageWidth; PF.H := Printer.PageHeight;
			PF.Xa := (-x0)*CellW + 96; PF.Ya := -3000; Fr.Restore(PF);
			font := "Syntax10.Scn.Fnt"; Printer.String(0, Printer.PageHeight-100, name, font);
			IF comment # "" THEN blank := "     "; Printer.ContString(blank, font); Printer.ContString(comment, font) END;
			Printer.Page(1)
		ELSE		
			NEW(PF); PF^ := F^; PF.selected := FALSE;
			PF.X := 0; PF.Y := 0; PF.W := Printer.PageWidth; PF.H := Printer.PageHeight;
			IF System3 THEN PF.X := 200; PF.Y := 200 END;
			PF.Xa := (-x0)*CellW + 96; PF.Ya := -3000;
			PF.print := TRUE; Fr.Restore(PF);
			font := "Syntax10.Scn.Fnt"; Printer.String(0, Printer.PageHeight-100, name, font);
			IF comment # "" THEN blank := "     "; Printer.ContString(blank, font); Printer.ContString(comment, font) END;
			Printer.Page(1)
		END
	END Print;

	PROCEDURE ShiftIO*(ga: CLGAs.GA; up: BOOLEAN);	
		VAR i: INTEGER; pn, ps, pw, pe: CLGAs.Pad;
	BEGIN
		IF up THEN
			pn := ga.p[CLGAs.North, CLGAs.Dim DIV 2 - 1]; ps := ga.p[CLGAs.South, CLGAs.Dim DIV 2 - 1];
			pw := ga.p[CLGAs.West, CLGAs.Dim DIV 2 - 1]; pe := ga.p[CLGAs.East, CLGAs.Dim DIV 2 - 1];
			i := CLGAs.Dim DIV 2 - 1;
			WHILE i > 8 DO
				ga.p[CLGAs.North, i] := ga.p[CLGAs.North, i-1]; ga.p[CLGAs.South, i] := ga.p[CLGAs.South, i-1];
				ga.p[CLGAs.West, i] := ga.p[CLGAs.West, i-1]; ga.p[CLGAs.East, i] := ga.p[CLGAs.East, i-1];
				DEC(i)
			END;
			ga.p[CLGAs.North, 8] := ga.p[CLGAs.North, 7]; ga.p[CLGAs.West, 8] := ga.p[CLGAs.West, 7];
			ga.p[CLGAs.North, 7] := pn; ga.p[CLGAs.South, 8] := ps;
			ga.p[CLGAs.West, 7] := pw; ga.p[CLGAs.East, 8] := pe
		ELSE	(* down *)
			pn := ga.p[CLGAs.North, 7]; ps := ga.p[CLGAs.South, 8];
			pw := ga.p[CLGAs.West, 7]; pe := ga.p[CLGAs.East, 8];
			ga.p[CLGAs.North, 7] := ga.p[CLGAs.North, 8]; ga.p[CLGAs.West, 7] := ga.p[CLGAs.West, 8];
			i := 8;
			WHILE i < CLGAs.Dim DIV 2 - 1 DO
				ga.p[CLGAs.North, i] := ga.p[CLGAs.North, i+1]; ga.p[CLGAs.South, i] := ga.p[CLGAs.South, i+1];
				ga.p[CLGAs.West, i] := ga.p[CLGAs.West, i+1]; ga.p[CLGAs.East, i] := ga.p[CLGAs.East, i+1];
				INC(i)
			END;
			ga.p[CLGAs.North, CLGAs.Dim DIV 2 - 1] := pn; ga.p[CLGAs.South, CLGAs.Dim DIV 2 - 1] := ps;
			ga.p[CLGAs.West, CLGAs.Dim DIV 2 - 1] := pw; ga.p[CLGAs.East, CLGAs.Dim DIV 2 - 1] := pe
		END
	END ShiftIO;

	PROCEDURE GetParFrame*(VAR f: Fr.Frame);	(** call from command only! **)
		VAR v: Viewers.Viewer;
	BEGIN
		IF (Oberon.Par.frame = Oberon.Par.vwr.dsc) & (Oberon.Par.frame.next # NIL)
				& (Oberon.Par.frame.next IS Fr.Frame) THEN
			f := Oberon.Par.frame.next(Fr.Frame)
		ELSE
			v := Oberon.MarkedViewer();
			IF (v.dsc # NIL) & (v.dsc.next # NIL) & (v.dsc.next IS Fr.Frame) THEN f := v.dsc.next(Fr.Frame)
			ELSE f := Fr.Selected()
			END
		END
	END GetParFrame;

BEGIN
	Texts.OpenWriter(W);
	rep[0, 0] := 4; rep[1, 0] := 1; rep[2, 0] := 64; rep[3, 0] := 16;
	rep[0, 1] := 2; rep[1, 1] := 8; rep[2, 1] := 128; rep[3, 1] := 32;
	rep[0, 2] := 5; rep[1, 2] := 80; rep[2, 2] := 20; rep[3, 2] := 65;
	rep[0, 3] := 10; rep[1, 3] := 160; rep[2, 3] := 34; rep[3, 3] := 136;
	rep[0, 4] := 6; rep[1, 4] := 9; rep[2, 4] := 96; rep[3, 4] := 144;
	rep[0, 5] := 66; rep[1, 5] := 24; rep[2, 5] := 36; rep[3, 5] := 129;
	rep[0, 6] := 132; rep[1, 6] := 33; rep[2, 6] := 72; rep[3, 6] := 18
END CLFrames.
