; module VT2.ASM  - for using VT100 with various CP/M programs
; Copyright 1983, Decmation, Inc., Santa Clara, CA 95051
;
; This module may be inserted between CP/M and the Decmation
; Bios to change terminal characteristics
; All calls to the bios pass through here
;
; In order to use this a 63K cp/m can be created:
; A>FIXCPM MOVCPM.COM    (optional, see fixcpm.doc)
; A>MOVCPM 63 *
; A>SAVE 34 CPM63.COM
; A>DDT CPM63.COM
; -IVT1.HEX
; -R
; -IVT2.HEX
; -R2980
; -G0
; A>SAVE 37 VT.COM
; A>VT [command line] (runs program in command line with modified keys)
;
; Key assignments modified so that user can use VT100/52 cursor keys to
; generate the "cursor diamond" used by many CP/M programs.
; PF1 and PF2 generate CTL-Q and CTL-O which are a problem to
; enter directly in some cases on some DEC systems.
;
; **** TERMINAL KEY ASSIGNMENTS ****
;
; PF1- SAME AS CTL-Q
; PF2- SAME AS CTL-O
; UPARROW - CURSOR UP (CTRL-E)
; DOWNARROW - CURSOR DOWN (CTRL-X)
; LEFTARROW - CURSOR LEFT (CTRL-S)
; RIGHTARROW -CURSOR RIGHT (CTRL-D)
; ESC-ESC - SAME AS ESC  (You must hit esc twice to generate esc.)
;
;
	org	0f600h	;start of bios for 63k CP/M
x	equ	0400h	;1024 byte offset
	jmp	$+x
wboot	equ	$+x
	jmp	wboot	;warm boot call
contst	equ	$+x	;bios address for console ready check
	jmp	contst	;console char ready check
			;returns A =ff for ready, 00 for not
conin	equ	$+x
	jmp	coninx	;get console char in A
conout	equ	$+x
	jmp	conout	;console char out, sends C to console
list	equ	$+x
	jmp	list	;list char out, sends C to list device
	jmp	$+x	;punch char out (C)
	jmp	$+x	;get reader char (A) (1AH=eof)
	jmp	$+x	;home (set disk track to 0)
	jmp	$+x	;seldsk (set current disk to value of C)
	jmp	$+x	;settrk BC contains track number
	jmp	$+x	;setsec BC contains disk sectory number
	jmp	$+x	;setdma BC contains DMA address for disk
	jmp	$+x	;read read 1 sector, return A=1 error, =0 
			;no error
	jmp	$+x	;write sector, A returned =1 error, =0
			;no error
lstst	equ	$+x
	jmp	lstst	;listst test list ready A=0 not ready, ff
			;ready
	jmp	$+x	;sectran sector in in BC, out in HL
			;table in DE
	jmp	$+x
	jmp	$+x
	jmp	$+x
	jmp	$+x
	jmp	$+x
	jmp	$+x
	jmp	$+x
	jmp	$+x
	jmp	$+x
	jmp	$+x
	jmp	$+x
	jmp	$+x
;
;
; process request for console input
;
esc	equ	27	;define escape char
;
coninx:	call	conin	;get a keyboard character in A
	cpi	esc	; see if escape char
	rnz		;skip escape sequence analysis if not
	call	conin	;the next char in sequence
	cpi	'['	;bracket ignore
	jz	t12
	cpi	'O'	;ignore O too
	jz	t12
	cpi	'?'	; ? too
	jz	t12
	jmp	t13	;if not ignore process as significent char
; Note: The cursor keys and PFx keys of the VT100/52 generate an escape
; sequence of the form esc * x - Where "*" may be O,? or [ or missing,
; depending ... x- is the significent character which tells which key.
;
t12:	call	conin	;get 3rd char of escape sequence
t13:	cpi	'A'	;process the significent char
	jnz	t131
	mvi	a,'e' and 31	;change to ctl-E up arrow
	ret
t131:	cpi	'B'
	jnz	t132
	mvi	a,'x' and 31	;down arrow
	ret
t132:	cpi	'C'
	jnz	t133
	mvi	a,'d' and 31	;right arrow
	ret
t133:	cpi	'D'
	jnz	t134
	mvi	a,'s' and 31	;left arrow
	ret
t134:	cpi	'P'	;pf1 key
	jnz	t135
	mvi	a,'q' and 31	;becomes ctl-q
	ret
t135:	cpi	'Q'	;pf2
	jnz	t136
	mvi	a,'o' and 31	;becomes ctl-o
	ret
t136:	ret	;change this statement and insert more code if desired


1