;	Stored on:	BIOS64.ASM	(64K CP/M BIOS FOR D100QU)
;	Author:		Paul Mennen
;	Copyright:	1983, Decmation
;
; MODIFIED 26-NOV-82 TO FIX READ EOF
; MODIFIED 11-DEC-82 TO ADD ENBIOS: MARKER
; MODIFIED 11-DEC-82 TO ADD 16 BYTE BUFFER CONOUT
; MODIFIED 8-FEB-83 TO WARM BOOT TO DEFAULT DISK
; MODIFIED 9-FEB-83 TO DELETE CHECKSUM COMPUTATIONS
; MODIFIED 15-FEB-83 TO ADD BIOS CALLS FOR MODEM FUNCTIONS
; modified 31-may-83 to increase character buffer to 64 bytes
; MODIFIED 12-JUNE-83 TO CHANGE MODEM CALLS
; NOTE: CLOSE TO SECTOR BOUNDRAY FBFF CALLING FOR CONTROL PGM CHANGE
; Modified 27-may-84 to add new functions based on SELDSK call
; MODIFIED 3-JUN-84 TO ADD FASTER PRINT OUTPUT OPTION
; Modified 25-Jun-84 to add reset for D200, 8088 processor
; modified 15-jul-84 to distinguish direct bios calls to
; modified 11-sep-84 to shorten d200 reset pulse
;      standard cp/m disks and get the right sector
; MODIFIED 27-NOV-84 TO DELAY TRUE ON CONTST AFTER CR
; MODIFIED 29-JAN-85 TO DELETE RESET OF D200 (PROTECT RAMDISK)
;
; MODIFIED 16-FEB-85  DELETE SPECIAL CODE FOR FLOPPY DISKS TO SAVE SPACE
; MARCH 1985
;      ADD CODE FOR FUNCTION 26 SEND FILE NAME TO DEC SYSTEM
; 3-APRIL-85 ADD CODE FOR KILL FUNCTION ON CONSOLE INPUT/ RUN PARMS
; 10-APRIL-85 ADD COLD BOOT CODE TO ZERO SUBMIT FLAG AT 3FH
;    AND CODE TO KILL CCP COMMAND BUFFER ON WARM BOOT
; INSTRUCTIONS FOR BUILDING A BOOTABLE RP/M SYSTEM WITH THIS BIOS
; A>ASM BIOS64		assemble this pgm
; A>XRPMORG @ E4	create 64k system in memory at 980h
; A>SAVE 34 RPM64.COM	save in file
; A>PATCH RPM64=BIOS64/FA00>1F80	patch bios to rp/m
; A>RPM64		;load rpm to memory, quits with jmp 0
; A>MOVSYS M A   put system from memory to disk A (B could be used)
;
; if CP/M is used instead, modify the commands above to use
; A>MOVCPM 64 *
; instead of xrpmorg
; you must have a cp/m to use movcpm
;
;
OFFSET	EQU	0B000H	; ADD -0400H TO MAKE BIOS 1K LARGER
CCP	EQU	03400h+OFFSET	; Adr. of Console Command Processor
BDOS	EQU	CCP + 806h	; Adr. of Basic Disk Operating System
BIOS	EQU	CCP + 1600h	; Adr. of Basic I/O System
DEFDK	EQU	04h		; Adr. of last CP/M default disk number
JUMP	EQU	0C3h		; Z80 opcode for JUMP
B$STORE	EQU	43EDh		; Z80 opcode for store of B,C to external adr.

	ORG	BIOS-1F80H+100H
	JMP	0	;AID IN CREATING SYSTEM

	ORG	BIOS		;		***** BIOS JUMP TABLE *****
;
	JMP	Boot		; Cold boot
wbootj	JMP	Wboot		; Warm boot
constj	JMP	Const		; Console status
coninj	JMP	Conin		; Console input
conouj	JMP	Conout		; Console out
	JMP	List		; Printer output
	JMP	Punch		; Ascii output
	JMP	Reader		; Ascii input
	JMP	Home		; Home drive
	JMP	Seldsk		; Select disk
	JMP	Settrk		; Set disk track number
	JMP	Setsec		; Set disk sector number
	JMP	Setdma		; Set dma address
	JMP	Read		; Read sector of selected disk
	JMP	Write		; Write sector of selected disk
	JMP	Listst		; Lister status
	JMP	Sectran		; Perform sector translation

	JMP	Home		; Leave room for future CP/M BIOS calls
	JMP	Home		; Leave room for future CP/M BIOS calls
;
;	These are DECMATION nonstandard BIOS calls
;
	JMP	Rdrt		; Read RT-11 file sector
	JMP	Wrrt		; Write RT-11 file sector
	JMP	Close		; Close RT-11 Output file
	JMP	Savdsk		; Return Disk Table pointer in HL
	JMP	Mdmout		; Output to Modem
	JMP	Mdmin		; Input from Modem
;
; RUN TIME PARAMETERS MANIPULATED BY SUBMIT FILES
; AT ABSOLUTE ADDRESS  FA4Bh
N0:	DB	0
N1:	DB	0
N2:	DB	0
N3:	DB	0
N4:	DB	0
N5:	DB	0
	JMP	Home		; Leave room for future Decmation BIOS calls
	JMP	Home		; Leave room for future Decmation BIOS calls
;
;	***** PDP-11 COMMUNICATION AREA *****

FUNC	DB	0	; Selects desired PDP-11 action (1 thru 16)
BUFFER	DB	0	; I/O Buffer
EOF	DB	0	; End of file flag
BOOTD	DB	0	; Disk number for CPM cold & warm boot
DISKNO	DB	0	; Disk number
SECTOR	DB	0	; Disk Sector number
TRACK	DW	0	; Disk Track number
DMA$ADR	DW	0	; Disk Read/Write buffer
;following word subject to modification by 11
cnbuf	DB	15	; mask for console out buffer
IALLOC	DB	0	; Type of Disk Write (0,1,2)
MDMCTB	DB	0	; MODEM CONTROL BYTE, ADDRESS OFFSET
OPTFLG	DB	6	;SET BY 11 TO SIGNIFY SUPPORT OF OPTIONAL
			;FEATURES. BIT 0=1 FOR FAST PRINTING
			; BIT 1(2)=1 MEANS THIS BIOS SUPPORTS FAST PRINT
			; BIT 2 (4) MEANS SUPPORTS FUNCTION 26
			; BIT 3(8) IF SET MEANS KILL ON CONSOLE INPUT REQ
CONRDY	DB	0	; 0-NOT READY, FF-READY (ENTIRELY SET BY 11)
LSTRDY	DB	0

; VECTORS TO DEFINE CPM SIZE
; THESE CHANGED BY 11 FOR 20K BIOS
; FOR 20K BIOS 11 MOVES COPY OF JUMP TABLE DOWN

CCPVEC	JMP	CCP	; START CCP
WBVEC	DW	BIOS+3
BDVEC	DW	BDOS	; BDOS ADDRESS FOR LOC 5
ENBIOS:	DW	NDISK	; MARKS END OF BIOS, START OF TABLES
INPTR:	DB	0	; INPUT CHAR PTR PTS TO EMPTY LOC
OUTPTR:	DB	0	; LOC FOR 11 TO PICK UP NEXT CHAR
BBASE:	DW	0,0,0,0	; 64 byte CHARACTER FIFO
	DW	0,0,0,0
	dw	0,0,0,0,0,0,0,0,0,0,0,0
	dw	0,0,0,0,0,0,0,0,0,0,0,0
; scratch area to pass addresses, etc
adrs1:	dw	0
adrs2:	dw	0
adrs3:	dw	0
adrs4:	dw	0
;
; CIRCULAR BUFFER TO IMPLEMENT FAST PRINTING OPTION
PRTPI:	DB	0
PRTPO:	DB	0	;INPUT, OUTPUT PTRS FOR BUFFER
PRTBUF:	DB	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
; END OF FIXED ASSIGNMENTS RELATIVE TO START OF BIOS
;	***** PDP-11 FUNCTION CODES *****

F$DISKWRITE	EQU	3
F$DISKREAD	EQU	4
F$WBOOT		EQU	5
F$SPARE		EQU	6	; SPARE FUNCTION CODE
F$CONIN		EQU	7
F$CONOUT	EQU	8
F$LIST		EQU	9
F$PUNCH		EQU	10
F$READER	EQU	11
F$RDRT		EQU	12	; READ SECTOR FROM RT FILE
F$WRRT		EQU	13	; WRITE SECTOR TO RT FILE
F$CLOSE		EQU	14	; CLOSE RT WRITE FILE
F$MDMOUT	EQU	15	; MODEM OUTPUT FUNCTION
F$MDMIN		EQU	16	; MODEM INPUT FUNCTION
F$EXITF		EQU	17	;exit back to DEC operating system
F$TIME		EQU	18	;return system time as hh:mm:ss
F$DATE		EQU	19	;return system date as 3, 16-bit
;				integers at adrs1 month, day, year (eg 84)
WBOOT	CALL	WAIT
	MVI	M,F$WBOOT	; Request Warm Boot Function
	LDA	DEFDK		; Get last CP/M default disk number
	STA	BOOTD		; Save it
WB1	MOV	A,M		; Wait for Warm Boot complete
	ORA	A		; Is function byte zero ?
	JNZ	WB1		; Wait if not (Cant use CALL WAIT1)
	STA	CCP+7	;WARM BOOT ONLY, KILL COMMAND BUFFER
	JMP	BOOT1
BOOT:
	XRA	A
	STA	03FH	;SPECIAL COLD BOOT ONLY, ZERO SUB FLAG
BOOT1:	MVI	A,JUMP		; jump opcode
	STA	0
	STA	5
	LHLD	WBVEC		; HL points to Warm Boot vector
	SHLD	1		; Store warm boot jump vector
	LHLD	BDVEC		; Pointer to BDOS
	SHLD	6		; Store BDOS vector
;
	LDA	BOOTD		; Get Disk # to boot from
	MOV	C,A		; Store it in C
	JMP	CCPVEC		; Start Console Command Processor

WAIT	LXI	H,FUNC		; Point to function byte
WAIT1	MOV	A,M		; Get function byte
	ORA	A		; Is it zero ?
	JNZ	WAIT1		; Wait if not
	RET

PUTC	CALL	WAIT		; Wait for 11 ready
	MOV	A,C
	STA	BUFFER		; Send byte to 11
	RET
;
; INPTR 0-15 CIRCULAR POINTER TO NEXT EMPTY LOCATION
; OUTPTR 0-15 CIRCULAR POINTER TO NEXT LOCATION FOR 11 TO REMOVE BYTE
; BBASE IS START OF BUFFER 16 BYTES
;
CONOUT	lda	cnbuf		;save mask in b
	mov	b,a
	LXI	H,INPTR
	MOV	A,M		; INPTR IN A
	INR	A		; IF INPTR+1=OUTPTR, BUFFER FULL
	ana	b	;mask modulo
	INX	H		; STEP TO OUTPTR
	CMP	M		; INPTR+1=OUTPTR??
	JZ	CONOUT		; LOOP FOREVER TILL 11 CHANGES OUTPTR
;  PUT CHAR IN BUFFER
	DCX	H		; BACK TO INPTR
	MOV	A,M		; INPTR EMPTY LOC
	MOV	L,A
	MVI	H,0
	LXI	D,BBASE
	DAD	D		; POINTS TO EMPTY BUF LOC (HL)
	MOV	M,C		; PUT AWAY CHAR
	LXI	H,INPTR
	MOV	A,M
	INR	A
	ana	b		; MODULO n
	MOV	M,A		; PUT INPTR+1 IN INPTR
	RET			; CHAR IN OUT BUF, RET

;

CONIN	CALL	WAIT
	LDA	OPTFLG
	ANI	8		;CHECK FOR KILL ON CONSOLE INPUT
	JZ	CONIN1
	MVI	M,F$EXITF	;EXIT TO HOST OPERATING SYSTEM (KILL)
	JMP	$		;HALT
CONIN1:	MVI	M,F$CONIN	; Request Console Input function
GETA	MOV	A,M		; Wait for 11 to clear function byte
	ORA	A		; Is it zero ?
	JNZ	GETA		; If no, test it again
	LDA	BUFFER		; If yes, put byte from 11 into reg. A
	RET
CONIL:	DB	0	;LAST CHAR INPUT
;

CONST:
	LDA	CONIL	;IF LAST CHAR WAS CR, DELAY READY
	CPI	0DH
	JNZ	CONST1
	XRA	A
	STA	CONIL	;KILL LAST BEING CR
CONST1:
	LDA	CONRDY
	RET

;
; IF FAST PRINTING ENABLED RETURNS READY IF SPACE IN BUFFER
; IF NO SPACE IN BUFFER RETURNS NOT READY
; IF NO FAST PRINTING USES FLAG SET BY 11
LISTST:	LDA	OPTFLG
	ANI	1
	JZ	LISTST8
	CALL	LISTS
	CMP	M	;SEE IF BUFFER FULL
	JZ	LISTST7	;IF FULL
	MVI	A,0FFH	;SAY READY
	RET
LISTST7:	XRA	A	;SAY NOT READY A=0
	RET
LISTST8:	LDA	LSTRDY
	RET
;UTILITY SUB TO GET POINTERS TO REGISTERS
LISTS:	LXI	H,PRTPI	;BUFFER POINTERS
	MOV	A,M
	INX	H
	INR	A
	ANI	15	;MODULO 16
	RET		;WITH HL, A SET
;OUTPUT TO PRINTER, IF FAST PRINTING PUTS IT IN CIRCULAR BUFFER
LIST:	LDA	OPTFLG
	ANI	1
	JNZ	LIST5	;GOT USE FAST BUFFER
	CALL	PUTC
	MVI	M,F$LIST
	JMP	LISTST8	;USEING OLD METHOD
LIST5:	CALL	LISTS	;SET UP REGISTERS
	CMP	M	;SEE IF BUFFER FULL PRTPI+1=PRTPO
	JZ	LIST5	;IF SO LOOP FOREVER
;NOW PUT CHAR IN C IN CIRUCLAR BUFFER
	DCR	A	;STEP PTR BACK TO EMPTY LOC
	ANI	15
	LXI	D,0
	MOV	E,A
	INX	H	;POINT TO BUFFER
	DAD	D	;POINT TO SLOT IN BUFFER
	MOV	M,C	;STASH CHAR
	INR	A
	ANI	15
	STA	PRTPI	;SET BUFFER POINTER
	RET

PUNCH	CALL	PUTC
	MVI	M,F$PUNCH	; Request Punch Ouptut function
	RET
; OUT BYTE TO DLV11, BYTE IN C, CODE (OFFSET) IN B
MDMOUT	CALL	PUTC
	MOV	A,B	;CONTROL CODE
	STA	MDMCTB	;TO MODEM CONTROL BYTE
	MVI	M,F$MDMOUT	; Request Modem Output fuction
	call	wait
	RET
;
READER	CALL	WAIT
	MVI	M,F$READER	; Request a reader character
	JMP	GETA		; return with character in reg. A
; INPUT A BYTE FROM DLV11, CODE IN B, BYTE RETURNED IN A
MDMIN	CALL	WAIT
MDMIN1:	MOV	A,B	;CONTROL CODE TO
	STA	MDMCTB	;MODEM CONTROL BYTE
	MVI	M,F$MDMIN	; Request a character from the Modem
	JMP	GETA		; return with character in reg. A

;

READ	CALL	WAIT
	MVI	M,F$DISKREAD	; Request Disk Read function
	JMP	WAIT1		; Return with A=0 (No error)

WRITE	CALL	WAIT
	MOV	A,C		; Get write type
	STA	IALLOC		; Save in 11 communication area
	MVI	M,F$DISKWRITE	; Request Disk Write function
	JMP	WAIT1		; Return with A=0 (No error)
;
;
;	Disk Read/Write of RT-11 files
;
; THE CPM PROGRAM MUST SAVE AND RESTORE THE DISK TABLES
; SO THAT CPM WON'T BECOME CONFUSED
;
RDRT	CALL	WAIT
	XRA	A		; Zero the EOF flag
	STA	EOF
	MVI	M,F$RDRT	; Request Read RT-11 function
	CALL	WAIT1		; Wait for completion
	LXI	H,EOF		; Point to End Of File flag
	MOV	C,M		; Return EOF flag in reg C
	RET

WRRT	CALL	WAIT
	MVI	M,F$WRRT	; Request Write RT-11 function
	JMP	WAIT1		; Return with A=0

CLOSE	CALL	WAIT
	MVI	M,F$CLOSE	; Request output close function
	RET
;
SETTRK	DW	B$STORE,TRACK	; Store Disk Track number
	RET

SETDMA	DW	B$STORE,DMA$ADR	; Store Disk buffer address
	RET

SETSEC	LXI	H,SECTOR	; Store Disk Sector number
	MOV	M,C		; Only use least sig. byte
	RET

SELDSK	MOV	A,C	;DISK NUMBER
	CPI	16	;DISK #16 HAS ENTIRELY DIFFERENT MEANING
	JZ	NONSTD	;DO SPECIAL NONSTANDARD BIOS CALL
	LXI	H,NDISK		; WORD CONTAINING NUM OF DISKS
	CMP	M		; COMPARE TO NO AVAIL
	JZ	SELDE
	JNC	SELDE
	STA	DISKNO		; SET DISK NUMBER FOR 11
	ADD	A		; *2
	ADD	A		; *4
	ADD	A		; *8
	ADD	A		; *16
	MVI	H,0		; ZERO H
	MOV	L,A		; DISK NO *16 IN LOWER PART
	LXI	D,DPHES		; BASE OF TABLE
	DAD	D		; ADD BASE TO HL
	RET			; EXIT WITH HL
;
; SPECIAL CALLS ENTERED VIA SELDSK WITH DISK NUMBER=16
; call seldsk with c=16, b=function number
; c is an illegal disk for a normal seldsk call
; b=17  cause immediate exit back to dec operating sytem
; b=22  will condition pgm forimmediate exit if user types ^C
; b=18 return system time as an 8 byte string at address hl
; b=19 return system date a 3-16bit integers at array
; b=20 or 21 modem calls see below
; all calls may not be implemented under all DEC OS
;
NONSTD:	MOV	A,B	;FUNCTION NUMBER IN B
	MOV	C,B	;FUNCTION NUMBER IN C
	CPI	17	;EXIT FUNCTION?
	JNZ	NSTD2
; command unconditional exit back to dec host operating system
; FUNCTION 17 EXIT TO DEC OPERATING SYSTEM
NSTD1:
	LHLD	INPTR	;WAIT FOR TTY BUFFER TO EMPTY
	MOV	A,H
	CMP	L
	JNZ	NSTD1
	CALL	WAIT
	MOV	M,C	;FUNCTION CODE
	CALL	WAIT
	RET
;return system time hh:mm:ss as 8-byte string pointed to by HL
;FUNCTION 18 GET SYSTEM TIME
NSTD2:	CPI	18	;SYSTEM TIME?
	JNZ	NSTD8
	XCHG		;USER GAVE ADDRESS IN HL, PUT IN DE
	CALL	NSTD1	;LET 11 GET TIME
	LXI	H,ADRS1	;POINT TO TIME STRING
	MVI	C,8	;BYTES TO MOVE
NSTD3:	MOV	A,M
	STAX	D
	INX	H
	INX	D
	DCR	C
	JNZ	NSTD3
	RET
; return system date as 3-16 bit numbers pointed to by hl
; FUNCTION 19 GET SYSTEM DATE
NSTD8:	CPI	19	;SYSTEM DATE?
	JNZ	NSTD12
	XCHG
	CALL	NSTD1	;GET DATE
	LXI	H,ADRS1	;ADDRESS OF DATE
	MVI	C,6	;BYTES TO MOVE
	JMP	NSTD3
;modem input calls
; c=16, b=20, d=code, e=data or character count (if any)
; hl=address of data (if any)
; if d=1 returns character in A provided there are characters in buffer
; if d=2 returns the number of input characters in 11 buffer in A
; if d=3 returns space in 11 output buffer (character count) in A
; if d=4 Attaches a circular buffer (66 byte) to the modem input
;      stream. Enter with HL pointing to this 66 byte area.
; modem calls not implemented on all operating systems
;
; FUNCTION 20 MODEM INPUT CALL
nstd12:	cpi	20
	jnz	nstd20
	shld	adrs1	;store address if any
	mov	b,d	;code
	mov	c,e	;data
	call	putc	;char count to 11
	jmp	mdmin1	;continue with old call
;modem output calls c=16, b=21
; if d=1 puts data byte in e in 11 output buffer if space available
; if d=2 initializes the auxiliary (modem) serial port
; if d=3 deinitializes the auxiliary serial port
; if d=4 attaches a circular buffer structure 66-bytes to the modem
;        output stream. Enter with HL pointing to 66 bytes of space.
; FUNCTION 21 MODEM OUTPUT CALL
nstd20:	cpi	21
	jnz	nstd22
	shld	adrs1	;address if any
	mov	b,d
	mov	c,e
	jmp	mdmout	;continue with old call
; FUNCTION 22 CONDITION FOR EXIT TO OPERATING SYSTEM IF CARET C
NSTD22:	cpi	22	;ERROR?
	jz	nstd1	;22 condition for operating system exit
; FUNCTION 23,24 RESERVED FOR DISK LOCKING
; FUNCTION 26 SEND FILE NAME TO DEC SYSTEM
; CP/M PROGRAM PROVIDES AT DMA ADDRESS A TABLE AS FOLLOWS
; BYTE 0 - FILE NAME FOR (1) SEN, (2) REC, (3) LST
; BYTE 1 - 11 SETS THIS BYTE TO FE IF OK, IF CANT FIND FILE TO FF
; BYTE 2 - COUNT OF BYTES IN STRING NOT INCL TERM NULL
; BYTE 3-N STRING CONTAINING FILE NAME TERMINATED BY NULL
;
nstd25:
	CPI	25
	JNZ	NSTD26
	jmp	nstd1
NSTD26:
	CPI	26
	JNZ	NSTD1
	SHLD	ADRS1
	JMP	NSTD1


SELDE	LXI	H,0		; ERROR INDICATOR

HOME	RET			; Home function not implemented

; Performs the logical to physical sector mapping.
; Enter with logical sector number in "BC"
; Exit with physical sector number in "HL"

SECTRAN	MVI	H,0		; ZERO H
	MOV	L,C		; MOVE C TO LOWER
	RET			; Only use least significant byte

;

; RETURNS POINTER IN HL SO CPM PROGRAM CAN SAVE AND RESTORE
; THE DISK PARAMETERS. THE PARAMETERS CAN BE USED TEMPORARILY
; FOR RT TRANSFERS

SAVDSK	CALL	WAIT		; 11 MUST FINISH WITH TABLES
	LXI	H,DISKNO	; PTR TO TABLES
	RET

; BEGINNING OF DISK TABLES, FILLED IN BY 11

NDISK	DB	0		; NUMBER OF ENTRIES
DPHES	DB	0		; START OF DPH'S

	END

