	title	'PALANTIR Font Definition File -- 05/01/82'

*****************************************************************
*								*
*		Qume PS Modern 10  -  xxxxx			*
*								*
*	The definition table must be assembled to produce	*
*	a HEX file, which should then be LOADed or SAVEd	*
*	(e.g., SAVE 1 name.WPF) from DDT to create the		*
*	font definition file expected by the PALANTIR.		*
*								*
*	The table consists of 128 2-byte entries for the	*
*	character set from Ascii 0-127.  The first byte of	*
*	each entry is the character size in increments.  The	*
*	second byte is the code to be sent to the printer,	*
*	which for some print wheels is different from the	*
*	original Ascii character.  If the high-order bit of	*
*	the second byte is on, the DFSHFT (Shift) logic in	*
*	the print driver is invoked at printout.		*
*								*
*	For mono-spaced wheels, the first byte will be the	*
*	same throughout.  For wheels that use the normal	*
*	character arrangement, the second byte of each entry	*
*	will contain the next higher binary value.  The first	*
*	32 entries of the table are not normally used, unless	*
*	by the Extended Character Set option for printers	*
*	with more than 96 characters per wheel. 		*
*								*
*****************************************************************

	org	100h

std	 equ	 10	 ;Average size at 12-pitch (at 120 increments)

;	List of character sizes

sza	equ	std-6
szb	equ	std-4
szc	equ	std-2
szd	equ	std
sze	equ	std+2
szf	equ	std+4

	page
;	Control/Extended Range

	db	0,0
	db	0,1
	db	0,2
	db	0,3
	db	0,4
	db	0,5
	db	0,6
	db	0,7
	db	0,8
	db	0,9
	db	0,10
	db	0,11
	db	0,12
	db	0,13
	db	0,14
	db	0,15
	db	0,16
	db	0,17
	db	0,18
	db	0,19
	db	0,20
	db	0,21
	db	0,22
	db	0,23
	db	0,24
	db	0,25
	db	0,26
	db	0,27
	db	0,28
	db	std,' '		;Soft Space
	db	szd,'3'		;Hard Hyphen
	db	std,' '		;Hard Space

	page
;	Standard Ascii Character Set

	db	std,' ' 	;Blank
	db	szb,'6' 	;Exclamation Point
	db	szc,'1' 	;Double Quotes
	db	szd,',' 	;Pound (Number) Sign
	db	szd,'A' 	;Dollar Sign
	db	szd,'x' 	;Percent Sign
	db	szd,'l'		;Ampersand
	db	szc,'Z'		;Single Quote
	db	szb,'d' 	;Left Parenthesis
	db	szb,'F' 	;Right Parenthesis
	db	szd,'H' 	;Asterisk
	db	szd,'R' 	;Plus Sign
	db	szc,'+' 	;Comma
	db	szd,'3' 	;Hyphen (Minus Sign)
	db	szc,'8' 	;Period
	db	szc,'-' 	;Slash
	db	szd,'n' 	;Digit Zero
	db	szd,'b' 	;Digit One
	db	szd,'c' 	;Digit Two
	db	szd,'o' 	;Digit Three
	db	szd,'e' 	;Digit Four
	db	szd,'r' 	;Digit Five
	db	szd,'a' 	;Digit Six
	db	szd,'i' 	;Digit Seven
	db	szd,'t' 	;Digit Eight
	db	szd,'h' 	;Digit Nine
	db	szb,';' 	;Colon
	db	szb,'J' 	;Semicolon
	db	szd,'W' 	;Less Than
	db	sze,'Y' 	;Equal Sign
	db	szd,'/'+128	;Greater Than
	db	szc,'N' 	;Question Mark

	db	szd,'y' 	;At-Sign
	db	sze,'I' 	;Capital A
	db	sze,'C' 	;Capital B
	db	sze,'=' 	;Capital C
	db	sze,'2' 	;Capital D
	db	sze,'O' 	;Capital E
	db	sze,'G' 	;Capital F
	db	sze,'#' 	;Capital G
	db	szf,'K' 	;Capital H
	db	szc,'Q' 	;Capital I
	db	szd,'U' 	;Capital J
	db	sze,'9' 	;Capital K
	db	sze,'D' 	;Capital L
	db	szf,'7' 	;Capital M
	db	sze,'P' 	;Capital N
	db	szf,'X' 	;Capital O

	db	szd,':' 	;Capital P
	db	sze,')' 	;Capital Q
	db	sze,'V' 	;Capital R
	db	sze,'T' 	;Capital S
	db	sze,'S' 	;Capital T
	db	sze,'4' 	;Capital U
	db	sze,'L' 	;Capital V
	db	szf,'$' 	;Capital W
	db	sze,'5' 	;Capital X
	db	sze,'''' 	;Capital Y
	db	szd,'B' 	;Capital Z
	page
	db	szc,'M' 	;Left Square Bracket (Open)
	db	szd,'u' 	;Backslash - [Section Marker]
	db	szc,'z' 	;Right Square Bracket (Close)
	db	szd,'k' 	;Carat - [Dagger]
	db	sze,'E' 	;Underscore

	db	szd,'s' 	;Accent - [Degree]
	db	szd,'_' 	;Lowercase a
	db	szd,'"' 	;Lowercase b
	db	szd,'/' 	;Lowercase c
	db	sze,'@' 	;Lowercase d
	db	szd,'*' 	;Lowercase e
	db	szc,'%' 	;Lowercase f
	db	szd,'}' 	;Lowercase g
	db	sze,'\' 	;Lowercase h
	db	szc,'^' 	;Lowercase i
	db	szc,']' 	;Lowercase j
	db	sze,'m' 	;Lowercase k
	db	szc,'[' 	;Lowercase l
	db	szf,'>' 	;Lowercase m
	db	sze,'(' 	;Lowercase n
	db	szd,60h 	;Lowercase o

	db	szd,'&' 	;Lowercase p
	db	szd,'j' 	;Lowercase q
	db	szd,'<' 	;Lowercase r
	db	szd,'|' 	;Lowercase s
	db	szc,'{' 	;Lowercase t
	db	sze,'?' 	;Lowercase u
	db	sze,'0' 	;Lowercase v
	db	szf,'~' 	;Lowercase w
	db	szd,'v' 	;Lowercase x
	db	sze,'!' 	;Lowercase y
	db	szc,'g' 	;Lowercase z
	db	szf,'f' 	;Left Curly Brace (Open) - [Copyright]
	db	szd,' '+128	;Vertical Bar
	db	sze,'q' 	;Right Curly Brace (Close) - [Registered]
	db	sze,'w' 	;Tilde - [Trademark]
	db	szd,'.'		;Delete Code (Not Used) - [Paragraph]

	end
 q q q q q q q q q q q q q q q q q q q q q q q q q q q q q q q q q q q 