h32020
s 00003/00003/00076
d D 1.7 83/03/08 23:10:25 mrk 7 6
c changes to quarterly periodic axis type
e
s 00014/00009/00065
d D 1.6 83/03/08 20:21:08 tes 6 5
c modified axis pipeline for integer calculations
e
s 00001/00001/00073
d D 1.5 83/03/02 00:43:38 mrk 5 4
c make these work always in (0-1) space, removed all (0-100) references
e
s 00002/00001/00072
d D 1.4 83/02/09 11:50:48 mrk 4 3
c turned on clipping of labels
e
s 00002/00002/00071
d D 1.3 83/02/08 17:27:00 mrk 3 2
c changed vertical text justification definition txtjv
e
s 00010/00008/00063
d D 1.2 83/01/28 13:58:58 tes 2 1
c initial_internal_update
e
s 00071/00000/00000
d D 1.1 83/01/28 13:04:03 tes 1 0
c date and time created 83/01/28 13:04:03 by tes
e
u
tes
mjb
mrk
mmm
U
t
T
I 1
subroutine gptclb (index, xloc, value)
########################################################################
#                                                                      #
#          THIS MATERIAL IS CONFIDENTIAL AND IS FURNISHED UNDER        #
#          A WRITTEN LICENSE AGREEMENT.  IT MAY NOT BE USED,           #
#          COPIED OR DISCLOSED TO OTHERS EXCEPT IN ACCORDANCE          #
#          WITH THE TERMS OF THAT AGREEMENT.                           #
#                                                                      #
#          COPYRIGHT (C) 1982 GRAPHIC SOFTWARE SYSTEMS INC.            #
#          ALL RIGHTS RESERVED.                                        #
#                                                                      #
#     Function: output a tic label                                     #
#                                                                      #
#     Input Parameters:                                                #
#            index  - axis to label (1=x, 2=y)                         #
#            xloc   - location on axis to place label                  #
#            value  - value to be output                               #
#                                                                      #
#     Output Parameters:                                               #
#            none                                                      #
#                                                                      #
#     Routines Called:                                                 #
#            imove  - modify current position for later action         #
#            text   - output a graphic text string                     #
#            gpnval - generate a periodic element                      #
#            gr2chr - convert a real number to a character string      #
D 2
#            gitoch - convert an integer into a character string       #
E 2
#                                                                      #
########################################################################
D 6
integer index
real xloc, value
E 6
I 6
integer index, xloc
real value
E 6
 
integer i, length, gr2chr, kerror
integer number(12)  # Array used to convert binary to characters

D 6
real p(2)
E 6
I 6
integer p(2)
E 6
 
include(`pltcom')

DxB write (DEBUGxUNIT, 100) index, xloc, value
DxB 100 format (' gptclb:', i5, 2f10.5)
 
D 6
   p(1) = zplmin(1)
   p(2) = zplmin(2)
E 6
I 6
   p(1) = nplmin(1)
   p(2) = nplmin(2)
E 6
   i = 1
   txtjh = 2
D 3
   txtjv = 2
E 3
I 3
   txtjv = 1
E 3
   if (index == 1) {
      i = 2 
      txtjh = 1
D 3
      txtjv = 0
E 3
I 3
      txtjv = 2
E 3
      }
D 6
   p(i) = p(i) - .01 
E 6
I 6
   p(i) = p(i) - 327 
E 6
D 5
   p(index) = xloc/100.
E 5
I 5
   p(index) = xloc
E 5
I 4
D 6
   nclip = YES   # Turn on clipping
E 4
   call imove (ABSOLUTE, p(1), p(2))   # Move to the label position
E 6
I 6
   call gpdc2n (p, zxabsl, zyabsl)

   call gpzmov (ABSOLUTE, p(1), p(2))   # Move to the label position
E 6
 
D 7
   if (nperid > 0 & nperid < 5) call gpnval (value, length, number)
E 7
I 7
   if (nperid > 0 & nperid < 6) call gpnval (value, length, number)
E 7
D 2
   else                         length = gr2chr (value, number, 10, 2, kerror)
E 2

D 2
   # If using integer labels, do not put anything out past the decimal point
   if (nreal(index) != 0)  {
      for (i=length; i>1; i=i-1)  {
         if (number(i) == PERIOD) break
         }
      length = i - 1
E 2
I 2
   else {  # A number label
      length = gr2chr (value, number, 10, 2, kerror)

      # If using integer labels, do not put anything out past the decimal point
      if (nreal(index) != 0)  {
         for (i=length; i>1; i=i-1)  {
            if (number(i) == PERIOD) break
            }
         length = i - 1
	 }
E 2
      }
 
I 6
D 7
   #nclip = YES   # Turn on clipping
E 7
I 7
   nclip = YES   # Turn on clipping
E 7

E 6
   call text (length, number)
D 4
 
E 4
I 4
D 6
   nclip = NO  # Now turn it off 
E 6
I 6

D 7
   #nclip = NO  # Now turn it off 
E 7
I 7
   nclip = NO  # Now turn it off 
E 7

E 6
E 4
   return
end
E 1
