h33396
s 00002/00002/00091
d D 1.5 83/03/08 23:37:38 tes 5 4
c fixed integer ZEPS problem when generating label start and end
e
s 00012/00010/00081
d D 1.4 83/03/08 20:20:28 tes 4 3
c modified axis pipeline for integer calculations
e
s 00002/00002/00089
d D 1.3 83/03/02 00:43:06 mrk 3 2
c make these work always in (0-1) space, removed all (0-100) references
e
s 00020/00003/00071
d D 1.2 83/01/28 13:51:14 tes 2 1
c initial_internal_update
e
s 00074/00000/00000
d D 1.1 83/01/28 13:02:05 tes 1 0
c date and time created 83/01/28 13:02:05 by tes
e
u
tes
mjb
mrk
mmm
U
t
T
I 1
subroutine gpgnax (index, lstart)
########################################################################
#                                                                      #
#          THIS MATERIAL IS CONFIDENTIAL AND IS FURNISHED UNDER        #
#          A WRITTEN LICENSE AGREEMENT.  IT MAY NOT BE USED,           #
#          COPIED OR DISCLOSED TO OTHERS EXCEPT IN ACCORDANCE          #
#          WITH THE TERMS OF THAT AGREEMENT.                           #
#                                                                      #
#          COPYRIGHT (C) 1982 GRAPHIC SOFTWARE SYSTEMS INC.            #
#          ALL RIGHTS RESERVED.                                        #
#                                                                      #
#     Function: output an axis                                         #
#                                                                      #
#     Input Parameters:                                                #
#            index  - axis to be generated (1=x, 2=y)                  #
#            lstart - label starting value                             #
#                                                                      #
#     Output Parameters:                                               #
#            none                                                      #
#                                                                      #
#     Routines Called:                                                 #
#            gpdbln - draw an axis base line                           #
#            gpgntc - generate a tic mark                              #
#            gptclb - output a tic label                               #
#                                                                      #
########################################################################
integer index
real lstart

integer i, j, ktic
D 2
real x
E 2
I 2
D 4
real x, end
E 4
E 2
 
D 4
real axinc,       # Actual tic increment on axis
     axstrt,      # Actual tic position on axis
     dtminr,      # Minor tic increments
     value        # Current tic label value
E 4
I 4
integer axinc,       # Actual tic increment on axis
        axstrt,      # Actual tic position on axis
        dtminr,      # Minor tic increments
        end,
        x

real value        # Current tic label value
E 4
 
include(`pltcom')
 
DxB write (DEBUGxUNIT, 100) index, lstart
DxB 100 format (' gpgnax:', i5, f10.5)
 
   call gpdbln (index)   # Draw axis base line
   if (nmajor > 0) {
 
      # We are to output at least two major tics
 
D 2
      value = lstart
E 2
D 4
      axinc = ztdist(index)/nmajor
      axstrt = ztstrt(index)
E 4
I 4
      axinc = ntdist/nmajor
      axstrt = ntstrt
E 4
I 2
      value = lstart

      # may need to modify the start and stop points if user specified
      # tic position outside of the data range
D 3
      end = zplmin(index)*100. - ZEPS
E 3
I 3
D 4
      end = zplmin(index) - ZEPS
E 4
I 4
D 5
      end = nplmin(index)
E 5
I 5
      end = nplmin(index) - 5
E 5
E 4
E 3
      while (axstrt < end)  {
	 axstrt = axstrt + axinc
	 nmajor = nmajor - 1
	 value = value + zlincr
	 }

D 4
      x = ztend(index)
D 3
      end = zplmax(index)*100. + ZEPS
E 3
I 3
      end = zplmax(index) + ZEPS
E 4
I 4
      x = ntend
D 5
      end = nplmax(index)
E 5
I 5
      end = nplmax(index) + 5
E 5
E 4
E 3
      while (x > end)  {
	 x = x - axinc
	 nmajor = nmajor - 1
	 }

E 2
      dtminr = axinc/nminor
      call gpgntc (index, axstrt, 2)   # major tic
      call gptclb (index, axstrt, value)
D 2
      do i=1, nmajor {         # Output labels and tics for axis
E 2
I 2
      for (i=1; i<=nmajor; i=i+1)  {  # Output labels and tics for axis
E 2
         x = axstrt + dtminr
         ktic = 1             # minor tics
         do j=1, nminor {
            if (j == nminor) ktic = 2      # major tic
            call gpgntc (index, x, ktic)
            x = x + dtminr
            }
         axstrt = axstrt + axinc
         value = value + zlincr
 
         if (nperid != 0)
            if (value > zpend) value = 1.0 # Reset to start
 
         call gptclb (index, axstrt, value)
         }
      }
   naxsts(index) = 1    # Inform system that this axis has been output
 
   return
end
E 1
