h30813
s 00000/00001/00125
d D 1.2 83/01/28 13:47:44 tes 2 1
c initial_internal_update
e
s 00126/00000/00000
d D 1.1 83/01/28 13:00:58 tes 1 0
c date and time created 83/01/28 13:00:58 by tes
e
u
tes
mjb
mrk
mmm
U
t
T
I 1
subroutine gkopdv (wkid)
########################################################################
#                                                                      #
#          THIS MATERIAL IS CONFIDENTIAL AND IS FURNISHED UNDER        #
#          A WRITTEN LICENSE AGREEMENT.  IT MAY NOT BE USED,           #
#          COPIED OR DISCLOSED TO OTHERS EXCEPT IN ACCORDANCE          #
#          WITH THE TERMS OF THAT AGREEMENT.                           #
#                                                                      #
#          COPYRIGHT (C) 1982 GRAPHIC SOFTWARE SYSTEMS INC.            #
#          ALL RIGHTS RESERVED.                                        #
#                                                                      #
#     Function: Initialize the graphic system for the current device   #
#                                                                      #
#     Input Parameters:                                                #
#            wkid    -  workstation identifier                         #
#                                                                      #
#      Output Parameters:                                              #
#            none                                                      #
#                                                                      #
#     Errors:                                                          #
#                                                                      #
#     Routines Called:                                                 #
#            gzddop - device independent device interface              #
#            gpclr  - clear the display surface                        #
#                                                                      #
########################################################################
integer wkid

integer i, numgdp, contrl(5), opcd, intin(10), ptsin(2), intout(45), ptsout(12)

integer nwkid, nlntyp, nplclr, nmrtyp, npmclr,
	ntfnt, ntclr, nfaint, nfasty, nfaclr 
	
include(`pltcom')

# The following equivalence statements are used to decrease the amount of code
#    necessary to access specific array elements. The arrays and the
#    variables equivalenced are listed below:
#
#       contrl(OPCODE) :: opcd
#
#       intin(1) :: nwkid
#       intin(2) :: nlntyp
#       intin(3) :: nplclr
#       intin(4) :: nmrtyp
#       intin(5) :: npmclr
#       intin(6) :: ntfnt
#       intin(7) :: ntclr
#       intin(8) :: nfaint
#       intin(9):: nfasty
#       intin(10):: nfaclr
#
 
equivalence (contrl(OPCODE), opcd), (intin(1), nwkid),
	    (intin(2), nlntyp), (intin(3), nplclr),
	    (intin(4), nmrtyp), (intin(5), npmclr), 
            (intin(6), ntfnt), (intin(7), ntclr),
            (intin(8), nfaint), (intin(9), nfasty),
            (intin(10), nfaclr)

   #    intin(1) = nwkid
   #    intin(2) = lntyp
   #    intin(3) = plclr
   #    intin(4) = mktyp
   #    intin(5) = pmclr
   #    intin(6) = txfnt
   #    intin(7) = txclr
   #    intin(8) = faint
   #    intin(9)= fasty
   #    intin(10)= faclr

   nwkid  = wkid
   nlntyp = nlstyl
   nplclr = nlcolr
   nmrtyp = nmstyl
   npmclr = nmcolr
   ntfnt = 1
   ntclr = 1
   nfaint = 0
   nfasty = 0
   nfaclr = 1

   #   contrl(OPCODE) = OPENxWORKSTATION  
   opcd = OPENxWORKSTATION
   contrl(VERTICESxIN) = 0
   contrl(INTEGERxINxLENGTH) = 10

   call gzddop (contrl, intin, ptsin, intout, ptsout)

   nxrast = intout(1)   # set the device width in rasters
   nyrast = intout(2)   # set the device height in rasters

   # Save the absolute pixel size
   npxlx = intout(4)
   npxly = intout(5)
  
   # set raster width
   zpxlx = 1./float(nxrast)
   zpxly = 1./float(nyrast)

   # set the viewing area transform components
   xvwmin = 0.0
   yvwmin = 0.0
   xvwlng = 32767.0
   yvwlng = 32767.0

D 2
   nhatch = intout(13)   # set number of hatch styles
E 2
   ntxtrt = intout(37)   # set text rotation capability flag
   nfill = intout(38)   # set fill area capability flag

   numgdp = intout(15)
   for (i=1;i<=numgdp;i=i+1)   {  # Scan the gdp list looking for bars
      if (intout(i+15) == BAR) nbarcp = YES
      }
   
   #  contrl(OPCODE) = SETxPOLYMARKERxSCALE
   opcd = SETxPOLYMARKERxSCALE
   contrl(VERTICESxIN) = 1
   ptsin(1) = 0
   ptsin(2) = 327   # Make the size 1/100 of y axis
   call gzddop (contrl, intin, ptsin, intout, ptsout)

   call gpclr          # Clear the display surface

   return
end
E 1
