h08267
s 00005/00006/00062
d D 1.2 83/01/28 13:46:49 tes 2 1
c initial_internal_update
e
s 00068/00000/00000
d D 1.1 83/01/28 13:00:49 tes 1 0
c date and time created 83/01/28 13:00:49 by tes
e
u
tes
mjb
mrk
mmm
U
t
T
I 1
subroutine errbar (count, xdata, ydata, plus, minus, color)
########################################################################
#                                                                      #
#          THIS MATERIAL IS CONFIDENTIAL AND IS FURNISHED UNDER        #
#          A WRITTEN LICENSE AGREEMENT.  IT MAY NOT BE USED,           #
#          COPIED OR DISCLOSED TO OTHERS EXCEPT IN ACCORDANCE          #
#          WITH THE TERMS OF THAT AGREEMENT.                           #
#                                                                      #
#          COPYRIGHT (C) 1982 GRAPHIC SOFTWARE SYSTEMS INC.            #
#          ALL RIGHTS RESERVED.                                        #
#                                                                      #
#     Function: Displays an error bar for each point for a             #
#               line graph or scatter chart                            #
#                                                                      #
#     Input Parameters:                                                #
#            color - color index for error bars                        #
#                                                                      #
#     Output Parameters:                                               #
#            none                                                      #
#                                                                      #
#     Routines Called:                                                 #
#        gpisrf - intialise the plot environment for the data set      #
#        gpxfrm - transform data from user units to plot area units    #
#        imove  - modify the current position for latter action        #
#        gpdraw - do a 2d draw                                         #
#        gpsatt - Change an attribute on the current device            #
#                                                                      #
########################################################################
integer count, color
real xdata(1), ydata(1), plus(1), minus(1)

integer j, iout
D 2
real tmpy, x, yp, ym
PLOTxREALS PLOTxGETREAL
E 2
I 2
real tmpy, x, yp, ym, gtreal 
E 2

include(`pltcom')

   zxleft = zplmin(1)   # Clip to axis extents
   zybotm = zplmin(2)
   zxrght = zplmax(1)
   zytop = zplmax(2)
   nclip = YES

   call gpisrf (count, xdata, ydata)  # Set up the axis properly

   # Set up the environment
 
   call gpsatt (SETxPOLYLINExCOLORxINDEX, color, iout) # Set line color

   call gpsatt (SETxPOLYLINExLINETYPE, 1, iout)
 
   do j=1, count {
D 2
      tmpy = PLOTxGETREAL(ydata(j))
      call gpxfrm (1, PLOTxGETREAL(xdata(j)), x)
      call gpxfrm (2, tmpy+PLOTxGETREAL(plus(j)), yp)
      call gpxfrm (2, tmpy+PLOTxGETREAL(minus(j)), ym)
E 2
I 2
      tmpy = gtreal (ydata, j-1)
      call gpxfrm (1, gtreal (xdata, j-1), x)
      call gpxfrm (2, tmpy+gtreal (plus, j-1), yp)
      call gpxfrm (2, tmpy+gtreal (minus, j-1), ym)
E 2
      call imove (ABSOLUTE, x, ym)
      call gpdraw (x, yp)
      }

   zxrght = 1.0   # Reset clipping edge to full screen
   zxleft = 0.0
   zytop = 1.0
   zybotm = 0.0
   nclip = NO   # Turn off clipping

   return
end
E 1
