h09305
s 00000/00000/00104
d D 1.2 83/03/31 12:47:09 mmm 2 1
c 
e
s 00104/00000/00000
d D 1.1 83/03/15 21:46:32 tes 1 0
c date and time created 83/03/15 21:46:32 by tes
e
u
4
U
t
T
I 1
subroutine gzwktn
########################################################################
#                                                                      #
#          THIS MATERIAL IS CONFIDENTIAL AND IS FURNISHED UNDER        #
#          A WRITTEN LICENSE AGREEMENT.  IT MAY NOT BE USED,           #
#          COPIED OR DISCLOSED TO OTHERS EXCEPT IN ACCORDANCE          #
#          WITH THE TERMS OF THAT AGREEMENT.                           #
#                                                                      #
#          COPYRIGHT (C) 1982 GRAPHIC SOFTWARE SYSTEMS INC.            #
#          ALL RIGHTS RESERVED.                                        #
#                                                                      #
#     Function: calculate the workstation transform                    #
#                                                                      #
#     Input Parameters:                                                #
#            none                                                      #
#     Output Parameters:                                               #
#            none                                                      #
#                                                                      #
#     Routines Called:                                                 #
#            gzcpmt - copy a square matrix                             #
#            gzdtrm - calculate determinant of a matrix                #
#            gzinvs - calculate the inverse of a matrix                #
#            gzmtid - set a matrix to identity                         #
#            gzcale - calculate and set the current clipping edge      #
#                                                                      #
########################################################################
integer k3
real gzdtrm,
     tmat1(3,3), mat11, mat22, mat31, mat32, wrkvw1, wrkvw2, 
     wrkvw3, wrkvw4, wrkvew(4), xratio, yratio, xwnext, ywnext
 
include(`gkscom')
 
# The following equivalence statements are used to decrease the amount of code
#    necessary to access specific array elements. The arrays and the
#    variables equivalenced are listed below:
#
#       tmat1(1,1) :: mat11
#       tmat1(2,2) :: mat22
#       tmat1(3,1) :: mat31
#       tmat1(3,2) :: mat32
#       wrkvew(1)  :: wrkvw1
#       wrkvew(2)  :: wrkvw2
#       wrkvew(3)  :: wrkvw3
#       wrkvew(4)  :: wrkvw4
 
equivalence (tmat1(1,1), mat11), (tmat1(2,2), mat22),
            (tmat1(3,1), mat31), (tmat1(3,2), mat32),
	    (wrkvew(1), wrkvw1), (wrkvew(2), wrkvw2),
	    (wrkvew(3), wrkvw3), (wrkvew(4), wrkvw4)
 
   nwkvw = 0

   # Calculate the viewport to window aspect ratios in both x and y

   xwnext = cwrkwn(2)-cwrkwn(1) # workstation window x extent
   ywnext = cwrkwn(4)-cwrkwn(3) # workstation window y extent

   xratio = (cwrkvw(2)-cwrkvw(1)) / xwnext
   yratio = (cwrkvw(4)-cwrkvw(3)) / ywnext

   # If y ratio less than xratio use to calculate max extents
   # else use x ratio
   if (yratio <= xratio) {
      wrkvw2 = (xwnext*yratio) + cwrkvw(1)
      wrkvw4 = (ywnext*yratio) + cwrkvw(3)
      }
   else {
      wrkvw2 = (xwnext*xratio) + cwrkvw(1)
      wrkvw4 = (ywnext*xratio) + cwrkvw(3)
      }

   # Set up NDC workstation viewport 

   # Convert current workstation viewport (DC) to 32k space
   wrkvw1 = cwrkvw(1)/(float(mxdsdc(1))+1.0) * 32768.0
   wrkvw2 = wrkvw2/(float(mxdsdc(1))+1.0) * 32768.0
   wrkvw3 = cwrkvw(3)/(float(mxdsdc(2))+1.0) * 32768.0
   wrkvw4 = wrkvw4/(float(mxdsdc(2))+1.0) * 32768.0

   k3 = 3
   call gzmtid (tmat1)

   #   tmat1(1,1) = (wrkvew(2)-wrkvew(1))/(cwrkwn(2)-cwrkwn(1))
   mat11 = (wrkvw2-wrkvw1) / xwnext
 
   #   tmat1(2,2) = (wrkvew(4)-wrkvew(3))/(cwrkwn(4)-cwrkwn(3))
   mat22 = (wrkvw4-wrkvw3) / ywnext
 
   #   tmat1(3,1) = wrkvew(1) - tmat1(1,1)*cwrkwn(1)
   mat31 = wrkvw1 - tmat1(1,1)*cwrkwn(1)
 
   #  tmat1(3,2) = wrkvew(3) - tmat1(2,2)*cwrkwn(3)
   mat32 = wrkvw3 - tmat1(2,2)*cwrkwn(3)
 
   if (abs(gzdtrm (tmat1)) >= zeps15) {
      call gzcpmt (tmat1, wkview)
      call gzinvs (wkview, rwview)
      }

   call gzcale

   return
end
E 1
