h04833
s 00007/00008/00219
d D 1.2 83/03/31 12:44:30 mmm 2 1
c 
e
s 00227/00000/00000
d D 1.1 83/03/15 21:44:15 tes 1 0
c date and time created 83/03/15 21:44:15 by tes
e
u
4
U
t
T
I 1
subroutine gtx (x0, y0, l, lstr, chars)
########################################################################
#                                                                      #
#          THIS MATERIAL IS CONFIDENTIAL AND IS FURNISHED UNDER        #
#          A WRITTEN LICENSE AGREEMENT.  IT MAY NOT BE USED,           #
#          COPIED OR DISCLOSED TO OTHERS EXCEPT IN ACCORDANCE          #
#          WITH THE TERMS OF THAT AGREEMENT.                           #
#                                                                      #
#          COPYRIGHT (C) 1982 GRAPHIC SOFTWARE SYSTEMS INC.            #
#          ALL RIGHTS RESERVED.                                        #
#                                                                      #
#     Function: Output text at specified position                      #
#                                                                      #
#     Input Parameters:                                                #
#            x0 - x coordinate of starting position                    #
#            y0 - y coordinate of starting position                    #
#            l  - dimension of array 'chars'                           #
#            lstr - number of characters to output                     #
#            chars(l) - string of ADE characters                       #
#      Output Parameters:                                              #
#            none                                                      #
#                                                                      #
#      Errors:                                                         #
#                                                                      #
#     Errors:                                                          #
#        5 GKS not in proper state: GKS must be either in the state    #
#          WSAC or in the state SGOP                                   #
#      101 Invalid code in string                                      #
#                                                                      #
#     Routines Called:                                                 #
#            errchk - perform appropriate error checking               #
#            gztxtn - calculate current text size                      #
#            gztxcp - text clipping routine                            #
#            gzndcd - convert from NDC to DC                           #
#            gzwndc - transform point front 2D world to NDC space      #
#            gzddop - call current device driver                       #
#            gkserr - KERNEL error reporter                            #
#                                                                      #
########################################################################
real x0, y0
integer l, lstr, chars(l)
 
integer contrl(5), opcd, vertin, intlen, ptsin(2), ptsin1, ptsin2, 
D 2
	idummy(1), errind, i, kout, kstart, kend, kount,
E 2
I 2
	idummy(1), errtxe, i, kout, kstart, kend, kount,
E 2
	dxdc, dydc, ksavx, ksavy, start1, start2, stop1, stop2

ifdef(`ERROR_ON',`
   integer errchk, errind, ierdum(1)
   ')

real cjx, cjy, delta, x, y, dx, dy, dxn, dyn, tx0, ty0,
     xoff, yoff, temp1, temp2, xend, yend, xorig,
D 2
     yorig, rdummy(4), line1(4), line2(4)
REALS GETREAL
E 2
I 2
     yorig, rdummy(4), line1(4), line2(4), gtreal 
E 2

include(`gkscom')

# The following equivalences are done in order to reduce code size

   equivalence (contrl(OPCODE), opcd), (contrl(VERTICESxIN), vertin),
	       (contrl(INTEGERxINxLENGTH), intlen),
	       (ptsin(1), ptsin1), (ptsin(2), ptsin2)

ifdef(`ERROR_ON',`
      rounum = GTX
      errind = errchk(wrkid, ierdum)
      ')

   kount = 0
   for (i=1; i<=lstr; i=i+1) {  # check for non-printable characters      
      if (chars(i) >= BLANK & chars(i) <= TILDE) kount = kount + 1
      }

   ifdef(`ERROR_ON',`
      if (kount < lstr) call gkserr (101)
      ')
 
   # update character size if viewing transform has changed
   if (ntext == 1) {
      call gztxtn (chrhgt)
      ntext = 0
      }

   if (kount > 0 ) {
 
D 2
      tx0 = GETREAL(x0)  # convert user format real to R format
      ty0 = GETREAL(y0)
E 2
I 2
      tx0 = gtreal (x0, 0)  # convert user format real to R format
      ty0 = gtreal (y0, 0)
E 2
               
	       # Find extent of string with this ridiculous call
D 2
      call gitxex (wrkid,x0,y0,l,kount,chars,errind,xend,yend,rdummy)
      xoff = GETREAL(xend)-tx0
      yoff = GETREAL(yend)-ty0
E 2
I 2
      call gitxex (wrkid,x0,y0,l,kount,chars,errtxe,xend,yend,rdummy)
      xoff = gtreal (xend, 0)-tx0
      yoff = gtreal (yend, 0)-ty0
E 2
      dx = xoff/kount    #determine the x and y deltas for one character
      dy = yoff/kount

      # Set text baseline depending upon precision
      temp1 = normdy
      temp2 = normdx
      if (txpre == CHARACTERxPRECISION) { # Use user specified values
	 temp1 = unrmdy
	 temp2 = unrmdx
	 }

      temp1 = curhgt*temp1*xywasp
      temp2 = curhgt*temp2
 
      if (txpre == STRINGxPRECISION & txrot == NO) {
         dx = curwdt 
         dy = 0.0
         }
      if (txpre == CHARACTERxPRECISION & txrot == NO) {
	 dy = dy * curhgt/curwdt * xywasp
	 }

      # x,y is the lower left corner of the first character cell. We adjust
      #   the position according to the specified text justification, 
      #        txtjh - horizontal:
      #                   0=left, 1=center, 2=right
      #        txtjv - vertical:
      #                   0=top, 1=CAP, 2=center, 3=base, 4=bottom
      cjx = .5*txtjh 
      cjy = 1. - .5*(float((2*txtjv)/3)) 
 
      x = (tx0 + cjy*temp1) - cjx*xoff
      y = (ty0 - cjy*temp2) - cjx*yoff
      
      # Text Clipping is done by clipping the rectangle which encloses the  
      #   text string. We use the base line and Caps line to clip against.
      #   If any portion of either line is clipped the character is 
      #   considered clipped.
 
      # Define two (2) lines: 1) define the lower extention of the text
      #    string and 2) the upper extention of the text string
      line1(1) = x
      line1(2) = y
      line1(3) = x + kount*dx
      line1(4) = y + kount*dy
      line2(1) = x - temp1
      line2(2) = y + temp2
      line2(3) = line2(1) + kount*dx
      line2(4) = line2(2) + kount*dy

      # 'delta' is the distance along the base line of one (1) character
      delta = sqrt(dx*dx + dy*dy)
      
      # initialize the end of the string variables to the full character
      #    string length
      stop1 = kount
      stop2 = kount

      # Clip each the string base line and the cap line and then determine
      #    where in the string to start and end output
      call gztxcp (line1, delta, start1, stop1)
      call gztxcp (line2, delta, start2, stop2)

      # if start1 and start2 are greater than 0, then there is at least one
      #    character to be output
      if ((start1 > 0) & (start2 > 0)) {
	
	 # determine the extents of the string to be output
	 kstart = max0 (start1, start2)
	 kend = min0 (stop1, stop2)
        
	 # determine the total string length to be output
	 kout = (kend - kstart) + 1
	
	 # calculate the position of the first character to be output
	 x = x + (kstart-1)*dx
	 y = y + (kstart-1)*dy
	 call gzwndc (x, y, temp1, temp2)
	 call gzndcd (temp1, temp2, x, y)
	 ksavx = x
	 ksavy = y
	
	 # calculate the delta 'x' and delta 'y' for each character in
	 #   device coordinates
	 call gzwndc (0.0, 0.0, temp1, temp2)
	 call gzndcd (temp1, temp2, xorig, yorig)
	 call gzwndc (dx, dy, temp1, temp2)
	 call gzndcd (temp1, temp2, dxn, dyn)
	 dxdc = dxn - xorig
	 dydc = dyn - yorig
	 }
      else {
	 kout = 0
	 }

      if (kout > 0) {
         # Set the string length for CHARxPRECISION initially, then if STRING
         #    is being used adjust the loop control parameter KOUT so we loop
         #    only once.
 
         # contrl(OPCODE) = TEXT
	 opcd = TEXT
	 # contrl(VERTICESxIN) = 1
	 vertin = 1
         # contrl(INTEGERxINxLENGTH) = 1
	 intlen = 1
         if (txpre == STRINGxPRECISION) {
             # contrl(INTEGERxINxLENGTH) = kout
	     intlen = kout
             kend = kstart
             }
 
	 # ptsin(i) = point to output text out
         ptsin1 = ksavx    
	 ptsin2 = ksavy
         
	 # Output the text string begining with the KSTART character in the
         #    string and ending with KEND.
         for (i=kstart; i<=kend; i=i+1) {
	    
	    # Output the character or string
	    call gzddop (contrl, chars(i), ptsin, idummy, idummy)
            
	    # Increment the character position to the next position
	    ptsin1 = ptsin1 + dxdc
            ptsin2 = ptsin2 + dydc
            }

         # Set screen erase flag to erase
	 eraflg = YES
         }
     }
 
   return
end
E 1
