h27884
s 00003/00003/00078
d D 1.2 83/03/31 12:32:12 mmm 2 1
c 
e
s 00081/00000/00000
d D 1.1 83/03/15 21:38:28 tes 1 0
c date and time created 83/03/15 21:38:28 by tes
e
u
4
U
t
T
I 1
subroutine giplf (wktype,errind,npli,rpli)
########################################################################
#                                                                      #
#          THIS MATERIAL IS CONFIDENTIAL AND IS FURNISHED UNDER        #
#          A WRITTEN LICENSE AGREEMENT.  IT MAY NOT BE USED,           #
#          COPIED OR DISCLOSED TO OTHERS EXCEPT IN ACCORDANCE          #
#          WITH THE TERMS OF THAT AGREEMENT.                           #
#                                                                      #
#          COPYRIGHT (C) 1982 GRAPHIC SOFTWARE SYSTEMS INC.            #
#          ALL RIGHTS RESERVED.                                        #
#                                                                      #
#     Function: Inquire polyline facilities                            #
#                                                                      #
#     Input Parameters:                                                #
#            wktype - workstation type                                 #
#     Output Parameters:                                               #
#            errind - error indicator                                  #
#            npli(1)- number of available line types                   #
#            npli(2)- number of available line widths                  #
#            rpli(1)- nominal line width                               #
#            rpli(2)- minimum line width                               #
#            rpli(3)- maximum line width                               #
#                                                                      #
#     Errors:                                                          #
#            7  GKS not in proper state: GKS must be in one of the     #
#               states WSOP, WSAC, or SGOP                             #
#           22  Specified workstation type is invalid                  #
#           23  Specified workstation does not exist                   #
#           37  Specified workstation is neither an output             #
#               station nor an output/input workstation                #
#                                                                      #
#     Routines Called:                                                 #
#            errchk - perform appropriate error checking               #
#                                                                      #
########################################################################
integer  wktype, errind, npli(2)
real rpli(3)

real trpl1, trpl2, trpl3, rtemp

ifdef(`ERROR_ON',`
   integer errchk, ierdum, ierary(1), erary1
   ')

include(`gkscom')

ifdef(`ERROR_ON',`
   equivalence (ierary(1), erary1)
   ')
 
   # In all inquiry routines, initialize errind to 0 (zero).
   errind = 0
   ifdef(`ERROR_ON',`
      rounum = GIPLF
      #   ierary(1) = wktype
      erary1 = wktype
      errind = errchk(ierdum, ierary)
      if (errind !=  0) return
      ')
   
   npli(1) = nlntyp  # Get values from common
   npli(2) = nlnwdt

   rtemp = (float(mxdsdc(1))+1.0) / 32768.0
   trpl1 = float(mnlnwd) * rtemp 
   trpl2 = trpl1 
   trpl3 = float(mxlnwd) * rtemp 
   if (trpl1 <= 0.0) trpl1 = 1.0  # Check for continous device

   if (devcor == METERS) {
      trpl1 = trpl1 * sptszx
      trpl2 = trpl2 * sptszx
      trpl3 = trpl3 * sptszx
      }

D 2
   PUTREAL(trpl1, rpli(1))  # Put back into user format reals
   PUTREAL(trpl2, rpli(2))
   PUTREAL(trpl3, rpli(3))
E 2
I 2
   call ptreal (trpl1, 0, rpli)  # Put back into user format reals
   call ptreal (trpl2, 1, rpli)
   call ptreal (trpl3, 2, rpli)
E 2

 return
end
E 1
