h08028
s 00005/00005/00058
d D 1.2 83/03/31 12:31:05 mmm 2 1
c 
e
s 00063/00000/00000
d D 1.1 83/03/15 21:37:22 tes 1 0
c date and time created 83/03/15 21:37:22 by tes
e
u
4
U
t
T
I 1
subroutine gicspa (errind, ia, pa)
########################################################################
#                                                                      #
#          THIS MATERIAL IS CONFIDENTIAL AND IS FURNISHED UNDER        #
#          A WRITTEN LICENSE AGREEMENT.  IT MAY NOT BE USED,           #
#          COPIED OR DISCLOSED TO OTHERS EXCEPT IN ACCORDANCE          #
#          WITH THE TERMS OF THAT AGREEMENT.                           #
#                                                                      #
#          COPYRIGHT (C) 1982 GRAPHIC SOFTWARE SYSTEMS INC.            #
#          ALL RIGHTS RESERVED.                                        #
#                                                                      #
#     Function: Inquire current setting of primitive attributes        #
#                                                                      #
#     Input Parameters:                                                #
#            none                                                      #
#     Output Parameters:                                               #
#            errind - error indicator                                  #
#            ia     - integer array of current setting of primitives   #
#                     current horizontal character alignment           #
#                     current vertical character alignment             #
#            pa     - real array of current setting of primitives      #
#                     current character height                         #
#                     current character up vector (2)                  #
#                                                                      #
#     Errors:                                                          #
#            8  GKS not in proper state: GKS must be in one of the     #
#               states GKOP, WSOP, WSAC, or SGOP                       #
#                                                                      #
#     Routines Called:                                                 #
#            errchk - perform appropriate error checking               #
#                                                                      #
########################################################################
integer errind, ia(2)
real pa(3)
 
ifdef(`ERROR_ON',`
   integer errchk, ierdum(1)
   ')

include(`gkscom')

   # In all inquiry routines, initialize errind to 0 (zero).
   errind = 0

   ifdef(`ERROR_ON',`
      rounum = GICSPA
      errind = errchk(ierdum(1), ierdum)
      if (errind != 0) return
      ')

   ia(1) = txtjh   # current horizontal character alignment   
   ia(2) = txtjv   # current vertical character alignment     
D 2
   PUTREAL(chrhgt,pa(1))   # Current character height
   PUTREAL(chrupx,pa(2))   # Current character up vector
   PUTREAL(chrupy,pa(3))                                   
E 2
I 2
   call ptreal (chrhgt, 0, pa)   # Current character height
   call ptreal (chrupx, 1, pa)   # Current character up vector
   call ptreal (chrupy, 2, pa)                                   
E 2

   if (txpre == STRINGxPRECISION) {
D 2
      PUTREAL(actupx,pa(2))    # Actual character up vector
      PUTREAL(actupy,pa(3))
E 2
I 2
      call ptreal (actupx, 1, pa)    # Actual character up vector
      call ptreal (actupy, 2, pa)
E 2
      }
	  
   return
end
E 1
