h11146
s 00004/00003/00204
d D 1.13 83/03/09 14:09:46 mjb 13 12
c 
e
s 00000/00000/00207
d D 1.12 83/03/09 01:22:54 mjb 12 11
c 
e
s 00001/00001/00206
d D 1.11 83/03/06 20:37:46 mjb 11 10
c 
e
s 00001/00001/00206
d D 1.10 83/03/04 14:16:31 mjb 10 9
c 
e
s 00002/00002/00205
d D 1.9 83/03/03 23:40:06 mjb 9 8
c changed interface to ingmem and inpmem
e
s 00001/00001/00206
d D 1.8 83/03/02 18:45:06 mjb 8 7
c put in switch ttyin calls
e
s 00045/00001/00162
d D 1.7 83/02/16 16:40:03 tes 7 6
c fixed data field blanking problem when redisplaying
e
s 00036/00011/00127
d D 1.6 83/02/16 11:19:08 tes 6 5
c fixed annotate buffer conflict, initialization/reading diff conflict
e
s 00002/00002/00136
d D 1.5 83/02/15 11:18:40 mjb 5 4
c integer'ed item in declaration
e
s 00005/00006/00133
d D 1.4 83/02/07 12:07:55 mjb 4 3
c fixed problem with initializing curve types
e
s 00002/00002/00137
d D 1.3 83/02/03 00:51:09 tes 3 2
c modified apdata interface to include last item to display
e
s 00006/00008/00133
d D 1.2 83/02/02 19:31:15 tes 2 1
c fixed error of looping on no file defined
e
s 00141/00000/00000
d D 1.1 83/02/02 11:14:09 tes 1 0
c date and time created 83/02/02 11:14:09 by tes
e
u
tes
mjb
U
t
T
I 1
D 4
subroutine rddif (rowcol, type)
E 4
I 4
subroutine rddif (rowcol)
E 4
########################################################################
#                                                                      #
#          THIS MATERIAL IS CONFIDENTIAL AND IS FURNISHED UNDER        #
#          A WRITTEN LICENSE AGREEMENT.  IT MAY NOT BE USED,           #
#          COPIED OR DISCLOSED TO OTHERS EXCEPT IN ACCORDANCE          #
#          WITH THE TERMS OF THAT AGREEMENT.                           #
#                                                                      #
#          COPYRIGHT (C) 1982 GRAPHIC SOFTWARE SYSTEMS INC.            #
#          ALL RIGHTS RESERVED.                                        #
#                                                                      #
#     Function: Read a SUPERCALC/VISICALC DIF data file                #
#                                                                      #
#     Input Parameters:                                                #
#            rowcol - row/column format flag, 1=row, 2=column          #
#                                                                      #
#     Output Parameters:                                               #
#            None                                                      #
#                                                                      #
#     Routines Called:                                                 #
#            None                                                      #
#                                                                      #
########################################################################
D 4
integer rowcol, type
E 4
I 4
integer rowcol
E 4

D 5
SHORTINT buf1(80), buf2(80), column, dtalng, eot, eotstr(2), item, key,
E 5
I 5
SHORTINT buf1(80), buf2(80), column, dtalng, eot, eotstr(2), key,
E 5
D 7
	 maxcol, valstr(2)
E 7
I 7
	 maxcol, valstr(2), undrbr(11)
E 7
D 5
integer fildes, iclear, iptr
E 5
I 5
integer fildes, iclear, iptr, item
E 5

integer i, done, difptr, difknt, savsec, savoff
integer gdclos, gdseek

integer floc(2), fbfknt

include(`gphcom')

common /mnuiob/ floc, fbfknt

data iclear /YES/
data eotstr /MINUS, DIG1/
data valstr /DIG0, COMMA/
I 7
data undrbr /10*UNDERLINE,NUL/
E 7

done = -1
D 6
fildes = 0
E 6
column = 0
I 6

# initialize the appropriate common areas...we must insure that the annotate
# buffer is reinitialized because it is used as a buffer for the input
# file.
if (bctype != PIE) {
   maxcol = 5
   dtalng = 75
D 9
   call ingmem 
E 9
I 9
   call ingmem (YES)
E 9
   }
else {
   maxcol = 1
D 13
   dtalng = 15
E 13
I 13
   dtalng = 16
E 13
D 9
   call inpmem
E 9
I 9
   call inpmem (YES)
E 9
   }

# prompt, open and position the input DIF file
E 6
call opndif (fildes)
I 6

# process the file only if we were successful in opening the file
E 6
if (fildes > 0) {
I 6

   # save the current position so that we can rewind to this position when
   # processing the file as columns. In this case we must scan the file
   # multiple times.
E 6
   savsec = fbfknt/128
   savoff = fbfknt - savsec*128
D 4
   if (type != PIE) {
E 4
I 4
D 6
   if (bctype != PIE) {
E 4
      maxcol = 5
      dtalng = 75
D 4
      call ingmem (type)
      if (type > TEXT) type = BAR
E 4
I 4
      call ingmem 
E 4
      }
   else {
      maxcol = 1
      dtalng = 15
      call inpmem
      }
E 6
D 2
   }
E 2

D 2
difptr = 1
E 2
I 2
   difptr = 1
I 3
   call apmenu (KEEPxDATA, iclear)
E 3
E 2

D 2
repeat {
E 2
I 2
   repeat {
E 2

I 6
      # loop until one set of data is obtained. This might be one "tuple" if
      # we are processing the file as rows or skipping through the "tuples"
      # and retaining one value per "tuple"

E 6
D 2
   item = 0
   if (fildes > 0) {
E 2
I 2
      item = 0
E 2
D 3
      call apmenu (KEEPxDATA, iclear)
E 3
      eot = 0        # initialize end of tuple flag
      difknt = 0
      while (eot == 0) {
	 difknt = difknt + 1
         call nxtcmd (fildes, buf1, NEWLINE)
         call nxtcmd (fildes, buf2, NEWLINE)

I 7
	 # check for end of file, buf(1) = 0
E 7
         if (buf1(1) == NUL) {
I 7

	    # if we are looking at rows of data, we are done
E 7
D 13
	    if (rowcol == 1) return
E 13
I 13
	    if (rowcol == 1) break 2
E 13
	    else {
I 7

	       # otherwise we have to rewind to the beginning of the data
	       # and look at the next set of data elements after we display
	       # the current set of data
E 7
	       difptr = difptr + 1
	       i = gdseek (fildes, savsec, savoff)
	       floc(1) = -1
	       break
	       }
	    }

I 7
         # check for a value, a value is defined as:
	 #      0,<data value>
	 #      V
	 # anything else is considered not a value
E 7
	 if ((buf1(1) == valstr(1) & buf1(2) == valstr(2)) &
	     (buf2(1) == BIGV)) {
I 7

	    # a value has been found, if we are scanning by row this is another
	    # value to be displayed. If we are scanning by column, we must 
	    # determine if this is the value from this "tuple" that we want
	    # ie. the Nth value in the tuple.
E 7
	    if ((rowcol == 1) | ((rowcol == 2) & (difknt == difptr))) {
I 7

	       # put the data value in the output buffer, we first blank
	       # the area to insure previous data is gone
E 7
	       item = item + 1
I 7
	       call qputa (item, undrbr)
E 7
	       call qputa (item, buf1(3))
	       }
	    }
I 7
	 
	 # check for an "end of tuple" string. This string looks like
	 #       -1,0
	 #       EOD
E 7
	 else if (buf1(1) == eotstr(1) & buf1(2) == eotstr(2)) {
I 7

	    # if we're doing rows, we're done
E 7
	    if (rowcol == 1) break
	    else {
I 7
	       
	       # if we're doing columns we're done if the tuple count (difknt)
	       # is the same as the number of tuples (difptr)
E 7
	       if (difknt == difptr) return
	       difknt = 0
	       }
	    }
	 else {
I 7

	    # otherwise if doing rows blank current data area, or if by column
	    # and this is the correct element of the tuple, blank out the data
	    # area....This was a non-numeric data item
E 7
	    if ((rowcol == 1) | ((rowcol == 2) & (difknt == difptr))) {
	       item = item + 1
I 7
	       call qputa (item, undrbr)
E 7
	       }
	    }
         } 
I 6
      
      # appear the data just read so that the user can determine if they want
      # to retain it
E 6
D 3
      call apdata (1)
E 3
I 3
      call apdata (1, item)
E 3

      repeat {
I 6

	 # ask the user if they want the data. If they do, process it and
	 # place it in the appropriate common area
E 6
D 8
         call getkey (key)
E 8
I 8
D 10
         ifdef(`UNIX',`call gdevin (key)',`call ttyin (key)')
E 10
I 10
D 11
         call gtty (key)
E 11
I 11
         call ttyin (key)
E 11
E 10
E 8
I 7

	 # upcase the user's answer
E 7
	 if (key > BIGZ) key = key - BLANK
	 if (key == BIGY) {
I 7

	    # the user wants this set of data, move the data from the display
	    # buffer to the common storage area
E 7
	    column = column + 1
	    iptr = (column-1)*375 + 1
	    do i=1, dtalng {
	       call qgeta (i, buf1)
	       if (buf1(1) != NUL) {
D 4
		  if (type != PIE) {
E 4
I 4
		  if (bctype != PIE) {
I 7

		     # place this data in the chart common area (line, bar..)
E 7
E 4
		     call qgetd (i, bgdta1(iptr))
		     bgddef(column) = bgddef(column) + 1
		     }
		  else {
I 7

		     # place this data in the pie chart common area
E 7
		     call qgetd (i, bpdata(iptr))
		     bpddef = bpddef + 1
		     }
	          iptr = iptr + 5
		  }
	       }
	    break
	    }
	 else if (key == BIGN) {
	    break
	    }
	 }
D 2
      }
   } until (column >= maxcol)
E 2
I 2
      } until (column >= maxcol)
   i = gdclos (fildes)
I 6

E 6
   }
E 2

I 6
# insure that the annotate buffer is initialized. We use the annontate buffer
# as an input buffer for the DIF file.
D 13
call inamem
E 13
I 13
do i=1, 1000
   anobuf(i) = NUL
E 13
E 6
D 2
i = gdclos (fildes)
E 2

return
end
E 1
