h21046
s 00029/00018/00066
d D 1.4 83/03/30 22:43:15 mjb 4 3
c changed clipping 
e
s 00036/00031/00048
d D 1.3 83/02/17 15:05:42 tes 3 2
c added hershey text clipping for annotation menu display
e
s 00001/00001/00078
d D 1.2 83/01/29 14:30:53 mjb 2 1
c made changes to anocom, included in gphcom
e
s 00079/00000/00000
d D 1.1 83/01/24 18:03:26 tes 1 0
c date and time created 83/01/24 18:03:26 by tes
e
u
tes
mjb
U
t
T
I 1
subroutine qgtext (x, y, string)
########################################################################
#                                                                      #
#          THIS MATERIAL IS CONFIDENTIAL AND IS FURNISHED UNDER        #
#          A WRITTEN LICENSE AGREEMENT.  IT MAY NOT BE USED,           #
#          COPIED OR DISCLOSED TO OTHERS EXCEPT IN ACCORDANCE          #
#          WITH THE TERMS OF THAT AGREEMENT.                           #
#                                                                      #
#          COPYRIGHT (C) 1982 GRAPHIC SOFTWARE SYSTEMS INC.            #
#          ALL RIGHTS RESERVED.                                        #
#                                                                      #
#     Function: Display a string of text as graphic text               #
#                                                                      #
#     Input Parameters:                                                #
#            x - integer display location (device coordinates)         #
#            y - integer display location (device coordinates)         #
#            string - null terminated character string                 #
#                                                                      #
#     Output Parameters:                                               #
#            None                                                      #
#                                                                      #
#     Routines Called:                                                 #
#            None                                                      #
#                                                                      #
########################################################################
integer x, y
SHORTINT string(1)

real rtop, rend
I 4
real xyin(2), xyout(2), min(2), max(2)
E 4
D 3
integer i, j, lx, ly, contrl(4), temp(41), ptsin(2), dummy(1)
E 3
I 3
integer i, j, lx, ly, contrl(4), itemp(41), ptsin(2), dummy(1)
SHORTINT btemp(41)
E 3

D 2
include(`anocom')
E 2
I 2
include(`gphcom')
E 2

I 3
equivalence (btemp(1), itemp(1))

E 3
data contrl /8, 1, 0, 0/
I 4
data min /0.0, 6882./
data max /26542., 32768./
E 4

# Assumption:
#   the text size has been set prior to entering this routine

D 3
if (cfont > 1) {
   call hshtxt (cfont-2, string, x, y)
E 3
I 3
i = 0
while (string(i+1) != NUL) {
   i = i + 1
   if (cfont > 1) btemp(i) = string(i)
   else           itemp(i) = string(i)
E 3
   }
D 3
else {
   i = 0
   while (string(i+1) != NUL) {
      i = i + 1
      temp(i) = string(i)
      }
E 3

D 3
   # clip the string to the screen extremes
   lx = x
   j = 0
   rend = float(i)*float(ctsizx) + float(x)
   rtop = float(y) + float(ctsizy)
   ly = y
   if (rtop > 32768.) {
      ly = 32768. - ctsizy
      }
   else if (ly < 6825) {
      ly = 6825
      }
   if (rend > 26624.) {
      i = (26624. - lx)/ctsizx
      }
   if (lx < 0) {
      j = 1 + (0-x)/ctsizx
      i = i - j
      lx = lx + j*ctsizx
      }
E 3
I 3
# clip the string to the screen extremes
lx = x
D 4
j = 0
E 4
rend = float(i)*float(ctsizx) + x
rtop = float(y) + ctsizy
ly = y
D 4
if (rtop > 32768.) {
   ly = 32768. - ctsizy
E 4
I 4
if (rtop > max(2)) {
   ly = max(2) - 1.5*ctsizy
E 4
   }
D 4
else if (ly < 6825) {
   ly = 6825
E 4
I 4
else if (ly < 6882) {
   ly = 6882
E 4
   }
D 4
if (rend > 26624.) {
   i = (26624. - lx)/ctsizx
   }
if (lx < 0) {
   j = 1 + (0-x)/ctsizx
   i = i - j
   lx = lx + j*ctsizx
   }
E 4
E 3

D 3
   if (i > 0) {
E 3
I 3
D 4
if (i > 0) {
   if (cfont > 1) {
      btemp(i+1) = NUL
      call hshtxt ((cfont-2), btemp(j+1), lx, ly)
E 4
I 4
if (cfont > 1) {
   xyin(1) = x
   xyin(2) = ly
   call hstclp (cfont-2, xyin, btemp, min, max, i, j, xyout)
   if (j >= i) {
      btemp(j+1) = NUL
      lx = xyout(1)
      ly = xyout(2)
      call hshtxt ((cfont-2), btemp(i), lx, ly)
E 4
      }
D 4
   else {
E 4
I 4
   }
else {
   j = 0
   if (rend > max(1)) {
      i = (max(1) - lx)/ctsizx
      }
   if (lx < 0) {
      j = 1 + (0-x)/ctsizx
      i = i - j
      lx = lx + j*ctsizx
      }
   
   if (i > 0) {
E 4
E 3
      ptsin(1) = lx
      ptsin(2) = ly
      contrl(4) = i
D 3
      call gzddop (contrl, temp(j+1), ptsin, dummy, dummy)
E 3
I 3
      call gzddop (contrl, itemp(j+1), ptsin, dummy, dummy)
E 3
      }
   }

return
end
E 1
