h62909
s 00006/00006/00126
d D 1.2 83/02/07 11:24:12 mjb 2 1
c if deffed all stops in these routines
e
s 00132/00000/00000
d D 1.1 83/01/20 11:13:59 tes 1 0
c date and time created 83/01/20 11:13:59 by tes
e
u
tes
mjb
U
t
T
I 1
subroutine qfield (buffer)
########################################################################
#                                                                      #
#          THIS MATERIAL IS CONFIDENTIAL AND IS FURNISHED UNDER        #
#          A WRITTEN LICENSE AGREEMENT.  IT MAY NOT BE USED,           #
#          COPIED OR DISCLOSED TO OTHERS EXCEPT IN ACCORDANCE          #
#          WITH THE TERMS OF THAT AGREEMENT.                           #
#                                                                      #
#          COPYRIGHT (C) 1982 GRAPHIC SOFTWARE SYSTEMS INC.            #
#          ALL RIGHTS RESERVED.                                        #
#                                                                      #
#     Function: Define a field item from given buffer                  #
#                                                                      #
#     Input Parameters:                                                #
#            buffer - (byte) buffer containing field item to be defined#
#                                                                      #
#     Output Parameters:                                               #
#            None                                                      #
#                                                                      #
#     Routines Called:                                                 #
#            pfditm - put a field item to memory                       #
#            ktoi   - convert from character to integer                #
#                                                                      #
########################################################################
SHORTINT buffer(1)

SHORTINT a5mod, arg1, arg5, arg6, c, upcase
integer i, istart, iend, tstart, tstop, value

# the field data structure has the following format:
#   each field is made up of a minimum of 7 bytes (choice) and is defined
#   as follows:
#
#   /command length/
#   /row/
#   /column/
#   /field length/
#   /video type + field type/
#   /multiple field count/
#   /toggle characters or seperator character terminated with null/
#   
#   the video type + field type item is defined as follows:
#
#      /video type + field type/
#             video reversed = 8
#             field type >   1=Alpha
#                            2=Integer
#                            3=Decimal
#                            4=Choice
#                            5=Toggle
#                            6=Seperator

   arg1 = 6      # minimum command length is 6
   arg6 = 1      # minimum count is 1 copy
   c = upcase (buffer(2))  # fold lower case to upper case
   a5mod = 0
   if (c == BIGR) a5mod = 128   # Reverse video requested
   c = upcase (buffer(3))  # fold lower case to upper case 
   if      (c == BIGA) arg5 = 1   # alpha
   else if (c == BIGI) arg5 = 2   # integer
   else if (c == BIGD) arg5 = 3   # decimal
   else if (c == BIGC) arg5 = 4   # choice 
   else if (c == BIGT) arg5 = 5   # toggle
   else if (c == BIGS) arg5 = 6   # seperator
D 2
   else stop 30     # illegal field attribute
E 2
I 2
   ifdef(`UNIX',`else stop 30')     # illegal field attribute
E 2

   c = buffer(4)
   iend = 4
   tstop = 0
   tstart = 5
   if (arg5 >= 5) {
      if (c == SLASH) {

	 # count the number of toggle characters
	 for (i=tstart; i<=80; i=i+1) {
	    c = buffer (i)
	    if (c == SLASH) break
	    arg1 = arg1 + 1   # increment command length for each character
	    }
D 2
	 if (c != SLASH) {
E 2
I 2
	 ifdef(`UNIX',`if (c != SLASH) {
E 2
	    stop 33   # toggle/seperator not terminated
D 2
	    }
E 2
I 2
	    }')
E 2
	 arg1 = arg1 + 1 # add one for null terminator for toggle chars.
	 tstop = i - 1   # set end position of the toggle characters
	 }
D 2
      else stop 32   # toggle/seperator field not defined
E 2
I 2
      ifdef(`UNIX',`else stop 32')   # toggle/seperator field not defined
E 2

      iend = i + 1
      c = buffer(iend)
      }
   c = upcase (c)      # fold lower case to upper case
   if (c != COMMA) {

      # Multiple field definition
      istart = iend
      if (c == BIGM) {
         call ktoi (buffer, istart, value, iend)
         arg6 = value
	 }
D 2
      else {
E 2
I 2
      ifdef(`UNIX',`else {
E 2
	 stop 31   # illegal multiple field attribute
D 2
	 }
E 2
I 2
	 }')
E 2
      }
   call pfditm (arg1)   # output the command length
   do i=1, 3 {
      
      # get the row, column, and field length
      #    arg2, arg3, arg4
      istart = iend + 1
      call ktoi (buffer, istart, value, iend)
      c = value
      call pfditm (c)
      }

   arg5 = arg5 - a5mod
   call pfditm (arg5)
   call pfditm (arg6)
   i = tstart

   if (i <= tstop) {
      # move the toggle/seperator characters to the data structure
      while (i <= tstop) {
         c = upcase (buffer(i))    # fold lower case to upper case
         call pfditm (c)
         i = i + 1
         }
      arg1 = 0
      call pfditm (arg1)
      }

return
end
E 1
