h64123
s 00191/00000/00000
d D 1.1 83/03/23 16:20:08 bog 1 0
c date and time created 83/03/23 16:20:08 by bog
e
u
4
U
t
T
I 1
#############################################################################
#									    #
#	This material is confidential and is furnished under		    #
#	a written license agreement.  It may not be used,		    #
#	copied or disclosed to others except in accordance		    #
#	with the terms of that agreement.				    #
#									    #
#	Copyright (C) 1982 Graphic Software Systems, Inc.		    #
#	All rights reserved.						    #
#									    #
#############################################################################
#									    #
#	Function:  							    #
#		Subroutine EmPoll ()					    #
#		    4012/4014 Emulator Main Polling Loop		    #
#									    #
#	Called By:							    #
#		Program Em4010						    #
#		    Tektronix 4010 Series Terminal Emulator		    #
#									    #
#	Routines Called:						    #
#		Character Function EmICom (Ch)				    #
#			Output	Ch:	Character in [NUL..DEL,EMPTY]	    #
#		    Get Ch from the communications port			    #
#									    #
#		Character Function EmIKb (Ch)				    #
#			Output	Ch:	Character in [all keys,EMPTY]	    #
#		    Get Ch from the keyboard				    #
#									    #
#		Subroutine EmOCom (Ch)					    #
#			Output	Ch:	Character in [NUL..DEL,BREAK])	    #
#		    Send Ch out the communications port			    #
#									    #
#		Subroutine EmPage ()					    #
#		    <Esc> <Ff> Clear screen				    #
#									    #
#		Subroutine EmRest ()					    #
#		    Reset Emulator as if just powered up		    #
#									    #
#		Subroutine EmCopy ()					    #
#		    <Esc> <Etb> Hardcopy screen				    #
#									    #
#		Subroutine EmStrp ()					    #
#		    Change communications parameters			    #
#		    Change "funny" key definitions			    #
#		    Change 4012/4014 straps				    #
#									    #
#		Subroutine EmGTrm (Ch,X,Y)				    #
#			Input	Ch:	Character in [NUL..DEL,EMPTY])	    #
#				X,Y:	Integer coordinates in XYSPACE	    #
#		    Terminate Graphic Input, maybe with Ch		    #
#									    #
#		Subroutine EmCntl (Ch)					    #
#			Input	Ch:	Character in [NUL..US]		    #
#		    Emulate all control characters.  LCE may be set.	    #
#									    #
#		Subroutine EmEscN (Ch)					    #
#			Input	Ch:	Character in [SPACE..DEL]	    #
#		    Emulate LCE with non-control character		    #
#									    #
#		Subroutine EmAlGr (Ch)					    #
#			Input	Ch:	Character in [SPACE..DEL]	    #
#									    #
#############################################################################
 
Subroutine EmPoll
CHARACTER Ch
 
CHARACTER LCh
CHARACTER EmICom,EmIKb
External EmICom,EmIKb
 
BEGINCOMMON
COMMON(BEAMSTATE)
COMMON(SWITCHES)
COMMON(STRAPS)
COMMON(DRIVER)
ENDCOMMON
 
Repeat {				# Forever
 
    Repeat {				# until some emulation necessary
 
	If (OnLine) {
	    If (EmICom(Ch) != EMPTY) {
		Break			# to emulation
		}
	    }
 
#	Switch (EmIKb(Ch)) {
	{
	LCh = eval(-(EMPTY)+1)+EmIKb(Ch)	# Map EMPTY to 1
	Goto (199,102,103,104,105,106,107,108,109,110),LCh
	Goto 198
 
#	    Case EMPTY: {
#	    101 {
#		}
#		Goto 199
 
#	    Case PAGE: {
	    102 {
		Call EmPage
		Ch = EMPTY
		}
		Goto 199
 
#	    Case RESET: {
	    103 {
		Call EmRest
		Ch = EMPTY
		}
		Goto 199
 
#	    Case HARDCOPY: {
	    104 {
		Call EmCopy
		Ch = EMPTY
		}
		Goto 199
 
#	    Case STRAPCHANGE: {
	    105 {
		Call EmStrp
		Ch = EMPTY
		}
		Goto 199
 
#	    Case RELEASE: {		# Nop on unexpected RELEASE
	    106 {
		Ch = EMPTY
		}
		Goto 199
 
#	    Case TOGGLESOURCE: {
	    107 {
		OnLine = NOT(OnLine)
		Bypass = FALSE
		Ch = EMPTY
		}
		Goto 199
 
#	    Case TOGGLEMARGIN: {
	    108 {
		PFMar1 = NOT(PFMar1)
		If (PFMar1) {
		    Margn2 = FALSE
		    }
		Ch = EMPTY
		}
		Goto 199
 
#	    Case BREAK: {
	    109 {
		If (OnLine) {
		    Call EmOCom(BREAK)
		    }
		Ch = EMPTY
		}
		Goto 199
 
#	    Case EXIT: {
	    110 {
		Return			# to mainline
		}
#		Goto 199
 
#	    Default: {			# Normal Ascii
	    198 {
		If (OnLine) {
		    If (Mode == GIN) {
			Call EmGTrm(Ch,X,Y)
			Ch = EMPTY
			}
		    Else {
			Call EmOCom(Ch)
			If (NOT(LocEch)) {
			    Ch = EMPTY
			    }
			}
		    }
		}
 
	  199 Continue
	    }
	} Until (Ch != EMPTY)
 
# Only Ascii characters should get through to here...
    Call EmAsci(Ch)			# Handle Ascii characters
    } 					# forever
End
E 1
