REM *** MBASEDMX 3.0 ***  MAG/base DATA MANAGEMENT LANGUAGE EXERCIZER
REM
REM WRITTEN: 09/29/80  UPDATED: 04/08/82
REM
REM PROPRIETARY SOFTWARE OF:
REM  MICRO APPLICATIONS GROUP
REM  20201 SHERMAN WAY, SUITE 205
REM  CANOGA PARK, CA 91306
REM
REM  (C) COPYRIGHT MAG 1980-1982 ALL RIGHTS RESERVED

%INCLUDE MBASECOM

	MBASE.COPYRIGHT$="(C) COPYRIGHT 1980-1982 MICRO APPLICATIONS GROUP"

	REM  * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
	REM  *                                                       *
	REM  *          INCLUDED FUNCTIONS AND MODULES               *
	REM  *                                                       *
	REM  * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

REM	MAG/base/MAGSAM KEYED FILE MANAGEMENT SYSTEM
%INCLUDE MBASEMS

REM	MAG/base/MAGDATE DATE EDIT MODULE
%INCLUDE MBASEMD

REM	MAG/base FILE MANAGEMENT FUNCTIONS
%INCLUDE MBASEFM

REM	MAG/base SCREEN MANAGEMENT FUNCTIONS
%INCLUDE MBASESM

REM	MAG/base STANDARD FUNCTIONS
%INCLUDE MBASESF

REM	MAG/base DATA BASE MANAGEMENT FUNCTIONS
%INCLUDE MBASEDML


	REM  * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
	REM  *                                                       *
100	REM  *             INITIALIZATION ROUTINE                    *
	REM  *                                                       *
	REM  * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

	HEAD1$="DML EXERCISER": REM 3.0
	HEAD3$=""

	REM  * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
	REM  *                                                       *
300	REM  *             MAINLINE LOGIC                            *
	REM  *                                                       *
	REM  * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

310	FUNC$="MENU"
	GOSUB 10100		:REM DISPLAY PRINCIPLE MENU
320	GOSUB 10600		:REM REQUEST SELECTION
	IF FUNCTION$="END" THEN GOTO 910	:REM EXIT PROGRAM
	FUNCTION$=UCASE$(FUNCTION$)
	PARAMETER$=""

	IF FUNCTION$="DGF" THEN GOSUB 1000:GOTO 330	:REM REQUEST FIELD NUM
	IF FUNCTION$="DGK" THEN GOSUB 2000:GOTO 330	:REM REQUEST KEY NUM
	IF FUNCTION$="DSF" THEN GOSUB 3000:GOTO 330	:REM REQUEST FILE NUM
	IF FUNCTION$="DSK" THEN GOSUB 2000:GOTO 330	:REM REQUEST KEY NUM

	IF FUNCTION$="XCF" THEN GOSUB 4000:GOTO 310	:REM CHANGE FIELDS
	IF FUNCTION$="XDD" THEN GOSUB 5000:GOTO 310	:REM DISPLAY FLD DEF

330	REM CALL THE DML SUBROUTINE
	IF PARAMETER$="END" THEN GOTO 320	:REM SKIP DML CALL
	GOSUB 10400				:REM DISPLAY SELECTED FUNCTION
	RET$=FN.DML$(FUNCTION$,PARAMETER$)
	IF FUNCTION$="DSF" THEN KDR.DESC$="": REM 3.0
	IF FUNCTION$="DSF" OR FUNCTION$="DGK" THEN \ 3.0
	   GOSUB 10100: \   DISPLAY MENU AND HEADS
	   GOSUB 10400: REM RE-DISPLAY FUNCTION
	GOSUB 10500				:REM DISPLAY RETURNED CODE
	GOTO 320				:REM NEXT OPERATION


	REM  * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
	REM  *                                                       *
900	REM  *             TERMINATION ROUTINE                       *
	REM  *                                                       *
	REM  * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

910	REM TERMINATE DMX - CHAIN BACK TO CALLER

	DUM$=FN.CHNRTN$


	REM  * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
	REM  *                                                       *
	REM  *              MAIN LOGIC SUBROUTINES                   *
	REM  *                                                       *
	REM  * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

1000	REM REQUEST FIELD SELECTION
	DESC$="field selection or 'END'"
	GOSUB 10300: REM REQUEST ENTRY
	RETURN

2000	REM REQUEST KEY SELECTION
	DESC$="key selection or 'END'"
	GOSUB 10300: REM REQUEST ENTRY
	RETURN

3000	REM REQUEST FILE SELECTION
	DESC$="file selection or 'END'"
	GOSUB 10300: REM REQUEST ENTRY
	RETURN

4000	REM CHANGE FIELD VALUES
	IF DML.FILENO$="" THEN GOTO 4090	:REM NO FILE HAS BEEN SELECTED
	FUNC$="CHANGE"
	HEAD3$="Change field values:"
	BEGFLD%=-15
	GOSUB 10800				:REM DISPLAY FIELD VALUES
	GOSUB 11300				:REM ENTER CHANGES
4090	RETURN

5000	REM DISPLAY CURRENT DEFINITIONS
	IF DML.FILENO$="" THEN GOTO 5090	:REM NO FILE HAS BEEN SELECTED
	FUNC$="DISPLAY"
	HEAD3$="Display of current definitions:"
	GOSUB 15100				:REM DISPLAY
5090	RETURN


	REM  * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
	REM  *                                                       *
10000	REM  *              DISPLAY/INPUT ROUTINES                   *
	REM  *                                                       *
	REM  * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

10100	REM DISPLAY MAIN MENU
	HEAD3$="Select function:"
	GOSUB 12100
	LINE%=6
	MLINE1$="DMI = INITIALIZE DML"
	MLINE2$="DMT = TERMINATE DML"
	GOSUB 10200
	MLINE1$="DSF = SELECT FILE"
	MLINE2$="DSK = SELECT KEY"
	GOSUB 10200
	MLINE1$="DOO = OPEN SELECTED FILE"
	MLINE2$="DCL = CLOSE SELECTED FILE"
	GOSUB 10200
	MLINE1$="DBB = BATCH ADD BEGIN"
	MLINE2$="DBE = BATCH ADD END"
	GOSUB 10200
	MLINE1$="DBA = BATCH ADD RECORD"
	MLINE2$="DWA = WRITE ADD RECORD"
	GOSUB 10200
	MLINE1$="DHU = HOLD FOR UPDATE"
	MLINE2$="DWU = WRITE UPDATE RECORD"
	GOSUB 10200
	MLINE1$="DRK = READ RECORD BY KEY"
	MLINE2$="DRG = READ RECORD GENERIC"
	GOSUB 10200
	MLINE1$="DRN = READ NEXT RECORD"
	MLINE2$="DDR = DELETE RECORD"
	GOSUB 10200
	MLINE1$="DGF = GET FIELD DEFINITION"
	MLINE2$="DGK = GET KEY DEFINITION"
	GOSUB 10200
	MLINE1$=""
	MLINE2$=""
	GOSUB 10200
	MLINE1$="XCF = CHANGE FIELDS"
	MLINE2$="XDD = DISPLAY DEFINITIONS"
	GOSUB 10200
	RETURN

10200	REM DISPLAY MENU LINE
	DUM$=FN.DISP.FLD$(0,MLINE1$,MLINE2$,LINE%,"CEL")
	LINE%=LINE%+1
	RETURN

10300	REM  REQUEST PARAMETER ENTRY
	PARAMETER$=FN.ENTER$(0,DESC$,"N",0,3,0,0,0,"END")
	RETURN

10400	REM DISPLAY SELECTION
	MSG$="Function: "+ FUNCTION$ 
	IF PARAMETER$<>"" THEN MSG$=MSG$+ "   Parameter: "+ PARAMETER$
	DUM$=FN.DISP.LINE$(MSG$,19,1,"","CEL")
	MSG$=""
	DUM$=FN.DISP.LINE$(MSG$,20,1,"","CEL")
	MSG$="Processing Function - Please wait ..."
	DUM$=FN.DISP.LINE$(MSG$,23,1,"","CEL")
	RETURN

10500	REM DISPLAY ERROR RETURN CODE
	MSG$="Error Return Code: "+ RET$ 
	IF DML.ERROR$<>"" THEN MSG$=MSG$+ "    Message: "+ DML.ERROR$
	DUM$=FN.DISP.LINE$(MSG$,20,1,"","CLL")
	RETURN

10600	REM ENTER FUNCTION SELECTION
	DESC$="desired function code or 'END'"
	FUNCTION$=FN.ENTER$(0,DESC$,"A",0,3,0,0,0,"END")
	RETURN

10800	REM  FIELD DISPLAY AND ENTRY FOR INQUIRY AND EVERY THING ELSE
	BEGFLD%=BEGFLD%+16: REM SET BEGINNING FIELD NUMBER FOR SCREEN
	IF BEGFLD%>FLR.FLDS% THEN BEGFLD%=1	:REM RESET SCROLL
	ENDFLD%=FN.MIN%(FLR.FLDS%,BEGFLD%+15): REM SET ENDING FIELD NUMBER
	GOSUB 12100: REM DISPLAY HEADINGS
	GOSUB 11100: REM DISPLAY SCREEN
10890	RETURN

10900	REM WAIT FOR RETURN
	DESC$="RETURN or 'END' to return to menu"
	FUNCTION$=FN.ENTER$(0,DESC$,"A",0,1,0,0,0,"END")
	RETURN

11100	REM DISPLAY SCREEN OF FIELDS
	LINE%=5
	FOR SB.I%=BEGFLD% TO ENDFLD%
	   LINE%=LINE%+1
	   RET$=FN.DML$("DGF",STR$(SB.I%))
	   IF RET$<>"0" THEN GOTO 11190	:REM DGF ERROR
	REM DISPLAY FIELD LINE ON SCREEN
	   DUM$=FN.DISP.FLD$(FDR.NO%,FDR.DESC$,FLD.VAL$(SB.I%),LINE%,"")
	NEXT SB.I%
11190	RETURN

11300	REM  REQUEST FIELD ENTRY FOR CHANGE
	IF FLR.FLDS%> 16 THEN \ 3.0
	   DESC$="desired field to change, RETURN=Page, or 'END'" \ 3.0
	ELSE \ 3.0
	   DESC$="desired field to change or 'END'": REM 3.0
	BEGF=1
	ENDF=FLR.FLDS%
11310	FLDNO$=FN.ENTER$(0,DESC$,"N",0,3,0,BEGF,ENDF,"END")
	IF FLDNO$="END" THEN GOTO 11390: REM DONE
	IF FLDNO$="" AND FLR.FLDS%<=16 THEN \ 3.0
	   GOTO 11310: REM 3.0
	IF VAL(FLDNO$)<>0 THEN GOTO 11320

	REM SCROLL SCREEN
	BEGFLD%=BEGFLD%+16
	IF BEGFLD%>FLR.FLDS% THEN BEGFLD%=1
	ENDFLD%=FN.MIN%(FLR.FLDS%,BEGFLD%+15)
	GOSUB 12100
	GOSUB 11100
	GOTO 11310

11320	I%=VAL(FLDNO$)
	DUPFLG$="N"
	GOSUB 11500	:REM GET CHANGE
	CHGFLG%=1	:REM SET CHANGE FLAG
	GOTO 11310

11390	RETURN

11500	REM GET FIELD CHANGE (I%=FIELD NUMBER)

	IF I%<BEGFLD% OR I%>ENDFLD% \ SET SCREEN TO SHOW FIELD
		THEN BEGFLD%=I% : ENDFLD%=FN.MIN%(FLR.FLDS%,BEGFLD%+15):\
		     GOSUB 12100 : GOSUB 11100

	LINE%=I%-BEGFLD%+6
	RET$=FN.DML$("DGF",STR$(I%))
	IF RET$<>"0" THEN GOTO 11590
	FLDTYP$=FDR.TYPE$: REM 3.0
	IF FLDTYP$="R" THEN FLDTYP$="A": REM 3.0
	IF FLDTYP$="I" THEN FLDTYP$="N": REM 3.0

11520	FLD$=FN.ENTER$(FDR.NO%,FDR.DESC$,FLDTYP$, \ 3.0
	   FDR.MINL%,FDR.MAXL%,FDR.DEC%, \
	   FDR.MINV,FDR.MAXV,"")


11560	FLD.VAL$(I%)=FLD$
	DUM$=FN.RDISP.FLD$(FLD.VAL$(I%),LINE%): REM RE-DISPLAY FIELD

11590	RETURN


12100	REM  DISPLAY FUNCTION HEADINGS
	DUM$=FN.DISP.HEAD$(HEAD1$,FUNC$,FLR.DESC$,KDR.DESC$,HEAD3$): REM 3.0
	RETURN

15100	REM DISPLAY CURRENT DEFINITIONS
	GOSUB 12100			:REM CLEAR SCREEN AND DISPLAY HEADINGS
	LINE%=6
	DESC$="File Number: "+STR$(FLR.NO%)+"  ID: "+FLR.ID$ \
	   +"  Description: "+FLR.DESC$
	GOSUB 15200
	DESC$="Drive: "+FLR.DRIVE$+"  Fields: "+STR$(FLR.FLDS%) \
	   +"  Keys: "+ STR$(FLR.KEYS%)+"  Next Index: "+STR$(FLR.INDEX%)
	GOSUB 15200
	DESC$="Field Number: "+STR$(FDR.NO%)+"  Description: "+FDR.DESC$ \
	   +"   Type: "+FDR.TYPE$
	GOSUB 15200
	DESC$="Minimum Length: "+STR$(FDR.MINL%)+"  Maximum: "+STR$(FDR.MAXL%)\
	   +"  Decimals: "+ STR$(FDR.DEC%)
	GOSUB 15200
	DESC$="Minimum Value: "+STR$(FDR.MINV)+"  Maximum: "+STR$(FDR.MAXV)
	GOSUB 15200

	DESC$="Key Number: "+STR$(KDR.NO%)+"  Description: "+KDR.DESC$ \
	   +"  Type: "+KDR.TYPE$
	GOSUB 15200

	IF KDR.TYPE$="D" THEN K.END%=10 ELSE K.END%=1
	FOR K%=1 TO K.END%
	   MSG$="P-Key "+CHR$(K%+64)+"    FIELD: "+STR$(KDR.FLD%(K%)) \
		+"    LENGTH: "+STR$(KDR.LEN%(K%))
	   DUM$=FN.DISP.LINE$(MSG$,LINE%,1,"","CEL")
	   LINE%=LINE%+1
	NEXT K%

	GOSUB 10900			:REM WAIT FOR RETURN
	RETURN
	
15200	REM DISPLAY LINE
	DUM$=FN.DISP.LINE$(DESC$,LINE%,1,"","CEL")
	LINE%=LINE%+1
	RETURN


	REM  * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
	REM  *                                                       *
20000	REM  *              PRINT ROUTINES                           *
	REM  *                                                       *
	REM  * * * * * * * * * * * * * * * * * * * * * * * * * * * * *


	REM  * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
	REM  *                                                       *
30000	REM  *              DISK I/O ROUTINES                        *
	REM  *                                                       *
	REM  * * * * * * * * * * * * * * * * * * * * * * * * * * * * *


	REM  * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
	REM  *                                                       *
40000	REM  *              MISCELLANEOUS ROUTINES                   *
	REM  *                                                       *
	REM  * * * * * * * * * * * * * * * * * * * * * * * * * * * * *


	REM  * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
	REM  *                                                       *
90000	REM  *              ERROR ROUTINES                           *
	REM  *                                                       *
	REM  * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

	END

