/*   *   *  *****  *   *  ****
     *  *   *      *   *  *   *
     ***    ***     * *   ****
     *  *   *        *    *   *
     *   *  *        *    *   *
     *   *  *****    *    ****
*/
/*  this module is for the keyboard transposition definitions */

#include	"equs.c"
#include	"data.c"

#define	KYROW1	10
#define	KYCOL1	0
#define	KYCOL2	0
#define	KYCOL3	2
#define	KYCOL4	4

/* base of character choice display */
#define	CDROW	0
#define CDCOL	8

#define	ARROW	'^'


/* size of character cells in pixels */
#define	BGPIXHEIGHT	21	/* LARGE CHAR */
#define	BGPIXWIDTH	10
#define	VTPIXHEIGHT	13	/* VERTICAL CHAR */
#define	VTPIXWIDTH	6
#define	HZPIXHEIGHT	11	/* SMALL HORIZONTAL CHAR */
#define	HZPIXWIDTH	6

/* PIXEL OFFSETS FROM 0,0 TO LOWER CORNER OF BOTTOM LEFTMOST CHAR */
#define	RBPIXBASE	8	/* LARGE ROW */
#define	CBPIXBASE	0	/* COL */
#define	RHPIXBASE	6	/* HORIZ SMALL ROW */
#define	CHPIXBASE	0	/* COL */
#define	RVPIXBASE	6	/* VERTICAL ROW */
#define	CVPIXBASE	0	/* COL */


struct	CRstruct	/* arrow cursor for choices */
	{ char	cursRow;  /* logoical row and item number */
	  char  cursCol;
	  char  cphyRow; /* physical position on screen */
	  char	cphyCol; 
	  char	keynum;  /* key number of item pointed to */
	};


main ()
{	struct	CRstruct CUR;
	char	result,i,j;

	ms60ptr = "Do you want to reset keyboard to original position. Please confirm (y/n) ";
	ms61ptr = "Is this the keyboard setting you wish to save? (y/n) ";
	ms62ptr = "Do you want to end this session without saving keyboard setting? (y/n) ";
	ms63ptr = "WARNING! Redefining this key disables a command key. Proceed? (y/n) ";
	ms64ptr = "Do you want to set up this definition in keyboard now? (y/n) ";
	ms65ptr = "Press F1 to finish.     Press F2 to start over.    Press F3 to abandon.";
	ms66ptr = "RE-ARRANGING THE KEYBOARD";
	ms67ptr = "All heys have REGULAR and SHIFT values.";
	ms68ptr = "Alphabet keys and some characters also have CTRL (^) values.";
	ms69ptr = "The Number Pad arrow keys move the highlight thorugh the";
	ms70ptr = "character set at the top of the screen.";
	ms71ptr = "Hitting a key (Regular, Shift or Ctrl) assings the ";
	ms72ptr = "highlighted character to that key.";


	for (i = 0; i < 128; i++)
		{ keybBuffer [i] = i;
		}

	/* inits */

	putz (keybzeroseq);  /* set keyboard to ascii astate for input */
	genKeyInit();
	initKeyboard();
	firstScreen();
	doPrompt (1,&ms82ptr);
	result = inpPrompt (PROMPTLINE,strlen (ms82ptr));
	if (result == ESC) 
		{ charsuc = FALSE;
		  return;
		}
	clearsc();
	dispChoices (&CUR);

	drawKeyboard();
	fillKeyboard();
	doPrmptLine();
	CUR.cursRow = '\0';
	CUR.cursCol = '\0';
	CUR.keynum = 1; 
	disparrow (CUR);
	
	while (1)
		{
		/* display hex val of current choice */
		result  = gtchna();  /* na - no abort on ^C */
		switch (result)
			{
			case (LEFTCUR)  : kcurleft (CUR);
			                  break;
			case (RIGHTCUR) : kcurright (CUR);
			                  break;
			case (UPCUR)    : kcurup (CUR);
			                  break;
			case (DOWNCUR)  : kcurdown (CUR);
			                  break;
	
			/* end */
			case (F1)       : clrPrompt (1);
			                  doPrompt (1,&ms61ptr);
			                  if (conPrompt (ms61ptr)) 
			                   	goto loopend;
			                  doPrmptLine();
			                  break;
			/* clear */
			case (F2)	: clrPrompt (1);
			                  doPrompt (1,&ms60ptr);
			                  if (conPrompt (ms60ptr))
			                  	{ movmem (lg.keytrantable,keybBuffer,128);
			                  	fillKeyBoard();
			                  	}
			                  doPrmptLine();
			                  break;	
			/* abort */
			case (F3)       : clrPrompt (1);
			                  doPrompt (1,&ms62ptr);
			                  if (conPrompt (ms62ptr))
			                  	goto routabort;
			                  doPrmptLine();
			                  break;	
			/* if CR confirm before setting */
			case (CTRLS)    :
			case (TAB)      :
			case (LF)       :
			case (DEL)      :
			case (BS)       :
			case (ESC)      :
			case (CR)	: clrPrompt (1);
			                  doPrompt (1,&ms63ptr);
			                  if (!conPrompt (ms63ptr)) 
						{ doPrmptLine();
						  break;
						}
					  doPrmptLine();
			default         : if (result <= DEL ) 
			                  	{ putkeyval (CUR.keynum,result);
						  keybBuffer [result] = CUR.keynum;
			                  	  disparrow (CUR);
			                  	}
			                  break;
			}  /* switch */
		}  /* while 1, main loop */
   loopend:
	charsuc =TRUE;

alldone:
	return;

routabort:
	movmem (lg.keytrantable,keybBuffer,128);
	charsuc = FALSE;
	return;

}  /* end of MAIN */


/*******   SET UP ROUTINES SECTION ******/
/*******   SET UP ROUTINES SECTION ******/
/*******   SET UP ROUTINES SECTION ******/
           
firstScreen()
{
	clearsc();
	curpos (3,MAINCOL+20);
	putz (ms66ptr);
	curpos (5,MAINCOL+2);
	putz (ms67ptr);
	curpos (6,MAINCOL+2);
	putz (ms68ptr);
	curpos (8,MAINCOL+2);
	putz (ms69ptr);
	curpos (9,MAINCOL+2);
	putz (ms70ptr);
	curpos (11,MAINCOL+2);
	putz (ms71ptr);
	curpos (12,MAINCOL+2);
	putz (ms72ptr);

} /* end of first screen */




doPrmptLine ()
{	clrPrompt (1);
 	doPrompt (1,&ms65ptr);
}


dispChoices (cur)
	struct CRstruct *cur;
{	int	i;

	for (i = 0; i < 5; i++)
		{ curpos ((CDROW + i),CDCOL);
		  putz (chRstring [i]);
		}
	curpos (5,0);
	putz ("Hex Val:");

} /* disp choices */


genKeyInit()
{
	seqcount [0] = 0;
	seqcount [1] = 0;
	seqcount [2] = 0;
	seqcount [3] = 0;
	seqcount [4] = 0;
	
	chROWents [0] = 31;
	chROWents [1] = 31;
	chROWents [2] = 31;
	chROWents [3] = 17;
	chROWents [4] = 17;

	kyROWents [0] = 13;
	kyROWents [1] = 14;
	kyROWents [2] = 12;
	kyROWents [3] = 10;

	chRstring [0] = "^A^B^C^D^E^F^G^H^I^J^K^L^M^N^O^P^Q^R^S^T^U^V^W^X^Y^Z^[^\\^]^^^_";
	chRstring [1] = " A B C D E F G H I J K L M N O P Q R S T U V W X Y Z { | } ~ _";
	chRstring [2] = " a b c d e f g h i j k l m n o p q r s t u v w x y z [ \\ ] ^ DEL";
	chRstring [3] = " = ` + * < > ? ! \" # $ % & ' ( ) SPACE";
	chRstring [4] = " - @ ; : , . / 1 2 3 4 5 6 7 8 9 0 ";

	KYrowLoc [0] = 2; KYcolLoc [0] = 0;  
	KYrowLoc [1] = 2; KYcolLoc [1] = 0;  /* ^A */
	KYrowLoc [2] = 3; KYcolLoc [2] = 4;  /* ^B */
	KYrowLoc [3] = 3; KYcolLoc [3] = 2;  /* ^C */
	KYrowLoc [4] = 2; KYcolLoc [4] = 2;  /* ^D */
	KYrowLoc [5] = 1; KYcolLoc [5] = 2;  /* ^E */
	KYrowLoc [6] = 2; KYcolLoc [6] = 3;  /* ^F */
	KYrowLoc [7] = 2; KYcolLoc [7] = 4;  /* ^G */
	KYrowLoc [8] = 2; KYcolLoc [8] = 5;  /* ^H */
	KYrowLoc [9] = 1; KYcolLoc [9] = 7;  /* ^I */
	KYrowLoc [10] = 2; KYcolLoc [10] = 6;  /* ^J */
	KYrowLoc [11] = 2; KYcolLoc [11] = 7;  /* ^K */
	KYrowLoc [12] = 2; KYcolLoc [12] = 8;  /* ^L */
	KYrowLoc [13] = 3; KYcolLoc [13] = 6;  /* ^M */
	KYrowLoc [14] = 3; KYcolLoc [14] = 5;  /* ^N */
	KYrowLoc [15] = 1; KYcolLoc [15] = 8;  /* ^O */
	KYrowLoc [16] = 1; KYcolLoc [16] = 9;  /* ^P */
	KYrowLoc [17] = 1; KYcolLoc [17] = 0;  /* ^Q */
	KYrowLoc [18] = 1; KYcolLoc [18] = 3;  /* ^R */
	KYrowLoc [19] = 2; KYcolLoc [19] = 1;  /* ^S */
	KYrowLoc [20] = 1; KYcolLoc [20] = 4;  /* ^T */
	KYrowLoc [21] = 1; KYcolLoc [21] = 6;  /* ^U */
	KYrowLoc [22] = 3; KYcolLoc [22] = 3;  /* ^V */
	KYrowLoc [23] = 1; KYcolLoc [23] = 1;  /* ^W */
	KYrowLoc [24] = 3; KYcolLoc [24] = 1;  /* ^X */
	KYrowLoc [25] = 1; KYcolLoc [25] = 5;  /* ^Y */
	KYrowLoc [26] = 3; KYcolLoc [26] = 0;  /* ^Z */
	KYrowLoc [27] = 1; KYcolLoc [27] = 10;  /* ^[ */
	KYrowLoc [28] = 0; KYcolLoc [28] = 11;  /* ^\ */
	KYrowLoc [29] = 2; KYcolLoc [29] = 11;  /* ^] */
	KYrowLoc [30] = 0; KYcolLoc [30] = 12;  /* ^^ */
	KYrowLoc [31] = 1; KYcolLoc [31] = 13;  /* ^_ */

	KYrowLoc [32] = 4; KYcolLoc [32] = 0;  /* SPACE */

	KYrowLoc [33] = 0; KYcolLoc [33] = 0;  /* ! */
	KYrowLoc [34] = 0; KYcolLoc [34] = 1;  /* " */
	KYrowLoc [35] = 0; KYcolLoc [35] = 2;  /* # */
	KYrowLoc [36] = 0; KYcolLoc [36] = 3;  /* $ */
	KYrowLoc [37] = 0; KYcolLoc [37] = 4;  /* % */
	KYrowLoc [38] = 0; KYcolLoc [38] = 5;  /* & */
	KYrowLoc [39] = 0; KYcolLoc [39] = 6;  /* ' */
	KYrowLoc [40] = 0; KYcolLoc [40] = 7;  /* ( */
	KYrowLoc [41] = 0; KYcolLoc [41] = 8;  /* ) */
	KYrowLoc [42] = 2; KYcolLoc [42] = 10;  /* * */
	KYrowLoc [43] = 2; KYcolLoc [43] = 9;  /* + */
	KYrowLoc [44] = 3; KYcolLoc [44] = 7;  /* , */
	KYrowLoc [45] = 0; KYcolLoc [45] = 10;  /* - */
	KYrowLoc [46] = 3; KYcolLoc [46] = 8;  /* . */
	KYrowLoc [47] = 3; KYcolLoc [47] = 9;  /* / */

	KYrowLoc [48] = 0; KYcolLoc [48] = 9;  /* 0 */

	movmem (&KYrowLoc [33],&KYrowLoc [49],15);
	movmem (&KYcolLoc [33],&KYcolLoc [49],15);
	

	KYrowLoc [64] = 1; KYcolLoc [64] = 11;  /* @ */

	movmem (&KYrowLoc [1],&KYrowLoc [65],31);
	movmem (&KYcolLoc [1],&KYcolLoc [65],31);

	KYrowLoc [96] = 1; KYcolLoc [96] = 11;  /* ` */

	movmem (&KYrowLoc [1],&KYrowLoc [97],31);
	movmem (&KYcolLoc [1],&KYcolLoc [97],31);



}  /* gen key init */

initKeyboard()
{	char	i,j,col;

	/* set up proper corner values */
	for (i = 0; i < 4; i++)
		kyRWrowcorn [i] = (KYROW1 + (i * 3));


	col = KYCOL1;
	for (i = 0; i < kyROWents[0]; i++)
		{ kyRWcolcorn [0][i] = col;
		  if (i == 0)
			{ col += 4;
			  kyRWbig[0][i] = FALSE;
			}
		  else
			{ col += 6;
			  kyRWbig[0][i] = TRUE;
			}
		} /* top row i to 13*/

	col = KYCOL2;
	for (i = 0; i < kyROWents[1]; i++)
		{ kyRWcolcorn [1][i] = col;
		  if ((i == 11) | (i == 12))
			{ col += 4;
			  kyRWbig[1][i] = FALSE;
			}
		  else
			{ col += 6;
			  kyRWbig[1][i] = TRUE;
			}
		} /* second row i to 14 */


	col = KYCOL3;
	for (i = 0; i < kyROWents[2]; i++)
		{ kyRWcolcorn [2][i] = col;
		  col += 6;
		  kyRWbig[2][i] = TRUE;
		} /* third row i to 12 */
	
	col = KYCOL4;
	for (i = 0; i < kyROWents[3]; i++)
		{ kyRWcolcorn [3][i] = col;
		  col += 6;
		  kyRWbig[3][i] = TRUE;
		} /* bot row i to 10 */


}  /* end of init key board */



drawKeyboard()
{	int	row,col,i,gheight,gwidth;
	for (row = 0; row < 4; row++)
		{
		for (col = 0; col < kyROWents [row]; col++)
			{ curpos (kyRWrowcorn[row],kyRWcolcorn[row][col]);
			  if (kyRWbig [row][col])
				drKEY (kyRWrowcorn[row],kyRWcolcorn[row][col],6);
			  else drKey (kyRWrowcorn[row],kyRWcolcorn[row][col],4);
			}
		if ((row != 1) & (isFox))
			{ ptch (LF); ptch ('|');
			ptch (BS); ptch (LF); ptch ('|');
			}
		}  /* row to 4 */
	/* draw space bar */
	if (isFox)
		{ curpos ((KYROW1 + 10),(kyRWcolcorn[3][0] + 2));
		  ptch ('|'); ptch (BS); ptch (LF);
		  repchar ('-',54);
		  ptch (BS); ptch (CTRLZ); ptch ('|');
		}
	else
		{ /* find corrdinates of corner */
		row = KYROW1 + 11;
		col = kyRWcolcorn [3][0] + 2;
		gtGbase (&row,&col,&gheight,&gwidth);
		GRmove ((col + gwidth /2),(row + gheight/2));
		GRdraw ((col + (gwidth * 54)- gwidth /2),(row + gheight/2));
		GRdraw ((col + (gwidth * 54)- gwidth /2),(row + (3 * gheight) - gheight/2 - 1));
		GRdraw ((col + (gwidth/2)),(row + (3 * gheight) - gheight/2 - 1));
		GRdraw ((col + gwidth /2),(row + gheight/2));
		CHmode();
		ptch (CR); /* display weirdness killer */
		}  /* 5000 space bar */		

} /* end of draw keyboard */




drkey (row,col,size)
	char	row,col,size;
{	int	grow,gcol,gheight,gwidth,offht,offwid,i;
	int	cpoint [8],rpoint [8];

	if (isFox)
		{
		repchar ('-',size);
		repchar (BS,size);
		ptch (CTRLZ); ptch ('|'); ptch (BS);
		ptch (CTRLZ); ptch ('|'); ptch (BS); ptch (CTRLZ);
		repchar ('-',size);
		}  /* isFox */
	else	/* 5000 */
		{ /* find corrdinates of corner */
		grow = row;
		gcol = col;
		gtGbase (&grow,&gcol,&gheight,&gwidth);
		offwid = gwidth/2 + 1;  /* offset lines from cell edge */
		offht = gheight/2 + 2;
		cpoint [0] = gcol + offwid + gwidth;
		rpoint [0] = grow + offht;
		cpoint [1] = gcol + (size * gwidth) - offwid;
		rpoint [1] = rpoint [0];
		cpoint [2] = cpoint [1] + gwidth;
		rpoint [2] = grow + gheight;
		cpoint [3] = cpoint [2];
		rpoint [3] = grow + (3 * gheight);
		cpoint [4] = cpoint [1];
		rpoint [4] = rpoint [3] + gheight - offht;
		cpoint [5] = cpoint [0];
		rpoint [5] = rpoint [4];
		cpoint [6] = gcol + offwid;
		rpoint [6] = rpoint [3];
		cpoint [7] = cpoint [6];
		rpoint [7] = rpoint [2];

		GRmode ();
		GRmove (cpoint [7],rpoint [7]);
		for (i = 0; i <= 7; i++)
			GRdraw (cpoint [i],rpoint[i]);
		CHmode();
		}	/* 5000 */
		
}  /* little key */


/* find graphic coordinates of lower key corner */
gtGbase (rowptr,colptr,htptr,wdptr)
	int	*rowptr,*colptr,*htptr,*wdptr;
{
	if (st.isSmall)
		{ if (isHoriz)
			{ *htptr = HZPIXHEIGHT;
			  *wdptr = HZPIXWIDTH;
			  *rowptr = ((49 - *rowptr) * HZPIXHEIGHT) + RHPIXBASE;
			  *colptr = ((*colptr) * HZPIXWIDTH) + CHPIXBASE;
			} /* horizontal */
		  else
			{ *htptr = VTPIXHEIGHT;
			  *wdptr = VTPIXWIDTH;
			  *rowptr = ((65 - *rowptr) * VTPIXHEIGHT) + RVPIXBASE;
			  *colptr = ((*colptr) * VTPIXWIDTH) + CVPIXBASE;
			}  /* not horizontal */
		}  /* isSmall */
	else 
		{ *htptr = BGPIXHEIGHT;
		  *wdptr = BGPIXWIDTH;
		  *rowptr = ((25 - *rowptr) * BGPIXHEIGHT) + RBPIXBASE;
		  *colptr = ((*colptr) * BGPIXWIDTH) + CBPIXBASE;
		}  /* large */

}  /* end of gtGbase */

fillKeyboard()
{	char	i,mode;

	for (i = 1; i < 128; i++)
		putKeyVal (keybBuffer[i],i);
}  /* end of fill keyboard */





/*******   ACTION ROUTINE SECTION ******/
/*******   ACTION ROUTINE SECTION ******/
/*******   ACTION ROUTINE SECTION ******/
/*******   ACTION ROUTINE SECTION ******/

kcurleft (cur)
	struct CRstruct  *cur;
{
	/* see if any place to move */
	if ((cur->cursCol) == 0)
		{ ptch (BELL);
		  return;
		}
	wipearrow (cur);
	cur->cursCol -= 1;
	keycalc (cur);
	disparrow (cur);

}  /* end of kcurleft */




kcurright (cur)
	struct CRstruct  *cur;
{
	/* see if any place to move */
	if ((cur->cursCol) == (chROWents [cur->cursRow] - 1))
		{ ptch (BELL);
		  return;
		}
	wipearrow (cur);
	cur->cursCol += 1;
	keycalc (cur);
	disparrow (cur);

}  /* end of kcurright */

kcurdown (cur)
	struct CRstruct  *cur;
{
	/* see if any place to move */
	if ((cur->cursRow) == 4)
		{ ptch (BELL);
		  return;
		}
	wipearrow (cur);
	/* choosing logical col */
	
	cur->cursRow += 1;
	cur->cursCol = min (chROWents [cur->cursRow] - 1,cur->cursCol);
	keycalc (cur);
	disparrow (cur);

}  /* end of kcurdown */


kcurup (cur)
	struct CRstruct  *cur;
{
	/* see if any place to move */
	if ((cur->cursRow) == 0)
		{ ptch (BELL);
		  return;
		}
	wipearrow (cur);
	/* choosing logical col */
	cur->cursRow -= 1;
	cur->cursCol = min (chROWents [cur->cursRow] - 1,cur->cursCol);
	keycalc (cur);
	disparrow (cur);

}  /* end of kcurup */








/*******   PRIMTIVE ROUTINE SECTION *******/
/*******   PRIMTIVE ROUTINE SECTION *******/
/*******   PRIMTIVE ROUTINE SECTION *******/
/*******   PRIMTIVE ROUTINE SECTION *******/
/*******   PRIMTIVE ROUTINE SECTION *******/


/* puts outchar onto key named by  key variable at apppropiate
	position on key */

putKeyVal (outchar,key)
	char	outchar,key;
{	char	rbase,cbase,outstr[6];

	/* find cursor position of named key on keyboard */
	if (key  == ' ') 
		{
		rbase = KYROW1 + 10;
		cbase = 31;
		got gotCoordinates;
		} /* key = blank */
	rbase = kyRWrowcorn [ KYrowLoc [key] ];
	cbase = kyRWcolcorn [ KYrowLoc [key] ][ KYcolLoc [key] ];
	if (key < ' ')
		{ rbase -= 2;
		  cbase += 1;
		}  /* control chars postion */
	else if ((key <= ')') | ((key >= 'A') & (key <= 'Z')) | findplace (key,"<>?+*}{`=|~_"))
		{ rbase -= 2;
		  if (kyRWbig [ KYrowLoc [key] ][ KYcolLoc [key] ])
		  	cbase += 4;
		  else cbase += 2;
		}  /* capital char postion */
	else
		{ rbase -= 1;
		  if (kyRWbig [ KYrowLoc [key] ][ KYcolLoc [key] ])
		  	cbase += 3;
		  else cbase += 2;
		} 	/* l.c. char */
  
gotCoordinates:
		/* build character to output */
	if (outchar == ' ')
		{ if (key == ' ') strcpy (outstr,"SPACE");
		  else strcpy (outstr,"SP");
		} 	/* space */
	else if (outchar == DEL)
		{ if (key == DEL) strcpy (outstr,"DEL");
		  else strcpy (outstr,"DL");
		} 	/* DEL */
	else if (outchar < ' ')
		{ outstr[0] = '^';
		  outstr [1] = (outchar + 0x40);
		  outstr [2] = '\0';
		}  	/* control char */
	else
		{ outstr [0] = outchar;
		  outstr [1] = '\0';
		}
	curpos (rbase,cbase);
	/* special blanking and placing for SPACE and DEL */
	if (key == ' ') 
		{	/* blank five chars */
		repchar (' ',5);
		repchar (BS,5);
		}  	/* space */
	if (key == DEL)
		{   /* blank previous char */
		ptch (BS); ptch (' ');
		if (outchar == DEL) ptch (BS);
		}
	/* blank two places and output char */
		repchar (' ',2);
		repchar (BS,2);
	putz (outstr);

}  /* put key val */


	




/* display the arrow */
disparrow (cur)
	struct	CRstruct *cur;
{   char	len,str [6],pos,i;

	if ((cur->cursRow == 2) & (cur->cursCol == 30)) len = 3; /* DEL */
	else if ((cur->cursRow == 3) & (cur->cursCol == 16)) len = 5; /* SPACE */
	else if (cur->cursRow == 0) len = 2;
	else len = 1;

	/* to underline fox frame with normal and underline markers,
	    to underline with 5000 put underline seq, chars then 
	   normal seq.  For fox keep count of number of entries on line.
	   When number reahces 8 line must be erased to underline */

	stphycurs (cur);
	curpos (cur->cphyRow,cur->cphyCol);
	if (isFox) 
		{
		if (++seqcount [cur->cursRow] == 8)
			{ seqcount [cur->cursRow] = 0;
			  curpos (cur->cphyRow,CDCOL);
			  putz (clrtoeolseq);
			  curpos (cur->cphyRow,CDCOL);
			  putz (chRstring [cur->cphyRow]);
			  curpos (cur->cphyRow,cur->cphyCol);
			} /* if sequence count is 8 */
		repchar (CTRLF,len);
		putz (normseq);
		repchar (BS,len);
		putz (inverseseq);
		} /* fox */
	else		/* 5000 */
		{
		pos = (2 * (cur->cursCol +1) -1);
		if (cur->cursRow == 0) pos--; 
		for (i = 0; i < len; i++)
			str [i] = chRstring [cur->cursRow] [pos + i];
		str [len] = '\0';
		putz (inverseseq);
		putz (str);
		putz (normseq);
		}  /* 5000 */

	curpos (5,9);
	printz ("%02x",cur->keynum);
	curpos (23,78);
} /* end of disparrow */





/* clear off the arrow */
wipearrow (cur)
	struct	CRstruct *cur;
{	char	pos,str[6],len,i;

	/* to wipe with fox change underline frame char to normal */
	stphycurs (cur);
	curpos (cur->cphyRow,cur->cphyCol);
	if (isFox)
		putz (normseq);
	else		/* 5000 */
		{
		if ((cur->cursRow == 2) & (cur->cursCol == 30)) len = 3; /* DEL */
		else if ((cur->cursRow == 3) & (cur->cursCol == 16)) len = 5; /* SPACE */
		else if (cur->cursRow == 0) len = 2;
		else len = 1;
		pos = (2 * (cur->cursCol+1)) - 1;
		if (cur->cursRow == 0) pos--; 
		for (i = 0; i < len; i++)
			str [i] = chRstring [cur->cursRow] [pos + i];
		str [len] = '\0';
		putz (str);
		}  /* 5000 */


} /* end of  wipe arrow */




/* calculate keynum value based on logical cursor positon  */
keycalc (cur)
	struct	CRstruct *cur;
{   char  num;
	if (cur->cursRow == 0) num = cur->cursCol + 1;
	else if ((cur->cursRow == 2) & (cur->cursCol == 30)) 
		num = 0x7f; /* DEL */
	else if ((cur->cursRow == 3) & (cur->cursCol == 16)) 
		num = 0x20; /* SPACE */
	else num = chRstring [cur->cursRow] [(2 * (cur->cursCol+1)) - 1];
	cur->keynum = num;
} /* end of keycalc */






/* set physical cursor postion based on logical position */
stPhyCurs (cur)
	struct	CRstruct *cur;
{
	cur->cphyRow = CDROW + cur->cursRow;
	/* each position in line takes two places */
	cur->cphyCol = CDCOL + (2 * cur->cursCol);
	if (cur->cphyRow != 0) cur->cphyCol++;
}

abort()
{   exit();
}

