	.title	'Option Header Construction'

	.ident	option
	.pabs
	.phex

	.loc 	100h

version	=	0
revision=	2
level	=	0

systyp	=\	'Option Header Selection
       0 => CP/M-86  on the DMS-86   or DMS-5086
       1 => MSDOS    on the DMS-86   or DMS-5086
       2 => CP/M-86  on the DMS-816
       3 => MSDOS    on the DMS-816
       4 => CP/M-2.2 on the DMS-816
       5 => HiDos    on the DMS-816
choice   = '


; OS numbers:

cpm2	==	11h
cpm86	==	12h
hidos	==	13h
msdos	==	21h

; Console types:

serial	==	0
parallel ==	80h

; Product numbers:

zsbc3	==	1
dms4	==	2
dms1280 ==	3
dms3c	==	4
dms86	==	5	; DMS-5086 and HNS-86
dms5016	==	6
dms816	==	7

; Option map bits:

; First byte:

flop8	==	1 < 0
flop5	==	1 < 1
flopibm ==	1 < 2
hard8	==	1 < 3
hard5	==	1 < 4
hard5a	==	1 < 5	; adaptec controller
p0ahead == 	1 < 6
p0poll	==	1 < 7

; Second byte:

p2poll	==	1 < ( 8 & 7 )
p3ahead	==	1 < ( 9 & 7 )
p3poll	==	1 < ( 10 & 7 )
pportc 	==	1 < ( 11 & 7 )	; parallel port 1 console
pportp 	== 	1 < ( 12 & 7 )	; parallel port 1 printer
pport2	==	1 < ( 13 & 7 )
mux	==	1 < ( 14 & 7 )	; console/prn mux (ADDS, 1280, 5000)
spool	==	1 < ( 15 & 7 )

; Third byte:

netbuff	==	1 < ( 16 & 7 )
clock	==	1 < ( 17 & 7 )
fpi	==	1 < ( 18 & 7 )	; front panel interrupt
drives	==	19 & 7
mmapvid ==	1 < ( 23 & 7 )	; memory mapped video

; Headers consist of the os type (1 byte),
; product map (16 bytes, first only used),
; option map ( 6 bytes, first 3 used),
; and length field ( 2 bytes),
; followed by the unambiguous clue
; that this is a header


	.ife	systyp -0,[

	.byte	cpm86
	.byte	1<dms86,0,0,0,0,0,0,0
	.byte	0,0,0,0,0,0,0,0
	.byte	p0ahead
	.byte	p2poll + p3ahead + pportc + pportp + mux + spool
	.byte	clock + fpi + netbuff + 8<drives
	.byte	0,0,0
]		; end cp/m hns

	.ife	systyp -1,[

	.byte	msdos
	.byte	1<dms86,0,0,0,0,0,0,0
	.byte	0,0,0,0,0,0,0,0
	.byte	p0ahead
	.byte	p2poll + p3ahead + pportc + pportp + mux + spool
	.byte	clock + fpi + netbuff + 8<drives
	.byte	0,0,0
]		; end msdos hns

; Header for the 816 CP/M-86 separated boot bios

	.ife	systyp -2,[

	.byte	cpm86
	.byte	1<dms816,0,0,0,0,0,0,0
	.byte	0,0,0,0,0,0,0,0
	.byte	p0ahead
	.byte	pport2 + p2poll + spool
	.byte	netbuff + 8<drives + mmapvid
	.byte	0,0,0
]		; end cp/m 86 816

; Header for the 816 MSDOS separated boot bios

	.ife	systyp -3,[

	.byte	msdos
 	.byte	1<dms816,0,0,0,0,0,0,0
	.byte	0,0,0,0,0,0,0,0
	.byte	p0ahead
	.byte	pport2 + p2poll + spool
	.byte	netbuff + 8<drives + mmapvid
	.byte	0,0,0
]		; end msdos 816

; Header for the 816 CP/M-2.2 separated boot bios

	.ife	systyp -4,[

	.byte	cpm2
	.byte	1<dms816,0,0,0,0,0,0,0
	.byte	0,0,0,0,0,0,0,0
	.byte	p0ahead
	.byte	pport2 + p2poll + spool
	.byte	netbuff + 4<drives + mmapvid
	.byte	0,0,0
]		; end cp/m-2.2  816


	.ife	systyp -5,[

	.byte	hidos
	.byte	1<dms816,0,0,0,0,0,0,0
	.byte	0,0,0,0,0,0,0,0
	.byte	p0ahead
	.byte	pport2 + p2poll + spool
	.byte	netbuff + 4<drives + mmapvid
	.byte	0,0,0
]		; end hidos 816

; Bad Option Selection

	.ifg	systyp -5,[
	  .if2,[.prntx	'Incorrect Option Selection']
		.end
	]	; end bad selection

; Unambiguous clue that this is a header sector -- 
; located at offset 25 in the sector

	.word	1	; length field not used
	.ascii	'THIS IS A HEADER'

	.loc	180h
	


	.ife	systyp -0,[

	.byte	cpm86
	.byte	1<dms86,0,0,0,0,0,0,0
	.byte	0,0,0,0,0,0,0,0
	.byte	p0ahead
	.byte	p2poll + p3ahead + pportc + pportp + mux + spool
	.byte	clock + fpi + netbuff + 8<drives
	.byte	0,0,0
]

	.ife	systyp -1,[

	.byte	msdos
	.byte	1<dms86,0,0,0,0,0,0,0
	.byte	0,0,0,0,0,0,0,0
	.byte	p0ahead
	.byte	p2poll + p3ahead + pportc + pportp + mux + spool
	.byte	clock + fpi + netbuff + 8<drives
	.byte	0,0,0
]

; Header for the 816 CP/M-86 separated boot bios

	.ife	systyp -2,[

	.byte	cpm86
	.byte	1<dms816,0,0,0,0,0,0,0
	.byte	0,0,0,0,0,0,0,0
	.byte	p0ahead
	.byte	pport2 + p2poll + spool
	.byte	netbuff + 8<drives + mmapvid
	.byte	0,0,0
]

; Header for the 816 MSDOS separated boot bios

	.ife	systyp -3,[

	.byte	msdos
	.byte	1<dms816,0,0,0,0,0,0,0
	.byte	0,0,0,0,0,0,0,0
	.byte	p0ahead
	.byte	pport2 + p2poll + spool
	.byte	netbuff + 8<drives + mmapvid
	.byte	0,0,0
]

; Header for the 816 CP/M-80 separated boot bios

	.ife	systyp -4,[

	.byte	cpm2
	.byte	1<dms816,0,0,0,0,0,0,0
	.byte	0,0,0,0,0,0,0,0
	.byte	p0ahead
	.byte	pport2 + p2poll + spool
	.byte	netbuff + 4<drives + mmapvid
	.byte	0,0,0
]

	.ife	systyp -5,[

	.byte	hidos
	.byte	1<dms816,0,0,0,0,0,0,0
	.byte	0,0,0,0,0,0,0,0
	.byte	p0ahead
	.byte	pport2 + p2poll + spool
	.byte	netbuff + 4<drives + mmapvid
	.byte	0,0,0
]		; end hidos 816

	.loc	180h+40h

; Now code an 86 style long jump to 80:0000
	.byte	0eah
	.word	0
	.word	80h

	.end
