;
;	Interface to AZTEC 'C' compiler for
;	Digital MicroSystems Extended Bios calls
;
; ver	0
; rev	0
; mod	a
; patch	a
;
; 		newroutine	mimics
;		----------	------
;		dmsbios		bios
;		dmsbioshl	bioshl
;
;	called like this:
;
;	integer = dmsbioshl( jmpNum, regA, regBC, regDE, regHL )
;	CHAR	= dmsbios( jmpNum, regA, regBC, regDE, regHL )
;
; clrDDbuf	=	0+31 = 31
; NETlock	=	1+31 = 32
; CPMmap	=	2+31 = 33
; NETunlock	=	3+31 = 34
; SETbyte	=	4	35
; revision byte, NETmsg address, so no 5
; SENDnet	=	6	37
; RECnet	=	7	38
;
; NACKpoll	=	8	39	station
; ACKpoll	=	9	40
;
; INTERCEPT	=	8	39	master
; INTERUPT	=	9	40
;
; PORTUout	=	10	41
; SETppa	=	11	42
; RECtime	=	12	43
; HDstatLocal	=	13	44
; NEThdStat	=	14	45
; SetNetMode	=	15	46
; SetListType	=	16	47

WRMboot	equ	0

CALL	equ	0cdH
LBCD	equ	0ed4bH
LDED	equ	0ed5bH
PUSHIX	equ	0dde5H
PUSHIY	equ	0fde5H
POPIX	equ	0dde1H
POPIY	equ	0fde1H
;
	public	dmsbios_
dmsbios_:
	call	setupArgs
	call	dmscombios
	mov	L,A
	mvi	H,0
	ret
;
	public	dmsbioshl
dmsbioshl:
	call	setupArgs	; Save IX, IY, BC as per AZTEC rules, also
				;copy parameters from stack to local memory
dmscombios:
	lhld	jmpNum		; Parameter telling which extended bios jump 
	xchg			; DE = which jump
	lhld	WRMboot+1	; Get normal bios jump table address + 3 =
				;warm boot jump address
	dcx	H
	dcx	H
	dcx	H		; HL = address of normal bios jump table
	dad	D	; Add DE 3 times since 3 bytes per jump in table
	dad	D
	dad	D		; HL = offset from normal bios jump table to
				; extended bios jump of users choice.
	shld	JumpAddress	; Set up call to the jump.
;	db	LBCD		; Set up registers to equal passed parameters.
;	dw	regBC
;	db	LDED
;	dw	regDE
	lhld	regBC
	mov	C,L
	mov	B,H
	lhld	regDE
	mov	E,L
	mov	D,H
	lhld	regHL
	lda	regA
	db	CALL		; Do the extended bios call.
JumpAddress:
	db	0,0		; Filled in above.
	RET

;..............................................................................

setupArgs:
	pop	D	; save return address to this routine's caller
	lxi	H,2	; compute address of arguments on stack
	dad	SP
;	dw	PUSHIX	; save IX
;	dw	PUSHIY	; save IY
	DB 221,229,253,229
	push	B	; save BC as required by AZTEC
	push	D	; put return address back
	lxi	D,jmpNum	; get ready to set up arguments
	mvi	B,10	; 5 arguments, two bytes each.
setupLoop:
	mov	A,M
	stax	D
	inx	H
	inx	D
	dcr	B
	jnz	setupLoop
	lxi	H,restore	; Address of routine to restore IX, IY, and BC
	xthl			; Put restore routine address on stack, get
				;this routine's caller's address from stack.
	pchl			; Return to this routine's caller.
;
restore:
	pop	B
;	dw	POPIY
;	dw	POPIX
	DB 253,225,221,225
	mov	A,H
	ora	L
	ret
;
	dseg
jmpNum:	ds	2
regA:	ds	2
regBC:	ds	2
regDE:	ds	2
regHL:	ds	2

	end

