/*			USERS			module 4
						contents = Modify
    "us4.c"
*/
/*=============================================================================
			INCLUDES
*/
/*
#define		debug4		0
*/
#define	OVERLAY	1
#include	"users.os"
#include	"standard.inc"

#define		EXTERNal	0

#include	"users.dat"

/*=============================================================================
			HISTORY
date		9 February 1984
person		tpl

ver	0
rev	0
mod	c
patch	4

 ver/rev
""""""""
  0/0

     mod patch
    """""""""""
	c1		3 February 1984		tpl
		.Try to squeeze more space out.

	b4		30 January 1984		tpl
		.RELEASED TO SOFTWARE TEST.

	b1		22 December 1983	tpl
		.Tear out parts and put into modules. Compiler can't handle
		this code on our low tpa.

	b0		22 December 1983	tpl
		.Break off Delete. Compiler runs out of room.

	a3		20 December 1983	tpl
		.Delete working.

	a0		19 December 1983	tpl
		.Begin this module.

*/
/*page*/
/*=============================================================================
			ROUTINES
*/
/*---------------------------------------------------------------------------*/
#ifdef OVERLAY
ovmain ()
#else
Modify()
#endif
{
  struct users_entry	u_entry;
  struct config_entry	c_entry;
  register CHAR		i, length, entry_num;
  CHAR	change_os_flag;
  int	ret_value;

    putz("\n\nModify an entry in the Users Table.\n");

    if ( (entry_num = Get_Entry()) == NuserTblEntries )
	return;

    putz("\n\n    Modify this entry\n\n");
    if( !Ask_if_entry_OK( &users_table[ entry_num], &config_table[ entry_num]))
	return;	/* Return if not ok.	*/

    Reset_Entry (&u_entry, &c_entry);


    putz("\n\nEntering RETURN will keep any old values.\n\n");

/* name */

    clear( input_buffer, Lname, SPACE);
    putz("Enter new user name -->                (8 characters maximum)");
    repchar(BS,37);
    if( (length = Tintostring( input_buffer, Lname, FALSE)) == 0 )
		/* if only RETURN entered, use old name.	*/
    {
	blockmv( u_entry.name, users_table[ entry_num ].name, Lname);
	printz("%.8s", u_entry.name );
    }
    else
    {
	strUpper(input_buffer);
	input_buffer[length] = SPACE;
	blockmv( u_entry.name, input_buffer, Lname);
    }


/* password */

    clear( input_buffer, Lpassword, SPACE);
    putz("\n\nEnter new password  -->                (6 characters maximum)");
    repchar( BS,37 );
    if( (length = Tintostring( input_buffer, Lname, FALSE)) == 0 )
		/* if only RETURN entered, use old password.	*/
    {
	strUpper( input_buffer);
	blockmv( u_entry.password, users_table[entry_num].password, Lpassword);
	printz("%.8s", u_entry.password );
    } else
    {
	input_buffer[length] = SPACE;
	strUpper (input_buffer);
	blockmv( u_entry.password, input_buffer, Lpassword);
    }

/* op_sys type */

    change_os_flag = Mod_Op_Sys( &u_entry, &c_entry, entry_num );

/* default assignments */

/* If the os was changed, no keeping of current default assignments. */
    if ( change_os_flag )
	change_os_flag = RETNOTOK;
    else
	change_os_flag = RETOK;
    Read_Assignments( &u_entry, &c_entry, entry_num, change_os_flag );

/* type ahead string */

    clear( input_buffer, LtypeAhead, SPACE );

    putz("\n\
Enter commands to be automatically executed upon login.\n\
31 character maximum.  Press RETURN at end of string.\n\
Use BACKSPACE or DELETE to edit commands.  Press @ before\n");
   putz ("entering RETURN, BACKSPACE, DELETE, or @ into commands.\n\
To erase the current login commands press 0, then RETURN.\n\
To keep the current login commands, press RETURN.\n\
--> ");

    length = C_intostring( input_buffer, LtypeAhead+1, FALSE);

    if ( length == 0 )	/* echo old type-ahead buffer */
    {
	blockmv( c_entry.type_ahead, config_table[ entry_num ].type_ahead,
						LtypeAhead);
	c_entry.size_type_ahead = config_table[ entry_num ].size_type_ahead;

	C_listchars( c_entry.type_ahead, c_entry.size_type_ahead);

	putz("\n");
    }

    else
    {
	if ( input_buffer[0] == '0' && length == 1 )	/* erase the string */
	{
	    c_entry.size_type_ahead = 0;
	    clear( c_entry.type_ahead, LtypeAhead, SPACE );
	}
	else				/* else use inputted string.	*/
	{
	    c_entry.size_type_ahead = length;
	    blockmv( c_entry.type_ahead, input_buffer, LtypeAhead);
	}
	putz("\n");

    } /* else length != 0 */

/* Ask if entry is what user wants. If so, put in table. If not, don't.	*/

    putz("\n\n");
    if ( Ask_if_entry_OK( &u_entry, &c_entry ) == TRUE )
    {
	blockmv( &users_table[ entry_num ], &u_entry,
						sizeof( struct users_entry ));
	blockmv( &config_table[ entry_num ], &c_entry,
						sizeof( struct config_entry ));
	changes_made = TRUE;	/* Mark global flag that change was made. */
    }

} /* Modify */

/*---------------------------------------------------------------------------*/

/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
