/*			USERS		module 2

    "us2.c"
*/
/*=============================================================================
			INCLUDES
*/
/*
#define		debug2		0
*/

#include	"users.os"
#include	"standard.inc"

#define		EXTERNal	0

#include	"users.dat"


/*=============================================================================
			HISTORY

date		3 February 1984
person		tpl

ver	0
rev	0
mod	c
patch	2

 ver / rev
"""""""""""
    0/0

     mod  patch
    """"""""""""
	b4		30 January 1984		tpl
		.RELEASED TO SOFTWARE TEST.

	b0		19 December 1983	tpl
		.Cut us2a.c in half, into us2b.c and us3a.c since running
		out of memory when compiling.

	a0		16 December 1983	tpl
		.Create this file from us0b.c.

*/
/*page*/
/*=============================================================================
				ROUTINES
*/
/*---------------------------------------------------------------------------*/

CHAR
Ask_if_entry_OK( u_entry, c_entry )
  struct users_entry	*u_entry;
  struct config_entry	*c_entry;
{
    Show_Header();
    Show_Entry( u_entry, c_entry );
    printz("\nIs this correct? -->                 (yes/no)");
    repchar(BS,24);
    return(Get_Yes_No(RETNOTOK));

} /* Ask_if_Partition_OK */

/*---------------------------------------------------------------------------*/
/*page*/

Reset_Entry( u_entry, c_entry )
  struct users_entry	*u_entry;
  struct config_entry	*c_entry;
{
#ifdef debugP
	putz("\np...Reset_Entry\n");
#endif

    clear( u_entry, sizeof( struct users_entry ), 0);
    clear( c_entry, sizeof( struct config_entry ), 0);

} /* Reset_Entry */

/*---------------------------------------------------------------------------*/
/*page*/

CHAR
First_Free_Entry()
{
  register CHAR		i;

#ifdef debugP
	putz("\np...First_Free_Entry\n");
#endif

    for ( i=0;     (users_table[i].name[0] != 0)
		&& (users_table[i].name[0] != 0xE5); )
	if (++i == NuserTblEntries)
	    return (0xff);	/* Failed to find free entry.	*/

    return(i);	/* Successfully found free entry.	*/

} /* First_Free_Entry */

/*---------------------------------------------------------------------------*/
/*page*/

int
Get_Entry()
{
  register CHAR		length, num_entry;

    while (TRUE)
    {
	putz("\nPress RETURN to go back to Main Menu\n\n\
Enter Users Table entry name --> ");

	clear( input_buffer, Lname, SPACE);
	
	if ( (length = Tintostring( input_buffer, Lname, FALSE)) == 0 )
		/* Return to Main Menu if just RETURN entered. */
	    return(NuserTblEntries);

	strUpper(input_buffer);
	input_buffer[length] = SPACE;	/* Clear '\0' so 'strncmp' works. */

	if ( (num_entry = Is_Dup_Users_Entry( input_buffer ))
							== NuserTblEntries )
	    putz("    Not found.\n");

	else
	    return( num_entry );

    } /* while true */

} /* Get_Entry */

/*---------------------------------------------------------------------------*/
/*page*/

int
Is_Dup_Users_Entry(name)
  CHAR	*name;
{
  register CHAR		i = 0;

    while (	   (users_table[i].name[0] != 0)
		&& (users_table[i].name[0] != 0xE5)     )
    {
	if (strncmp( name, users_table[i].name, Lname) == 0)
	    return (i);
	if ( ++i == NuserTblEntries )
	    break;	/* return NuserTblEntries for not duplicate.	*/
    }

    return(NuserTblEntries);

} /* Is_Dup_Users_Entry */

/*---------------------------------------------------------------------------*/
/*page*/

CHAR
Get_Yes_No(accept_return)
  int	accept_return;	/* Is "RET" a valid response besides yes or no. */
{
  register CHAR		length, i;

    while(TRUE)
    {
	if (   ( (length = Tintostring( input_buffer, Lyn ,FALSE)) == 0  )
		&& (accept_return)    )
	    return(RETURN);
	strUpper(input_buffer);
	for ( i=0; i<NUMyn; ++i )
	if ( strcmp( input_buffer, yes_no_responses[i] ) == 0 )
	{
	    putz("\n");
	    if (i < 2)
		return(TRUE);  /* Yes entry. */
	    else
		return(FALSE); /* No entry.  */
	}
	ptch(BELL);
	repchar(BS,length);

    } /* while true */

} /* Get_Yes_No */

/*---------------------------------------------------------------------------*/
/*page*/

CHAR
Read_OS_Kind(accept_return)
  CHAR	accept_return;		/* TRUE if RET is ok as a response.	*/
{
  register CHAR		i, length;

    putz("Enter Kind of Operating System.\n");
    putz("    'Full' gives you a full service operating system.\n");
    putz("    'HiMem' gives you a limited service operating \n");
    putz("           system with more memory available.\n");

    while ( TRUE )
    {
	putz("\nEnter kind of O.S.  -->                     (Full, HiMem)");
	repchar(BS,33);
	while ( ( (length = Tintostring( input_buffer, LkindOS, FALSE )) == 0 )
		&& ( !accept_return ) )
	    ptch( BELL );

	strUpper(input_buffer);
	if ( (length == 0) && (accept_return) )
	    return(RETURN);

	for ( i=0; i<NkindOS; ++i)
	    if (strcmp( input_buffer, os_kind_table[i]) == 0)
	    {
		putz("\n");
		switch(i)
		{
		    case 0:
			return(FULLsys);
		    case 1:
			return(HiMEMsys);
		}
	    }/*if match*/

	printz("%c    That is not a valid kind of operating system.\n", BELL);
			
    } /* while true */

} /* Read_OS_Kind */

/*---------------------------------------------------------------------------*/
/*page*/

CHAR
Read_Op_Sys(accept_return)
  CHAR	accept_return;		/* TRUE if RET is ok as a response.	*/
{
  register CHAR		i, length;

    while ( TRUE )
    {
	printz("Operating System Type -->                (MSDOS, CPM)");
	repchar(BS,27);
	while ( ( (length = Tintostring( input_buffer, LnameOS, FALSE )) == 0 )
		&& ( !accept_return ) )
	    ptch( BELL );
	strUpper(input_buffer);
	if ( (length == 0) && (accept_return) )
	    return(RETURN);

	for ( i=0; i<NnameOS; ++i)
	    if (strcmp( input_buffer, os_name_table[i]) == 0)
	    {
		putz("\n");
		switch(i)
		{
		    case 0:
			return(CPMsys);
		    case 1:
			return(MSDOSsys);
		}
	    }/*if match*/
	printz("%c    That is not a valid operating system type.\n", BELL);
			
    } /* while true */

} /* Read_Op_Sys */

/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
