/* **************************************************************
 *								*
 *			  SYSLIB6.C				*
 *	       LIST SYSTEM DIRECTORY OR OS TABLE		*
 *		  last modified 02/10/84 dsb			*
 *								*
 ************************************************************** */

#include "libc.h"
#include "syslib.h"
#include "hardio.h"

/* ***************** REVISION HISTORY OF THIS MODULE ***************   

    01/19/84	Put list functions in this overlay
    02/10/84	Used register variables wherever possible

*/


ovmain()	      /* Sub-menu of options to list table entries */
{
    char a;

    printf("\nTo list the OPERATING SYSTEM TABLE type 'O'.  Any other");
    printf("\nkey starts list of Control Area Directory.");
    printf("\n(Any key stops or restarts listing) --> ");

    dgets(&a,1);		/* get ANY string from the user */
    if(toupper(a) == 'O')
	dump_ost();		  /* dump os table contents */
    else
	dump_sd();
    waitkey();
} /* list */



dump_sd()
{
    register struct SDentry *entry;
    register int i;

    printf("\n\n     CONTROL AREA DIRECTORY\n");
    sd_header();
    entry = (struct SDentry *) sysdir.buffer;
    for(i=0; entry->name[0] && (entry->name[0]!=0xE5) &&(i < 128); i++,entry++)
    {
	printf("\n%x\t",i);
	prt_sd(entry);
	check_wait();
    }
} /* dump sd */

dump_ost()
{
    register struct OSTentry *entry;
    register char a;
    register int i;

    printf("\n\n       OPERATING SYSTEM TABLE\n");
    ost_header();
    for(i=0, entry = (struct OSTentry *) ostable.buffer;
			  (a=entry->load_list[0][0]) && (a != 0xE5); entry++)
    {
	printf("\n%x\t",i++);
	prt_os(entry);
	check_wait();
    }

} /* dump ost */

[0][0]) && (a != 0xE5); entry++)
    {
	printf("\n%x\t",i++);
	