
/*======================================================================*/
/*	PCOMPRES.C	overlay for Alloc for compressing		*/
/*			hard disk partitions.				*/
/*======================================================================*/

#include	"standard.inc"

#define		EXTERNal
#include	"alloctbl.dat"

#define		NODEBUG

/*=============================================================================
			HISTORY

date		24 February 1984
person		tpl

ver	0
rev	0
mod	a
patch	a

  ver-rev
""""""""""""
    0-0

	mod-patch
      """""""""""""
	  a-a		24 February 1984	tpl
		.Change from Jon Cook's Compress program to overlay for
		Alloc program.
		.printf -> printz and putchar -> ptch.
*/
/*page*/
/*=============================================================================
			ROUTINES
*/
ovmain ()
{
    MoveParts ();
}

/*---------------------------------------------------------------------------*/

/*page*/

#define	SECTSIZE	128
#define	DATtrack	0x00
#define DATsector	0x79
#define	DATlength	8

/*======================================================*/
/*	Things related to disk and partition size	*/
/*======================================================*/
#define DspCnt	"      Tracks left to move"

#define	KPerTrack	16
#define SectPerK	8

#define PartDelete(p)	((p)->name [0] == 'd')
#define PartExists(p)	(p->size != 0 && p->size != 0xE5)
#define	PartSize(p)	(sizeinK [(p)->size])
/* indexed by DAT size byte */
#define SIZEMAX		7
int	sizeinK [SIZEMAX] = {
	0,
	256,
	2 * 256,
	4 * 256,
	8 * 256,
	16 * 256,
	32 * 256
	};

#ifndef NODEBUG
#define SizeName(s)	(sizename [(s)])
CHAR	*sizename [SIZEMAX] = {
	"Unknown",
	"256K",
	"512K",
	"1M",
	"2M",
	"4M",
	"8M"
	};
#endif

/*page*/
/*======================================================================*/
/*			Move Table					*/
/*======================================================================*/

#define	KtoTracks(b)	((b) / KPerTrack)

/*======================================================================*/
/*			Disk I/O stuff					*/
/*======================================================================*/

#define getDAT(b)	hd_xfer (READ, DATtrack, DATsector, b, DATlength)
#define putDAT(b)	hd_xfer (WRITE, DATtrack, DATsector, b, DATlength)

#define getK(t, s, b)	hd_xfer (READ, t, s, b, 8)
#define putK(t, s, b)	hd_xfer (WRITE, t, s, b, 8)

/*======================================================================*/
/*			GLOBAL VARIABLES				*/
/*======================================================================*/
int		Nparts = 0;	/* Number of partitions in DAT		     */
unsigned int	total_tracks;	/* total number of tracks to move	     */

/*page*/
#define BS 	(8)
/*==============================================================*/
/*	backup 	- backup 'n' spaces on the screen		*/
/*==============================================================*/
backup (n) 
int	n;
{
	while (n--) ptch(BS);
	}


/*======================================================================*/
/*	CopyTrack	-	copties a track from src to dst		*/
/*======================================================================*/
CopyTrack (s, d)
unsigned int	s, d;
{
int	i;
CHAR	b [1024];

#ifndef NODEBUG
	printz ("copying from %04xt to %04xt\n", s, d);
#endif

	for (i = 0; i < KPerTrack; ++i) {
#ifndef NODEBUG
		printz ("\t%04xs\n",
			i*SectPerK+1, s, d);
#endif
		getK (s, i*SectPerK+1, b);
		putK (d, i*SectPerK+1, b);
		}

	}

/*======================================================================*/
/*	initialize	- initialization				*/
/*======================================================================*/
initialize () {
struct a_entry	*p;

#ifndef NODEBUG
	printz ("======== INITIALIZE =======\n");
#endif

	
	getDAT (alloc_table);
	}

#ifndef	NODEBUG
/*======================================================================*/
/*	dump_alloc	- debugging dump of alloc table			*/
/*======================================================================*/
dump_alloc (tbl, msg)
struct	a_entry	*tbl;
CHAR		*msg;
{
struct	a_entry	*p;
int	i;

	printz ("%s\n", msg);
	for (p = tbl, i = 0; p != &tbl [NallocEntries] && PartExists (p); 
			++p, ++i) {
		printz ("\t%d:%8.8s %s %s\n", i, p->name, 
			SizeName (p->size),PartDelete (p) ? " DELETED " : "");
		}
	printz ("End of dump\n");
	}
#endif

/*page*/
/*======================================================================*/
/*	MoveParts	- Move partitions if necessary.			*/
/*======================================================================*/
MoveParts () {
struct	MoveEntry	*m;
struct	a_entry	*p;
unsigned int			cur_src;
unsigned int			cur_dst;
int				i;

#ifndef NODEBUG
	printz ("======== Build Move Table =========\n");
#endif
	total_tracks = 0;
	p = alloc_table;
	cur_dst = cur_src = PartSize (p);

	/*=============================*/
	/* find partitions to compress */
	/*=============================*/
	for (Nparts = 1, ++p;
		p != &alloc_table [NallocEntries] && PartExists (p); 
		++p, ++Nparts) {
		if (!PartDelete (p)) {
			if (cur_src != cur_dst)
				total_tracks += KtoTracks (PartSize (p));
			cur_dst += PartSize (p);
			}
		cur_src += PartSize (p);
		}


	p = alloc_table;
	cur_dst = cur_src = PartSize (p);
	for (Nparts = 1, ++p, i = 1;
		p != &alloc_table [NallocEntries] && PartExists (p); 
		++p, ++Nparts) {
		if (!PartDelete (p)) {

			/* UPDATE DAT */
			if (Nparts != i)
				blockmv (&alloc_table [i],
					&alloc_table [Nparts],
					sizeof (struct a_entry));

			/* COPY PARTITION */
			if (cur_src != cur_dst) {
				printz ("Moving partition %-8.8s\n", p->name);
				/* display message 
				   and get ready to start count down */
				printz (DspCnt);
				backup (strlen (DspCnt));
				Move1Part (cur_src, cur_dst, PartSize (p));
				}
			else 
				printz ("Partition %-8.8s stays put\n", p->name);

			cur_dst += PartSize (p);
			++i;
			}
		cur_src += PartSize (p);
		}

	clear (&alloc_table [i], (NallocEntries - i) * sizeof (struct a_entry), '\0');
#ifndef NODEBUG
	dump_alloc (alloc_tab, "DAT after compression");
#endif
	putDAT (alloc_table);

	}
/*page*/
/*======================================================================*/
/*	Move1Part	- move a single partition			*/
/*======================================================================*/
Move1Part (src, dst, len)
unsigned int	src;	/* source of data in Kbytes		*/
unsigned int	dst;	/* destination of data in Kbytes	*/
unsigned int	len;	/* length of data in Kbytes		*/
{
int	i;

	/* convert from Kbytes to Tracks */
	len = KtoTracks (len);
	src = KtoTracks (src);
	dst = KtoTracks (dst);

	printz ("%5.5u", total_tracks);
	backup (5);
#ifndef NODEBUG
	printz  ("\n\tCOMPRESSING (tracks): %d from %u to %u\n",len,src,dst);
#endif
	for (i = 0; i < len; ++i) {
		CopyTrack (src + i, dst + i);
		--total_tracks;
		printz ("%5.5u", total_tracks);
		backup (5);
		}
	}

/*======================================================================*/

