/*							*/
/*			NETUNTLOK Utility		*/
/*			main program			*/

#define ver 1
#define rev 1
#define mod 'A'
#defin as 'c'

#define bufl	20
#define fnnlock 29
#define fnunlock 30

#include "netunlok.os"
#include "c:switch.os"

CHAR *getline();
struct sstring {
	CHAR	length;
	CHAR	name[20];
};

main(argc, argv)
int	argc;
CHAR	*argv[];
{
	int len;
	CHAR buf[bufl];
	CHAR *s;
	s = buf;

	printf("Remove a lock string from the lock table, version %d.%d%c%c\n\n",ver,rev,mod,asm);
	printf("Please use the following convention when you remove a lock string.\n");
	printf("Separate the file name from the file type with a period.\n\n");
	printf("To unlock a partition, enter the partition name.\n\n");
	
	if (argc == 1)	{
		do	{
			printf ("Enter your lock string: ");
		} while (!(len = getline (s, bufl)));
#ifdef dbg
		printf ("%s  %d\n", s, len);
#endif
	}
	else
		len = strlen (s = argv[1]);
	if (len > 13)
		printf("Lock string is too long.\n");
	else	
		dounlock (len, s);
#ifdef cpm86
	qexit();
#endif
}
/*page*/
dounlock (l, p)
int	l;
char	*p;
{
	CHAR	result;
	struct	sstring t;
	CHAR	*u = t.name;

	t.length = l;
	while (*u++  = toupper(*p++))
		;
	result = (bios86 (3, fnunlock, &t) & 0XFF);
#ifdef dbg
	printf ("result = %x\n", result);
#endif
	switch (result) {
		case 0:
			printf("Your lock string is removed from the lock table.\n");
			break;
		case 1:
			printf("NET Error - Can't Cope.\n");
			break;
		case 2:
			printf("This lock string does not exist in the lock table.\n");
			break;
		default:
			printf("Unknown result = %x\n", result);
			break;
	}
}
