
/*==============================================================*/
/*	Jon's misc useful routines				*/
/*==============================================================*/


#include "jonsubs.os"
#include "c:switch.os"

#define	BOOLEAN	int
#define true	1
#define false	0
#define beep() putchar ('\7')
#define isprint(c) (c >= ' ' && c < 0xF7) 

#define BS 	(8)
/*==============================================================*/
/*	backup 	- backup 'n' spaces on the screen		*/
/*==============================================================*/
backup (n) 
int	n;
{
	while (n--) putchar (BS);
	}



/*==============================================================*/
/*	do_menu		- generic command processor and		*/
/*			   performer.				*/
/*==============================================================*/
do_menu (this_menu, these_cmds, Not_a_Choice)
CHAR	*this_menu [];
CHAR	*these_cmds;
CHAR	*Not_a_Choice;
{
CHAR	*str [80];
int	c;

	show_menu (this_menu);
	while (index (these_cmds, (c = tolower (getstr(str, 80)))) == NULL) {
		beep ();
		printf (Not_a_Choice);
		}
	return c;	
	}

/*==============================================================*/
/*	get_yesno	- get Y or N from the keyboard		*/
/*==============================================================*/
BOOLEAN get_yesno (YesNoPlease)
CHAR	*YesNoPlease;
{
int	c;
CHAR	str [80];

	for (;;) {
		c = getstr (str, 80);
		if (tolower (c) == 'y')
			return (true);
		else if (tolower (c) == 'n')
			return (false);
		else {
			beep ();
			printf (YesNoPlease);
			}
		}
	}

/*==============================================================*/
/*	message	- 	same as show_menu			*/
/*==============================================================*/
message (m) CHAR *m[]; {show_menu(m); }

/*==============================================================*/
/*	show_menu	- generic menu shower			*/
/*==============================================================*/
show_menu (menu)
CHAR	*menu [];
{
	while (*menu != NULL)
		printf (*menu++);
	}

/*==============================================================*/
/* 	submit	- creates a $$$.sub format file 		*/
/*		  if te file is named $$$.sub it will run next	*/
/*==============================================================*/
submit (fname, s) 
CHAR	*fname;
CHAR	**s;
{
CHAR	buffer [128];
FILE	*fp;
int	fn;
CHAR	**p;

	clear (buffer, 128, (CHAR) 0x1A);
	for (p = s; *p != NULL; p++)
		;
	unlink (fname);
	if ((fn = open (fname, O_WRONLY + O_CREAT)) == EOF) {
		return (false);
		}

	while (p-- != s) {
		sprintf (buffer, " %s", *p);
		buffer [strlen (buffer)+1] = '$';
		buffer [0] = (CHAR) strlen (*p);
	
		if (write (fn, buffer, 128) == EOF) {
			close (fn);
			return (false);
			}
		};
	
	if (close (fn) == EOF)
		return (false);
	return (true);
	}




#define CR	13
#define LF	10
#define CTRLX	0x18
#define	DEL	0x7F


/*======================================================*/
/*	getstr	- get and echo string	 		*/
/*======================================================*/

CHAR	*getstr ( buf, len)
CHAR	*buf;
int	len;
{
CHAR	*p;
CHAR	c;
int	cnt;
CHAR	bucket;
	

start:	clear ( buf, len, ' ');
	p = buf;
	cnt = len;
	while (cnt) {
		c = getchar ();
		switch (c) {
		case CR :
		case LF :
			*p++ = NULL;
			return *buf;
		case CTRLX :
			while (cnt--) {
				putchar (BS);
				putchar (' ');
				putchar (BS);
				}
			goto start;
		case DEL :
		case BS	:
			if (p != buf) {
				putchar (BS);
				putchar (' ');
				putchar (BS);
				*--p = ' ';
				cnt++;
				}
			break;
		default : 
			*p++ = c;
			cnt--;
			break;
		}
		}

	while ((bucket = getchar ()) != CR && bucket != LF)
			return *buf;
	}
/*======================================================================*/
