/*	FileCopy module		'assign' for msdos/cpm file copy utility

	"FCASSIGN.C"
*/

#include "filecopy.os"
#include "c:switch.os"
#include "fcconst.h"
#include "fcstruct.h"
#include "fcdata.h"

/*=============================================================================
			HISTORY
    Last change:        15 March 1984		tpl
ver	0
rev	0
mod	g
patch	6


     mod-patch
    +++++++++++
	g2		12 March 1984	tpl
		.Add write mode queries to keep in sync with master
		when doing assignment to MSdos drive and reassigning
		the CPM drive displaced by the MSdos assignment.
		.Clean up unused local variables and sizeIndex passed
		to InitFrgnDir.
		.Move dph getting into InitFrgnDrive.
		Do only bios seldisks. Make sure to selDisk
		the currently logged in disk after getting DPH address.


  g1		January  12, 1984	jjc
	.Change to Mike Pompa's assign routine  
  f6		November 11, 1983	tpl
	.Last series of patches: FCB drive -> 1=A, 2=B, 3=C...
	But OS uses (via SelDisk and CurDisk) 0=A, 1=B, 2=C, ...
	.Many variable name changes, cleanups.
	.Arrays of pointers for each drive's descriptors' working.

  f		November 8, 1983	tpl
	.New mod for we the new mods.

  e		October 21, 1983	tpl
	.Space fill sendAssignData.
	.Make run on master.

  d		October 17, 1983	tpl
	.Take out main. Put in 'if debug_mode' and ask for driveLetter.

  c		October 14, 1983	tpl
	.Take out variables/structs and put in "fcinit.dat".

  b		October 13, 1983	tpl
	.initial version works o.k., but allows erroneous partition names.

  a		October 11, 1983	tpl
	.Start coding 'assign' call for FileCopy utility.


*/

/*=============================================================================
			CONSTANTS / DEFINITIONS
*/

/* Number of users HiNet supports at one time.	*/
#ifndef NnetUsers
#define		NnetUsers	32
#endif

/* define write mode commands.		*/
#define		WMquery		3
#define		WMrelease	1
#define		NOTowned	0xff

/*=============================================================================
			DATA STRUCTURES
*/

/* write mode send structure */

struct 	WMsend {
	CHAR wmcmd; /* generic command */
	CHAR WMcmd; /* specific command: grt/rel/frc/qry */
	CHAR WMvol;
	CHAR WMunit;
	CHAR WMvalue;
	CHAR WMuserno;
	};
/*=================================================================*/
/* write mode receive structure */

struct	WMrec {
	CHAR WMack;
	CHAR WMstatus;
	CHAR WMuser[ 8];
	};
/*=================================================================*/
/* write mode bios vector structure */

struct	WMstruct {
	struct WMsend wmsend;
	CHAR logdrive;
	struct WMrec wmrec;
	};
/*=================================================================*/

extern struct WMstruct	WMparams;


/*=============================================================================
			VARIABLES and DATA STRUCTURES
*/
extern CHAR	begin_disk;	/* User's logged on disk when filecopy run.  */



CHAR	ms_drive;   /* Keeps track of drive used for msdos transfer. */
		    /* Used in zabort.				     */

/* Set TRUE if msdos partition used for transfer is Ownable.	*/
CHAR	ms_part_ownable = FALSE;

/* Saves DPB of drive to be used for MSDOS transfer. */
struct DPB	save_dpb;

CHA	*usedDPBaddr	/ Point t DP use fo MSDO transfer    */

/* Flag set to TRUE if SaveDrive is called.  */
int	driveSaved	=	FALSE;


/*page*/
/*=============================================================================
			ROUTINES
*/
/*---------------------------------------------------------------------------*/

CHAR
Assign( driveLetter, partition )
  CHAR	driveLetter, *partition;
{
  CHAR	status, drive;

  drive = driveLetter - 'A';

/* Save current drive info for 'drive' so we can reset it		*/
/*  after filecopy is done.						*/
	SaveDrive( drive );	/* Sets "driveSaved" flag for zabort.	*/
	ms_drive = drive;

#ifdef debug
	printf("Assign drive %c to partition %-8.8s\n", driveLetter, partition);
#endif

/* PWAssign overlays new dpb */
  MSAssign ();
  if (PWAssign (drive, partition))
  {
    CPAssign ();
    return (FALSE);
  }
  CPAssign ();

/* Do a write mode query to get master and station in sync.	*/
/* Also to see if partition is Ownable.				*/
  WM_Command( WMquery, drive, usedDPBaddr, TRUE); /* zabort if failure. */

  status = WMparams.wmrec.WMstatus;
  if (  (status == NOTowned) || ((status >= 0) && (status < NnetUsers))  )
    ms_part_ownable = TRUE;

/* Get here if have valid partition name and password.	*/

  InitFrgnDrive( drive );

  return(TRUE);

}/*assign*/

/*page*/
/*---------------------------------------------------------------------------*/

InitFrgnDrive( drive )
int	drive;
{
int	xlate_sector, save_DMA;
struct BPB		*curBPB; /* local ptr to frgn_BPB [drive] */
struct ms_dir_info	*curDir; /* loca ptr to frgnDirInfo [drive] */ 
struct BPB_sector	BPBsect;

/* Setup variables for foreign directory access.		*/
/*  Assume msdos is foreign for now.				*/

#ifdef debug
	printf("p..InitFrgnDrive    drive: %c ( %x hex )\n", drive+'A', drive);
#endif


	if ( ( frgn_BPB [drive] = alloc(sizeof(struct BPB)) ) == 0) {
		printf("Allocation error for frgn_BPB in InitFrgnDrive.\n");
		zabort();
		}
	curBPB = frgn_BPB [drive];

#ifdef debug
	printf("  frgn_BPB[%x] : %x\n", drive, frgn_BPB[drive]);
#endif

/* Read MS-DOS BIOS Parameter Block from disk partition */

	/* Select disk to read from and initialize frgn_dph.	*/
	frgn_dph driv   seldisk driv );

	save_DMA = GetDMA ();
	SetDMA (&BPBsect);
	dmsbios (SETTRACK, 0, 0, 0, 0); /* Track zero */
	xlate_sector = dmsbioshl (SECTRAN, 0, 0,
		frgn_dph [drive]->translate_table, 0);
	dmsbios (SETSECTOR, 0, xlate_sector, 0, 0);
	if (dmsbios (BIOSREAD, 0, 0, 0, 0) == 1) {
		printf ("**** ERROR. BPB read failed!.\n");
		zabort ();
		}
	blockmv (curBPB, &(BPBsect.bpb), sizeof (struct BPB));

	seldisk( CurDisk() );	/* resync bios and bdos. */


#ifdef debug
	printf ("BPB read:\n\tBytes/Sec:\t%d\tSec/Clust:\t%d\n",
		curBPB->BytesInSect, curBPB->SectPerCluster);
	printf ("\tresrved:\t%d\t# FATs:  \t%d\n",
		curBPB->reserved_sect, curBPB->num_FATs);
	printf ("\t# Root: \t%d\tSec/Disk:\t%d\n",
		curBPB->num_Root_Dir_Entries, curBPB->SectPerDisk);
	printf ("\tMedia:  \t%d\tSec/FAT: \t%d\n",
		curBPB->media_descriptor, curBPB->SectPerFAT);
	printf ("\tSec/Track:\t%d\n",
		curBPB->SectPerTrack); 
#endif

/* Get FAT and fill in BPB sect per track field, if necessary	*/
	seldisk( drive );	/* Select drive for MSgetFAT	*/
	SetDMA (save_DMA);
	MSgetFAT (drive);
	seldisk( CurDisk() );	/* resync bios and bdos.	*/

/* First sector of directory is the one after last FATsector. So take all
   reserved sectors ( one for BPB ) plus sectors for FATS to get the first 
   sector of the directory sector.		     */

	if ((frgnDirInfo[ drive ] = alloc(sizeof(struct ms_dir_info))) == 0) {
		printf("Allocation error for frgnDirInfo in InitFrgnDrive.\n"); 
		zabort();
		}
#ifdef debug
	printf("  frgnDirInfo[%x] : %x\n", drive, frgnDirInfo[drive]);
#endif
	curDir = frgnDirInfo [drive];
	curDir->begSector = (curBPB->reserved_sect
		+ (curBPB->num_FATs * curBPB->SectPerFAT));
	curDir->begTrack =
		curDir->begSector / curBPB->SectPerTrack;
	curDir->curSector = 0;
	curDir->curTrack = 0;
	curDir->curEntry = 0;
	curDir->endEntry = curBPB->num_Root_Dir_Entries;
	curDir->bytesInCluster	= 
		curBPB->BytesInSect * curBPB->SectPerCluster;
	curDir->dataOffset = curBPB->reserved_sect
		+ (curBPB->num_FATs * curBPB->SectPerFAT)
		+ (curBPB->num_Root_Dir_Entries 
		/ (curBPB->BytesInSect / sizeof (struct ms_dir_entry)));

	/* Find the last cluster in FAT. */

/* First compute the maximum number of clusters for the whole drive.	     */
/* The +1 at the end allows for clusters being numbered from 0 ( so -1 ) but */
/*the first two clusters ( 0 and 1 ) are not used ( so +2 ), and +2-1=+1.    */

	curDir->lastCluster = (curBPB->SectPerDisk
		/ curBPB->SectPerCluster) + 1;
#ifdef dbg1
	printf("   max cluster: %x hex    %d decimal\n",
			curDir->lastCluster,
			curDir->lastCluster);
#endif
	/* Allow room for BPB sector, FATs, and directory.	*/

	curDir->lastCluster -= (curDir->dataOffset
			+ (curBPB->SectPerCluster - 1))
			/ curBPB->SectPerCluster;
#ifdef dbg1
	printf("   last allocatable cluster: %x hex    %d decimal\n",
			curDir->lastCluster,
			curDir->lastCluster);
#endif


#ifdef debug
	printf("DataOffset: %x hex\n",curDir->dataOffset);
	printf("BytesInCluster: %x hex %d decimal\n",
					curDir->bytesInCluster,
					curDir->bytesInCluster);
#endif

	}/*InitFrgnDrive*/

/*page*/
/*---------------------------------------------------------------------------*/

DeAssign( drive_letter )
{

#ifdef debug
	printf("p..DeAssign      drive %c\n", drive_letter);
#endif

    UnSaveDrive( drive_letter - 'A' );

}/*DeAssign*/

/*---------------------------------------------------------------------------*/

zabort ()
{
    if ( driveSaved )
	UnSaveDrive( ms_drive );

    printf ("%c Abort.\n", BELL );

    DiskReset();
    SelDisk( begin_disk );

    exit( 0 );
}

/*page*/
/*---------------------------------------------------------------------------*/

SaveDrive( drive )
  int	drive;
{
  struct DPH	*dph;

    dph = seldisk(drive);
    seldisk( CurDisk() );	/* Get bios and bdos back in sync.	*/

    usedDPBaddr = dph->dpb_address - 16;
    blockmv( &save_dpb, usedDPBaddr, sizeof(struct DPB) );

    driveSaved = TRUE;

}/* SaveDrive */

/*page*/
/*---------------------------------------------------------------------------*/

UnSaveDrive( drive )
  int	drive;
{
/* If partition used for MSDOS transsfer is ownable, then release ownership. */
    if ( ms_part_ownable )
				/* don`t zabort on failure. */
	WM_Command( WMrelease, drive, usedDPBaddr, FALSE);

    blockmv( usedDPBaddr, &save_dpb, sizeof(struct DPB) ); /* Restore DPB. */

/* Put master and station into sync.*/
    WM_Command( WMquery, drive, usedDPBaddr, TRUE); /* zabort if failure. */

    driveSaved = FALSE;	/* Reset flag.	*/


}/* UnSaveDrive */

/*---------------------------------------------------------------------------*/

/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

