/*
    This file is an adjunct to tlioprim.c.  It has routines for editing
    an input buffer with entry and display of control characters.  It
    uses character I/O routines located in tlioprim.c

    2/17/84	Steve Roe
*/


#define  BELL  0x07	/* ascii bell code */
#define  BS    0x08	/* ascii backspace code */
#define  LF    0x0A	/* ascii linefeed code */
#define  CR    0x0D	/* ascii carriage return code */
#define  DEL   0x7F	/* ascii delete code */

#define  ASCII_MASK  0x7F	/* Mask byte to ascii character set */
#define  CTRL_MASK   0x60	/* Used to check for control characters */
#define  CAPS_MASK    0x40	/* Converts control characters to printable */


int C_intostring( p, max, crlf)	/* enter a string with control chars */
    char *p;			/* pointer to string buffer */
    int max;			/* size of string buffer */
    int crlf;			/* print terminating crlf? */
    {				/* returns length of string */
    register int i = 0, c;

    max--;			/* maximum string length */

    while ((c = gtch() & ASCII_MASK) != CR && c != LF)
	{
	if (c == BS || c == DEL)
	    {
	    if (i == 0)  ptch(BELL);
	    else
		{
		C_erase( *(--p) );
		i--;
		}
	    }
	else
	    {
	    if (i == max)  ptch(BELL);
	    else
		{
		if (c == '@')  
		{	C_write (c);
			c = gtch();
		}
		C_write( *p++ = c );
		i++;
		}
	    }
	}

    if (crlf)  ptch('\n');
    *p = '\0';

    return(i);		/* return length of string */
    }

/*page*/

C_listchars( p, num)	/* list a buffer of ascii characters */
    register char *p;	/* buffer pointer */
    register int num;	/* number of characters to list */
    {
    while (num-- > 0)
	C_write( *p++ );
    }


C_write( c )		/* output an ascii character display */
    int c;
    {
    c &= ASCII_MASK;	/* mask to ascii range */

    if (!(c & CTRL_MASK))
	{
	ptch('^');
	c |= CAPS_MASK;
	}
    ptch(c);
    }


C_erase( c )		/* erase an ascii character display */
    int c;
    {
    if ( !(c & CTRL_MASK) )
	{
	ptch(BS); ptch(' '); ptch(BS);
	}
    ptch(BS); ptch(' '); ptch(BS);
    }
