/*		ALLOC				Document
    "ALLOCDOC.C"

	There are two programs supported by this document,
    Alloc and NetAlloc. 
	Alloc can only run stand alone due to problems with changing the
    partition allocation table while the master is running.
	NetAlloc runs on a master and allows minor changes to the partition
    allocation table.

	These programs allow the set up, maintainance, changing, formatting
    of hard disk allocaion tables and partitions.

*/
/*=============================================================================
			INCLUDES
*/
/* define INITdata to initialize all global variables in alloc.dat.	*/

#define		INITdata	0

#include	"alloc.dat"

/*---------------------------------------------------------------------------*/

#ifdef ALLOC
#define		vers	8
#define		rev	0
#define		mod	'a'
#define		patch	'c'
#define		date   "March 16, 1984"
#endif

#ifdef NETALLOC
#define		vers	1
#define		rev	0
#define		mod	'a'
#define		patch	'b'
#define		date   "March 16, 1984"
#endif

/*
===============================================================================
			PROGRAM HISTORY

	ALLOC			( NETALLOC history follows )

 ver/rev
==========
  8 / 0

     mod-patch
    +++++++++++
	a-a		7 March 1984	tpl
		.Go from ver=0 to ver=8 to get in step with
		current version of Alloc.
		.All overlays working.
		.Nearly ready for initial release.

(no versions 1,2,3,4,5,6,7.
	Skipped to get in step with current release of Alloc.)

 ver/rev
==========
  0 / 0

  mod
 =====
   s		22 February 1984	tpl
	.Alloc and NetAlloc working.
	.Hard disk drivers in and working.
	.Now overlaying formatting code.

   r		16 February 1984	tpl
	.Splitting into two programs, ALLOC and NETALLOC.

   q		February 1984		tpl
	.RELEASED to software test.

   p		18 January 1984		tpl
	.Take out debugging.
	.Take out most bios calls and replace with function calls
	from MPBIOS.C.

   o		13 January 1984		tpl
	.Now this module is compiled and not included.
	.It does the global data initializations.

  n		3 January 1984		tpl
	.Update to USERS type constants.
	.New include file structure.
	.Go over all code and do minor cleanup.

   m		September 29, 1983	tpl
	.New menus.
	.New space/size mechanism.

  l		September 15, 1983	tpl
	.Modify and Delete.
	.Make separate struct definition file.
	.Take all global variables/data structures out of alloc4 module.

   k		September 12, 1983	tpl
	.Save and MSDOS partition initialization.

   j		September 9, 1983	tpl
	.Add MSDOS partition initializing code.

   i		Sept	2,  1983	tpl
	.Break 00h into separate modules.

   h		August	31, 1983	tpl
	.Reorganize menu structure to multi level.

   g		August	30, 1983	tpl
	.Begin size code. Setup tables for hard disk types and sizes.
	.Begin volume related stuff.

-------------------------------------------------------------------------------
*/
/*page*/
/*

		NETALLOC
 ver/rev
"""""""""
   1/0

     mod-patch
    +++++++++++
	a-a		8 March 1984	tpl
		.Bump up version for release.


 ver/rev
"""""""""
   0/0

    mod-patch
   """""""""""
      a-g		7 March 1984		tpl
		.Final touches on Clear, YouOwnIt, Ownable, OnlyRead
		and ReadWrite.

      a-a		16 February 1984	tpl
		.Make this program from Alloc.


*/
/*page*/
/*=============================================================================

	Current control byte mapping

  -----------------------------------------------------------------
  |   7   |   6   |   5   |   4   |   3   |   2   |   1   |   0   |
  -----------------------------------------------------------------
      |       |       |       |       |       |       |       |
      |       |       |       |       |       +-------+-------+
      |       |       |       |       |               |    
      |       +-------+-------+    reserved	 op. sys.
      |		      |				000 = CPM
      |		protection mode			001 = MSDOS
      |		000 = Read Write		010 -> 111 = reserved
      |		001 = Read Only
      |		010 = First Write
      |		011 = reserved
      |
      |		1xx = Shared
  tape backup
*/

/*---------------------------------------------------------------------------*/

/*page*/
/*=============================================================================
			ROUTINE
*/

Show_Version()
{
    putz("\n");
    repchar(LF,10);
#ifdef ALLOC
    putz("    ALLOC      ");
#endif
#ifdef NETALLOC
    putz("    NETALLOC   ");
#endif

    printz("version %d.%d%c%c     for Separated Boot systems.\n",
				vers, rev, mod, patch);
    printz("                                          %s\n", date);
}

/*---------------------------------------------------------------------------*/

Not_Implemented()
{
    putz("This is not implemented yet.\n");
    Wait_for_Input();

} /* Not_Implemented */

/*---------------------------------------------------------------------------*/

/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/


