/*	Alloc module 5.				#5
    "AL5.C"

    This module contains Listing and Info routines, plus Volume info/changeing.
*/
/*
#define		debug5
*/
#define		EXTERNal	0
#include	"alloc.dat"

/*=============================================================================
			HISTORY

date		15 March 1984
person		tpl

ver	0
rev	0
mod	d
patch	2

 mod-patch
----------
   d1		28 February 1984	tpl
	.Use password level to determine if passwords are to be displayed
	in the alloc table list.

   d0		17 February 1984	tpl
	.Spilt to Alloc and NetAlloc. Call hd_vol_select if Alloc.

   c3		9 February 1984		tpl
	.No longer set hi bit of size to mark parition as deleted.
	Just check for a 'd' in the first byte of the name.

   b12		30 January 1984		tpl
	.RELEASED TO SOFTWARE TEST.

   b9		17 January 1984		tpl
	.Take out "if ( debug_mode )" and replace with
	"#ifdef debug" and "#endif" to save space.


   b3		5 January 1984		tpl
	.Enter multi-volume support.

   b2		4 January 1984		tpl
	.Changes made for mod 'b' working.

  b		3 January 1984		tpl
	.Update to USERS constant naming 'standard'.
	.Change to new #include scheme.

  a		September 23, 1983	tpl
	.Make this module from alloc1/g, alloc2/g, alloc3/f, alloc4/e.


*/

/*=============================================================================
		VARIABLES and DATA STRUCTURES
*/

/*page*/
/*=============================================================================
				ROUTINES
*/

Vol_Select()
{
  register	i;
  CHAR		input[2];
  CHAR		length;

    if ( num_vols_present == 1 )
    {
	printz("%c\n\n\nThere is only one volume present, volume %d.\n",
					BELL, cur_volume);
	putz("Thus you can not change volumes.\n");
	Wait_for_Input();
	return;
    }

    if ( changes_made == TRUE )
    {
	putz("You have made changes to the ALLOC table for\n");
	printz(" volume %d without saving it to the hard disk.\n", cur_volume);
	printz("%c\nDo you still want to change volumes? --> ", BELL);
	if ( Get_Yes_No(RETNOTOK) == FALSE)
	    return;
    }

    Info();
    putz("\n\n         Hard Disk Volume Selection\n\n");

    while ( TRUE )
    {
	putz("Enter new volume number: ");
	length = 0;
	while ( length == 0 )
	{
	    length = Tintostring( input, 1, FALSE );
	    if ( length == 0 )
		ptch( BELL );
	}

	input[0] -= '0';	/* convert from ascii to hex.	*/

	if ( type_index[ input[0] ] == Nvol )	/* then disk not present	*/
	    printz("%c        That disk is not present.\n", BELL);
	else
	    if ( input[0] >= Nvol )
		printz("%        Ther ar no tha man hard disks.\n" BELL);
	    else
	    {
		cur_volume = input[0];
#ifdef ALLOC
		hd_vol_select( cur_volume );
#endif
		Get_Alloc_Table();
		changes_made = FALSE;	/* Starting anew.	*/

		break;		/* break out of while TRUE loop.	*/
	    }
    } /* while TRUE */

}/*Vol_Select*/

/*---------------------------------------------------------------------------*/
/*page*/

Info()
{
  register CHAR	i, vol;

    putz("\n\n       Hard Disk Volume Information.\n\n");
    putz("                      Space (Kb)\n");
    putz(" Vol#   Vol Name   Total  Used   Free             Type\n");
    putz("------ ---------- -------------------- -----------------------------\n");
    for ( vol=0; vol<Nvol; vol++)
    {
	if ( type_index[ vol ] != Nvol )	/* then volume exists */
	{
	    printz("  %1d    ",vol);
	    for ( i=0; i<LvolLabel; i++)
#ifdef NETALLOC
		ptch( hd_info.volume[vol].vol_label[i] );
#endif
#ifdef ALLOC
		ptch( hd_info[vol].vol_label[i] );
#endif
	    printz(" %6u", hd_types[ type_index[vol] ].size_in_Kbytes);
	    printz(" %6u", space_allocated[vol]);
	    printz(" %6u", space_free[vol]);
	    printz(" %s\n", hd_types[ type_index[vol] ].name);
	}
    }

    printz("\n Currently selected: volume %d\n", cur_volume);

}/*Info*/

/*---------------------------------------------------------------------------*/
/*page*/

List_Table()
{
  register	i;

    printz("\n\n List the allocation table.\n");
    Show_Header_of_Table();
    for ( i=0; (i < NallocEntries) && (alloc_table[i].size != 0); i++)
	Show_Partition( &alloc_table[i] );
    printz("\n\n %2d entries used out of %2d.\n", i, NallocEntries);

}/*List_Table*/

/*---------------------------------------------------------------------------*/
/*page*/

Show_Header_of_Table()
{
putz("\n\
   Name      Password   Size   Operating  Flagged   Protection\n\
                                System     Backup      Mode\n\
---------------------------------------------------------------\n");
}

/*---------------------------------------------------------------------------*/
/*page*/

Show_Partition(ptr_partition)
  struct a_entry	*ptr_partition;
{
  register CHAR	control, ch;

    repchar(SPACE,2);

    if ( (ptr_partition->name[0] == 0) || (ptr_partition->name[0] == SPACE) )
		/* then partition0 = boot partition = control area. */
	putz("Control     Area  ");

    else
    {
	printz("%.8s    ", ptr_partition->name );
	printz("%.6s", ptr_partition->password );
/*
	if ( pwLevel == MANAGERlevel )
	    printz("%.6s", ptr_partition->password );
	else
	    repchar(SPACE,6);
*/
    }

    printz("    %-4s", size_table[ (ptr_partition->size & 0x0f) -1 ] );

    ch = ptr_partition->name[0];
    if (  (ch == 0) || (ch == SPACE) || (ch == 'd')  )
		/* then partition = control area, or deleted partition so */
		/*don't show any OS, tape backup flag or protection,	  */
		/*i.e. control byte attributes.				  */
	;
    else
    {
	control = ptr_partition->control;
	if ((control & MSDOS) != 0)
	    printz("     MSDOS");
	else
	    printz("     CPM  ");

	repchar(SPACE,7);
	if ((control & TAPEBACKUP) != 0)
	    printz("yes");
	else
	    printz("no ");

	repchar(SPACE,5);
	control &= PRTCTMASK;	/* Get bits 4, 5 and 6		*/
	switch(control)
	{
	    case SHARED:
		printz("shared");
		break;
	    case READONLY:
		printz("read only");
		break;
	    case READWRITE:
		printz("read write");
		break;
	    case OWNABLE:
		printz("ownable");
		break;
	    default:
		printz("error. %x",control);
		break;
	}
    } /* else show control byte attributes. */

    putz("\n");

} /* Show_Partition */

/*---------------------------------------------------------------------------*/
/*page*/

CHAR
Comp_Space_Usage()
{
  register j;
  CHAR	i = 0;
  unsigned int	num_256k_chunks = 0;
  unsigned int	del_256k_chunks = 0;
  CHAR	size;
  int	power_A, power_B;

    while ( (alloc_table[i].size != 0) && (i<NallocEntries) )
    {
	size = alloc_table[i].size;
	if ( alloc_table[i].name[0] != 'd' )	/* if not deleted	*/
	{
	    power_A = 1;
	    for ( j=0; j < size-1; j++)
		power_A = power_A * 2;
	    num_256k_chunks += power_A;
	}
	else		/* else partition is deleted.	*/
	{
	    power_B = 1;
	    for ( j=0; j < (alloc_table[i].size & 0x7f) - 1; j++)
		power_B = power_B * 2;
	    del_256k_chunks += power_B;
	}

	i++;
    }/*while*/

#ifdef debug5
	printz("num_256k_chunks: %x hex    %u decimal\n",
				num_256k_chunks, num_256k_chunks);
	printz("del_256k_chunks: %x hex    %u decimal\n",
				 del_256k_chunks, del_256k_chunks);
#endif

    if (num_256k_chunks > (hd_types[ type_index[cur_volume] ].size_in_Kbytes / 256) )
    {
	printz("%cFatal error. Allocation table has more space allocated than is available.\n");
	printz("volume: %d      disk: %s\nspace_allocated: %u decimal   %x hex\n",
		cur_volume, hd_types[ type_index[cur_volume] ].name,
		num_256k_chunks*256, num_256k_chunks*256);
	zabort();
    }
    else
    {
	space_allocated[cur_volume] = num_256k_chunks * 256;
	space_free[cur_volume]
			= hd_types[ type_index[cur_volume] ].size_in_Kbytes
			 - space_allocated[cur_volume];
	space_partitioned[cur_volume]
			= space_allocated[cur_volume] +(256 * del_256k_chunks);
    }

}/*Comp_Space_Usage*/

/*---------------------------------------------------------------------------*/

/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

