/*	Alloc module 3.				#3
    "AL3.C"

    This module contains Partition manipulation routines,
	Add, Delete, Modify.
*/
/*
#define		debug3		FALSE
*/

#define		EXTERNal	0

#include	"alloc.dat"

/*=============================================================================
			HISTORY

date		9 March 1984
person		tpl

ver	0
rev	0
mod	c
patch	6

 mod-patch
-----------
   c5		27 February 1984	tpl
	.Take out COMPRESS warnings just put in. We are going to
	release Les Wilson's souped up HiDos and COMPRESS is no longer needed.

   c4		27 February 1984	tpl
	.Add HiDos wrnings about COMPRESS and SHRALLOC.

  c3		9 February 1984		tpl
	.Nolonger set hi bit of size to mark parition as deleted.
	Just check for a 'd' in the first byte of the name.

  c2		2 February 1984		tpl
	.Break into al3.c and al7.c.

  b17		27 January 1984		tpl
	.RELEASE TO KEN H. FOR BETA TEST TESTING.

   b9		17 January 1984		tpl
	.Take out "if ( debug_mode )" and replace with
	"#ifdef debug" and "#endif" to save space.

   b4		6 January 1984		tpl
	.Enter reset hard disk and format hard disk code.

  b		3 January 1984		tpl
	.Update constants to reflect USERS type standard.
	.Update to new include file structure.

  a		September 23, 1983	tpl
	.Make this module from alloc1/g, alloc2/g, alloc3/f, alloc4/e.

*/

/*page*/
/*=============================================================================
			VARIABLES
*/

CHAR	del_name[] = { 'd','e','l','e','t','e','d',' '};

/*=============================================================================
				ROUTINES
*/

Add()
{
  CHAR	partition;
  struct a_entry	*part_ptr;

    printz("\n\n Add a partition.\n\n");
    if ( First_Free_Partition() == 0 )
    {
	printz("\n%cThe Allocation Table is full.\n",BELL);
	Wait_for_Input();
	return;
    }
    if ( space_free[cur_volume] < 256 )
    {
	printz("\n%cThere is no space to add a partition.\n",BELL);
	Wait_for_Input();
	return;
    }

    if ( (part_ptr = alloc( sizeof( struct a_entry))) == 0 )
    {
	putz("No room to allocate part_ptr in Add.\n");
	zabort();
    }

    if ( New_Partition_Setup(part_ptr) == 0)
	return ( 0 );

/* If adding a shared partition give user reminder.	*/
    if ( (part_ptr->control & PRTCTMASK) == SHARED )
    {
	putz("\n\
Did you run SHRALLOC on this partition before running ALLOC?\n\
    -->           (y/n)");
	repchar(BS,15);
	if ( !Get_Yes_No(RETNOTOK) )
	{
	    putz("\n\
Partition not put in table.\n");
	    Wait_for_Input();
	    return;
	}

    }/* if shared */


    if (Ask_if_Partition_OK( part_ptr ) == TRUE)
    {
	partition = Find_Size_Partition( part_ptr->size );
	blockmv(&alloc_table[partition], part_ptr, sizeof(struct a_entry));
	Comp_Space_Usage();
	changes_made = TRUE;

    /* flag to Format the partition when doing the next save.	*/
	parts_to_format[ frmt_p_index++ ] = partition;

    /* flag to set write_mode_table entry to 0xff when doing next save	*/
    /*if the partition is ownable.					*/

	if ( (alloc_table[partition].control & PRTCTMASK) == OWNABLE )
	    partsSetOwned[ set_owned_index++ ] = partition;

    }

    free( part_ptr );

} /* Add */

/*---------------------------------------------------------------------------*/
/*page*/

CHAR
New_Partition_Setup(part_ptr)
  struct a_entry	*part_ptr;
{
  CHAR	*input_string, length, i, duplicates;

    Reset_Partition( part_ptr);

/* Name setting.	*/

    input_string = Read_Name( &length, RETNOTOK );
    putz("\n");
    for ( i=0; (i<Lname) && (input_string[i] != '\0'); i++ )
	part_ptr->name[i] = input_string[i];

/* Password setting.	*/

    input_string = ReadPassword( &length );	/* MUST pass parameter. */
    putz("\n");
    for ( i=0; (i<Lpassword) && (input_string[i] != '\0'); i++)
	part_ptr->password[i] = input_string[i];

/* Size setting	*/

    if ( (part_ptr->size = Get_Size()) == 0 )
	return(0);		/* Not enough space for desired size.*/

/* Control byte setting.					*/
/* Control byte is zero here due to Reset_Partition call above.	*/
/* Set operating system to CPM or MSDOS.			*/

    part_ptr->control |= Read_Op_Sys(RETNOTOK);

/* Set tape backup flag if desired.				*/
    printz("Flagged Backup   :                (yes/no)");
    repchar(BS,23);
    if (Get_Yes_No(RETNOTOK) == TRUE)
	part_ptr->control |= TAPEBACKUP;

/* Set protection mode to READWRITE, READONLY, OWNABLE, or SHARED */

    part_ptr->control |= Read_Protection_Type(RETNOTOK, part_ptr->control);


    return(1);	/*signal ok*/

}/*New_Partition_Setup*/

/*---------------------------------------------------------------------------*/
/*page*/

Delete()
{
  register CHAR	i, j, partition;
  CHAR	size;

    printz("\n\n Delete chosen partition.\n");
    partition = GetPartName();

    if (partition == 0)
	return( 0 );

    printz("\nThis will erase ALL files on this partition:\n");
    Show_Header_of_Table();
    Show_Partition( &alloc_table[partition] );
    putz("\n");
    printz("Are you sure you want to DELETE this partition :        (yes/no)");
    repchar(BS,15);
    if (Get_Yes_No(RETNOTOK) == FALSE)
	return( 0 );

    changes_made = TRUE;

    size = alloc_table[partition].size;
    Reset_Partition( &alloc_table[partition] );
    alloc_table[partition].size = size;
    for ( i=0; i<Lname; i++)
	alloc_table[partition].name[i] = del_name[i];

/* Mark all deleted partitions at the end of the table as blank entries. */

    if ( (partition+1 == NallocEntries)
	 || (alloc_table[partition+1].size == 0) )
    {
	i = partition;
	while( (i>0) && (alloc_table[i].name[0] == 'd')  )
	{
	    Reset_Partition( &alloc_table[i] );
	    for ( j=0; j<frmt_p_index; j++ )
		/* If partition to format has been deleted
			take it out of parts_to_format list. */
		if ( parts_to_format[j] == i )
		    parts_to_format[j] = NallocEntries;
	    i--;
	}
    }

    Comp_Space_Usage();


}/*Delete*/

/*---------------------------------------------------------------------------*/
/*page*/

Modify()
{
  register	i, partition;
  CHAR	*input_string, length;
  CHAR	OSok = FALSE;
  CHAR	format_flag = FALSE;
  CHAR	ownable_flag = FALSE;
  struct a_entry	*table_ptr;
  int	response;

    printz("\n\n Modify a partition.\n");

    if ( (partition = GetPartName()) == 0 )
	return( 0 );

    Show_Header_of_Table();
    Show_Partition( &alloc_table[partition] );
    putz("\n\n");

    if( (table_ptr = alloc( sizeof( struct a_entry))) == 0 )
    {
	putz("No room to allocate table_ptr in Modify.\n");
	zabort();
    }

    Reset_Partition(table_ptr);

/* Name setting.	*/

    input_string = Read_Name( &length, RETOK );

    if (length != 0)
    {
	for ( i=0; (i<Lname) && (input_string[i] != '\0'); i++ )
	    table_ptr->name[i] = toupper(input_string[i]);
    }
    else	/* else use old name.	*/
    {
	for ( i=0; i<Lname; i++)
	{
	    table_ptr->name[i] = alloc_table[partition].name[i];
	    ptch( alloc_table[partition].name[i] );
	}
    }
    putz("\n");

/* Password setting.	*/

    putz("\n    Enter 0 to clear password.\n");
    input_string = ReadPassword( &length );

    switch( length )
    {
	case 0:		/* Use old password. */
		for ( i=0; i<Lpassword; i++)
		{
		    table_ptr->password[i] = alloc_table[partition].password[i];
		    ptch( alloc_table[partition].password[i] );
		}
		break;

	case 1:
		if ( input_buffer[0] == '0' )	/* Leave blank.	*/
		{
		    ptch(BS);		/* Blank user's input. */
		    ptch(SPACE);
		    break;
		}
		/* else fall through to default */

	default:	/* Use new password. */
		for ( i=0; (i<Lpassword) && (input_string[i] != '\0'); i++)
		    table_ptr->password[i] = input_string[i];
		break;

    }/* switch on length */

    putz("\n");	

/* Size not modifiable.	*/

    printz("Size             : %-4s           (May not Modify size.)\n",
			size_table[ alloc_table[ partition ].size-1 ] );
    table_ptr->size = alloc_table[partition].size;

/* Control byte setting. */

    while ( !OSok )	/* OSok is initialized to FALSE */
    {
	response = Read_Op_Sys(RETOK);
	if (response != RETURN)
	{	/* if new O.S. is not the same as the old O.S. */
	    if ( response != (alloc_table[partition].control & OSMASK) )
	    {
		printz("%c\n\
You have changed the operating system.\n\
This will DELETE ALL FILES on this partition when you save the table.\n\
Do you still wish to change operating systems?\n\
   ----> ", BELL);
		if ( Get_Yes_No(RETNOTOK) )
		{
		    table_ptr->control |= response;
		    format_flag = TRUE;
		    OSok = TRUE;
		}
	    }
	    else		/* else new O.S. matches old O.S.	*/
	    {
		table_ptr->control |= response;
		OSok = TRUE;
	    }
	}
	else
	{
	    table_ptr->control |= (alloc_table[partition].control & OSMASK);
	    if ((alloc_table[partition].control & MSDOS) == MSDOS)
		printz("MSDOS\n");
	    else
		printz("CPM\n");
	    OSok = TRUE;
	}

    } /* while OSok */

    printz("Flagged Backup   :                (yes/no)");
    repchar(BS,23);
    response = Get_Yes_No(RETOK);
    if (response != RETURN)
    {
	if (response == TRUE)
	    table_ptr->control |= TAPEBACKUP;
	else
	    table_ptr->control |= NOTAPEBACKUP;
    }
    else
    {
	table_ptr->control |= (alloc_table[partition].control & TAPEBACKUP);
	if ((alloc_table[partition].control & TAPEBACKUP) == TAPEBACKUP)
	    printz("yes\n");
	else
	    printz("no\n");
    }

/* Set protection mode to READWRITE, READONLY, OWNABLE, or SHARED */

    response = Read_Protection_Type(RETOK, table_ptr->control);
    if (response != RETURN)
    {
	table_ptr->control |= response;
	if ( response == OWNABLE )
	    ownable_flag = TRUE;

/* If modifying to a shared partition from not shared. */
	if ( (response == SHARED)
		&& ((alloc_table[partition].control & PRTCTMASK) != SHARED) )
	{
	    putz("\n\
Did you run SHRALLOC on this partition before running ALLOC?\n\
    -->           (y/n)");
	    repchar(BS,15);
	    if ( !Get_Yes_No(RETNOTOK) )
	    {
		putz("\n\
Partition not put in table.\n");
		Wait_for_Input();
		return;
	    }
	}/* if not shared -> shared */


    }/* if RETURN */

    else
    {
	table_ptr->control |= ( alloc_table[partition].control & PRTCTMASK );
	switch( alloc_table[partition].control & PRTCTMASK )
	{
	    case READONLY:
			putz("RO\n");
			break;
	    case READWRITE:
			putz("RW\n");
			break;
	    case OWNABLE:
			putz("O\n");
			break;
	    case SHARED:
			putz("S\n");
			break;
	    default:
			printz("error. %x\n",response);
			break;
	}/*switch*/
    }/*else*/

    if (Ask_if_Partition_OK(table_ptr) == TRUE)
    {
	blockmv( &alloc_table[partition], table_ptr, sizeof(struct a_entry) );
	changes_made = TRUE;

    /* flag to Format the partition when doing the next save.	*/
	if ( format_flag == TRUE )
	    parts_to_format[ frmt_p_index++ ] = partition;

    /* flag to set write_mode_table entry to 0xff when doing next save	*/
    /*if the partition is ownable.					*/

	if ( ownable_flag == TRUE )
	    partsSetOwned[ set_owned_index++ ] = partition;
    }

    free( table_ptr );

}/*Modify*/

/*---------------------------------------------------------------------------*/


/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

