/*	Alloc module 2				#2
    "AL2.C"

    This module contains Table manipulation routines, Get, Save, 
and their support routines.
*/
/*
#define		debug2		0
*/

#define		EXTERNal	0

#include	"alloc.dat"

/*=============================================================================
			HISTORY

date		8 March 1984
person		tpl

ver	0
rev	0
mod	c
patch	13

 mod-patch
-----------
    c7		22 February 1984	tpl
	.Overlaying FormatPartition ( al4 module ) as 'pformat.ovr'.

    c6		17 February 1984	tpl
	.Changing to hd_xfer from data_xfer for Alloc but not NetAlloc.

    c3		16 February 1984	tpl
	.Making split of Alloc into Alloc and NetAlloc.

   b14		31 January 1984		tpl
	.RELEASED TO SOFTWARE TEST.

   b8		17 January 1984		tpl
	.Take out "if ( debug_mode )" and replace with
	"#ifdef debug" and "#endif" to save space.


  b		3 January 1984		tpl
	.Update constants to reflect USERS type standard.
	.Update to new include file structure.

  a		September 23, 1983	tpl
	.Make this module from alloc1/g, alloc2/g, alloc3/f, alloc4/e.


*/

/*page*/
/*=============================================================================
			ROUTINES
*/
/*---------------------------------------------------------------------------*/

Save_Table()
{

#ifdef NETALLOC
  register	mode, i;

/* First write Alloc Table to the hard disk.	*/

    data_xfer( WRITE, ALLOCtrack, ALLOCsector-1, alloc_table, ALLOCsizeInSectors);

/* Now update the Write Mode Table via the bios Write Mode Force Command. */
/* All partitions that need to be changed are stored in array wm_Update.  */
/* If partitions are to be forced to YouOwnIt status, then array to_be_owned */
/*  will have a TRUE entry corresponding to the wm_Update entry.	  */

/* Pass to WM_Force the partition number and either the usernumber to get */
/*  ownership or the protection mode the partition is to be set to.	  */

    for( i=0; i<index_wm_update; i++)
    {
	if ( to_be_owned[i] )
	    WM_Force( wm_Update[i], userno() );
	else
	{
	    switch ( alloc_table[ wm_Update[i] ].control & PRTCTMASK )
	    {
		case READONLY:
				mode = ISreadOnly;
				break;
		case READWRITE:
				mode = ISreadWrite;
				break;
		case OWNABLE:
				mode = NOTowned;
				break;
		case SHARED:
				mode = ISshared;
				break;
		default:
				putz("Error in Save_Table.\n");
				zabort();
	    }/*switch*/

	    WM_Force( wm_Update[i], mode );

	}/*else*/
    }

    index_wm_update = 0;
    clear( wm_Update, NallocEntries, NallocEntries );
    clear( to_be_owned, FALSE, NallocEntries );

    changes_made = FALSE;

#endif

#ifdef ALLOC

  CHAR	i, j;

    hd_xfer( WRITE, ALLOCtrack, ALLOCsector, alloc_table, ALLOCsizeInSectors);

/* Format partitions if necessary. */

    if ( frmt_p_index != 0 )	/* Then partitions to format.	*/
    {
	if ( ovloader( "alloc2" ) == -1 )	/* then error */
	{
	    overlayErr();
	    putz(" alloc2.ovr file.\n");
	    zabort();
	}
	frmt_p_index = 0;		/* Reset index */
    }

/* Now do Write_Mode_Table update if necessary.	*/

    if ( set_owned_index != 0 )
    {
	Get_Write_Mode_Table();

	for ( i=0; i<set_owned_index; i++ )
	    write_mode_table[ cur_volume ][ partsSetOwnable[i] ] = 0xff;

	Save_Write_Mode_Table();

	set_owned_index = 0;	/* Reset index */
    }

    changes_made = FALSE;

#endif

}/*Save_Table_to_Control_Area*/

/*page*/
/*---------------------------------------------------------------------------*/

Get_Alloc_Table()
{

#ifdef NETALLOC

    data_xfer( READ, ALLOCtrack, ALLOCsector-1, alloc_table, ALLOCsizeInSectors);

    Comp_Space_Usage();

    index_wm_update = 0;
    clear( wm_Update, NallocEntries, NallocEntries );
    clear( to_be_owned, FALSE, NallocEntries );

    changes_made = FALSE;

#endif

#ifdef ALLOC

#ifdef debug2
	putz("..enter Get_Alloc_Table\n");
#endif

    frmt_p_index = 0;		/* Reset partitions to format index.	*/
    changes_made = FALSE;

    hd_xfer( READ, ALLOCtrack, ALLOCsector, alloc_table, ALLOCsizeInSectors);

/* Alloc table is deemed BAD if the size of the first partition is not valid.*/

    if ( (alloc_table[0].size < 0) || (alloc_table[0].size > NpartSizes) )
    {
	printz("%c\n\nThe allocation table looks uninitialized.\n\
Do you wish to initialize the allocation table and save\
 it to the hard disk?\n\
   -----> ", BELL);

	if ( Get_Yes_No(RETNOTOK) )
	{
	    Zero_Table();
	    Save_Table_to_Control_Area();
	}
    }

    Comp_Space_Usage();

#endif

} /* Get_Control_Table	*/

/*---------------------------------------------------------------------------*/
/*page*/

#ifdef ALLOC

Zero_Table()
{
  register CHAR	i;

    for ( i=0; i<NallocEntries; i++ )
	Reset_Partition( &alloc_table[ i ] );

    alloc_table[0].size = 1;

    changes_made == FALSE;
    frmt_p_index = 0;

}/*Zero_Table*/

#endif

/*---------------------------------------------------------------------------*/
/*page*/
/*
Wait( time )
  CHAR time;
{
  unsigned int i;
  CHAR j;

    for ( j=0; j<time; j++ )
	for ( i=0; i<0xffff; i++ )
	    ;
}
*/
/*---------------------------------------------------------------------------*/


/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
