/*	Alloc module 1				#1
    "AL1.C"

    This module contains general initialization/reinitialization code.
*/
/*
#define		debug1		0
*/
#define		EXTERNal	0

#include	"alloc.dat"

/*=============================================================================
			HISTORY

date		9 March 1984
person		tpl

ver	0
rev	0
mod	c
patch	15 

 mod-patch
-----------
    c9		29 February 1984	tpl
	.Add Check_WM_Table routine. Call it in Init_Sizes for each
	existing volume.

    c8		27 February 1984	tpl
	.Take volume selection out of initialize and put in main.

   c7		22 February 1984	tpl
	.Take out dpb_B and dph_B.

   c4		17 February 1984	tpl
	.For Alloc use hard disk drivers ala hardio.lib.

   c3		16 February 1984	tpl
	.Split into Alloc and NetAlloc.

  b10		30 January 1984		tpl
	.RELEASED TO SOFTWARE TEST.


  b4		17 January 1984		tpl
	.Take out "if ( debug_mode )" and put in
	#ifdef debug and #endif to save space.

  b3		13 January 1984		tpl
	.Now the INITdata definition is in "ALLOCDOC.C".


  b2		5 January 1984		tpl
	.Adding multi-volume support.

   b1		4 January 1984		tpl
	.Changes for mod 'c' working.

  b		3 January 1984		tpl
	.Update constants to reflect USERS type standard.
	.Update to new include file structure.

  a		September 23, 1983	tpl
	.Make this module from alloc1/g, alloc2/g, alloc3/f, alloc4/e.
*/

/*=============================================================================
			DEFINES
*/
#define		EnableIntButton()	ENAIB()


/*page*/
/*=============================================================================
			ROUTINES

/*---------------------------------------------------------------------------*/

Initialize()
{
  CHAR	*temp_dpb_ptr;	/* So we can do byte math.	*/
  register i;

#ifdef debug1
	printz("\n..Enter Initialize\n");
#endif

    begin_disk = CurDisk();	/* Save current disk.		*/

    Init_Hard_Disks();		/* Sets up type_index array
					and num_vols_present.	*/

    Init_Space_and_WMT_verify();/* Does write mode table verify against */
				/* the alloc tables for mismatches.	*/
				/* Sets up space usage arrays for each	*/
				/*volume present. re:			*/
				/*		space_allocated[]	*/
				/*		space_free[]		*/
				/*		space_partitioned[]	*/
/* Now set cur_volume.	*/

    switch( num_vols_present )
    {
    /* NOTE THAT THERE MUST BE Nvol CASES !!!			*/

	case 0:
		printz("\n%cNo hard disk is present.\n", BELL );
		zabort();
		break;

	case 1:
		for ( i=0; i<Nvol; i++ )
		    if ( type_index[i] != Nvol )   /* then volume is present.*/
		    {
			cur_volume = i;
#ifdef ALLOC
			hd_vol_select( cur_volume );
#endif
			break;		/* Break out of for loop.	*/
		    }
		break;

	case 2:		/* For more than one volume present, ask user which */
	case 3:		/*one to use initially, now done in main.	    */
	case 4:	/* Nvol == 4 */

		/* Vol_Select done in main.	*/
		break;

	default:
		break;
    }

}/* Initialize */

/*---------------------------------------------------------------------------*/
/*page*/

Init_Hard_Disks()
{
  struct vol_info	*vol_ptr;
  register j,i;

#ifdef debug1
	putz("..enter Init_Hard_Disks\n");
#endif

#ifdef NETALLOC
    hdstat( &hd_info );		/* bios call */

    if (hd_info.status != 0)
#endif

#ifdef ALLOC
    if ( (hd_info = hd_init()) == 0 )
#endif

    {
	printz("%c\nThe hard disk is not operational.\n\n", BELL);
	zabort();
    }

/* if valid firmware, then setup type_index for each available volume. */

    num_vols_present = 0;
    for ( j=0; j<Nvol; j++)
    {
#ifdef NETALLOC
	vol_ptr = &(hd_info.volume[j]);
#endif
#ifdef ALLOC
	vol_ptr = &(hd_info[j]);
#endif
	if (vol_ptr->vol_present != 0)	/* If volume is present. */
	{
	    num_vols_present++;

#ifdef NETALLOC
	    if (hd_info.Xebec == 'X')	/* Then 5.25 inch hard disk.	*/
#endif
#ifdef ALLOC
	    if (hd_controller() == 'X')	/* Then 5.25 inch hard disk.	*/
#endif
		type_index[j] = (vol_ptr->head_mask) - 1;

	    else	/* else, 8 or 14 inch hard disk.		*/
	    {
		i = FIRST8or14disk;
		while ( (vol_ptr->tracks != hd_types[i].tracks)
		    || (vol_ptr->sect_per_track != hd_types[i].sect_per_track)
		    || ((vol_ptr->head_mask+1) != hd_types[i].RW_heads) )
		{
		    i++;
		    if (i == NhdTypes)
		    {
			printz("\n%cUnknown hard disk type.\n",BELL);
			zabort();
		    }
		}/*while no type match*/

		type_index[j] = i;	/* MATCH found. */
#ifdef debug1
		printz("vol %x is hard disk type %x.\n", j, i);
		printz("hd_types[%x] = %s\n", i, hd_types[i].name);
#endif
	    } /* else 8 or 14 inch disk */

	}/*if vol present*/

	else	/* else volume not present.	*/
	{
	    type_index[j] = Nvol;	/* Mark volume as not present.	*/
#ifdef debug1
	    printz("vol %x is not present.\n", j);
#endif

	}

    } /* for j=0 to Nvol */

}/*Init_Hard_Disks*/

/*---------------------------------------------------------------------------*/
/*page*/

Init_Space_and_WMT_verify()
{
  register CHAR	i;

#ifdef debug1
	    putz("..Init_Space_Usage\n");
#endif

    for ( i=0; i<Nvol; i++ )
    {
	if ( type_index[i] != Nvol )	/* if volume is present */
	{
	    cur_volume = i;
#ifdef ALLOC
	    hd_vol_select( cur_volume );
#endif
	    Get_Alloc_Table();	/* Calls 'Comp_Space_Usage'.		*/
/*
	    Check_WM_Table();
*/
	}
    }

    cur_volume = 0;
#ifdef ALLOC
    hd_vol_select( cur_volume );
#endif

} /* Init_Space_Usage */

/*---------------------------------------------------------------------------*/
/*page*/

ReInitialize()
{
#ifdef debug1
	putz("\n.Enter ReInitialize");
#endif

    DiskReset();	/* Reset any dpb changes that may have occured. */

    SelDisk( begin_disk );	/* Reselect original disk.	*/

#ifdef ALLOC
    EnableIntButton();	/* Reset so the interrupt button is again working. */
			/* It was disabled in 'main'.			   */
#endif

}/*ReInitialize*/

/*---------------------------------------------------------------------------*/

/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

