#define VERSION     1
#define REVISION    1
#define PATCH	    'f'

#define ever	    (;;)
#define FALSE	    0
#define TRUE	    1
#define CR	    0x0D
#define BS	    0x08
#define DEL	    0x7F
#define ESC	    0x1B
#define BELL	    0x07
#define CTRL_X	    'X'-'@'
#define ADDING	    'A'
#define MODIFYING   'M'

#define MTtrack   0x01		/* constants describing location and length */
#define MTsector  0x08		/* of tables on hard disk unit 0 */
#define MTlength    12

/* *********************** OPTION MAP BIT LABELS ***************** */

#define OP_8FLOP    0
#define OP_FOXFLOP  1
#define OP_IBMFLOP  2
#define OP_8HARD    3
#define OP_XEBHARD  4
#define OP_ADPHARD  5
#define OP_P0AHEAD  6
#define OP_P0POLL   7
#define OP_P2POLL   8
#define OP_P3AHEAD  9
#define OP_P3POLL   10
#define OP_PAR1CON  11
#define OP_PAR1PRT  12
#define OP_PAR2PRT  13
#define OP_PRTMUX   14
#define OP_SPOOLER  15
#define OP_NETBUFF  16
#define OP_CLOCK    17
#define OP_FRONTINT 18
#define OP_DRIVES   19	  /* also uses 20,21,22 for number of logical drives */
#define OP_MEMMAP   23	  /* brand new memory-mapped console on 816 */

/* ************************* C MACROS **************************** */

#define getfile(f)	  data_xfer(READ,f.track,f.sector,f.buffer,f.length)
#define putfile(f)	  data_xfer(WRITE,f.track,f.sector,f.buffer,f.length)

/* ************************ STRUCTURES *************************** */

typedef struct sfile {		/* table description */
    int track;		/* beginning track   */
    char sector;	/* beginning sector  */
    char length;	/* number of sectors */
    char *buffer;	/* buffer it goes in */
    } SFILE;

struct MTentry {
    long sernum; 
    char product;
    char optmap[6];
    char iobyte;
    };

extern SFILE machtable;

#define MAXDESC 15
struct CONFIGURE {
    char prod;
    char optm[6];
    char def_iob;
    char *short_name;
    char *long_name;
    char *description;
    };
extern struct CONFIGURE desc_code[];

struct PORT {			    /* names of physical io facilities in */
    char *shorter;		    /* abbreviated and full form, and the */
    char *longer;		    /* bits in the bit-map which say whether */
    char map1;			    /* you have one (maybe two such bits, eg.*/
    char map2;			    /* typeahead & poll, console & printer..)*/
    };				    /* Test on bit 0xFF always returns FALSE */
extern struct PORT port[];

struct IOFEATURES {	  /* types of logical-to-physical correspondence */
    struct PORT *con[4];  /* (not as many of these as there are products */
    struct PORT *prt[8];  /* since nearly everything looks like a DSC-3) */
    };
extern struct IOFEATURES io_devs[];

struct PRODUCT {	    /* for a given product number, there is a struct */
    char *name; 	    /* of this type which gives its name and points */
    struct IOFEATURES *io;  /* to a description of its io facilities */
    };
extern struct PRODUCT product[];

extern char *option[];
extern char *cpm_console[];
extern char *cpm_printer[];
extern char MTbuf[];
extern int  error;
extern int  abort_req;


/* ***************** FUNCTIONS THAT DON'T RETURN INTS **************** */

long atoh(),gethex();


n int  abort_req;


/* ***************** FUNCTIONS THAT DON'T RETURN INTS **************